/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.util;

public final class NumberConverter {
    private int setCount;
    private int getCount;
    private int[] uArray = new int[64];
    private int firstK;
    private static final double invLogOfTenBaseTwo = Math.log(2.0) / Math.log(10.0);
    private static final long[] TEN_TO_THE = new long[20];

    static {
        NumberConverter.TEN_TO_THE[0] = 1L;
        int i = 1;
        while (i < TEN_TO_THE.length) {
            long previous = TEN_TO_THE[i - 1];
            NumberConverter.TEN_TO_THE[i] = (previous << 1) + (previous << 3);
            ++i;
        }
    }

    private static NumberConverter getConverter() {
        return new NumberConverter();
    }

    public static String convert(double input) {
        return NumberConverter.getConverter().convertD(input);
    }

    public static String convert(float input) {
        return NumberConverter.getConverter().convertF(input);
    }

    public String convertD(double inputNumber) {
        int p = 1075;
        long signMask = Long.MIN_VALUE;
        long eMask = 0x7FF0000000000000L;
        long fMask = 0xFFFFFFFFFFFFFL;
        long inputNumberBits = Double.doubleToLongBits(inputNumber);
        StringBuffer result = new StringBuffer();
        if ((inputNumberBits & signMask) != 0L) {
            result.append('-');
        }
        int e = (int)((inputNumberBits & eMask) >> 52);
        long f = inputNumberBits & fMask;
        boolean mantissaIsZero = f == 0L;
        int pow = 0;
        int numBits = 52;
        if (e == 2047) {
            if (mantissaIsZero) {
                result.append("Infinity");
                return result.toString();
            }
            return "NaN";
        }
        if (e == 0) {
            if (mantissaIsZero) {
                result.append("0.0");
                return result.toString();
            }
            if (f == 1L) {
                result.append("4.9E-324");
                return result.toString();
            }
            pow = 1 - p;
            long ff = f;
            while ((ff & 0x10000000000000L) == 0L) {
                ff <<= 1;
                --numBits;
            }
        } else {
            f |= 0x10000000000000L;
            pow = e - p;
        }
        if (-59 < pow && pow < 6 || pow == -59 && !mantissaIsZero) {
            this.longDigitGenerator(f, pow, e == 0, mantissaIsZero, numBits);
        } else {
            this.bigIntDigitGeneratorInstImpl(f, pow, e == 0, mantissaIsZero, numBits);
        }
        if (inputNumber >= 1.0E7 || inputNumber <= -1.0E7 || inputNumber > -0.001 && inputNumber < 0.001) {
            return this.freeFormatExponential(result);
        }
        return this.freeFormat(result);
    }

    public String convertF(float inputNumber) {
        int p = 150;
        int signMask = Integer.MIN_VALUE;
        int eMask = 2139095040;
        int fMask = 0x7FFFFF;
        int inputNumberBits = Float.floatToIntBits(inputNumber);
        StringBuffer result = new StringBuffer();
        if ((inputNumberBits & signMask) != 0) {
            result.append('-');
        }
        int e = (inputNumberBits & eMask) >> 23;
        int f = inputNumberBits & fMask;
        boolean mantissaIsZero = f == 0;
        int pow = 0;
        int numBits = 23;
        if (e == 255) {
            if (mantissaIsZero) {
                result.append("Infinity");
                return result.toString();
            }
            return "NaN";
        }
        if (e == 0) {
            if (mantissaIsZero) {
                result.append("0.0");
                return result.toString();
            }
            pow = 1 - p;
            if (f < 8) {
                f <<= 2;
                pow -= 2;
            }
            int ff = f;
            while ((ff & 0x800000) == 0) {
                ff <<= 1;
                --numBits;
            }
        } else {
            f |= 0x800000;
            pow = e - p;
        }
        if (-59 < pow && pow < 35 || pow == -59 && !mantissaIsZero) {
            this.longDigitGenerator(f, pow, e == 0, mantissaIsZero, numBits);
        } else {
            this.bigIntDigitGeneratorInstImpl(f, pow, e == 0, mantissaIsZero, numBits);
        }
        if (inputNumber >= 1.0E7f || inputNumber <= -1.0E7f || inputNumber > -0.001f && inputNumber < 0.001f) {
            return this.freeFormatExponential(result);
        }
        return this.freeFormat(result);
    }

    private String freeFormatExponential(StringBuffer result) {
        int k;
        char[] formattedDecimal = new char[25];
        formattedDecimal[0] = (char)(48 + this.uArray[this.getCount++]);
        formattedDecimal[1] = 46;
        int charPos = 2;
        int expt = k = this.firstK;
        while (true) {
            --k;
            if (this.getCount >= this.setCount) break;
            formattedDecimal[charPos++] = (char)(48 + this.uArray[this.getCount++]);
        }
        if (k == expt - 1) {
            formattedDecimal[charPos++] = 48;
        }
        formattedDecimal[charPos++] = 69;
        result.append(formattedDecimal, 0, charPos);
        result.append(expt);
        return result.toString();
    }

    private String freeFormat(StringBuffer result) {
        char[] formattedDecimal = new char[25];
        int charPos = 0;
        int k = this.firstK;
        if (k < 0) {
            formattedDecimal[0] = 48;
            formattedDecimal[1] = 46;
            charPos += 2;
            int i = k + 1;
            while (i < 0) {
                formattedDecimal[charPos++] = 48;
                ++i;
            }
        }
        int U = this.uArray[this.getCount++];
        do {
            if (U != -1) {
                formattedDecimal[charPos++] = (char)(48 + U);
            } else if (k >= -1) {
                formattedDecimal[charPos++] = 48;
            }
            if (k != 0) continue;
            formattedDecimal[charPos++] = 46;
        } while ((U = this.getCount < this.setCount ? this.uArray[this.getCount++] : -1) != -1 || --k >= -1);
        result.append(formattedDecimal, 0, charPos);
        return result.toString();
    }

    private native void bigIntDigitGeneratorInstImpl(long var1, int var3, boolean var4, boolean var5, int var6);

    private void longDigitGenerator(long f, int e, boolean isDenormalized, boolean mantissaIsZero, int p) {
        boolean high;
        boolean low;
        int U;
        long S;
        long R;
        long M;
        if (e >= 0) {
            M = 1L << e;
            if (!mantissaIsZero) {
                R = f << e + 1;
                S = 2L;
            } else {
                R = f << e + 2;
                S = 4L;
            }
        } else {
            M = 1L;
            if (isDenormalized || !mantissaIsZero) {
                R = f << 1;
                S = 1L << 1 - e;
            } else {
                R = f << 2;
                S = 1L << 2 - e;
            }
        }
        int k = (int)Math.ceil((double)(e + p - 1) * invLogOfTenBaseTwo - 1.0E-10);
        if (k > 0) {
            S *= TEN_TO_THE[k];
        } else if (k < 0) {
            long scale = TEN_TO_THE[-k];
            R *= scale;
            long l = M = M == 1L ? scale : M * scale;
        }
        if (R + M > S) {
            this.firstK = k;
        } else {
            this.firstK = k - 1;
            R *= 10L;
            M *= 10L;
        }
        this.setCount = 0;
        this.getCount = 0;
        long[] Si = new long[]{S, S << 1, S << 2, S << 3};
        while (true) {
            U = 0;
            int i = 3;
            while (i >= 0) {
                long remainder = R - Si[i];
                if (remainder >= 0L) {
                    R = remainder;
                    U += 1 << i;
                }
                --i;
            }
            low = R < M;
            boolean bl = high = R + M > S;
            if (low || high) break;
            R *= 10L;
            M *= 10L;
            this.uArray[this.setCount++] = U;
        }
        this.uArray[this.setCount++] = low && !high ? U : (high && !low ? U + 1 : (R << 1 < S ? U : U + 1));
    }
}

