/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.net.www.protocol.jxe.Handler;
import com.ibm.oti.vm.Jxe;
import com.ibm.oti.vm.JxeException;
import com.ibm.oti.vm.URLSystemClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public final class URLExtensionClassLoader
extends URLSystemClassLoader {
    private static final URL[] classPath = URLExtensionClassLoader.getClassPath();

    public URLExtensionClassLoader() {
        this((ClassLoader)null);
    }

    URLExtensionClassLoader(ClassLoader parent) {
        super(classPath, parent);
    }

    static URL[] getClassPath() {
        int total = 0;
        String extDirs = System.getProperty("java.ext.dirs");
        if (extDirs == null) {
            String bootPath = System.getProperty("java.home", "");
            File defaultExt = new File(bootPath, "lib/ext");
            String configDirName = System.getProperty("com.ibm.oti.configuration.dir");
            File opPkgExt = new File(bootPath, "lib/" + configDirName + "/opt-ext");
            extDirs = String.valueOf(defaultExt.getPath()) + File.pathSeparatorChar + opPkgExt.getPath();
            System.setProperty("java.ext.dirs", extDirs);
        }
        int index = 0;
        int extCount = 0;
        int end = extDirs.length();
        while (index < end) {
            int next = extDirs.indexOf(File.pathSeparatorChar, index);
            if (next == -1) {
                next = end;
            }
            if (next - index > 0) {
                ++extCount;
            }
            index = next + 1;
        }
        String[][] list = new String[extCount][];
        String[] extDirPath = new String[extCount];
        extCount = 0;
        index = 0;
        while (index < end) {
            int next = extDirs.indexOf(File.pathSeparatorChar, index);
            if (next == -1) {
                next = end;
            }
            if (next - index > 0) {
                String path = extDirs.substring(index, next);
                File extDir = new File(path);
                list[extCount] = extDir.list();
                if (list[extCount] != null) {
                    total += list[extCount].length;
                    extDirPath[extCount++] = String.valueOf(extDir.getPath()) + File.separatorChar;
                }
            }
            index = next + 1;
        }
        URL[] parsedPath = new URL[total];
        if (list != null) {
            int count = 0;
            int j = 0;
            while (j < list.length) {
                if (list[j] != null) {
                    int i = 0;
                    while (i < list[j].length) {
                        block22: {
                            boolean foundJxe;
                            String path;
                            String file;
                            block21: {
                                file = list[j][i];
                                path = null;
                                foundJxe = false;
                                if (file.length() > 4 && file.substring(file.length() - 4).equalsIgnoreCase(".jxe")) {
                                    try {
                                        Jxe jxe = Jxe.fromFile(new File(String.valueOf(extDirPath[j]) + file));
                                        if (jxe == null) break block21;
                                        parsedPath[count] = new URL("jxe", jxe.getUuid(), -1, "/", new Handler(jxe));
                                        ++count;
                                        break block22;
                                    }
                                    catch (IOException iOException) {
                                    }
                                    catch (JxeException jxeException) {
                                    }
                                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
                                }
                            }
                            if (!foundJxe) {
                                path = "file:" + extDirPath[j] + file;
                            }
                            try {
                                parsedPath[count] = new URL(path);
                                ++count;
                            }
                            catch (MalformedURLException malformedURLException) {}
                        }
                        ++i;
                    }
                }
                ++j;
            }
            if (count < parsedPath.length) {
                URL[] paths = new URL[count];
                System.arraycopy((Object)parsedPath, 0, (Object)paths, 0, count);
                parsedPath = paths;
            }
        }
        return parsedPath;
    }

    boolean addExitPermission() {
        return false;
    }
}

