/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.util.Msg;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written;

    public DataOutputStream(OutputStream out) {
        super(out);
    }

    public void flush() throws IOException {
        super.flush();
    }

    public final int size() {
        if (this.written < 0) {
            this.written = Integer.MAX_VALUE;
        }
        return this.written;
    }

    public void write(byte[] buffer, int offset, int count) throws IOException {
        if (buffer != null) {
            this.out.write(buffer, offset, count);
            this.written += count;
        } else {
            throw new NullPointerException(Msg.getString("K0047"));
        }
    }

    public void write(int oneByte) throws IOException {
        this.out.write(oneByte);
        ++this.written;
    }

    public final void writeBoolean(boolean val) throws IOException {
        this.out.write(val ? 1 : 0);
        ++this.written;
    }

    public final void writeByte(int val) throws IOException {
        this.out.write(val);
        ++this.written;
    }

    public final void writeBytes(String str) throws IOException {
        byte[] bytes = new byte[str.length()];
        int index = 0;
        while (index < str.length()) {
            bytes[index] = (byte)str.charAt(index);
            ++index;
        }
        this.out.write(bytes);
        this.written += bytes.length;
    }

    public final void writeChar(int val) throws IOException {
        this.out.write(val >> 8);
        this.out.write(val);
        this.written += 2;
    }

    public final void writeChars(String str) throws IOException {
        byte[] newBytes = new byte[str.length() * 2];
        int index = 0;
        while (index < str.length()) {
            int newIndex = index == 0 ? index : index * 2;
            newBytes[newIndex] = (byte)(str.charAt(index) >> 8);
            newBytes[newIndex + 1] = (byte)str.charAt(index);
            ++index;
        }
        this.out.write(newBytes);
        this.written += newBytes.length;
    }

    public final void writeDouble(double val) throws IOException {
        this.writeLong(Double.doubleToLongBits(val));
    }

    public final void writeFloat(float val) throws IOException {
        this.writeInt(Float.floatToIntBits(val));
    }

    public final void writeInt(int val) throws IOException {
        this.out.write(val >> 24);
        this.out.write(val >> 16);
        this.out.write(val >> 8);
        this.out.write(val);
        this.written += 4;
    }

    public final void writeLong(long val) throws IOException {
        this.writeInt((int)(val >> 32));
        this.writeInt((int)val);
    }

    public final void writeShort(int val) throws IOException {
        this.writeChar(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeUTF(String str) throws IOException {
        long utfCount;
        int length = str.length();
        if (length <= 2730) {
            int size = length * 3;
            boolean makeBuf = true;
            byte[] byArray = DataInputStream.byteBuf;
            synchronized (DataInputStream.byteBuf) {
                byte[] utfBytes;
                if (DataInputStream.useShared) {
                    DataInputStream.useShared = false;
                    makeBuf = false;
                }
                // ** MonitorExit[var6_6] (shouldn't be in output)
                if (makeBuf) {
                    utfBytes = new byte[size];
                } else {
                    if (DataInputStream.byteBuf.length < size) {
                        DataInputStream.byteBuf = new byte[size];
                    }
                    utfBytes = DataInputStream.byteBuf;
                }
                int utfIndex = 0;
                int i = 0;
                while (i < length) {
                    char charValue = str.charAt(i);
                    if (charValue > '\u0000' && charValue <= '\u007f') {
                        utfBytes[utfIndex++] = (byte)charValue;
                    } else if (charValue <= '\u07ff') {
                        utfBytes[utfIndex++] = (byte)(0xC0 | 0x1F & charValue >> 6);
                        utfBytes[utfIndex++] = (byte)(0x80 | 0x3F & charValue);
                    } else {
                        utfBytes[utfIndex++] = (byte)(0xE0 | 0xF & charValue >> 12);
                        utfBytes[utfIndex++] = (byte)(0x80 | 0x3F & charValue >> 6);
                        utfBytes[utfIndex++] = (byte)(0x80 | 0x3F & charValue);
                    }
                    ++i;
                }
                this.writeShort(utfIndex);
                this.write(utfBytes, 0, utfIndex);
                if (!makeBuf) {
                    DataInputStream.useShared = true;
                }
            }
        } else if (length <= 65535 && (utfCount = this.countUTFBytes(str)) <= 65535L) {
            this.writeShort((int)utfCount);
            this.writeUTFBytes(str, utfCount);
        } else {
            throw new UTFDataFormatException(Msg.getString("K0068"));
        }
    }

    long countUTFBytes(String str) {
        int utfCount = 0;
        int length = str.length();
        int i = 0;
        while (i < length) {
            char charValue = str.charAt(i);
            utfCount = charValue > '\u0000' && charValue <= '\u007f' ? ++utfCount : (charValue <= '\u07ff' ? (utfCount += 2) : (utfCount += 3));
            ++i;
        }
        return utfCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void writeUTFBytes(String str, long count) throws IOException {
        int length;
        byte[] utfBytes;
        boolean single = true;
        int size = (int)count;
        if (count > 8192L) {
            single = false;
            size = 8192;
        }
        boolean makeBuf = true;
        if (DataInputStream.useShared) {
            byte[] byArray = DataInputStream.byteBuf;
            // MONITORENTER : java.io.DataInputStream.byteBuf
            if (DataInputStream.useShared) {
                DataInputStream.useShared = false;
                makeBuf = false;
            }
            // MONITOREXIT : byArray
        }
        if (makeBuf) {
            utfBytes = new byte[size];
        } else {
            if (DataInputStream.byteBuf.length < size) {
                DataInputStream.byteBuf = new byte[size];
            }
            utfBytes = DataInputStream.byteBuf;
        }
        int utfIndex = 0;
        int i = 0;
        int end = length = str.length();
        while (i < length) {
            if (!single && (end = i + (utfBytes.length - utfIndex) / 3) > length) {
                end = length;
            }
            int j = i;
            while (j < end) {
                char charValue = str.charAt(j);
                if (charValue > '\u0000' && charValue <= '\u007f') {
                    utfBytes[utfIndex++] = (byte)charValue;
                } else if (charValue <= '\u07ff') {
                    utfBytes[utfIndex++] = (byte)(0xC0 | 0x1F & charValue >> 6);
                    utfBytes[utfIndex++] = (byte)(0x80 | 0x3F & charValue);
                } else {
                    utfBytes[utfIndex++] = (byte)(0xE0 | 0xF & charValue >> 12);
                    utfBytes[utfIndex++] = (byte)(0x80 | 0x3F & charValue >> 6);
                    utfBytes[utfIndex++] = (byte)(0x80 | 0x3F & charValue);
                }
                ++j;
            }
            if (single || utfIndex > utfBytes.length - 300) {
                this.write(utfBytes, 0, utfIndex);
                if (single) {
                    return;
                }
                utfIndex = 0;
            }
            i = end;
        }
        if (utfIndex > 0) {
            this.write(utfBytes, 0, utfIndex);
        }
        if (makeBuf) return;
        DataInputStream.useShared = true;
    }
}

