/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilePermission;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Vector;

final class FilePermissionCollection
extends PermissionCollection
implements Serializable {
    private static final long serialVersionUID = 2202956749081564585L;
    Vector permissions = new Vector();

    public void add(Permission permission) {
        if (!this.isReadOnly()) {
            if (!(permission instanceof FilePermission)) {
                throw new IllegalArgumentException(permission.toString());
            }
        } else {
            throw new IllegalStateException();
        }
        this.permissions.addElement(permission);
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }

    public boolean implies(Permission permission) {
        if (permission instanceof FilePermission) {
            FilePermission fp = (FilePermission)permission;
            int matchedMask = 0;
            int i = 0;
            while (i < this.permissions.size() && (matchedMask & fp.mask) != fp.mask) {
                matchedMask |= ((FilePermission)this.permissions.elementAt(i)).impliesMask(permission);
                ++i;
            }
            return (matchedMask & fp.mask) == fp.mask;
        }
        return false;
    }
}

