/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.PriviAction;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.EmulatedFields;
import java.io.EmulatedFieldsForDumping;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.util.IdentityHashMap;

public class ObjectOutputStream
extends OutputStream
implements ObjectOutput,
ObjectStreamConstants {
    private int nestedLevels;
    private DataOutputStream output;
    private boolean enableReplace;
    private DataOutputStream primitiveTypes;
    private ByteArrayOutputStream primitiveTypesBuffer;
    private IdentityHashMap objectsWritten;
    private int currentHandle;
    private Object currentObject;
    private ObjectStreamClass currentClass;
    private int protocolVersion;
    private StreamCorruptedException nestedException;
    private EmulatedFieldsForDumping currentPutField;
    private boolean subclassOverridingImplementation;
    private IdentityHashMap writeReplaceCache;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected ObjectOutputStream() throws IOException, SecurityException {
        SecurityManager currentManager = System.getSecurityManager();
        if (currentManager != null) {
            currentManager.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.subclassOverridingImplementation = true;
    }

    public ObjectOutputStream(OutputStream output) throws IOException {
        Class thisClass;
        Class implementationClass = this.getClass();
        Class clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.io.ObjectOutputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (implementationClass != (thisClass = clazz)) {
            SecurityManager sm;
            Method method;
            boolean mustCheck = false;
            try {
                method = implementationClass.getMethod("putFields", ObjectStreamClass.EMPTY_CONSTRUCTOR_PARAM_TYPES);
                mustCheck = method.getDeclaringClass() != thisClass;
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            if (!mustCheck) {
                try {
                    method = implementationClass.getMethod("writeUnshared", ObjectStreamClass.UNSHARED_PARAM_TYPES);
                    mustCheck = method.getDeclaringClass() != thisClass;
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            if (mustCheck && (sm = System.getSecurityManager()) != null) {
                sm.checkPermission(ObjectStreamConstants.SUBCLASS_IMPLEMENTATION_PERMISSION);
            }
        }
        this.output = output instanceof DataOutputStream ? (DataOutputStream)output : new DataOutputStream(output);
        this.enableReplace = false;
        this.protocolVersion = 2;
        this.subclassOverridingImplementation = false;
        this.writeReplaceCache = new IdentityHashMap();
        this.resetState();
        this.nestedException = new StreamCorruptedException();
        this.primitiveTypes = this.output;
        this.writeStreamHeader();
        this.primitiveTypes = null;
    }

    protected void annotateClass(Class aClass) throws IOException {
    }

    protected void annotateProxyClass(Class aClass) throws IOException {
    }

    private void checkWritePrimitiveTypes() throws IOException {
        if (this.primitiveTypes == null) {
            this.primitiveTypesBuffer = new ByteArrayOutputStream(128);
            this.primitiveTypes = new DataOutputStream(this.primitiveTypesBuffer);
        }
    }

    public void close() throws IOException {
        this.flush();
        this.output.close();
    }

    private void computePutField() {
        this.currentPutField = new EmulatedFieldsForDumping(this.currentClass);
    }

    public void defaultWriteObject() throws IOException {
        if (this.currentObject == null) {
            throw new NotActiveException();
        }
        this.writeFieldValues(this.currentObject, this.currentClass);
    }

    protected void drain() throws IOException {
        if (this.primitiveTypes == null) {
            return;
        }
        int offset = 0;
        byte[] written = this.primitiveTypesBuffer.toByteArray();
        while (offset < written.length) {
            int toWrite;
            int n = toWrite = written.length - offset > 1024 ? 1024 : written.length - offset;
            if (toWrite < 256) {
                this.output.writeByte(119);
                this.output.writeByte((byte)toWrite);
            } else {
                this.output.writeByte(122);
                this.output.writeInt(toWrite);
            }
            this.output.write(written, offset, toWrite);
            offset += toWrite;
        }
        this.primitiveTypes = null;
        this.primitiveTypesBuffer = null;
    }

    private Integer dumpCycle(Object obj) throws IOException {
        Integer handle = this.registeredObjectHandleFor(obj);
        if (handle != null) {
            this.writeCyclicReference(handle);
            return handle;
        }
        return null;
    }

    protected boolean enableReplaceObject(boolean enable) throws SecurityException {
        SecurityManager currentManager;
        if (enable && (currentManager = System.getSecurityManager()) != null) {
            currentManager.checkPermission(SUBSTITUTION_PERMISSION);
        }
        boolean originalValue = this.enableReplace;
        this.enableReplace = enable;
        return originalValue;
    }

    public void flush() throws IOException {
        this.drain();
        this.output.flush();
    }

    private static native boolean getFieldBool(Object var0, Class var1, String var2);

    private static native byte getFieldByte(Object var0, Class var1, String var2);

    private static native char getFieldChar(Object var0, Class var1, String var2);

    private static native double getFieldDouble(Object var0, Class var1, String var2);

    private static native float getFieldFloat(Object var0, Class var1, String var2);

    private static native int getFieldInt(Object var0, Class var1, String var2);

    private static native long getFieldLong(Object var0, Class var1, String var2);

    private static native Object getFieldObj(Object var0, Class var1, String var2, String var3);

    private static native short getFieldShort(Object var0, Class var1, String var2);

    private int nextHandle() {
        return this.currentHandle++;
    }

    public PutField putFields() throws IOException {
        if (this.currentObject != null) {
            if (this.currentPutField == null) {
                this.computePutField();
            }
            return this.currentPutField;
        }
        throw new NotActiveException();
    }

    private Integer registeredObjectHandleFor(Object obj) {
        return (Integer)this.objectsWritten.get(obj);
    }

    private Integer registerObjectWritten(Object obj) {
        Integer handle = new Integer(this.nextHandle());
        this.registerObjectWritten(obj, handle);
        return handle;
    }

    private void removeUnsharedReference(Object obj, Integer previousHandle) {
        if (previousHandle != null) {
            this.registerObjectWritten(obj, previousHandle);
        } else {
            this.objectsWritten.remove(obj);
        }
    }

    private void registerObjectWritten(Object obj, Integer handle) {
        this.objectsWritten.put(obj, handle);
    }

    protected Object replaceObject(Object object) throws IOException {
        return object;
    }

    public void reset() throws IOException {
        this.drain();
        this.output.writeByte(121);
        this.resetState();
    }

    private void resetSeenObjects() {
        this.objectsWritten = new IdentityHashMap();
        this.currentHandle = 0x7E0000;
    }

    private void resetState() {
        this.resetSeenObjects();
        this.nestedLevels = 0;
    }

    public void useProtocolVersion(int version) throws IOException {
        this.protocolVersion = version;
    }

    public void write(byte[] buffer) throws IOException {
        this.checkWritePrimitiveTypes();
        this.primitiveTypes.write(buffer);
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.checkWritePrimitiveTypes();
        this.primitiveTypes.write(buffer, offset, length);
    }

    public void write(int value) throws IOException {
        this.checkWritePrimitiveTypes();
        this.primitiveTypes.write(value);
    }

    public void writeBoolean(boolean value) throws IOException {
        this.checkWritePrimitiveTypes();
        this.primitiveTypes.writeBoolean(value);
    }

    public void writeByte(int value) throws IOException {
        this.checkWritePrimitiveTypes();
        this.primitiveTypes.writeByte(value);
    }

    public void writeBytes(String value) throws IOException {
        this.checkWritePrimitiveTypes();
        this.primitiveTypes.writeBytes(value);
    }

    public void writeChar(int value) throws IOException {
        this.checkWritePrimitiveTypes();
        this.primitiveTypes.writeChar(value);
    }

    public void writeChars(String value) throws IOException {
        this.checkWritePrimitiveTypes();
        this.primitiveTypes.writeChars(value);
    }

    private Integer writeClassDesc(ObjectStreamClass classDesc, boolean unshared) throws IOException {
        if (classDesc == null) {
            this.writeNull();
            return null;
        }
        Integer handle = null;
        if (!unshared) {
            handle = this.dumpCycle(classDesc);
        }
        if (handle == null) {
            Class classToWrite = classDesc.forClass();
            Integer previousHandle = (Integer)this.objectsWritten.get(classDesc);
            handle = this.registerObjectWritten(classDesc);
            if (Proxy.isProxyClass(classToWrite)) {
                this.output.writeByte(125);
                Class[] interfaces = classToWrite.getInterfaces();
                this.output.writeInt(interfaces.length);
                int i = 0;
                while (i < interfaces.length) {
                    this.output.writeUTF(interfaces[i].getName());
                    ++i;
                }
                this.annotateProxyClass(classToWrite);
                this.output.writeByte(120);
                Class clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.reflect.Proxy");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.writeClassDescForClass(clazz);
                if (unshared) {
                    this.removeUnsharedReference(classDesc, previousHandle);
                }
                return handle;
            }
            this.output.writeByte(114);
            if (this.protocolVersion == 1) {
                this.writeNewClassDesc(classDesc);
            } else {
                this.primitiveTypes = this.output;
                this.writeClassDescriptor(classDesc);
                this.primitiveTypes = null;
            }
            this.annotateClass(classToWrite);
            this.drain();
            this.output.writeByte(120);
            this.writeClassDesc(classDesc.getSuperclass(), false);
            if (unshared) {
                this.removeUnsharedReference(classDesc, previousHandle);
            }
        }
        return handle;
    }

    private Integer writeClassDescForClass(Class objClass) throws IOException {
        return this.writeClassDesc(ObjectStreamClass.lookup(objClass), false);
    }

    private void writeCyclicReference(Integer handle) throws IOException {
        this.output.writeByte(113);
        this.output.writeInt(handle);
    }

    public void writeDouble(double value) throws IOException {
        this.checkWritePrimitiveTypes();
        this.primitiveTypes.writeDouble(value);
    }

    private void writeFieldDescriptors(ObjectStreamClass classDesc, boolean externalizable) throws IOException {
        Class loadedClass = classDesc.forClass();
        ObjectStreamField[] fields = null;
        int fieldCount = 0;
        if (!externalizable && loadedClass != ObjectStreamClass.STRINGCLASS) {
            fields = classDesc.fields();
            fieldCount = fields.length;
        }
        this.output.writeShort(fieldCount);
        int i = 0;
        while (i < fieldCount) {
            ObjectStreamField f = fields[i];
            this.output.writeByte(f.getTypeCode());
            this.output.writeUTF(f.getName());
            if (!f.isPrimitive()) {
                this.writeObject(f.getTypeString());
            }
            ++i;
        }
    }

    public void writeFields() throws IOException {
        if (this.currentPutField == null) {
            throw new NotActiveException();
        }
        this.writeFieldValues(this.currentPutField);
    }

    private void writeFieldValues(EmulatedFieldsForDumping emulatedFields) throws IOException {
        EmulatedFields accessibleSimulatedFields = emulatedFields.emulatedFields();
        EmulatedFields.ObjectSlot[] slots = accessibleSimulatedFields.slots();
        int i = 0;
        while (i < slots.length) {
            EmulatedFields.ObjectSlot slot = slots[i];
            Object fieldValue = slot.getFieldValue();
            Class type = slot.getField().getType();
            if (type == Integer.TYPE) {
                this.output.writeInt(fieldValue != null ? (Integer)fieldValue : 0);
            } else if (type == Byte.TYPE) {
                this.output.writeByte(fieldValue != null ? (int)((Byte)fieldValue).byteValue() : 0);
            } else if (type == Character.TYPE) {
                this.output.writeChar(fieldValue != null ? (int)((Character)fieldValue).charValue() : 0);
            } else if (type == Short.TYPE) {
                this.output.writeShort(fieldValue != null ? (int)((Short)fieldValue).shortValue() : 0);
            } else if (type == Boolean.TYPE) {
                this.output.writeBoolean(fieldValue != null ? (Boolean)fieldValue : false);
            } else if (type == Long.TYPE) {
                this.output.writeLong(fieldValue != null ? (Long)fieldValue : 0L);
            } else if (type == Float.TYPE) {
                this.output.writeFloat(fieldValue != null ? ((Float)fieldValue).floatValue() : 0.0f);
            } else if (type == Double.TYPE) {
                this.output.writeDouble(fieldValue != null ? (Double)fieldValue : 0.0);
            } else {
                this.writeObject(fieldValue);
            }
            ++i;
        }
    }

    private void writeFieldValues(Object obj, ObjectStreamClass classDesc) throws IOException {
        ObjectStreamField[] fields = classDesc.fields();
        Class declaringClass = classDesc.forClass();
        int i = 0;
        while (i < fields.length) {
            block16: {
                try {
                    ObjectStreamField fieldDesc = fields[i];
                    if (fieldDesc.isPrimitive()) {
                        switch (fieldDesc.getTypeCode()) {
                            case 'B': {
                                this.output.writeByte(ObjectOutputStream.getFieldByte(obj, declaringClass, fieldDesc.getName()));
                                break block16;
                            }
                            case 'C': {
                                this.output.writeChar(ObjectOutputStream.getFieldChar(obj, declaringClass, fieldDesc.getName()));
                                break block16;
                            }
                            case 'D': {
                                this.output.writeDouble(ObjectOutputStream.getFieldDouble(obj, declaringClass, fieldDesc.getName()));
                                break block16;
                            }
                            case 'F': {
                                this.output.writeFloat(ObjectOutputStream.getFieldFloat(obj, declaringClass, fieldDesc.getName()));
                                break block16;
                            }
                            case 'I': {
                                this.output.writeInt(ObjectOutputStream.getFieldInt(obj, declaringClass, fieldDesc.getName()));
                                break block16;
                            }
                            case 'J': {
                                this.output.writeLong(ObjectOutputStream.getFieldLong(obj, declaringClass, fieldDesc.getName()));
                                break block16;
                            }
                            case 'S': {
                                this.output.writeShort(ObjectOutputStream.getFieldShort(obj, declaringClass, fieldDesc.getName()));
                                break block16;
                            }
                            case 'Z': {
                                this.output.writeBoolean(ObjectOutputStream.getFieldBool(obj, declaringClass, fieldDesc.getName()));
                                break block16;
                            }
                            default: {
                                throw new IOException(Msg.getString("K00d5", fieldDesc.getTypeCode()));
                            }
                        }
                    }
                    Object field = ObjectOutputStream.getFieldObj(obj, declaringClass, fieldDesc.getName(), fieldDesc.getTypeString());
                    if (fieldDesc.getUnshared()) {
                        this.writeUnshared(field);
                    } else {
                        this.writeObject(field);
                    }
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    throw new InvalidClassException(classDesc.getName());
                }
            }
            ++i;
        }
    }

    public void writeFloat(float value) throws IOException {
        this.checkWritePrimitiveTypes();
        this.primitiveTypes.writeFloat(value);
    }

    private void writeHierarchy(Object object, ObjectStreamClass classDesc) throws IOException, NotActiveException {
        if (object != null) {
            if (classDesc.getSuperclass() != null) {
                this.writeHierarchy(object, classDesc.getSuperclass());
            }
            this.currentObject = object;
            this.currentClass = classDesc;
            boolean executed = false;
            Class targetClass = classDesc.forClass();
            try {
                Method method = ObjectStreamClass.getPrivateWriteObjectMethod(targetClass);
                if (method != null) {
                    AccessController.doPrivileged(new PriviAction(method));
                    try {
                        method.invoke(object, new Object[]{this});
                        executed = true;
                    }
                    catch (InvocationTargetException e) {
                        Throwable ex = e.getTargetException();
                        if (ex instanceof RuntimeException) {
                            throw (RuntimeException)ex;
                        }
                        if (ex instanceof Error) {
                            throw (Error)ex;
                        }
                        throw (IOException)ex;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e.toString());
                    }
                }
                if (executed) {
                    this.drain();
                    this.output.writeByte(120);
                }
                this.defaultWriteObject();
            }
            finally {
                this.currentObject = null;
                this.currentClass = null;
                this.currentPutField = null;
            }
        } else {
            throw new NotActiveException();
        }
    }

    public void writeInt(int value) throws IOException {
        this.checkWritePrimitiveTypes();
        this.primitiveTypes.writeInt(value);
    }

    public void writeLong(long value) throws IOException {
        this.checkWritePrimitiveTypes();
        this.primitiveTypes.writeLong(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Integer writeNewArray(Object array, Class arrayClass, Class componentType) throws IOException {
        this.output.writeByte(117);
        this.writeClassDescForClass(arrayClass);
        Integer handle = this.registerObjectWritten(array);
        if (componentType.isPrimitive()) {
            if (componentType == Integer.TYPE) {
                int[] intArray = (int[])array;
                this.output.writeInt(intArray.length);
                int i = 0;
                while (i < intArray.length) {
                    this.output.writeInt(intArray[i]);
                    ++i;
                }
                return handle;
            } else if (componentType == Byte.TYPE) {
                byte[] byteArray = (byte[])array;
                this.output.writeInt(byteArray.length);
                this.output.write(byteArray, 0, byteArray.length);
                return handle;
            } else if (componentType == Character.TYPE) {
                char[] charArray = (char[])array;
                this.output.writeInt(charArray.length);
                int i = 0;
                while (i < charArray.length) {
                    this.output.writeChar(charArray[i]);
                    ++i;
                }
                return handle;
            } else if (componentType == Short.TYPE) {
                short[] shortArray = (short[])array;
                this.output.writeInt(shortArray.length);
                int i = 0;
                while (i < shortArray.length) {
                    this.output.writeShort(shortArray[i]);
                    ++i;
                }
                return handle;
            } else if (componentType == Boolean.TYPE) {
                boolean[] booleanArray = (boolean[])array;
                this.output.writeInt(booleanArray.length);
                int i = 0;
                while (i < booleanArray.length) {
                    this.output.writeBoolean(booleanArray[i]);
                    ++i;
                }
                return handle;
            } else if (componentType == Long.TYPE) {
                long[] longArray = (long[])array;
                this.output.writeInt(longArray.length);
                int i = 0;
                while (i < longArray.length) {
                    this.output.writeLong(longArray[i]);
                    ++i;
                }
                return handle;
            } else if (componentType == Float.TYPE) {
                float[] floatArray = (float[])array;
                this.output.writeInt(floatArray.length);
                int i = 0;
                while (i < floatArray.length) {
                    this.output.writeFloat(floatArray[i]);
                    ++i;
                }
                return handle;
            } else {
                if (componentType != Double.TYPE) throw new InvalidClassException(Msg.getString("K00d7", arrayClass.getName()));
                double[] doubleArray = (double[])array;
                this.output.writeInt(doubleArray.length);
                int i = 0;
                while (i < doubleArray.length) {
                    this.output.writeDouble(doubleArray[i]);
                    ++i;
                }
            }
            return handle;
        } else {
            Object[] objectArray = (Object[])array;
            this.output.writeInt(objectArray.length);
            int i = 0;
            while (i < objectArray.length) {
                this.writeObject(objectArray[i]);
                ++i;
            }
        }
        return handle;
    }

    private Integer writeNewClass(Class object) throws IOException {
        this.output.writeByte(118);
        this.writeClassDesc(ObjectStreamClass.lookupStreamClass(object), false);
        return this.registerObjectWritten(object);
    }

    private void writeNewClassDesc(ObjectStreamClass classDesc) throws IOException {
        this.output.writeUTF(classDesc.getName());
        this.output.writeLong(classDesc.getSerialVersionUID());
        byte flags = classDesc.getFlags();
        boolean externalizable = false;
        externalizable = ObjectStreamClass.isExternalizable(classDesc.forClass());
        if (this.protocolVersion != 1 && externalizable) {
            flags = (byte)(flags | 8);
        }
        this.output.writeByte(flags);
        this.writeFieldDescriptors(classDesc, externalizable);
    }

    protected void writeClassDescriptor(ObjectStreamClass classDesc) throws IOException {
        this.writeNewClassDesc(classDesc);
    }

    private void writeNewException(Exception ex) throws IOException {
        this.output.writeByte(123);
        this.resetSeenObjects();
        this.writeObjectInternal(ex, false, false, false);
        this.resetSeenObjects();
    }

    private void checkSerializable(Class theClass, boolean externalizable) throws IOException {
        boolean serializable = ObjectStreamClass.isSerializable(theClass);
        if (!externalizable && !serializable) {
            throw new NotSerializableException(theClass.getName());
        }
    }

    private Integer writeNewObject(Object object, Class theClass, boolean unshared) throws IOException {
        EmulatedFieldsForDumping originalCurrentPutField = this.currentPutField;
        this.currentPutField = null;
        boolean externalizable = ObjectStreamClass.isExternalizable(theClass);
        this.checkSerializable(theClass, externalizable);
        this.output.writeByte(115);
        this.writeClassDescForClass(theClass);
        Integer previousHandle = (Integer)this.objectsWritten.get(object);
        Integer handle = this.registerObjectWritten(object);
        this.currentObject = object;
        this.currentClass = ObjectStreamClass.lookup(theClass);
        try {
            if (externalizable) {
                boolean noBlockData;
                boolean bl = noBlockData = this.protocolVersion == 1;
                if (noBlockData) {
                    this.primitiveTypes = this.output;
                }
                ((Externalizable)object).writeExternal(this);
                if (noBlockData) {
                    this.primitiveTypes = null;
                } else {
                    this.drain();
                    this.output.writeByte(120);
                }
            } else {
                this.writeHierarchy(object, this.currentClass);
            }
        }
        finally {
            if (unshared) {
                this.removeUnsharedReference(object, previousHandle);
            }
            this.currentObject = null;
            this.currentClass = null;
            this.currentPutField = originalCurrentPutField;
        }
        return handle;
    }

    private Integer writeNewString(String object) throws IOException {
        long count = this.output.countUTFBytes(object);
        if (count <= 65535L) {
            this.output.writeByte(116);
            this.output.writeShort((short)count);
        } else {
            this.output.writeByte(124);
            this.output.writeLong(count);
        }
        this.output.writeUTFBytes(object, count);
        return this.registerObjectWritten(object);
    }

    private void writeNull() throws IOException {
        this.output.writeByte(112);
    }

    public final void writeObject(Object object) throws IOException {
        this.writeObject(object, false);
    }

    public void writeUnshared(Object object) throws IOException {
        this.writeObject(object, true);
    }

    private void writeObject(Object object, boolean unshared) throws IOException {
        boolean setOutput = this.primitiveTypes == this.output;
        if (setOutput) {
            this.primitiveTypes = null;
        }
        if (this.subclassOverridingImplementation && !unshared) {
            this.writeObjectOverride(object);
        } else {
            try {
                this.drain();
                this.writeObjectInternal(object, unshared, true, true);
                if (setOutput) {
                    this.primitiveTypes = this.output;
                }
            }
            catch (IOException ioEx1) {
                if (this.nestedLevels == 0 && ioEx1 != this.nestedException) {
                    try {
                        this.writeNewException(ioEx1);
                    }
                    catch (IOException iOException) {
                        this.nestedException.fillInStackTrace();
                        throw this.nestedException;
                    }
                }
                throw ioEx1;
            }
        }
    }

    private Integer writeObjectInternal(Object object, boolean unshared, boolean computeClassBasedReplacement, boolean computeStreamReplacement) throws IOException {
        if (object == null) {
            this.writeNull();
            return null;
        }
        Integer handle = null;
        if (!unshared && (handle = this.dumpCycle(object)) != null) {
            return handle;
        }
        Class objClass = object.getClass();
        ++this.nestedLevels;
        try {
            Object streamReplacement;
            Object writeReplaceMethod;
            if (objClass == ObjectStreamClass.CLASSCLASS) {
                Integer n = this.writeNewClass((Class)object);
                return n;
            }
            if (objClass == ObjectStreamClass.OBJECTSTREAMCLASSCLASS) {
                Integer n = this.writeClassDesc((ObjectStreamClass)object, unshared);
                return n;
            }
            if (computeClassBasedReplacement && (writeReplaceMethod = this.writeReplaceCache.get(objClass)) != this) {
                if (writeReplaceMethod == null) {
                    Method writeReplace = ObjectStreamClass.methodWriteReplace(objClass);
                    if (writeReplace == null) {
                        this.writeReplaceCache.put(objClass, this);
                        writeReplaceMethod = null;
                    } else {
                        boolean externalizable = ObjectStreamClass.isExternalizable(objClass);
                        this.checkSerializable(objClass, externalizable);
                        AccessController.doPrivileged(new PriviAction(writeReplace));
                        this.writeReplaceCache.put(objClass, writeReplace);
                        writeReplaceMethod = writeReplace;
                    }
                }
                if (writeReplaceMethod != null) {
                    Object classBasedReplacement;
                    try {
                        classBasedReplacement = ((Method)writeReplaceMethod).invoke(object, null);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        classBasedReplacement = object;
                    }
                    catch (InvocationTargetException ite) {
                        Throwable target = ite.getTargetException();
                        if (target instanceof ObjectStreamException) {
                            throw (ObjectStreamException)target;
                        }
                        if (target instanceof Error) {
                            throw (Error)target;
                        }
                        throw (RuntimeException)target;
                    }
                    if (classBasedReplacement != object) {
                        Integer replacementHandle = this.writeObjectInternal(classBasedReplacement, false, false, computeStreamReplacement);
                        if (replacementHandle != null) {
                            this.registerObjectWritten(object, replacementHandle);
                        }
                        Integer n = replacementHandle;
                        return n;
                    }
                }
            }
            if (this.enableReplace && computeStreamReplacement && (streamReplacement = this.replaceObject(object)) != object) {
                Integer replacementHandle = this.writeObjectInternal(streamReplacement, false, computeClassBasedReplacement, false);
                if (replacementHandle != null) {
                    this.registerObjectWritten(object, replacementHandle);
                }
                Integer n = replacementHandle;
                return n;
            }
            if (objClass == ObjectStreamClass.STRINGCLASS) {
                Integer n = this.writeNewString((String)object);
                return n;
            }
            if (objClass.isArray()) {
                Integer n = this.writeNewArray(object, objClass, objClass.getComponentType());
                return n;
            }
            Integer n = this.writeNewObject(object, objClass, unshared);
            return n;
        }
        finally {
            --this.nestedLevels;
        }
    }

    protected void writeObjectOverride(Object object) throws IOException {
        throw new IOException();
    }

    public void writeShort(int value) throws IOException {
        this.checkWritePrimitiveTypes();
        this.primitiveTypes.writeShort(value);
    }

    protected void writeStreamHeader() throws IOException {
        this.output.writeShort(-21267);
        this.output.writeShort(5);
    }

    public void writeUTF(String value) throws IOException {
        this.checkWritePrimitiveTypes();
        this.primitiveTypes.writeUTF(value);
    }

    public static abstract class PutField {
        public abstract void put(String var1, boolean var2);

        public abstract void put(String var1, char var2);

        public abstract void put(String var1, byte var2);

        public abstract void put(String var1, short var2);

        public abstract void put(String var1, int var2);

        public abstract void put(String var1, long var2);

        public abstract void put(String var1, float var2);

        public abstract void put(String var1, double var2);

        public abstract void put(String var1, Object var2);

        public abstract void write(ObjectOutput var1) throws IOException;
    }
}

