/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.ibm.oti.util.Inet6Util;
import com.ibm.oti.util.Msg;
import com.ibm.oti.util.PriviAction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.NegativeCache;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class InetAddress
implements Serializable {
    static final byte[] any_bytes = new byte[4];
    static final byte[] localhost_bytes;
    static final InetAddress ANY;
    static final InetAddress LOOPBACK;
    private static final long serialVersionUID = 3286316764910316507L;
    String hostName;
    int family = 2;
    byte[] ipaddress;
    private static final ObjectStreamField[] serialPersistentFields;
    static /* synthetic */ Class class$0;

    static {
        byte[] byArray = new byte[4];
        byArray[0] = 127;
        byArray[3] = 1;
        localhost_bytes = byArray;
        ANY = new Inet4Address(any_bytes);
        LOOPBACK = new Inet4Address(localhost_bytes, "localhost");
        InetAddress.oneTimeInitialization(true);
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[3];
        objectStreamFieldArray[0] = new ObjectStreamField("address", Integer.TYPE);
        objectStreamFieldArray[1] = new ObjectStreamField("family", Integer.TYPE);
        Class clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[2] = new ObjectStreamField("hostName", clazz);
        serialPersistentFields = objectStreamFieldArray;
    }

    private static native void oneTimeInitialization(boolean var0);

    InetAddress() {
    }

    InetAddress(byte[] address) {
        this.ipaddress = address;
    }

    InetAddress(byte[] address, String hostName) {
        this.ipaddress = address;
        this.hostName = hostName;
    }

    static byte[] addressOf(int addr) {
        int temp = addr;
        byte[] array = new byte[4];
        array[3] = (byte)(temp & 0xFF);
        array[2] = (byte)((temp >>>= 8) & 0xFF);
        array[1] = (byte)((temp >>>= 8) & 0xFF);
        array[0] = (byte)((temp >>>= 8) & 0xFF);
        return array;
    }

    CacheElement cacheElement() {
        return new CacheElement();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        byte[] objIPaddress = ((InetAddress)obj).ipaddress;
        int i = 0;
        while (i < objIPaddress.length) {
            if (objIPaddress[i] != this.ipaddress[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public byte[] getAddress() {
        return (byte[])this.ipaddress.clone();
    }

    public static InetAddress[] getAllByName(String host) throws UnknownHostException {
        if (host == null) {
            return new InetAddress[]{InetAddress.preferIPv6Addresses() ? Inet6Address.LOOPBACK : LOOPBACK};
        }
        if (host.length() == 0) {
            throw new UnknownHostException(Msg.getString("K0038"));
        }
        if (InetAddress.isHostName(host)) {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkConnect(host, -1);
            }
            if (Socket.preferIPv4Stack()) {
                return InetAddress.getAliasesByNameImpl(host);
            }
            InetAddress[] returnedAddresses = InetAddress.getAliasesByNameImpl(host);
            InetAddress[] orderedAddresses = null;
            if (returnedAddresses != null) {
                orderedAddresses = new InetAddress[returnedAddresses.length];
                int curPosition = 0;
                if (InetAddress.preferIPv6Addresses()) {
                    int i = 0;
                    while (i < returnedAddresses.length) {
                        if (returnedAddresses[i] instanceof Inet6Address) {
                            orderedAddresses[curPosition] = returnedAddresses[i];
                            ++curPosition;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < returnedAddresses.length) {
                        if (returnedAddresses[i] instanceof Inet4Address) {
                            orderedAddresses[curPosition] = returnedAddresses[i];
                            ++curPosition;
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < returnedAddresses.length) {
                        if (returnedAddresses[i] instanceof Inet4Address) {
                            orderedAddresses[curPosition] = returnedAddresses[i];
                            ++curPosition;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < returnedAddresses.length) {
                        if (returnedAddresses[i] instanceof Inet6Address) {
                            orderedAddresses[curPosition] = returnedAddresses[i];
                            ++curPosition;
                        }
                        ++i;
                    }
                }
            }
            return orderedAddresses;
        }
        byte[] hBytes = Inet6Util.createByteArrayFromIPAddressString(host);
        if (hBytes.length == 4) {
            return new InetAddress[]{new Inet4Address(hBytes)};
        }
        if (hBytes.length == 16) {
            return new InetAddress[]{new Inet6Address(hBytes)};
        }
        return new InetAddress[]{new InetAddress(hBytes)};
    }

    public static InetAddress getByName(String host) throws UnknownHostException {
        if (host == null || host.length() == 0) {
            return LOOPBACK;
        }
        if (host.equals("0")) {
            return ANY;
        }
        if (InetAddress.isHostName(host)) {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkConnect(host, -1);
            }
            return InetAddress.lookupHostByName(host);
        }
        return InetAddress.createHostNameFromIPAddress(host);
    }

    public String getHostAddress() {
        return InetAddress.inetNtoaImpl(InetAddress.bytesToInt(this.ipaddress, 0));
    }

    public String getHostName() {
        try {
            if (this.hostName == null) {
                int address = 0;
                if (this.ipaddress.length == 4 && (address = InetAddress.bytesToInt(this.ipaddress, 0)) == 0) {
                    this.hostName = InetAddress.inetNtoaImpl(address);
                    return this.hostName;
                }
                this.hostName = InetAddress.getHostByAddrImpl((byte[])this.ipaddress).hostName;
            }
        }
        catch (UnknownHostException unknownHostException) {
            this.hostName = Inet6Util.createIPAddrStringFromByteArray(this.ipaddress);
            return this.hostName;
        }
        SecurityManager security = System.getSecurityManager();
        try {
            if (security != null && InetAddress.isHostName(this.hostName)) {
                security.checkConnect(this.hostName, -1);
            }
        }
        catch (SecurityException securityException) {
            return Inet6Util.createIPAddrStringFromByteArray(this.ipaddress);
        }
        return this.hostName;
    }

    public String getCanonicalHostName() {
        String canonicalName;
        try {
            int address = 0;
            if (this.ipaddress.length == 4 && (address = InetAddress.bytesToInt(this.ipaddress, 0)) == 0) {
                return InetAddress.inetNtoaImpl(address);
            }
            canonicalName = InetAddress.getHostByAddrImpl((byte[])this.ipaddress).hostName;
        }
        catch (UnknownHostException unknownHostException) {
            return Inet6Util.createIPAddrStringFromByteArray(this.ipaddress);
        }
        SecurityManager security = System.getSecurityManager();
        try {
            if (security != null && InetAddress.isHostName(canonicalName)) {
                security.checkConnect(canonicalName, -1);
            }
        }
        catch (SecurityException securityException) {
            return Inet6Util.createIPAddrStringFromByteArray(this.ipaddress);
        }
        return canonicalName;
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        String host = InetAddress.getHostNameImpl();
        SecurityManager security = System.getSecurityManager();
        try {
            if (security != null) {
                security.checkConnect(host, -1);
            }
        }
        catch (SecurityException securityException) {
            return LOOPBACK;
        }
        return InetAddress.lookupHostByName(host);
    }

    public int hashCode() {
        return InetAddress.bytesToInt(this.ipaddress, 0);
    }

    public boolean isMulticastAddress() {
        return (this.ipaddress[0] & 0xFF) >>> 4 == 14;
    }

    static synchronized InetAddress lookupHostByName(String host) throws UnknownHostException {
        InetAddress anInetAddress;
        int ttl = -1;
        String ttlValue = (String)AccessController.doPrivileged(new PriviAction("networkaddress.cache.ttl"));
        try {
            if (ttlValue != null) {
                ttl = Integer.decode(ttlValue);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        CacheElement element = null;
        if (ttl == 0) {
            Cache.clear();
        } else {
            element = Cache.get(host);
            if (element != null && ttl > 0 && element.timeAdded + (long)(ttl * 1000) < System.currentTimeMillis()) {
                element = null;
            }
        }
        if (element != null) {
            return element.inetAddress();
        }
        String failedMessage = NegativeCache.getFailedMessage(host);
        if (failedMessage != null) {
            throw new UnknownHostException(String.valueOf(host) + " - " + failedMessage);
        }
        try {
            anInetAddress = InetAddress.getHostByNameImpl(host, InetAddress.preferIPv6Addresses());
        }
        catch (UnknownHostException e) {
            NegativeCache.put(host, e.getMessage());
            throw new UnknownHostException(String.valueOf(host) + " - " + e.getMessage());
        }
        Cache.add(anInetAddress);
        return anInetAddress;
    }

    static native InetAddress[] getAliasesByNameImpl(String var0) throws UnknownHostException;

    static native InetAddress getHostByAddrImpl(byte[] var0) throws UnknownHostException;

    static int inetAddr(String host) throws UnknownHostException {
        return host.equals("255.255.255.255") ? -1 : InetAddress.inetAddrImpl(host);
    }

    static native int inetAddrImpl(String var0) throws UnknownHostException;

    static native String inetNtoaImpl(int var0);

    static native InetAddress getHostByNameImpl(String var0, boolean var1) throws UnknownHostException;

    static native String getHostNameImpl();

    static String getHostNameInternal(String host) throws UnknownHostException {
        if (host == null || host.length() == 0) {
            return LOOPBACK.getHostAddress();
        }
        if (InetAddress.isHostName(host)) {
            return InetAddress.lookupHostByName(host).getHostAddress();
        }
        return host;
    }

    public String toString() {
        if (this.hostName == null) {
            return "/" + this.getHostAddress();
        }
        return String.valueOf(this.getHostName()) + "/" + this.getHostAddress();
    }

    private static boolean isHostName(String value) {
        return !Inet6Util.isValidIPV4Address(value) && !Inet6Util.isValidIP6Address(value);
    }

    public boolean isLoopbackAddress() {
        return false;
    }

    public boolean isLinkLocalAddress() {
        return false;
    }

    public boolean isSiteLocalAddress() {
        return false;
    }

    public boolean isMCGlobal() {
        return false;
    }

    public boolean isMCNodeLocal() {
        return false;
    }

    public boolean isMCLinkLocal() {
        return false;
    }

    public boolean isMCSiteLocal() {
        return false;
    }

    public boolean isMCOrgLocal() {
        return false;
    }

    public boolean isAnyLocalAddress() {
        return false;
    }

    public static InetAddress getByAddress(byte[] ipAddress) throws UnknownHostException {
        return InetAddress.getByAddress(ipAddress, 0);
    }

    static InetAddress getByAddress(byte[] ipAddress, int scope_id) throws UnknownHostException {
        if (ipAddress != null && ipAddress.length == 4) {
            byte[] copy_address = new byte[4];
            int i = 0;
            while (i < 4) {
                copy_address[i] = ipAddress[i];
                ++i;
            }
            return new Inet4Address(ipAddress);
        }
        if (ipAddress != null && ipAddress.length == 16) {
            if (InetAddress.isIPv4MappedAddress(ipAddress)) {
                byte[] copy_address = new byte[4];
                int i = 0;
                while (i < 4) {
                    copy_address[i] = ipAddress[12 + i];
                    ++i;
                }
                return new Inet4Address(copy_address);
            }
            byte[] copy_address = (byte[])ipAddress.clone();
            return new Inet6Address(copy_address, scope_id);
        }
        throw new UnknownHostException(Msg.getString("K0339"));
    }

    private static boolean isIPv4MappedAddress(byte[] ipAddress) {
        int i = 0;
        while (i < 10) {
            if (ipAddress[i] != 0) {
                return false;
            }
            ++i;
        }
        return ipAddress[10] == -1 && ipAddress[11] == -1;
    }

    public static InetAddress getByAddress(String hostName, byte[] ipAddress) throws UnknownHostException {
        return InetAddress.getByAddress(hostName, ipAddress, 0);
    }

    static InetAddress getByAddress(String hostName, byte[] ipAddress, int scope_id) throws UnknownHostException {
        if (ipAddress != null && ipAddress.length == 4) {
            byte[] copy_address = new byte[4];
            int i = 0;
            while (i < 4) {
                copy_address[i] = ipAddress[i];
                ++i;
            }
            return new Inet4Address(ipAddress, hostName);
        }
        if (ipAddress != null && ipAddress.length == 16) {
            if (InetAddress.isIPv4MappedAddress(ipAddress)) {
                byte[] copy_address = new byte[4];
                int i = 0;
                while (i < 4) {
                    copy_address[i] = ipAddress[12 + i];
                    ++i;
                }
                return new Inet4Address(ipAddress, hostName);
            }
            byte[] copy_address = new byte[16];
            int i = 0;
            while (i < 16) {
                copy_address[i] = ipAddress[i];
                ++i;
            }
            return new Inet6Address(ipAddress, hostName, scope_id);
        }
        throw new UnknownHostException(Msg.getString("K0332", hostName));
    }

    static void intToBytes(int value, byte[] bytes, int start) {
        bytes[start] = (byte)(value >> 24 & 0xFF);
        bytes[start + 1] = (byte)(value >> 16 & 0xFF);
        bytes[start + 2] = (byte)(value >> 8 & 0xFF);
        bytes[start + 3] = (byte)(value & 0xFF);
    }

    static int bytesToInt(byte[] bytes, int start) {
        int value = bytes[start + 3] & 0xFF | (bytes[start + 2] & 0xFF) << 8 | (bytes[start + 1] & 0xFF) << 16 | (bytes[start] & 0xFF) << 24;
        return value;
    }

    static InetAddress createHostNameFromIPAddress(String ipAddressString) throws UnknownHostException {
        InetAddress address = null;
        if (Inet6Util.isValidIPV4Address(ipAddressString)) {
            StringTokenizer tokenizer = new StringTokenizer(ipAddressString, ".");
            String token = "";
            int tempInt = 0;
            byte[] byteAddress = new byte[4];
            int i = 0;
            while (i < 4) {
                token = tokenizer.nextToken();
                tempInt = Integer.parseInt(token);
                byteAddress[i] = (byte)tempInt;
                ++i;
            }
            address = new Inet4Address(byteAddress);
        } else {
            int i;
            if (ipAddressString.charAt(0) == '[') {
                ipAddressString = ipAddressString.substring(1, ipAddressString.length() - 1);
            }
            StringTokenizer tokenizer = new StringTokenizer(ipAddressString, ":.%", true);
            ArrayList hexStrings = new ArrayList();
            ArrayList decStrings = new ArrayList();
            String scopeString = null;
            String token = "";
            String prevToken = "";
            String prevPrevToken = "";
            int doubleColonIndex = -1;
            while (tokenizer.hasMoreTokens()) {
                prevPrevToken = prevToken;
                prevToken = token;
                token = tokenizer.nextToken();
                if (token.equals(":")) {
                    if (prevToken.equals(":")) {
                        doubleColonIndex = hexStrings.size();
                        continue;
                    }
                    if (prevToken.equals("")) continue;
                    hexStrings.add(prevToken);
                    continue;
                }
                if (token.equals(".")) {
                    decStrings.add(prevToken);
                    continue;
                }
                if (!token.equals("%")) continue;
                if (!prevToken.equals(":") && !prevToken.equals(".")) {
                    if (prevPrevToken.equals(":")) {
                        hexStrings.add(prevToken);
                    } else if (prevPrevToken.equals(".")) {
                        decStrings.add(prevToken);
                    }
                }
                scopeString = tokenizer.nextToken();
                while (tokenizer.hasMoreTokens()) {
                    scopeString = String.valueOf(scopeString) + tokenizer.nextToken();
                }
            }
            if (prevToken.equals(":")) {
                if (token.equals(":")) {
                    doubleColonIndex = hexStrings.size();
                } else {
                    hexStrings.add(token);
                }
            } else if (prevToken.equals(".")) {
                decStrings.add(token);
            }
            int hexStringsLength = 8;
            if (decStrings.size() > 0) {
                hexStringsLength -= 2;
            }
            if (doubleColonIndex != -1) {
                int numberToInsert = hexStringsLength - hexStrings.size();
                i = 0;
                while (i < numberToInsert) {
                    hexStrings.add(doubleColonIndex, "0");
                    ++i;
                }
            }
            byte[] ipByteArray = new byte[16];
            i = 0;
            while (i < hexStrings.size()) {
                Inet6Util.convertToBytes((String)hexStrings.get(i), ipByteArray, i * 2);
                ++i;
            }
            i = 0;
            while (i < decStrings.size()) {
                ipByteArray[i + 12] = (byte)(Integer.parseInt((String)decStrings.get(i)) & 0xFF);
                ++i;
            }
            boolean ipV4 = true;
            int i2 = 0;
            while (i2 < 10) {
                if (ipByteArray[i2] != 0) {
                    ipV4 = false;
                    break;
                }
                ++i2;
            }
            if (ipByteArray[10] != -1 || ipByteArray[11] != -1) {
                ipV4 = false;
            }
            if (ipV4) {
                byte[] ipv4ByteArray = new byte[4];
                int i3 = 0;
                while (i3 < 4) {
                    ipv4ByteArray[i3] = ipByteArray[i3 + 12];
                    ++i3;
                }
                address = InetAddress.getByAddress(ipv4ByteArray);
            } else {
                int scopeId = 0;
                if (scopeString != null) {
                    try {
                        scopeId = Integer.parseInt(scopeString);
                    }
                    catch (Exception exception) {
                        try {
                            NetworkInterface ni = NetworkInterface.getByName(scopeString);
                            Enumeration ifs = ni.getInetAddresses();
                            while (ifs.hasMoreElements()) {
                                InetAddress ia = (InetAddress)ifs.nextElement();
                                if (!(ia instanceof Inet6Address) || !ia.isLinkLocalAddress()) continue;
                                Inet6Address ipv6 = (Inet6Address)ia;
                                scopeId = ipv6.scope_id;
                            }
                        }
                        catch (Exception exception2) {
                            throw new UnknownHostException(Msg.getString("K030f"));
                        }
                    }
                }
                address = InetAddress.getByAddress(ipByteArray, scopeId);
            }
        }
        return address;
    }

    static boolean preferIPv6Addresses() {
        String result = (String)AccessController.doPrivileged(new PriviAction("java.net.preferIPv6Addresses"));
        return "true".equals(result);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        ObjectOutputStream.PutField fields = stream.putFields();
        if (this.ipaddress == null) {
            fields.put("address", 0);
        } else {
            fields.put("address", InetAddress.bytesToInt(this.ipaddress, 0));
        }
        fields.put("family", this.family);
        fields.put("hostName", this.hostName);
        stream.writeFields();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        int addr = fields.get("address", 0);
        this.ipaddress = new byte[4];
        InetAddress.intToBytes(addr, this.ipaddress, 0);
        this.hostName = (String)fields.get("hostName", null);
        this.family = fields.get("family", 2);
    }

    private Object readResolve() throws ObjectStreamException {
        return new Inet4Address(this.ipaddress, this.hostName);
    }

    class CacheElement {
        long timeAdded = System.currentTimeMillis();
        CacheElement next;

        String hostName() {
            return InetAddress.this.hostName;
        }

        InetAddress inetAddress() {
            return InetAddress.this;
        }
    }

    static class Cache {
        static int maxSize = 5;
        private static int size = 0;
        private static CacheElement head;

        Cache() {
        }

        static void clear() {
            size = 0;
            head = null;
        }

        static void add(InetAddress value) {
            CacheElement newElement = value.cacheElement();
            if (size < maxSize) {
                ++size;
            } else {
                Cache.deleteTail();
            }
            newElement.next = head;
            head = newElement;
        }

        static CacheElement get(String name) {
            CacheElement previous = null;
            CacheElement current = head;
            boolean notFound = true;
            while (current != null && (notFound = !name.equals(current.hostName()))) {
                previous = current;
                current = current.next;
            }
            if (notFound) {
                return null;
            }
            Cache.moveToHead(current, previous);
            return current;
        }

        private static void deleteTail() {
            if (size == 0) {
                return;
            }
            if (1 == size) {
                head = null;
            }
            CacheElement previous = null;
            CacheElement current = head;
            while (current.next != null) {
                previous = current;
                current = current.next;
            }
            previous.next = null;
        }

        private static void moveToHead(CacheElement element, CacheElement elementPredecessor) {
            if (elementPredecessor == null) {
                head = element;
            } else {
                elementPredecessor.next = element.next;
                element.next = head;
                head = element;
            }
        }
    }
}

