/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public abstract class SignatureSpi {
    protected SecureRandom appRandom;

    public Object clone() throws CloneNotSupportedException {
        SignatureSpi result = (SignatureSpi)super.clone();
        try {
            result.appRandom = (SecureRandom)this.appRandom.getClass().newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CloneNotSupportedException();
        }
        catch (InstantiationException instantiationException) {
            throw new CloneNotSupportedException();
        }
        return result;
    }

    protected abstract void engineInitSign(PrivateKey var1) throws InvalidKeyException;

    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.appRandom = random;
        this.engineInitSign(privateKey);
    }

    protected abstract void engineInitVerify(PublicKey var1) throws InvalidKeyException;

    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        throw new UnsupportedOperationException();
    }

    protected AlgorithmParameters engineGetParameters() {
        throw new UnsupportedOperationException();
    }

    protected abstract byte[] engineSign() throws SignatureException;

    protected int engineSign(byte[] buffer, int offset, int length) throws SignatureException {
        byte[] result = this.engineSign();
        if (length < result.length) {
            throw new SignatureException();
        }
        System.arraycopy((Object)result, 0, (Object)buffer, offset, result.length);
        return result.length;
    }

    protected abstract void engineUpdate(byte[] var1, int var2, int var3) throws SignatureException;

    protected abstract void engineUpdate(byte var1) throws SignatureException;

    protected abstract boolean engineVerify(byte[] var1) throws SignatureException;

    protected boolean engineVerify(byte[] sigBytes, int offset, int length) throws SignatureException {
        byte[] data = new byte[length];
        System.arraycopy((Object)sigBytes, offset, (Object)data, 0, length);
        return this.engineVerify(data);
    }
}

