/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.PriviAction;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.security.AccessController;
import java.text.CharacterIterator;
import java.text.DictionaryBasedBreakIterator;
import java.text.RuleBasedBreakIterator;
import java.text.StringCharacterIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class BreakIterator
implements Cloneable {
    public static final int DONE = -1;
    private static final int CHARACTER_INDEX = 0;
    private static final int WORD_INDEX = 1;
    private static final int LINE_INDEX = 2;
    private static final int SENTENCE_INDEX = 3;
    private static final SoftReference[] iterCache = new SoftReference[4];

    protected BreakIterator() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public abstract int first();

    public abstract int last();

    public abstract int next(int var1);

    public abstract int next();

    public abstract int previous();

    public abstract int following(int var1);

    public int preceding(int offset) {
        int pos = this.following(offset);
        while (pos >= offset && pos != -1) {
            pos = this.previous();
        }
        return pos;
    }

    public boolean isBoundary(int offset) {
        if (offset == 0) {
            return true;
        }
        return this.following(offset - 1) == offset;
    }

    public abstract int current();

    public abstract CharacterIterator getText();

    public void setText(String newText) {
        this.setText(new StringCharacterIterator(newText));
    }

    public abstract void setText(CharacterIterator var1);

    public static BreakIterator getWordInstance() {
        return BreakIterator.getWordInstance(Locale.getDefault());
    }

    public static BreakIterator getWordInstance(Locale where) {
        return BreakIterator.getBreakInstance(where, 1, "WordBreakRules", "WordBreakDictionary");
    }

    public static BreakIterator getLineInstance() {
        return BreakIterator.getLineInstance(Locale.getDefault());
    }

    public static BreakIterator getLineInstance(Locale where) {
        return BreakIterator.getBreakInstance(where, 2, "LineBreakRules", "LineBreakDictionary");
    }

    public static BreakIterator getCharacterInstance() {
        return BreakIterator.getCharacterInstance(Locale.getDefault());
    }

    public static BreakIterator getCharacterInstance(Locale where) {
        return BreakIterator.getBreakInstance(where, 0, "CharacterBreakRules", "CharacterBreakDictionary");
    }

    public static BreakIterator getSentenceInstance() {
        return BreakIterator.getSentenceInstance(Locale.getDefault());
    }

    public static BreakIterator getSentenceInstance(Locale where) {
        return BreakIterator.getBreakInstance(where, 3, "SentenceBreakRules", "SentenceBreakDictionary");
    }

    private static BreakIterator getBreakInstance(Locale where, int type, String rulesName, String dictionaryName) {
        BreakIteratorCache cache;
        Locale loc = where;
        if (loc == null) {
            loc = Locale.getDefault();
        }
        if (iterCache[type] != null && (cache = (BreakIteratorCache)iterCache[type].get()) != null && cache.getLocale().equals(loc)) {
            return cache.createBreakInstance();
        }
        BreakIterator result = BreakIterator.createBreakInstance(loc, type, rulesName, dictionaryName);
        BreakIteratorCache cache2 = new BreakIteratorCache(loc, result);
        BreakIterator.iterCache[type] = new SoftReference(cache2);
        return result;
    }

    private static ResourceBundle getBundle(String baseName, Locale locale) {
        return (ResourceBundle)AccessController.doPrivileged(new PriviAction(baseName, locale));
    }

    private static BreakIterator createBreakInstance(Locale where, int type, String rulesName, String dictionaryName) {
        ResourceBundle bundle = BreakIterator.getBundle("com.ibm.oti.text.resources.BreakIteratorRules", where);
        String[] classNames = bundle.getStringArray("BreakIteratorClasses");
        String rules = bundle.getString(rulesName);
        if (classNames[type].equals("RuleBasedBreakIterator")) {
            return new RuleBasedBreakIterator(rules);
        }
        if (classNames[type].equals("DictionaryBasedBreakIterator")) {
            try {
                URL url = (URL)bundle.getObject(dictionaryName);
                InputStream dictionary = url.openStream();
                return new DictionaryBasedBreakIterator(rules, dictionary);
            }
            catch (IOException iOException) {
            }
            catch (MissingResourceException missingResourceException) {}
            return new RuleBasedBreakIterator(rules);
        }
        throw new IllegalArgumentException(Msg.getString("K000f", classNames[type]));
    }

    public static synchronized Locale[] getAvailableLocales() {
        return Locale.getAvailableLocales();
    }

    private static final class BreakIteratorCache {
        private BreakIterator iter;
        private Locale where;

        BreakIteratorCache(Locale where, BreakIterator iter) {
            this.where = where;
            this.iter = (BreakIterator)iter.clone();
        }

        Locale getLocale() {
            return this.where;
        }

        BreakIterator createBreakInstance() {
            return (BreakIterator)this.iter.clone();
        }
    }
}

