/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class LinkedList
extends AbstractSequentialList
implements List,
Cloneable,
Serializable {
    private static final long serialVersionUID = 876323262645176354L;
    transient int size = 0;
    transient Link voidLink;

    public LinkedList() {
        this.voidLink.previous = this.voidLink = new Link(null, null, null);
        this.voidLink.next = this.voidLink;
    }

    public LinkedList(Collection collection) {
        this();
        this.addAll(collection);
    }

    public void add(int location, Object object) {
        if (location >= 0 && location <= this.size) {
            Link newLink;
            int i;
            Link link = this.voidLink;
            if (location < this.size / 2) {
                i = 0;
                while (i <= location) {
                    link = link.next;
                    ++i;
                }
            } else {
                i = this.size;
                while (i > location) {
                    link = link.previous;
                    --i;
                }
            }
            Link previous = link.previous;
            previous.next = newLink = new Link(object, previous, link);
            link.previous = newLink;
            ++this.size;
            ++this.modCount;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    public boolean add(Object object) {
        Link newLink;
        Link oldLast = this.voidLink.previous;
        this.voidLink.previous = newLink = new Link(object, oldLast, this.voidLink);
        oldLast.next = newLink;
        ++this.size;
        ++this.modCount;
        return true;
    }

    public boolean addAll(int location, Collection collection) {
        int adding = collection.size();
        if (adding == 0) {
            return false;
        }
        if (location >= 0 && location <= this.size) {
            int i;
            Link previous = this.voidLink;
            if (location < this.size / 2) {
                i = 0;
                while (i < location) {
                    previous = previous.next;
                    ++i;
                }
            } else {
                i = this.size;
                while (i >= location) {
                    previous = previous.previous;
                    --i;
                }
            }
            Link next = previous.next;
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                Link newLink;
                previous.next = newLink = new Link(it.next(), previous, null);
                previous = newLink;
            }
            previous.next = next;
            next.previous = previous;
            this.size += adding;
            ++this.modCount;
            return true;
        }
        throw new IndexOutOfBoundsException();
    }

    public boolean addAll(Collection collection) {
        int adding = collection.size();
        if (adding == 0) {
            return false;
        }
        Link previous = this.voidLink.previous;
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            Link newLink;
            previous.next = newLink = new Link(it.next(), previous, null);
            previous = newLink;
        }
        previous.next = this.voidLink;
        this.voidLink.previous = previous;
        this.size += adding;
        ++this.modCount;
        return true;
    }

    public void addFirst(Object object) {
        Link newLink;
        Link oldFirst = this.voidLink.next;
        this.voidLink.next = newLink = new Link(object, this.voidLink, oldFirst);
        oldFirst.previous = newLink;
        ++this.size;
        ++this.modCount;
    }

    public void addLast(Object object) {
        Link newLink;
        Link oldLast = this.voidLink.previous;
        this.voidLink.previous = newLink = new Link(object, oldLast, this.voidLink);
        oldLast.next = newLink;
        ++this.size;
        ++this.modCount;
    }

    public void clear() {
        if (this.size > 0) {
            this.size = 0;
            this.voidLink.next = this.voidLink;
            this.voidLink.previous = this.voidLink;
            ++this.modCount;
        }
    }

    public Object clone() {
        return new LinkedList(this);
    }

    /*
     * Unable to fully structure code
     */
    public boolean contains(Object object) {
        block4: {
            link = this.voidLink.next;
            if (object == null) ** GOTO lbl12
            while (link != this.voidLink) {
                if (object.equals(link.data)) {
                    return true;
                }
                link = link.next;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                if (link.data == null) {
                    return true;
                }
                link = link.next;
lbl12:
                // 2 sources

                ** while (link != this.voidLink)
            }
        }
        return false;
    }

    public Object get(int location) {
        if (location >= 0 && location < this.size) {
            Link link = this.voidLink;
            if (location < this.size / 2) {
                int i = 0;
                while (i <= location) {
                    link = link.next;
                    ++i;
                }
            } else {
                int i = this.size;
                while (i > location) {
                    link = link.previous;
                    --i;
                }
            }
            return link.data;
        }
        throw new IndexOutOfBoundsException();
    }

    public Object getFirst() {
        Link first = this.voidLink.next;
        if (first != this.voidLink) {
            return first.data;
        }
        throw new NoSuchElementException();
    }

    public Object getLast() {
        Link last = this.voidLink.previous;
        if (last != this.voidLink) {
            return last.data;
        }
        throw new NoSuchElementException();
    }

    /*
     * Unable to fully structure code
     */
    public int indexOf(Object object) {
        block4: {
            pos = 0;
            link = this.voidLink.next;
            if (object == null) ** GOTO lbl15
            while (link != this.voidLink) {
                if (object.equals(link.data)) {
                    return pos;
                }
                link = link.next;
                ++pos;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                if (link.data == null) {
                    return pos;
                }
                link = link.next;
                ++pos;
lbl15:
                // 2 sources

                ** while (link != this.voidLink)
            }
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public int lastIndexOf(Object object) {
        block4: {
            pos = this.size;
            link = this.voidLink.previous;
            if (object == null) ** GOTO lbl15
            while (link != this.voidLink) {
                --pos;
                if (object.equals(link.data)) {
                    return pos;
                }
                link = link.previous;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                --pos;
                if (link.data == null) {
                    return pos;
                }
                link = link.previous;
lbl15:
                // 2 sources

                ** while (link != this.voidLink)
            }
        }
        return -1;
    }

    public ListIterator listIterator(int location) {
        return new LinkIterator(this, location);
    }

    public Object remove(int location) {
        if (location >= 0 && location < this.size) {
            Link next;
            int i;
            Link link = this.voidLink;
            if (location < this.size / 2) {
                i = 0;
                while (i <= location) {
                    link = link.next;
                    ++i;
                }
            } else {
                i = this.size;
                while (i > location) {
                    link = link.previous;
                    --i;
                }
            }
            Link previous = link.previous;
            previous.next = next = link.next;
            next.previous = previous;
            --this.size;
            ++this.modCount;
            return link.data;
        }
        throw new IndexOutOfBoundsException();
    }

    /*
     * Unable to fully structure code
     */
    public boolean remove(Object object) {
        block3: {
            link = this.voidLink.next;
            if (object == null) ** GOTO lbl8
            while (link != this.voidLink && !object.equals(link.data)) {
                link = link.next;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                link = link.next;
lbl8:
                // 2 sources

                ** while (link != this.voidLink && link.data != null)
            }
        }
        if (link == this.voidLink) {
            return false;
        }
        next = link.next;
        previous = link.previous;
        previous.next = next;
        next.previous = previous;
        --this.size;
        ++this.modCount;
        return true;
    }

    public Object removeFirst() {
        Link first = this.voidLink.next;
        if (first != this.voidLink) {
            Link next;
            this.voidLink.next = next = first.next;
            next.previous = this.voidLink;
            --this.size;
            ++this.modCount;
            return first.data;
        }
        throw new NoSuchElementException();
    }

    public Object removeLast() {
        Link last = this.voidLink.previous;
        if (last != this.voidLink) {
            Link previous;
            this.voidLink.previous = previous = last.previous;
            previous.next = this.voidLink;
            --this.size;
            ++this.modCount;
            return last.data;
        }
        throw new NoSuchElementException();
    }

    public Object set(int location, Object object) {
        if (location >= 0 && location < this.size) {
            int i;
            Link link = this.voidLink;
            if (location < this.size / 2) {
                i = 0;
                while (i <= location) {
                    link = link.next;
                    ++i;
                }
            } else {
                i = this.size;
                while (i > location) {
                    link = link.previous;
                    --i;
                }
            }
            Object result = link.data;
            link.data = object;
            return result;
        }
        throw new IndexOutOfBoundsException();
    }

    public int size() {
        return this.size;
    }

    public Object[] toArray() {
        int index = 0;
        Object[] contents = new Object[this.size];
        Link link = this.voidLink.next;
        while (link != this.voidLink) {
            contents[index++] = link.data;
            link = link.next;
        }
        return contents;
    }

    public Object[] toArray(Object[] contents) {
        int index = 0;
        if (this.size > contents.length) {
            contents = (Object[])Array.newInstance(contents.getClass().getComponentType(), this.size);
        }
        Link link = this.voidLink.next;
        while (link != this.voidLink) {
            contents[index++] = link.data;
            link = link.next;
        }
        if (index < contents.length) {
            contents[index] = null;
        }
        return contents;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.size);
        Iterator it = this.iterator();
        while (it.hasNext()) {
            stream.writeObject(it.next());
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.size = stream.readInt();
        Link link = this.voidLink = new Link(null, null, null);
        int i = this.size;
        while (--i >= 0) {
            Link nextLink;
            link.next = nextLink = new Link(stream.readObject(), link, null);
            link = nextLink;
        }
        link.next = this.voidLink;
        this.voidLink.previous = link;
    }

    private static final class Link {
        Object data;
        Link previous;
        Link next;

        Link(Object o, Link p, Link n) {
            this.data = o;
            this.previous = p;
            this.next = n;
        }
    }

    private static final class LinkIterator
    implements ListIterator {
        int pos;
        int expectedModCount;
        final LinkedList list;
        Link link;
        Link lastLink;

        LinkIterator(LinkedList object, int location) {
            this.list = object;
            this.expectedModCount = this.list.modCount;
            if (location >= 0 && location <= this.list.size) {
                this.link = this.list.voidLink;
                if (location < this.list.size / 2) {
                    this.pos = -1;
                    while (this.pos + 1 < location) {
                        this.link = this.link.next;
                        ++this.pos;
                    }
                } else {
                    this.pos = this.list.size;
                    while (this.pos >= location) {
                        this.link = this.link.previous;
                        --this.pos;
                    }
                }
            } else {
                throw new IndexOutOfBoundsException();
            }
        }

        public void add(Object object) {
            if (this.expectedModCount == this.list.modCount) {
                Link newLink;
                Link next = this.link.next;
                this.link.next = newLink = new Link(object, this.link, next);
                next.previous = newLink;
                this.link = newLink;
                this.lastLink = null;
                ++this.pos;
                ++this.expectedModCount;
                ++this.list.size;
                ++this.list.modCount;
            } else {
                throw new ConcurrentModificationException();
            }
        }

        public boolean hasNext() {
            return this.link.next != this.list.voidLink;
        }

        public boolean hasPrevious() {
            return this.link != this.list.voidLink;
        }

        public Object next() {
            if (this.expectedModCount == this.list.modCount) {
                Link next = this.link.next;
                if (next != this.list.voidLink) {
                    this.lastLink = this.link = next;
                    ++this.pos;
                    return this.link.data;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public int nextIndex() {
            return this.pos + 1;
        }

        public Object previous() {
            if (this.expectedModCount == this.list.modCount) {
                if (this.link != this.list.voidLink) {
                    this.lastLink = this.link;
                    this.link = this.link.previous;
                    --this.pos;
                    return this.lastLink.data;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public int previousIndex() {
            return this.pos;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            Link previous;
            if (this.expectedModCount != this.list.modCount) throw new ConcurrentModificationException();
            if (this.lastLink == null) throw new IllegalStateException();
            Link next = this.lastLink.next;
            next.previous = previous = this.lastLink.previous;
            previous.next = next;
            if (this.lastLink == this.link) {
                --this.pos;
            }
            this.link = previous;
            this.lastLink = null;
            ++this.expectedModCount;
            --this.list.size;
            ++this.list.modCount;
        }

        public void set(Object object) {
            if (this.expectedModCount == this.list.modCount) {
                if (this.lastLink == null) {
                    throw new IllegalStateException();
                }
            } else {
                throw new ConcurrentModificationException();
            }
            this.lastLink.data = object;
        }
    }
}

