/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.MapEntry;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class TreeMap
extends AbstractMap
implements SortedMap,
Cloneable,
Serializable {
    private static final long serialVersionUID = 919286545866124006L;
    transient int size = 0;
    transient Entry root;
    private Comparator comparator;
    transient int modCount = 0;

    public TreeMap() {
    }

    public TreeMap(Comparator comparator) {
        this.comparator = comparator;
    }

    public TreeMap(Map map) {
        this();
        this.putAll(map);
    }

    public TreeMap(SortedMap map) {
        this(map.comparator());
        Iterator it = map.entrySet().iterator();
        if (it.hasNext()) {
            Entry last;
            Map.Entry entry = (Map.Entry)it.next();
            this.root = last = new Entry(entry.getKey(), entry.getValue());
            this.size = 1;
            while (it.hasNext()) {
                entry = (Map.Entry)it.next();
                Entry x = new Entry(entry.getKey(), entry.getValue());
                x.parent = last;
                last.right = x;
                ++this.size;
                this.balance(x);
                last = x;
            }
        }
    }

    void balance(Entry x) {
        x.color = true;
        while (x != this.root && x.parent.color) {
            Entry y;
            if (x.parent == x.parent.parent.left) {
                y = x.parent.parent.right;
                if (y != null && y.color) {
                    x.parent.color = false;
                    y.color = false;
                    x.parent.parent.color = true;
                    x = x.parent.parent;
                    continue;
                }
                if (x == x.parent.right) {
                    x = x.parent;
                    this.leftRotate(x);
                }
                x.parent.color = false;
                x.parent.parent.color = true;
                this.rightRotate(x.parent.parent);
                continue;
            }
            y = x.parent.parent.left;
            if (y != null && y.color) {
                x.parent.color = false;
                y.color = false;
                x.parent.parent.color = true;
                x = x.parent.parent;
                continue;
            }
            if (x == x.parent.left) {
                x = x.parent;
                this.rightRotate(x);
            }
            x.parent.color = false;
            x.parent.parent.color = true;
            this.leftRotate(x.parent.parent);
        }
        this.root.color = false;
    }

    public void clear() {
        this.root = null;
        this.size = 0;
        ++this.modCount;
    }

    public Object clone() {
        try {
            TreeMap clone = (TreeMap)super.clone();
            if (this.root != null) {
                clone.root = this.root.clone(null);
            }
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public boolean containsKey(Object key) {
        return this.find(key) != null;
    }

    public boolean containsValue(Object value) {
        if (this.root != null) {
            return this.containsValue(this.root, value);
        }
        return false;
    }

    private boolean containsValue(Entry node, Object value) {
        if (value == null ? node.value == null : value.equals(node.value)) {
            return true;
        }
        if (node.left != null && this.containsValue(node.left, value)) {
            return true;
        }
        return node.right != null && this.containsValue(node.right, value);
    }

    public Set entrySet() {
        return new AbstractSet(){

            public int size() {
                return TreeMap.this.size;
            }

            public void clear() {
                TreeMap.this.clear();
            }

            public boolean contains(Object object) {
                if (object instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    Object v1 = TreeMap.this.get(entry.getKey());
                    Object v2 = entry.getValue();
                    return v1 == null ? v2 == null : v1.equals(v2);
                }
                return false;
            }

            public Iterator iterator() {
                return new TreeMapIterator(TreeMap.this, new MapEntry.Type(this){
                    final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public Object get(MapEntry entry) {
                        return entry;
                    }
                });
            }
        };
    }

    private Entry find(Object key) {
        Comparable object = null;
        if (this.comparator == null) {
            object = (Comparable)key;
        }
        Entry x = this.root;
        while (x != null) {
            int result;
            int n = result = object != null ? object.compareTo(x.key) : this.comparator.compare(key, x.key);
            if (result == 0) {
                return x;
            }
            Entry entry = x = result < 0 ? x.left : x.right;
        }
        return null;
    }

    Entry findAfter(Object key) {
        Comparable object = null;
        if (this.comparator == null) {
            object = (Comparable)key;
        }
        Entry x = this.root;
        Entry last = null;
        while (x != null) {
            int result;
            int n = result = object != null ? object.compareTo(x.key) : this.comparator.compare(key, x.key);
            if (result == 0) {
                return x;
            }
            if (result < 0) {
                last = x;
                x = x.left;
                continue;
            }
            x = x.right;
        }
        return last;
    }

    Entry findBefore(Object key) {
        Comparable object = null;
        if (this.comparator == null) {
            object = (Comparable)key;
        }
        Entry x = this.root;
        Entry last = null;
        while (x != null) {
            int result;
            int n = result = object != null ? object.compareTo(x.key) : this.comparator.compare(key, x.key);
            if (result <= 0) {
                x = x.left;
                continue;
            }
            last = x;
            x = x.right;
        }
        return last;
    }

    public Object firstKey() {
        if (this.root != null) {
            return TreeMap.minimum((Entry)this.root).key;
        }
        throw new NoSuchElementException();
    }

    private void fixup(Entry x) {
        while (x != this.root && !x.color) {
            Entry w;
            if (x == x.parent.left) {
                w = x.parent.right;
                if (w == null) {
                    x = x.parent;
                    continue;
                }
                if (w.color) {
                    w.color = false;
                    x.parent.color = true;
                    this.leftRotate(x.parent);
                    w = x.parent.right;
                    if (w == null) {
                        x = x.parent;
                        continue;
                    }
                }
                if (!(w.left != null && w.left.color || w.right != null && w.right.color)) {
                    w.color = true;
                    x = x.parent;
                    continue;
                }
                if (w.right == null || !w.right.color) {
                    w.left.color = false;
                    w.color = true;
                    this.rightRotate(w);
                    w = x.parent.right;
                }
                w.color = x.parent.color;
                x.parent.color = false;
                w.right.color = false;
                this.leftRotate(x.parent);
                x = this.root;
                continue;
            }
            w = x.parent.left;
            if (w == null) {
                x = x.parent;
                continue;
            }
            if (w.color) {
                w.color = false;
                x.parent.color = true;
                this.rightRotate(x.parent);
                w = x.parent.left;
                if (w == null) {
                    x = x.parent;
                    continue;
                }
            }
            if (!(w.left != null && w.left.color || w.right != null && w.right.color)) {
                w.color = true;
                x = x.parent;
                continue;
            }
            if (w.left == null || !w.left.color) {
                w.right.color = false;
                w.color = true;
                this.leftRotate(w);
                w = x.parent.left;
            }
            w.color = x.parent.color;
            x.parent.color = false;
            w.left.color = false;
            this.rightRotate(x.parent);
            x = this.root;
        }
        x.color = false;
    }

    public Object get(Object key) {
        Entry node = this.find(key);
        if (node != null) {
            return node.value;
        }
        return null;
    }

    public SortedMap headMap(Object endKey) {
        if (this.comparator == null) {
            ((Comparable)endKey).compareTo(endKey);
        } else {
            this.comparator.compare(endKey, endKey);
        }
        return new SubMap(this, endKey);
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public boolean contains(Object object) {
                    return TreeMap.this.containsKey(object);
                }

                public int size() {
                    return TreeMap.this.size;
                }

                public void clear() {
                    TreeMap.this.clear();
                }

                public Iterator iterator() {
                    return new TreeMapIterator(TreeMap.this, new MapEntry.Type(this){
                        final /* synthetic */ 8 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public Object get(MapEntry entry) {
                            return entry.key;
                        }
                    });
                }
            };
        }
        return this.keySet;
    }

    public Object lastKey() {
        if (this.root != null) {
            return TreeMap.maximum((Entry)this.root).key;
        }
        throw new NoSuchElementException();
    }

    private void leftRotate(Entry x) {
        Entry y = x.right;
        x.right = y.left;
        if (y.left != null) {
            y.left.parent = x;
        }
        y.parent = x.parent;
        if (x.parent == null) {
            this.root = y;
        } else if (x == x.parent.left) {
            x.parent.left = y;
        } else {
            x.parent.right = y;
        }
        y.left = x;
        x.parent = y;
    }

    static Entry maximum(Entry x) {
        while (x.right != null) {
            x = x.right;
        }
        return x;
    }

    static Entry minimum(Entry x) {
        while (x.left != null) {
            x = x.left;
        }
        return x;
    }

    static Entry predecessor(Entry x) {
        if (x.left != null) {
            return TreeMap.maximum(x.left);
        }
        Entry y = x.parent;
        while (y != null && x == y.left) {
            x = y;
            y = y.parent;
        }
        return y;
    }

    public Object put(Object key, Object value) {
        Entry entry = this.rbInsert(key);
        Object result = entry.value;
        entry.value = value;
        return result;
    }

    public void putAll(Map map) {
        super.putAll(map);
    }

    void rbDelete(Entry z) {
        Entry x;
        Entry y = z.left == null || z.right == null ? z : TreeMap.successor(z);
        Entry entry = x = y.left != null ? y.left : y.right;
        if (x != null) {
            x.parent = y.parent;
        }
        if (y.parent == null) {
            this.root = x;
        } else if (y == y.parent.left) {
            y.parent.left = x;
        } else {
            y.parent.right = x;
        }
        ++this.modCount;
        if (y != z) {
            z.key = y.key;
            z.value = y.value;
        }
        if (!y.color && this.root != null) {
            if (x == null) {
                this.fixup(y.parent);
            } else {
                this.fixup(x);
            }
        }
        --this.size;
    }

    private Entry rbInsert(Object object) {
        int result = 0;
        Comparable key = null;
        if (this.comparator == null) {
            key = (Comparable)object;
        }
        Entry y = null;
        Entry x = this.root;
        while (x != null) {
            y = x;
            int n = result = key != null ? key.compareTo(x.key) : this.comparator.compare(object, x.key);
            if (result == 0) {
                return x;
            }
            Entry entry = x = result < 0 ? x.left : x.right;
        }
        ++this.size;
        ++this.modCount;
        Entry z = new Entry(object);
        if (y == null) {
            this.root = z;
            return this.root;
        }
        z.parent = y;
        if (result < 0) {
            y.left = z;
        } else {
            y.right = z;
        }
        this.balance(z);
        return z;
    }

    public Object remove(Object key) {
        Entry node = this.find(key);
        if (node == null) {
            return null;
        }
        Object result = node.value;
        this.rbDelete(node);
        return result;
    }

    private void rightRotate(Entry x) {
        Entry y = x.left;
        x.left = y.right;
        if (y.right != null) {
            y.right.parent = x;
        }
        y.parent = x.parent;
        if (x.parent == null) {
            this.root = y;
        } else if (x == x.parent.right) {
            x.parent.right = y;
        } else {
            x.parent.left = y;
        }
        y.right = x;
        x.parent = y;
    }

    public int size() {
        return this.size;
    }

    public SortedMap subMap(Object startKey, Object endKey) {
        if (this.comparator == null ? ((Comparable)startKey).compareTo(endKey) <= 0 : this.comparator.compare(startKey, endKey) <= 0) {
            return new SubMap(startKey, this, endKey);
        }
        throw new IllegalArgumentException();
    }

    static Entry successor(Entry x) {
        if (x.right != null) {
            return TreeMap.minimum(x.right);
        }
        Entry y = x.parent;
        while (y != null && x == y.right) {
            x = y;
            y = y.parent;
        }
        return y;
    }

    public SortedMap tailMap(Object startKey) {
        if (this.comparator == null) {
            ((Comparable)startKey).compareTo(startKey);
        } else {
            this.comparator.compare(startKey, startKey);
        }
        return new SubMap(startKey, this);
    }

    public Collection values() {
        if (this.valuesCollection == null) {
            this.valuesCollection = new AbstractCollection(){

                public boolean contains(Object object) {
                    return TreeMap.this.containsValue(object);
                }

                public int size() {
                    return TreeMap.this.size;
                }

                public void clear() {
                    TreeMap.this.clear();
                }

                public Iterator iterator() {
                    return new TreeMapIterator(TreeMap.this, new MapEntry.Type(this){
                        final /* synthetic */ 10 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public Object get(MapEntry entry) {
                            return entry.value;
                        }
                    });
                }
            };
        }
        return this.valuesCollection;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.size);
        if (this.size > 0) {
            Entry node = TreeMap.minimum(this.root);
            while (node != null) {
                stream.writeObject(node.key);
                stream.writeObject(node.value);
                node = TreeMap.successor(node);
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.size = stream.readInt();
        Entry last = null;
        int i = this.size;
        while (--i >= 0) {
            Entry node = new Entry(stream.readObject());
            node.value = stream.readObject();
            if (last == null) {
                this.root = node;
            } else {
                node.parent = last;
                last.right = node;
                this.balance(node);
            }
            last = node;
        }
    }

    static class Entry
    extends MapEntry {
        Entry parent;
        Entry left;
        Entry right;
        boolean color;

        Entry(Object key) {
            super(key);
        }

        Entry(Object key, Object value) {
            super(key, value);
        }

        Entry clone(Entry parent) {
            Entry clone = (Entry)super.clone();
            clone.parent = parent;
            if (this.left != null) {
                clone.left = this.left.clone(clone);
            }
            if (this.right != null) {
                clone.right = this.right.clone(clone);
            }
            return clone;
        }
    }

    private static final class TreeMapIterator
    implements Iterator {
        private final TreeMap backingMap;
        private int expectedModCount;
        private final MapEntry.Type type;
        private boolean hasEnd = false;
        private Entry node;
        private Entry lastNode;
        private Object endKey;

        TreeMapIterator(TreeMap map, MapEntry.Type value) {
            this.backingMap = map;
            this.type = value;
            this.expectedModCount = map.modCount;
            if (map.root != null) {
                this.node = TreeMap.minimum(map.root);
            }
        }

        TreeMapIterator(TreeMap map, MapEntry.Type value, Entry startNode, boolean checkEnd, Object end) {
            this.backingMap = map;
            this.type = value;
            this.expectedModCount = map.modCount;
            this.node = startNode;
            this.hasEnd = checkEnd;
            this.endKey = end;
        }

        public boolean hasNext() {
            return this.node != null;
        }

        public Object next() {
            if (this.expectedModCount == this.backingMap.modCount) {
                if (this.node != null) {
                    this.lastNode = this.node;
                    this.node = TreeMap.successor(this.node);
                    if (this.hasEnd && this.node != null) {
                        Comparator c = this.backingMap.comparator();
                        if (c == null) {
                            if (((Comparable)this.endKey).compareTo(this.node.key) <= 0) {
                                this.node = null;
                            }
                        } else if (c.compare(this.endKey, this.node.key) <= 0) {
                            this.node = null;
                        }
                    }
                    return this.type.get(this.lastNode);
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            if (this.expectedModCount != this.backingMap.modCount) throw new ConcurrentModificationException();
            if (this.lastNode == null) throw new IllegalStateException();
            Object originalKey = this.lastNode.key;
            this.backingMap.rbDelete(this.lastNode);
            if (this.lastNode.key != originalKey) {
                this.node = this.lastNode;
            }
            this.lastNode = null;
            ++this.expectedModCount;
        }
    }

    static final class SubMap
    extends AbstractMap
    implements SortedMap {
        private final TreeMap backingMap;
        private boolean hasStart;
        private boolean hasEnd;
        private Object startKey;
        private Object endKey;

        SubMap(Object start, TreeMap map) {
            this.backingMap = map;
            this.hasStart = true;
            this.startKey = start;
        }

        SubMap(Object start, TreeMap map, Object end) {
            this.backingMap = map;
            this.hasEnd = true;
            this.hasStart = true;
            this.startKey = start;
            this.endKey = end;
        }

        SubMap(TreeMap map, Object end) {
            this.backingMap = map;
            this.hasEnd = true;
            this.endKey = end;
        }

        private void checkRange(Object key) {
            if (this.backingMap.comparator() == null) {
                Comparable object = (Comparable)key;
                if (this.hasStart && object.compareTo(this.startKey) < 0) {
                    throw new IllegalArgumentException();
                }
                if (this.hasEnd && object.compareTo(this.endKey) >= 0) {
                    throw new IllegalArgumentException();
                }
            } else {
                if (this.hasStart && this.backingMap.comparator().compare(key, this.startKey) < 0) {
                    throw new IllegalArgumentException();
                }
                if (this.hasEnd && this.backingMap.comparator().compare(key, this.endKey) >= 0) {
                    throw new IllegalArgumentException();
                }
            }
        }

        private boolean checkRange(Object key, boolean hasStart, boolean hasEnd) {
            if (this.backingMap.comparator() == null) {
                Comparable object = (Comparable)key;
                if (hasStart && object.compareTo(this.startKey) < 0) {
                    return false;
                }
                if (hasEnd && object.compareTo(this.endKey) >= 0) {
                    return false;
                }
            } else {
                if (hasStart && this.backingMap.comparator().compare(key, this.startKey) < 0) {
                    return false;
                }
                if (hasEnd && this.backingMap.comparator().compare(key, this.endKey) >= 0) {
                    return false;
                }
            }
            return true;
        }

        public Comparator comparator() {
            return this.backingMap.comparator();
        }

        public boolean containsKey(Object key) {
            if (this.checkRange(key, this.hasStart, this.hasEnd)) {
                return this.backingMap.containsKey(key);
            }
            return false;
        }

        public Set entrySet() {
            return new SubMapSet(this, this.hasStart, this.startKey, this.backingMap, this.hasEnd, this.endKey, new MapEntry.Type(this){
                final /* synthetic */ SubMap this$1;
                {
                    this.this$1 = subMap;
                }

                public Object get(MapEntry entry) {
                    return entry;
                }
            }){
                final /* synthetic */ SubMap this$1;
                {
                    this.this$1 = subMap;
                }

                public boolean contains(Object object) {
                    if (object instanceof Map.Entry) {
                        Map.Entry entry = (Map.Entry)object;
                        Object v1 = this.this$1.get(entry.getKey());
                        Object v2 = entry.getValue();
                        return v1 == null ? v2 == null : v1.equals(v2);
                    }
                    return false;
                }
            };
        }

        public Object firstKey() {
            if (!this.hasStart) {
                return this.backingMap.firstKey();
            }
            Entry node = this.backingMap.findAfter(this.startKey);
            if (node != null && this.checkRange(node.key, false, this.hasEnd)) {
                return node.key;
            }
            throw new NoSuchElementException();
        }

        public Object get(Object key) {
            if (this.checkRange(key, this.hasStart, this.hasEnd)) {
                return this.backingMap.get(key);
            }
            return null;
        }

        public SortedMap headMap(Object endKey) {
            this.checkRange(endKey);
            if (this.hasStart) {
                return new SubMap(this.startKey, this.backingMap, endKey);
            }
            return new SubMap(this.backingMap, endKey);
        }

        public boolean isEmpty() {
            if (this.hasStart) {
                Entry node = this.backingMap.findAfter(this.startKey);
                return node == null || !this.checkRange(node.key, false, this.hasEnd);
            }
            return this.backingMap.findBefore(this.endKey) == null;
        }

        public Set keySet() {
            if (this.keySet == null) {
                this.keySet = new SubMapSet(this, this.hasStart, this.startKey, this.backingMap, this.hasEnd, this.endKey, new MapEntry.Type(this){
                    final /* synthetic */ SubMap this$1;
                    {
                        this.this$1 = subMap;
                    }

                    public Object get(MapEntry entry) {
                        return entry.key;
                    }
                }){
                    final /* synthetic */ SubMap this$1;
                    {
                        this.this$1 = subMap;
                    }

                    public boolean contains(Object object) {
                        return this.this$1.containsKey(object);
                    }
                };
            }
            return this.keySet;
        }

        public Object lastKey() {
            if (!this.hasEnd) {
                return this.backingMap.lastKey();
            }
            Entry node = this.backingMap.findBefore(this.endKey);
            if (node != null && this.checkRange(node.key, this.hasStart, false)) {
                return node.key;
            }
            throw new NoSuchElementException();
        }

        public Object put(Object key, Object value) {
            if (this.checkRange(key, this.hasStart, this.hasEnd)) {
                return this.backingMap.put(key, value);
            }
            throw new IllegalArgumentException();
        }

        public Object remove(Object key) {
            if (this.checkRange(key, this.hasStart, this.hasEnd)) {
                return this.backingMap.remove(key);
            }
            return null;
        }

        public SortedMap subMap(Object startKey, Object endKey) {
            this.checkRange(startKey);
            this.checkRange(endKey);
            Comparator c = this.backingMap.comparator();
            if (c == null ? ((Comparable)startKey).compareTo(endKey) <= 0 : c.compare(startKey, endKey) <= 0) {
                return new SubMap(startKey, this.backingMap, endKey);
            }
            throw new IllegalArgumentException();
        }

        public SortedMap tailMap(Object startKey) {
            this.checkRange(startKey);
            if (this.hasEnd) {
                return new SubMap(startKey, this.backingMap, this.endKey);
            }
            return new SubMap(startKey, this.backingMap);
        }

        public Collection values() {
            return new SubMapSet(this.hasStart, this.startKey, this.backingMap, this.hasEnd, this.endKey, new MapEntry.Type(this){
                final /* synthetic */ SubMap this$1;
                {
                    this.this$1 = subMap;
                }

                public Object get(MapEntry entry) {
                    return entry.value;
                }
            });
        }

        static class SubMapSet
        extends AbstractSet
        implements Set {
            final TreeMap backingMap;
            boolean hasStart;
            boolean hasEnd;
            Object startKey;
            Object endKey;
            final MapEntry.Type type;

            SubMapSet(TreeMap map, MapEntry.Type theType) {
                this.backingMap = map;
                this.type = theType;
            }

            SubMapSet(boolean starting, Object start, TreeMap map, boolean ending, Object end, MapEntry.Type theType) {
                this(map, theType);
                this.hasStart = starting;
                this.startKey = start;
                this.hasEnd = ending;
                this.endKey = end;
            }

            void checkRange(Object key) {
                if (this.backingMap.comparator() == null) {
                    Comparable object = (Comparable)key;
                    if (this.hasStart && object.compareTo(this.startKey) < 0) {
                        throw new IllegalArgumentException();
                    }
                    if (this.hasEnd && object.compareTo(this.endKey) >= 0) {
                        throw new IllegalArgumentException();
                    }
                } else {
                    if (this.hasStart && this.backingMap.comparator().compare(key, this.startKey) < 0) {
                        throw new IllegalArgumentException();
                    }
                    if (this.hasEnd && this.backingMap.comparator().compare(key, this.endKey) >= 0) {
                        throw new IllegalArgumentException();
                    }
                }
            }

            boolean checkRange(Object key, boolean hasStart, boolean hasEnd) {
                if (this.backingMap.comparator() == null) {
                    Comparable object = (Comparable)key;
                    if (hasStart && object.compareTo(this.startKey) < 0) {
                        return false;
                    }
                    if (hasEnd && object.compareTo(this.endKey) >= 0) {
                        return false;
                    }
                } else {
                    if (hasStart && this.backingMap.comparator().compare(key, this.startKey) < 0) {
                        return false;
                    }
                    if (hasEnd && this.backingMap.comparator().compare(key, this.endKey) >= 0) {
                        return false;
                    }
                }
                return true;
            }

            public boolean isEmpty() {
                if (this.hasStart) {
                    Entry node = this.backingMap.findAfter(this.startKey);
                    return node == null || !this.checkRange(node.key, false, this.hasEnd);
                }
                return this.backingMap.findBefore(this.endKey) == null;
            }

            public Iterator iterator() {
                Entry startNode;
                if (this.hasStart) {
                    startNode = this.backingMap.findAfter(this.startKey);
                    if (startNode != null && !this.checkRange(startNode.key, false, this.hasEnd)) {
                        startNode = null;
                    }
                } else {
                    startNode = this.backingMap.findBefore(this.endKey);
                    if (startNode != null) {
                        startNode = TreeMap.minimum(this.backingMap.root);
                    }
                }
                return new TreeMapIterator(this.backingMap, this.type, startNode, this.hasEnd, this.endKey);
            }

            public int size() {
                int size = 0;
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    ++size;
                    it.next();
                }
                return size;
            }
        }
    }
}

