/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import com.ibm.oti.jce.support.JCEClassValidator;
import com.ibm.oti.jce.support.Msg;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.ShortBufferException;

public class Mac
implements Cloneable {
    MacSpi implementation = null;
    Provider provider = null;
    String algorithm = null;
    boolean initialized = false;
    private static final String MAC_SERVICE_PREFIX = "Mac.";

    protected Mac(MacSpi impl, Provider prov, String alg) {
        this.implementation = impl;
        this.provider = prov;
        this.algorithm = alg;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final Mac getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] providers = Security.getProviders(MAC_SERVICE_PREFIX + algorithm);
        if (providers == null) {
            throw new NoSuchAlgorithmException();
        }
        return Mac.getInstance(algorithm, providers[0]);
    }

    public static final Mac getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(Msg.getString("JCE003", provider));
        }
        return Mac.getInstance(algorithm, p);
    }

    public static final Mac getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        String className = provider.getProperty(MAC_SERVICE_PREFIX + algorithm);
        if (className == null) {
            throw new NoSuchAlgorithmException();
        }
        Class macClass = null;
        try {
            macClass = Class.forName(className, true, provider.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        JCEClassValidator validator = new JCEClassValidator(macClass);
        try {
            validator.validateJCEProviderClass();
        }
        catch (SecurityException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        MacSpi implementationClass = null;
        try {
            implementationClass = (MacSpi)macClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        return new Mac(implementationClass, provider, algorithm);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final int getMacLength() {
        return this.implementation.engineGetMacLength();
    }

    public final void init(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException();
        }
        try {
            this.init(key, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(Msg.getString("JCE010"));
        }
    }

    public final void init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (key == null) {
            throw new InvalidKeyException();
        }
        this.implementation.engineInit(key, params);
        this.initialized = true;
    }

    public final void update(byte aByte) throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.implementation.engineUpdate(aByte);
    }

    public final void update(byte[] data) throws IllegalStateException {
        this.update(data, 0, data.length);
    }

    public final void update(byte[] data, int offset, int len) throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.implementation.engineUpdate(data, offset, len);
    }

    public final byte[] doFinal() throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        return this.implementation.engineDoFinal();
    }

    public final void doFinal(byte[] output, int offset) throws ShortBufferException, IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        byte[] result = this.implementation.engineDoFinal();
        if (result.length > output.length - offset) {
            throw new ShortBufferException();
        }
        System.arraycopy((Object)result, 0, (Object)output, offset, this.implementation.engineGetMacLength());
    }

    public final byte[] doFinal(byte[] input) throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.implementation.engineUpdate(input, 0, input.length);
        return this.implementation.engineDoFinal();
    }

    public final void reset() {
        this.implementation.engineReset();
    }

    public final Object clone() throws CloneNotSupportedException {
        MacSpi spiClone = (MacSpi)this.implementation.clone();
        Mac clone = new Mac(spiClone, this.provider, this.algorithm);
        return clone;
    }
}

