/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class SealedObject
implements Serializable {
    static final long serialVersionUID = 4482838265551344752L;
    protected byte[] encodedParams = null;
    String sealAlg;
    byte[] encryptedContent = new byte[0];
    String paramsAlg;

    public SealedObject(Serializable object, Cipher cipher) throws IOException, IllegalBlockSizeException {
        this.sealAlg = cipher.getAlgorithm();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.close();
        byte[] objectBytes = baos.toByteArray();
        baos.close();
        if (cipher.getParameters() != null) {
            this.paramsAlg = cipher.getParameters().getAlgorithm();
            this.encodedParams = cipher.getParameters().getEncoded();
        }
        try {
            this.encryptedContent = cipher.doFinal(objectBytes);
        }
        catch (IllegalStateException e) {
            throw new IOException(e.getMessage());
        }
        catch (BadPaddingException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected SealedObject(SealedObject object) {
        this.sealAlg = object.sealAlg;
        this.paramsAlg = object.paramsAlg;
        this.encryptedContent = object.encryptedContent;
        this.encodedParams = object.encodedParams;
    }

    public final String getAlgorithm() {
        return this.sealAlg;
    }

    public final Object getObject(Key key) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, InvalidKeyException {
        String algName = null;
        int seperatorIndex = this.sealAlg.indexOf(47);
        algName = seperatorIndex == -1 ? this.sealAlg : this.sealAlg.substring(0, seperatorIndex);
        AlgorithmParameters params = null;
        if (this.encodedParams != null) {
            params = AlgorithmParameters.getInstance(algName);
            params.init(this.encodedParams);
        }
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(this.sealAlg);
        }
        catch (NoSuchPaddingException e) {
            throw new IOException(e.getMessage());
        }
        try {
            cipher.init(2, key, params);
        }
        catch (InvalidAlgorithmParameterException e1) {
            throw new IOException(e1.getMessage());
        }
        Object o = null;
        try {
            o = this.getObject(cipher);
        }
        catch (IllegalBlockSizeException e2) {
            throw new IOException(e2.getMessage());
        }
        catch (BadPaddingException e2) {
            throw new InvalidKeyException(e2.getMessage());
        }
        return o;
    }

    public final Object getObject(Cipher cipher) throws IOException, ClassNotFoundException, IllegalBlockSizeException, BadPaddingException {
        byte[] decryptedObjectBytes = null;
        try {
            decryptedObjectBytes = cipher.doFinal(this.encryptedContent);
        }
        catch (IllegalStateException e2) {
            throw new IOException(e2.getMessage());
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(decryptedObjectBytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object o = ois.readObject();
        return o;
    }

    public final Object getObject(Key key, String provider) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        AlgorithmParameters params = null;
        if (this.encodedParams != null) {
            params = AlgorithmParameters.getInstance(this.sealAlg, provider);
            params.init(this.encodedParams);
        }
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(this.sealAlg, provider);
        }
        catch (NoSuchPaddingException e) {
            throw new IOException(e.getMessage());
        }
        try {
            cipher.init(2, key, params);
        }
        catch (InvalidAlgorithmParameterException e1) {
            throw new IOException(e1.getMessage());
        }
        Object o = null;
        try {
            o = this.getObject(cipher);
        }
        catch (IllegalBlockSizeException e2) {
            throw new IOException(e2.getMessage());
        }
        catch (BadPaddingException e2) {
            throw new IOException(e2.getMessage());
        }
        return o;
    }
}

