/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.maofro.proxy;

import enea.ose.system.Signal;
import se.ericsson.cello.maofro.proxy.FroMaoGenericCfm;
import se.ericsson.cello.maofro.proxy.FroMaoGenericCreateCfm;
import se.ericsson.cello.maofro.proxy.FroMaoGenericDeleteCfm;
import se.ericsson.cello.maofro.proxy.FroMaoGenericReq;
import se.ericsson.cello.maofro.proxy.FroMaoHandler;
import se.ericsson.cello.maofro.proxy.FroMaoHandlerRegistry;
import se.ericsson.cello.maofro.proxy.SignalSender;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.support.debug.MessageLog;

public class FroMaoRequestRouter {
    public static final int RESULT_OK = 0;
    public static final int RESULT_NOT_OK = 1;
    public static final int RESULT_UNABLE_TO_PROCESS = 2;
    private FroMaoHandlerRegistry handlers = null;
    private SignalSender sender = null;

    public FroMaoRequestRouter(FroMaoHandlerRegistry froMaoHandlerRegistry, SignalSender signalSender) {
        this.handlers = froMaoHandlerRegistry;
        this.sender = signalSender;
    }

    public void routeRequest(FroMaoGenericReq froMaoGenericReq) {
        int n = froMaoGenericReq.getFroType();
        FroMaoHandler froMaoHandler = this.handlers.lookup(n);
        FroMaoGenericCfm froMaoGenericCfm = null;
        switch (froMaoGenericReq.getSigNo()) {
            case 721041: {
                froMaoGenericCfm = this.handleCreate(froMaoGenericReq, n, froMaoHandler);
                break;
            }
            case 721043: {
                froMaoGenericCfm = this.handleDelete(froMaoGenericReq, n, froMaoHandler);
                break;
            }
            default: {
                MessageLog.traceError(this.getClass(), (String)("Programming fault: Subscribed to an unsupported signal, sigNo = " + froMaoGenericReq.getSigNo()));
            }
        }
        if (froMaoGenericCfm != null) {
            froMaoGenericCfm.setRequestId(froMaoGenericReq.getRequestId());
            this.sender.send(froMaoGenericReq.getRequestSender(), (Signal)froMaoGenericCfm);
        }
    }

    private FroMaoGenericCfm handleDelete(FroMaoGenericReq froMaoGenericReq, int n, FroMaoHandler froMaoHandler) {
        TagNameDictionary tagNameDictionary = this.getDictionary(froMaoHandler);
        FroMaoGenericDeleteCfm froMaoGenericDeleteCfm = new FroMaoGenericDeleteCfm(tagNameDictionary);
        if (froMaoHandler == null) {
            froMaoGenericDeleteCfm.setResult(2);
        } else {
            try {
                froMaoHandler.handleDelete(froMaoGenericReq.getParameters(tagNameDictionary));
            }
            catch (MoAccessException moAccessException) {
                froMaoGenericDeleteCfm.setResult(1);
                MessageLog.traceError(this.getClass(), (String)"Handler failed to process the delete request", (Throwable)moAccessException);
            }
            catch (Throwable throwable) {
                MessageLog.traceError(this.getClass(), (String)"Error processing delete request", (Throwable)throwable);
                froMaoGenericDeleteCfm.setResult(2);
            }
        }
        return froMaoGenericDeleteCfm;
    }

    private TagNameDictionary getDictionary(FroMaoHandler froMaoHandler) {
        TagNameDictionary tagNameDictionary = null;
        if (froMaoHandler != null) {
            tagNameDictionary = froMaoHandler.getTagNameDictionary();
        }
        return tagNameDictionary;
    }

    private FroMaoGenericCfm handleCreate(FroMaoGenericReq froMaoGenericReq, int n, FroMaoHandler froMaoHandler) {
        TagNameDictionary tagNameDictionary = this.getDictionary(froMaoHandler);
        FroMaoGenericCreateCfm froMaoGenericCreateCfm = new FroMaoGenericCreateCfm(tagNameDictionary);
        if (froMaoHandler == null) {
            froMaoGenericCreateCfm.setResult(2);
            MessageLog.traceError(this.getClass(), (String)("No FRO-MAO handler registered for froType=" + n));
        } else {
            try {
                froMaoHandler.handleCreate(froMaoGenericReq.getParameters(tagNameDictionary));
            }
            catch (MoAccessException moAccessException) {
                froMaoGenericCreateCfm.setResult(1);
                MessageLog.traceError(this.getClass(), (String)"Handler failed to process the create request", (Throwable)moAccessException);
            }
            catch (Throwable throwable) {
                MessageLog.traceError(this.getClass(), (String)"Error processing create request", (Throwable)throwable);
                froMaoGenericCreateCfm.setResult(2);
            }
        }
        return froMaoGenericCreateCfm;
    }
}

