/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.maofro.proxy;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import se.ericsson.cello.maofro.proxy.InvalidTagFormatException;
import se.ericsson.cello.maofro.proxy.KeyNotFoundException;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.maofro.proxy.ValueNotFoundException;

public class PropertiesTagNameDictionary
implements TagNameDictionary {
    private Properties properties;

    public PropertiesTagNameDictionary(Properties properties) {
        this.properties = properties;
    }

    public String lookupValue(String string) throws KeyNotFoundException {
        String string2 = this.properties.getProperty(string);
        if (string2 == null) {
            throw new KeyNotFoundException(string);
        }
        return string2;
    }

    public String lookupKey(String string) throws ValueNotFoundException {
        Enumeration<?> enumeration = this.properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string.equals(this.properties.getProperty(string2))) continue;
            return string2;
        }
        throw new ValueNotFoundException(string);
    }

    public int lookupTag(String string) throws KeyNotFoundException, InvalidTagFormatException {
        String string2 = this.lookupValue(string);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidTagFormatException(string, string2);
        }
    }

    public String lookupName(int n) throws ValueNotFoundException {
        return this.lookupKey(String.valueOf(n));
    }

    public Iterator keys() {
        ArrayList arrayList = new ArrayList();
        Enumeration<?> enumeration = this.properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList.iterator();
    }
}

