/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.maofro.proxy;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import se.ericsson.cello.maofro.proxy.MaoFroCommonTags;
import se.ericsson.cello.maofro.proxy.PropertiesTagNameDictionary;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;

public class TagNameDictionaries {
    private static TagNameDictionary defaultDictionary = null;
    private static Map dictionaries = new HashMap();

    public static TagNameDictionary get(ResourceBundle resourceBundle) {
        if (!dictionaries.containsKey(resourceBundle)) {
            dictionaries.put(resourceBundle, (PropertiesTagNameDictionary)TagNameDictionaries.create(resourceBundle));
        }
        return (TagNameDictionary)dictionaries.get(resourceBundle);
    }

    public static TagNameDictionary create(ResourceBundle resourceBundle) {
        Properties properties = TagNameDictionaries.createDefaultProperties();
        TagNameDictionaries.copy(resourceBundle, properties);
        return new PropertiesTagNameDictionary(properties);
    }

    public static TagNameDictionary getDefault() {
        if (defaultDictionary == null) {
            Properties properties = TagNameDictionaries.createDefaultProperties();
            defaultDictionary = new PropertiesTagNameDictionary(properties);
        }
        return defaultDictionary;
    }

    private static Properties createDefaultProperties() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(MaoFroCommonTags.class.getName());
        Properties properties = new Properties();
        TagNameDictionaries.copy(resourceBundle, properties);
        return properties;
    }

    private static void copy(ResourceBundle resourceBundle, Properties properties) {
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            properties.setProperty(string, resourceBundle.getString(string));
        }
    }
}

