/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import se.ericsson.cello.neal.NealLogger;
import se.ericsson.cello.neal.internal.NealLevel;

public class SystemOutLogger
implements NealLogger,
NealLevel {
    int levelValue = Integer.MIN_VALUE;

    public SystemOutLogger() {
        this(Integer.MIN_VALUE);
    }

    public SystemOutLogger(int n) {
        this.levelValue = n;
    }

    public synchronized int setLevel(int n) {
        int n2 = this.levelValue;
        this.levelValue = n;
        return n2;
    }

    public synchronized int getLevel() {
        return this.levelValue;
    }

    private static StringBuffer getStackDump(int n) {
        int n2;
        Throwable throwable = new Throwable(){

            public String toString() {
                return "";
            }
        };
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        String string = stringWriter.getBuffer().toString();
        int n3 = 1;
        for (int i = 0; i < n && (n2 = string.indexOf(10, n3)) != -1; ++i) {
            n3 = n2 + 1;
        }
        stringWriter.getBuffer().delete(0, n3);
        return stringWriter.getBuffer();
    }

    public static String getStackTrace(int n) {
        return "\n   StackTrace:\n" + SystemOutLogger.getStackDump(n + 1).toString();
    }

    public static String getCalledFrom(int n) {
        StringBuffer stringBuffer = SystemOutLogger.getStackDump(n + 1);
        String string = stringBuffer.toString();
        int n2 = string.indexOf("\n");
        stringBuffer.delete(n2, stringBuffer.length());
        stringBuffer.delete(0, 4);
        return stringBuffer.toString();
    }

    public void config(String string) {
        if (700 < this.levelValue) {
            return;
        }
        System.out.println("\nCONFIG : " + string);
    }

    public void entering(String string, String string2, Object object) {
        if (400 < this.levelValue) {
            return;
        }
        System.out.println("\nENTERING : " + string + "#" + string2 + "(" + object + ")");
    }

    public void entering(String string, String string2, Object[] objectArray) {
        if (400 < this.levelValue) {
            return;
        }
        System.out.println("\nENTERING : " + string + "#" + string2 + "(" + Arrays.asList(objectArray) + ")");
    }

    public void entering(String string, String string2) {
        if (400 < this.levelValue) {
            return;
        }
        System.out.println("\nENTERING : " + string + "#" + string2 + "()");
    }

    public void exiting(String string, String string2, Object object) {
        if (400 < this.levelValue) {
            return;
        }
        System.out.println("\nEXITING : " + string + "#" + string2 + " : " + object);
    }

    public void exiting(String string, String string2) {
        if (400 < this.levelValue) {
            return;
        }
        System.out.println("\nEXITING : " + string + "#" + string2);
    }

    public void info(String string) {
        if (800 < this.levelValue) {
            return;
        }
        System.out.println("\nINFO : " + string);
    }

    public void severe(String string) {
        if (1000 < this.levelValue) {
            return;
        }
        System.out.println("\nSEVERE : " + string);
    }

    public void warning(String string) {
        if (900 < this.levelValue) {
            return;
        }
        System.out.println("\nWARNING : " + string);
    }

    public void fine(String string) {
        if (500 < this.levelValue) {
            return;
        }
        System.out.println("\nFINE : " + string);
    }

    public void finer(String string) {
        if (400 < this.levelValue) {
            return;
        }
        System.out.println("\nFINER : " + string);
    }

    public void finest(String string) {
        if (300 < this.levelValue) {
            return;
        }
        System.out.println("\nFINEST : " + string);
    }
}

