/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment;

import enea.ose.system.Signal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import se.ericsson.cello.equipment.DatabaseAccessException;
import se.ericsson.cello.equipment.EquipmentMoImpl;
import se.ericsson.cello.equipment.JvmMo;
import se.ericsson.cello.equipment.JvmMoAccess;
import se.ericsson.cello.equipment.LoadModuleBuildIF;
import se.ericsson.cello.equipment.PlugInUnitRepositoryImpl;
import se.ericsson.cello.equipment.eqaccess.ServiceControllerAccess;
import se.ericsson.cello.equipment.eqaccess.UpgradeBackupServiceInformation;
import se.ericsson.cello.equipment.fropxy.OsaJvmGetAttributesRsp;
import se.ericsson.cello.equipment.fropxy.OsaJvmMgmntProxy;
import se.ericsson.cello.equipment.fropxy.OsaJvmSetClasspathRsp;
import se.ericsson.cello.equipment.fropxy.OsaJvmSetMainRsp;
import se.ericsson.cello.equipment.fropxy.OsaJvmSetOptionRsp;
import se.ericsson.cello.equipment.intma.ReliableProgramUniterAccess;
import se.ericsson.cello.equipment.intma.SwAllocationAccess;
import se.ericsson.cello.equipment.suaccess.JvmMoSU_Access;
import se.ericsson.cello.managedelement.JvmMoBuildIF;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.ActionNotAllowedException;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.AccessControlHelper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IllegalArgumentTypeException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.internal.MoppletNameStorage;
import se.ericsson.cello.persistence.DbAccessException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.servloc.ServiceRepository;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.util.library.Lib;

public class JvmMoImpl
extends ManagedObjectBase
implements JvmMo,
Runnable,
JvmMoSU_Access,
JvmMoAccess,
JvmMoBuildIF {
    private static JvmMoImpl instance;
    private static final String jvmId = "1";
    private static ReliableProgramUniterAccess jvmRpu;
    private MoppletNameStorage moppletNameStorage;
    static final String[] reservedClasses;
    private MoData data;
    private StringAttribute userLabel;
    private SequenceAttribute admClasspath;
    private ReferenceAttribute reservedBy;
    private static OsaJvmMgmntProxy roProxy;
    private static final String[] SUPPORTED_VERSIONS;
    private static final String EMPTY_STRING = "";
    private static final int MO_DATA_REVISION_31 = 3000;
    private static final int MO_DATA_REVISION_36 = 3006;
    private static final int MO_DATA_REVISION_60 = 6000;
    private static final int MO_DATA_REVISION_LATEST = 6000;

    public static synchronized JvmMoImpl instance() {
        UpgradeTrace.debug((Class)JvmMoImpl.class, (int)70, (String)"instance()");
        try {
            if (instance == null) {
                instance = new JvmMoImpl();
            }
        }
        catch (MoNameAlreadyTakenException moNameAlreadyTakenException) {
            MessageLog.traceError((Class)JvmMoImpl.class, (String)"Create instance of JvmMo mo failed", (Throwable)moNameAlreadyTakenException);
        }
        return instance;
    }

    private JvmMoImpl() throws MoNameAlreadyTakenException {
        super((ManagedObject)EquipmentMoImpl.instance(), "Jvm", jvmId, null);
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"JvmMoImpl()");
        this.moppletNameStorage = (MoppletNameStorage)ServiceLocatorFacade.getRepository().getService(MoppletNameStorage.class);
        ServiceLocatorFacade.getRepository().addService((Object)this, JvmMoBuildIF.class, null);
    }

    synchronized void registerData() {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"registerData()");
        if (this.data == null) {
            try {
                TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
                Control control = transactionFactory.create(3600);
                Coordinator coordinator = control.getCoordinator();
                MessageLog.trace((int)5, this.getClass(), (String)("Cello_CMA txId = " + coordinator.getTransactionID() + ", timeout = 3600 sec"));
                this.data = new MoData(this.getLocalDistinguishedName(), "Jvm", true, coordinator);
                this.userLabel = new StringAttribute("userLabel", true, EMPTY_STRING);
                this.data.registerPersistentAttr((Attribute)this.userLabel);
                this.admClasspath = new SequenceAttribute("admClasspath", true);
                this.data.registerPersistentAttr((Attribute)this.admClasspath);
                this.reservedBy = new ReferenceAttribute("reservedBy", false, null);
                this.data.registerPersistentAttr((Attribute)this.reservedBy);
                this.data.setRevision(6000);
                this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                control.getTerminator().commit();
            }
            catch (Exception exception) {
                MessageLog.traceError(this.getClass(), (String)"start of Jvm failed", (Throwable)exception);
            }
        }
    }

    void recover(MoData moData) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"recover(MoData recoveredData)", (String)("recoveredData: " + moData));
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(6000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("admClasspath");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.admClasspath = (SequenceAttribute)moData.getAttribute("admClasspath");
        this.reservedBy = (ReferenceAttribute)moData.getAttribute("reservedBy");
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"delete(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        throw new UndeletableMoException((ManagedObject)this);
    }

    public String getJvmId(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getJvmId(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        return jvmId;
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getUserLabel(Coordinator c", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setUserLabel(String value, Coordinator c)", (String)("value: " + string));
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"Jvm", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public String getClasspath(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getClasspath(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaJvmGetAttributesRsp osaJvmGetAttributesRsp = roProxy.sendOsaJvmGetAttributesReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), true);
        JvmMoImpl.checkSignal((Signal)osaJvmGetAttributesRsp);
        JvmMoImpl.checkResult(osaJvmGetAttributesRsp.getResult());
        return osaJvmGetAttributesRsp.getClasspath();
    }

    public String getOptions(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getOptions(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaJvmGetAttributesRsp osaJvmGetAttributesRsp = roProxy.sendOsaJvmGetAttributesReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), true);
        JvmMoImpl.checkSignal((Signal)osaJvmGetAttributesRsp);
        JvmMoImpl.checkResult(osaJvmGetAttributesRsp.getResult());
        return osaJvmGetAttributesRsp.getOption();
    }

    public String[] getAdmOptions(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getAdmOptions(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaJvmGetAttributesRsp osaJvmGetAttributesRsp = roProxy.sendOsaJvmGetAttributesReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), false);
        JvmMoImpl.checkSignal((Signal)osaJvmGetAttributesRsp);
        JvmMoImpl.checkResult(osaJvmGetAttributesRsp.getResult());
        String[] stringArray = this.stringToArray(osaJvmGetAttributesRsp.getOption());
        return stringArray;
    }

    private String[] stringToArray(String string) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"stringToArray(String str)", (String)("str: " + string));
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public String getMain(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getMain(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaJvmGetAttributesRsp osaJvmGetAttributesRsp = roProxy.sendOsaJvmGetAttributesReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), true);
        JvmMoImpl.checkSignal((Signal)osaJvmGetAttributesRsp);
        JvmMoImpl.checkResult(osaJvmGetAttributesRsp.getResult());
        return osaJvmGetAttributesRsp.getMain();
    }

    public ManagedObject[] getAdmClasspath(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getAdmClasspath(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Attribute[] attributeArray = this.admClasspath.getValue(coordinator);
        ManagedObject[] managedObjectArray = new ManagedObject[attributeArray.length];
        for (int i = 0; i < attributeArray.length; ++i) {
            managedObjectArray[i] = ((ReferenceAttribute)attributeArray[i]).getValue(coordinator);
        }
        return managedObjectArray;
    }

    public void setAdmOptions(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAdmOptions(String[] aOptionArr, Coordinator c)", (String)("aOptionArr: " + Lib.toString((String[])stringArray) + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("-")) {
                stringBuffer.append(stringArray[i]);
                stringBuffer.append(" ");
                continue;
            }
            stringBuffer.append("-");
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(" ");
        }
        OsaJvmSetOptionRsp osaJvmSetOptionRsp = roProxy.sendOsaJvmSetOptionReq(coordinator.getTransactionID(), stringBuffer.toString());
        JvmMoImpl.checkSignal((Signal)osaJvmSetOptionRsp);
        JvmMoImpl.checkResult(osaJvmSetOptionRsp.getResult());
    }

    public void setAdmMain(String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAdmMain(String aMo, Coordinator c)", (String)("aMo: " + string + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        String string2 = string;
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaJvmSetMainRsp osaJvmSetMainRsp = roProxy.sendOsaJvmSetMainReq(coordinator.getTransactionID(), string2);
        JvmMoImpl.checkSignal((Signal)osaJvmSetMainRsp);
        JvmMoImpl.checkResult(osaJvmSetMainRsp.getResult());
        String[] stringArray = new String[]{"admMain"};
        Object[] objectArray = new Object[]{string};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public String getAdmMain(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getAdmMain(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaJvmGetAttributesRsp osaJvmGetAttributesRsp = roProxy.sendOsaJvmGetAttributesReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), false);
        JvmMoImpl.checkSignal((Signal)osaJvmGetAttributesRsp);
        JvmMoImpl.checkResult(osaJvmGetAttributesRsp.getResult());
        return osaJvmGetAttributesRsp.getMain();
    }

    public void setAdmClasspath(ManagedObject[] managedObjectArray, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAdmClasspath(ManagedObject[] value, Coordinator c)", (String)("value: " + Lib.toString((ManagedObject[])managedObjectArray) + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        for (int i = 0; i < managedObjectArray.length; ++i) {
            if (managedObjectArray[i] instanceof LoadModuleBuildIF) continue;
            throw new IllegalArgumentTypeException((ManagedObject)this, "admClasspath");
        }
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.removeAllMopplets(coordinator);
        this.removeAdmClasspath(coordinator);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < managedObjectArray.length; ++i) {
            this.addAdmClass((LoadModuleBuildIF)managedObjectArray[i], coordinator);
            this.addMopplets(((LoadModuleBuildIF)managedObjectArray[i]).getMoppletEntries(coordinator), coordinator);
            String string = ((LoadModuleBuildIF)managedObjectArray[i]).getLoadModuleFilePathSU(coordinator);
            if (EMPTY_STRING.equals(string)) {
                UpgradeTrace.log1(this.getClass(), (String)"setAdmClasspath(ManagedObject[] value,Coordinator c)", (String)("The Loadmodule " + managedObjectArray[i].getFullDistinguishedName() + " is not being included in the classPath as the file doesn't exist physically on the target."));
            }
            stringBuffer.append(string);
            if (i == managedObjectArray.length - 1) continue;
            stringBuffer.append(":");
        }
        OsaJvmSetClasspathRsp osaJvmSetClasspathRsp = roProxy.sendOsaJvmSetClasspathReq(coordinator.getTransactionID(), stringBuffer.toString());
        JvmMoImpl.checkSignal((Signal)osaJvmSetClasspathRsp);
        JvmMoImpl.checkResult(osaJvmSetClasspathRsp.getResult());
    }

    public ManagedObject getReliableProgramUniter(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getReliableProgramUniter(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        if (jvmRpu == null) {
            int n;
            this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
            OsaJvmGetAttributesRsp osaJvmGetAttributesRsp = null;
            for (n = 0; n < 2 && osaJvmGetAttributesRsp == null; ++n) {
                osaJvmGetAttributesRsp = roProxy.sendOsaJvmGetAttributesReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), true);
            }
            n = 0;
            JvmMoImpl.checkSignal(osaJvmGetAttributesRsp);
            JvmMoImpl.checkResult(osaJvmGetAttributesRsp.getResult());
            ServiceRepository serviceRepository = ServiceLocatorFacade.getRepository();
            Iterator iterator = serviceRepository.getServices(ReliableProgramUniterAccess.class);
            ReliableProgramUniterAccess reliableProgramUniterAccess = null;
            while (iterator.hasNext()) {
                reliableProgramUniterAccess = (ReliableProgramUniterAccess)iterator.next();
                if (reliableProgramUniterAccess.getRpuId(coordinator) != (long)osaJvmGetAttributesRsp.getRpuId()) continue;
                jvmRpu = reliableProgramUniterAccess;
                return (ManagedObject)reliableProgramUniterAccess;
            }
            return null;
        }
        return (ManagedObject)jvmRpu;
    }

    public int getFreeMemory(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getFreeMemory(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        System.gc();
        return (int)Runtime.getRuntime().freeMemory();
    }

    public int getTotalMemory(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getTotalMemory(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        return (int)Runtime.getRuntime().totalMemory();
    }

    public String[] getMopplets(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getMopplets(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        String[] stringArray = null;
        try {
            stringArray = this.moppletNameStorage.getMoppletNames();
        }
        catch (DbAccessException dbAccessException) {
            throw new DatabaseAccessException("Unable to retrieve mopplet names", dbAccessException);
        }
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getMopplets(Coordinator c)", (String)("Returns mopplets: " + Lib.toString((String[])stringArray)));
        return stringArray;
    }

    public String[] getProperties(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProperties(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        Properties properties = System.getProperties();
        String[] stringArray = new String[properties.size()];
        Enumeration<?> enumeration = properties.propertyNames();
        int n = 0;
        String string = null;
        while (enumeration.hasMoreElements() && n < properties.size()) {
            string = (String)enumeration.nextElement();
            stringArray[n++] = string + "=" + (String)properties.get(string);
        }
        UpgradeTrace.debug(this.getClass(), (int)71, (String)"getProperties(Coordinator c)", (String)("Returns Properties result: " + Lib.toString((String[])stringArray)));
        return stringArray;
    }

    public ManagedObject[] getReservedBySwAllocation(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getReservedBySwAllocation(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ManagedObject[] managedObjectArray = null;
        if (this.reservedBy.getValue(coordinator) != null) {
            this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
            managedObjectArray = new ManagedObject[]{this.reservedBy.getValue(coordinator)};
            return managedObjectArray;
        }
        managedObjectArray = new ManagedObject[]{};
        return managedObjectArray;
    }

    public ManagedObject getReservedSwAllocationMo(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getReservedSwAllocationMo (Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.reservedBy.getValue(coordinator);
    }

    public String[] getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }

    public void actionSetProperty(String string, String string2, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionSetProperty(String name, String value, Coordinator c)", (String)("name: " + string + "\n\tvalue: " + string2 + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        AccessControlHelper.performAccessControl();
        Properties properties = System.getProperties();
        properties.put(string, string2);
        System.setProperties(properties);
    }

    public void actionGarbageCollect(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionGarbageCollect(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        System.gc();
    }

    public void actionRestart(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionRestart(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        AccessControlHelper.performAccessControl();
        this.checkThatJvmRestartIsAllowed();
        Thread thread = new Thread((Runnable)this, "JvmRestart");
        thread.start();
    }

    public void run() {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"run()");
        try {
            Thread.currentThread();
            Thread.sleep(200L);
            int n = roProxy.sendOsaJvmReloadReqNoCfm();
            if (n == -1) {
                throw new FroNotAccessibleException("Jvm", "Resource fro is not accessible.");
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            MessageLog.traceError(this.getClass(), (String)"No Ose process found when trying to restart Jvm.", (Throwable)froNotAccessibleException);
        }
        catch (Exception exception) {
            MessageLog.traceError(this.getClass(), (String)"RuntimeError", (Throwable)exception);
        }
        catch (Error error) {
            MessageLog.traceError(this.getClass(), (String)"RuntimeError", (Throwable)error);
        }
    }

    public SwAllocationAccess getReservedBy(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getReservedBy (Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return (SwAllocationAccess)this.reservedBy.getValue(coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"reserve( ManagedObject swAllocationBuildIF, Coordinator c)", (String)("swAllocationBuildIF: " + managedObject + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.reservedBy = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"Jvm", (MoData)this.data, (ReferenceAttribute)this.reservedBy, (String[])reservedClasses);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"release( ManagedObject swAllocationBuildIF, Coordinator c)", (String)("swAllocationBuildIF: " + managedObject + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.reservedBy = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"Jvm", (MoData)this.data, (ReferenceAttribute)this.reservedBy, (String[])reservedClasses);
    }

    public void actionForcedRestart(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionForcedRestart(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        AccessControlHelper.performAccessControl();
        Thread thread = new Thread((Runnable)this, "JvmRestart");
        thread.start();
    }

    private void addMopplets(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"addMopplets(String[] classNames, Coordinator c)", (String)("classNames: " + Lib.toString((String[])stringArray) + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.moppletNameStorage.add(stringArray[i], coordinator);
                continue;
            }
            catch (DbAccessException dbAccessException) {
                throw new DatabaseAccessException("Unable to store mopplet name " + stringArray[i], dbAccessException);
            }
        }
    }

    private void addAdmClass(LoadModuleBuildIF loadModuleBuildIF, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"addAdmClass(LoadModuleBuildIF lm, Coordinator c)", (String)("lm: " + loadModuleBuildIF + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ReferenceAttribute referenceAttribute = new ReferenceAttribute(EMPTY_STRING, false);
        referenceAttribute.setValue((ManagedObject)loadModuleBuildIF);
        this.admClasspath.addElement((Attribute)referenceAttribute);
    }

    private void checkThatJvmRestartIsAllowed() throws ActionNotAllowedException {
        UpgradeBackupServiceInformation upgradeBackupServiceInformation;
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"checkThatJvmRestartIsAllowed()");
        ServiceControllerAccess serviceControllerAccess = (ServiceControllerAccess)this.getMaoContext().getServiceRepository().getService(ServiceControllerAccess.class);
        if (serviceControllerAccess != null && (upgradeBackupServiceInformation = serviceControllerAccess.getExecutingUpgradeBackupServiceInformation()).isBusy()) {
            throw new ActionNotAllowedException("Jvm", "Restart of Jvm is not allowed due to either a backup/restore or an upgrade is ongoing\n\tService: " + upgradeBackupServiceInformation.getServiceName() + "\n\tSubFunction: " + upgradeBackupServiceInformation.getSubFunction());
        }
    }

    private void removeAllMopplets(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"removeAllMopplets(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        try {
            this.moppletNameStorage.clear(coordinator);
        }
        catch (DbAccessException dbAccessException) {
            throw new DatabaseAccessException("Unable to clear mopplet name table", dbAccessException);
        }
    }

    private void removeAdmClasspath(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"removeAdmClasspath(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Attribute[] attributeArray = this.admClasspath.getValue(coordinator);
        for (int i = 0; i < attributeArray.length; ++i) {
            this.admClasspath.removeElement(attributeArray[i]);
        }
    }

    public String getType() {
        return "Jvm";
    }

    public ManagedObject getActivePiuId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = 0;
        if (coordinator != null) {
            n = coordinator.getTransactionID();
        }
        OsaJvmGetAttributesRsp osaJvmGetAttributesRsp = roProxy.sendOsaJvmGetAttributesReq(n, true);
        JvmMoImpl.checkSignal((Signal)osaJvmGetAttributesRsp);
        JvmMoImpl.checkResult(osaJvmGetAttributesRsp.getResult());
        ManagedObject managedObject = PlugInUnitRepositoryImpl.instance().lookupInstance(osaJvmGetAttributesRsp.getPiuId(), coordinator);
        if (managedObject == null) {
            throw new ConfigurationMismatchException("No PlugInUnit that corresponds to froId: " + osaJvmGetAttributesRsp.getPiuId() + " could be found.", "Jvm", "getActivePiuId");
        }
        return managedObject;
    }

    private static void checkSignal(Signal signal) throws FroNotAccessibleException {
        UpgradeTrace.debug((Class)JvmMoImpl.class, (int)70, (String)"checkSignal(enea.ose.system.Signal sig)", (String)("sig: " + signal));
        if (signal == null) {
            throw new FroNotAccessibleException("Jvm", EMPTY_STRING);
        }
    }

    private static void checkResult(int n) throws FroRequestFailedException {
        UpgradeTrace.debug((Class)JvmMoImpl.class, (int)70, (String)"checkResult(int result)", (String)("result: " + n));
        if (n != 123 && n != 125) {
            throw new FroRequestFailedException("Jvm", "Jvm fro", "checkResult" + roProxy.getResultMsg(n), n);
        }
    }

    static {
        reservedClasses = new String[]{"se.ericsson.cello.swmanagement.SwAllocationMoImpl"};
        roProxy = OsaJvmMgmntProxy.instance();
        SUPPORTED_VERSIONS = new String[]{"SU_1"};
    }
}

