/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.equipment.Aal5ReservingPiu;
import se.ericsson.cello.equipment.CppBoardMarker;
import se.ericsson.cello.equipment.PiuDeviceMo;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.equipment.ProcessorType;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.RestartRankEnum;
import se.ericsson.cello.mao.RestartReasonEnum;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class PiuDeviceMoImpl
extends CelloMao
implements PiuDeviceMo,
FroInfo,
CppBoardMarker {
    private MoData data;
    private static final int MO_DATA_REVISION_7 = 7000;
    private static final int MO_DATA_REVISION_LATEST = 7000;
    private static final String PIU_RESTART_CAUSE_VALUE = "PiuRestartCausevalue";
    private static final String PIU_RESTART_RANK_VALUE = "PiuRestartRankvalue";
    private static final String PIU_RESTART_REASON_VALUE = "PiuRestartReasonvalue";
    private static final String PIU_RESTART_INFO = "PiuRestartInfo";
    private static final int PIU_DEVICE_RESTART = 1;
    private SequenceAttribute reservedBy;
    private MaoFroIndicationHandler indicationHandler = null;
    protected static final String PIU_ID = "PiuFroId";
    protected static final String RESTART_RANK = "restartRank";
    protected static final String RESTART_REASON = "restartReason";
    protected static final String RESTART_INFO = "restartInfo";
    private FroProxy piuDeviceProxy = null;
    static /* synthetic */ Class class$se$ericsson$cello$equipment$Aal5ReservingPiu;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public static synchronized PiuDeviceMoImpl create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"PiuDevice", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"PlugInUnit");
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"administrativeState", (AttrList)attrList, (boolean)false, (int)1, (int)0, (int)2, (String)"PiuDevice");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"PiuDevice", (int)128, (int)0);
        arrayList.add(new SignedIntParameter(PIU_ID, ((PlugInUnitMo)managedObject).getResourceId(coordinator)));
        arrayList.add(new SignedIntParameter("administrativeState", n));
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"PiuDevice");
        return new PiuDeviceMoImpl(managedObject, string, arrayList, string2, froProxy, maoFroIndicationHandler, coordinator);
    }

    private PiuDeviceMoImpl(ManagedObject managedObject, String string, ArrayList arrayList, String string2, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "PiuDevice", string, coordinator);
        this.piuDeviceProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        FroData froData = this.piuDeviceProxy.create(coordinator, (Collection)arrayList);
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("froId", true, froData.getFroId()));
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.reservedBy = new SequenceAttribute("reservedBy", false);
        this.data.registerPersistentAttr((Attribute)this.reservedBy);
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, froData.getFroId());
        this.data.setRevision(7000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public PiuDeviceMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        this.piuDeviceProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(7000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute("froId");
        this.reservedBy = (SequenceAttribute)moData.getAttribute("reservedBy");
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute("froId")).getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.getReservedBy(coordinator).length != 0) {
            throw new MoReservedNotDeletableException((ManagedObject)this);
        }
        this.piuDeviceProxy.delete(coordinator, this.getFroId(coordinator), null);
        this.indicationHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("administrativeState", coordinator);
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("administrativeState", new Integer(n), coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public int getDeviceId(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("deviceId", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public String getPiuDeviceId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("PiuDeviceId", coordinator);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("reservedBy", coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                signedIntParameter = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)this.reservedBy, (Coordinator)coordinator);
                this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
                int n = ProcessorType.SP.getValue();
                Iterator iterator = this.getMaoContext().getServiceRepository().getServices(class$se$ericsson$cello$equipment$Aal5ReservingPiu == null ? PiuDeviceMoImpl.class$("se.ericsson.cello.equipment.Aal5ReservingPiu") : class$se$ericsson$cello$equipment$Aal5ReservingPiu);
                Aal5ReservingPiu aal5ReservingPiu = null;
                ManagedObject[] managedObjectArray = null;
                if (iterator != null && iterator.hasNext()) {
                    aal5ReservingPiu = (Aal5ReservingPiu)iterator.next();
                    managedObjectArray = aal5ReservingPiu.getReservingAal5CepFroIds(coordinator, this.getFroId(coordinator), n);
                }
                if (managedObjectArray != null) {
                    ManagedObject[] managedObjectArray2 = new ManagedObject[((SignedIntParameter)signedIntParameter).length + managedObjectArray.length];
                    System.arraycopy(signedIntParameter, 0, managedObjectArray2, 0, ((SignedIntParameter)signedIntParameter).length);
                    System.arraycopy(managedObjectArray, 0, managedObjectArray2, ((SignedIntParameter)signedIntParameter).length, managedObjectArray.length);
                    objectArray[i] = managedObjectArray2;
                    continue;
                }
                objectArray[i] = signedIntParameter;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("availabilityStatus");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("operationalState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("administrativeState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("deviceId")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("deviceId");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("froId")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator));
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "PiuDevice");
        }
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Hashtable<String, SignedIntParameter> hashtable = new Hashtable<String, SignedIntParameter>();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? PiuDeviceMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "PiuDevice");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"PiuDevice", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? PiuDeviceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("administrativeState", "PiuDevice");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"administrativeState", (int)n, (int)0, (int)2, (String)"PiuDevice");
                if (n == 2) {
                    n = 0;
                }
                hashtable.put("administrativeState", new SignedIntParameter("administrativeState", n));
                this.sendNotification("administrativeState", new Integer(n), coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "PiuDevice");
        }
        if (hashtable.size() != 0) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(hashtable.values());
            this.piuDeviceProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    private Map getAttrFromRes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.piuDeviceProxy.getAttributes(coordinator, this.getFroId(coordinator));
        }
        return map;
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("froId", coordinator);
    }

    public void actionManualRestart(int n, int n2, String string, Coordinator coordinator) throws MoAccessException {
        if (!RestartReasonEnum.inManualRange((int)n2) && n2 != 30) {
            throw new ValueOutOfRangeException(PIU_RESTART_REASON_VALUE, "PiuDevice");
        }
        if (!RestartRankEnum.inRange((int)n)) {
            throw new ValueOutOfRangeException(PIU_RESTART_RANK_VALUE, "PiuDevice");
        }
        if (string.length() > 80) {
            throw new ValueOutOfRangeException(PIU_RESTART_INFO, "PiuDevice");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new SignedIntParameter(RESTART_RANK, n));
        arrayList.add(new SignedIntParameter(RESTART_REASON, n2));
        arrayList.add(new StringParameter(RESTART_INFO, string));
        this.piuDeviceProxy.actionWithCfm(coordinator, this.getFroId(coordinator), 1, arrayList);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.reservedBy = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"PiuDevice", (MoData)this.data, (SequenceAttribute)this.reservedBy);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.reservedBy = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"PiuDevice", (MoData)this.data, (SequenceAttribute)this.reservedBy);
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }
}

