/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.collector;

import se.ericsson.cello.aueframework.collector.CollectorHandler;
import se.ericsson.cello.aueframework.collector.CollectorUpgradeParticipator;
import se.ericsson.cello.aueframework.collector.SystemUpgradeProxy;
import se.ericsson.cello.aueframework.collector.SystemUpgradeProxyFactory;
import se.ericsson.cello.aueframework.collector.Trigger;
import se.ericsson.cello.aueframework.collector.WriteableCollectorContext;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.common.AueRuntimeException;

public class DataCollector
implements Runnable,
CollectorUpgradeParticipator {
    private String participatorName;
    private CollectorHandler handler;
    private WriteableCollectorContext context;
    private SystemUpgradeProxy proxy;
    private static final String COLLECTOR_NAME_SUFFIX = " data collector";

    public DataCollector(String string, CollectorHandler collectorHandler, SystemUpgradeProxyFactory systemUpgradeProxyFactory, WriteableCollectorContext writeableCollectorContext) {
        this.participatorName = string + COLLECTOR_NAME_SUFFIX;
        this.handler = collectorHandler;
        this.proxy = systemUpgradeProxyFactory.getProxy(this);
        this.context = writeableCollectorContext;
    }

    public String participatorName() {
        return this.participatorName;
    }

    public void triggerIndicated(String string) {
        this.info("Received trigger: " + string);
        try {
            this.context.setCurrentTrigger(new Trigger(string, this.proxy));
            this.context.getEnvironment().start(this, this.participatorName());
        }
        catch (Throwable throwable) {
            this.error("Runtime error: ", throwable);
            this.proxy.triggerConfirmed(string, false);
        }
    }

    public void run() {
        boolean bl = false;
        String[] stringArray = null;
        try {
            this.handler.collect(this.context);
            bl = true;
        }
        catch (AueException aueException) {
            stringArray = this.handleError(aueException, aueException.getRootCause());
        }
        catch (AueRuntimeException aueRuntimeException) {
            stringArray = this.handleError(aueRuntimeException, aueRuntimeException.getRootCause());
        }
        catch (LinkageError linkageError) {
            this.error("AUE Framework is probably wrongly configured in the UCF. Please refer to the CMA AUE DM Description for details.", linkageError);
            stringArray = new String[]{linkageError.toString()};
        }
        catch (Throwable throwable) {
            stringArray = this.handleError(throwable, null);
        }
        this.confirmTrigger(bl, stringArray);
    }

    private void confirmTrigger(boolean bl, String[] stringArray) {
        if (stringArray == null) {
            this.proxy.triggerConfirmed(this.context.getTrigger(), bl);
        } else {
            this.proxy.triggerConfirmed(this.context.getTrigger(), bl, stringArray);
        }
        this.info("Confirmed " + this.context.getTrigger() + " trigger.");
    }

    private String[] handleError(Throwable throwable, Throwable throwable2) {
        this.error("Data collection unsuccessful", throwable);
        String[] stringArray = null;
        if (throwable2 == null) {
            stringArray = new String[]{throwable.toString()};
        } else {
            stringArray = new String[]{throwable.toString(), throwable2.toString()};
            this.error("Root cause:", throwable2);
        }
        return stringArray;
    }

    private void trace(String string) {
        this.context.getLogger().trace(1, this.getClass(), this.prefixed(string));
    }

    private void error(String string, Throwable throwable) {
        this.context.getLogger().error(this.getClass(), this.prefixed(string), throwable);
    }

    private void info(String string) {
        this.context.getLogger().info(this.getClass(), this.prefixed(string));
    }

    private String prefixed(String string) {
        return this.participatorName + ": " + string;
    }
}

