/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.collector.actions;

import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.DataCollectorAction;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;

public class DeleteCollectorMo
implements DataCollectorAction {
    private String identity;

    public DeleteCollectorMo(String string) throws NullPointerException {
        if (string == null) {
            throw new NullPointerException("DataCollector MO identity is null");
        }
        this.identity = string;
    }

    public void perform(CollectorContext collectorContext, Coordinator coordinator, String string) throws AueException {
        ManagedObject managedObject = this.findCollectorMo(collectorContext);
        if (managedObject == null) {
            collectorContext.getLogger().error(this.getClass(), "DataCollector MO with identity " + this.identity + " does not exist.");
        } else {
            try {
                managedObject.delete(coordinator);
            }
            catch (MoAccessException moAccessException) {
                throw new AueException("Unable to delete DataCollector MO '" + this.identity + "'", moAccessException);
            }
        }
    }

    public ManagedObject findCollectorMo(CollectorContext collectorContext) {
        return collectorContext.getMoAccessor().lookup(DeleteCollectorMo.getCollectorMoLDN(this.identity));
    }

    public static String getCollectorMoLDN(String string) {
        return "ManagedElement=1,DataCollector=" + string;
    }
}

