/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.converter;

import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.common.RevisionReader;
import se.ericsson.cello.aueframework.converter.LdnUtilities;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.transaction.Coordinator;

public class LoadModuleRevisionReader
implements RevisionReader {
    private MoDataAccessor accessor = null;
    private String expectedProductNumber = null;
    private static final String JVM = "Jvm";
    private static final String LOADMODULE = "LoadModule";
    private static final String JVM_ADM_CLASSPATH = "admClasspath";
    private static final String LM_PRODUCT_NO = "productNumber";
    private static final String LM_PRODUCT_REV = "productRevision";

    public LoadModuleRevisionReader(MoDataAccessor moDataAccessor, String string) {
        this.accessor = moDataAccessor;
        this.expectedProductNumber = string;
    }

    public String readRevision(Coordinator coordinator) throws AueException {
        MoDataWrapper moDataWrapper = (MoDataWrapper)this.accessor.getByType(JVM).iterator().next();
        Attribute[] attributeArray = ((SequenceAttribute)moDataWrapper.getAttribute(JVM_ADM_CLASSPATH)).getValue(null);
        String string = null;
        MoDataWrapper moDataWrapper2 = null;
        String string2 = null;
        for (int i = 0; i < attributeArray.length; ++i) {
            string2 = ((ReferenceAttribute)attributeArray[i]).getReferenceAsLDN();
            moDataWrapper2 = LdnUtilities.findMoInstance(this.accessor, string2);
            string = ((StringAttribute)moDataWrapper2.getAttribute(LM_PRODUCT_NO)).getValue(null);
            if (!this.expectedProductNumber.equals(string)) continue;
            return ((StringAttribute)moDataWrapper2.getAttribute(LM_PRODUCT_REV)).getValue(null);
        }
        throw new AueException("Unable to find active load module with product number " + this.expectedProductNumber + ". Double check classpath and/or " + "Converter configuration.");
    }
}

