/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.actions;

import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Transaction;
import se.ericsson.wcdma.rbs.cabinetviewer.NealManager;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.CabinetViewerAction;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.CollectTracesFtp;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.GzFileFilter;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Operable;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.progress.IndeterminateProgressDialog;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.progress.ProgressDlgUser;

public class CollectTraces
extends CabinetViewerAction
implements Runnable,
ProgressDlgUser {
    private static int WAIT_FOR_COLLECT_TRACES = 30000;
    private static String COLLECT_TRACES_FILE = "CollectTraces.log.gz";
    private static String actionDisplayName = "Collect traces";
    private static ArrayList collectTracesLabels = new ArrayList();
    static final String COLLECT_TRACE_STATUS = "collectTraceStatus";
    protected Mo nodeBFunctionMo = null;
    protected String nodeBFunctionLdn = null;
    private volatile boolean traceCollectionStopped = false;
    private volatile boolean collectTracesStarted = false;
    static final int TRACE_COLLECTION_UNDERTERMINED = 0;
    static final int TRACE_COLLECTION_COLLECTING = 1;
    static final int TRACE_COLLECTION_READY = 2;
    static final int TRACE_COLLECTION_FAILED = 3;
    private Thread thread;
    private String destinationTraceFile;

    public CollectTraces(Operable operable) {
        super(operable, actionDisplayName, "KEY_TRACES_COLLECTABLE");
        this.init();
    }

    public CollectTraces() {
        super(actionDisplayName, "KEY_TRACES_COLLECTABLE");
    }

    @Override
    protected void addOptions(JPanel jPanel, GridBagConstraints gridBagConstraints) {
    }

    @Override
    protected String getText() {
        return null;
    }

    @Override
    public void setOperable(Operable operable) {
        super.setOperable(operable);
        this.init();
    }

    private void init() {
        this.nodeBFunctionLdn = this.operable.getTargetMoLdnForCollectTraces();
        if (this.nodeBFunctionLdn != null) {
            this.nodeBFunctionMo = this.cmService.getMo(this.nodeBFunctionLdn);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.performTheAction();
    }

    @Override
    public void progressCancelButtonPressed() {
        this.thread.interrupt();
        this.traceCollectionStopped = true;
    }

    @Override
    protected void performTheAction() {
        CollectTraces collectTraces = this;
        if (!this.collectTracesStarted) {
            this.thread = new Thread(collectTraces);
            this.thread.start();
        }
    }

    @Override
    public void run() {
        this.collectTracesStarted = true;
        Trace.observation(this, "Show progress dialog");
        IndeterminateProgressDialog indeterminateProgressDialog = new IndeterminateProgressDialog(this, "Collecting traces", collectTracesLabels);
        SwingUtilities.invokeLater(indeterminateProgressDialog);
        try {
            Trace.observation(this, "Start trace collection");
            this.startTraceCollection();
            Trace.observation(this, "Wait for trace collection");
            this.waitForTraceCollection();
        }
        catch (Exception exception) {
            String string = "Failed to start collect traces";
            if (this.isMomException(exception, "NotEnoughDiskSpace")) {
                string = "Failed to start collect traces, not enough disk space";
            } else if (NealManager.isCausedByNodeRestarting(exception)) {
                string = "Failed to start collect traces, unable to connect to node";
            }
            Trace.error(this, string, exception);
            this.showErrorFromThread("Unable to collect traces", exception);
            this.traceCollectionStopped = true;
        }
        Trace.observation(this, "Closing progress window. Is trace collection finished = " + this.traceCollectionStopped);
        this.closeDialog(indeterminateProgressDialog);
        indeterminateProgressDialog.dispose();
        if (!this.traceCollectionStopped) {
            Trace.observation(this, "Get destination filename, username and password");
            this.getFtpData();
        }
        if (!this.traceCollectionStopped) {
            Trace.observation(this, "Get the file using FTP");
            CollectTracesFtp collectTracesFtp = new CollectTracesFtp(this, this.destinationTraceFile);
            collectTracesFtp.start();
        }
        if (this.traceCollectionStopped) {
            this.collectTracesStarted = false;
        }
    }

    protected void setStarted(boolean bl) {
        this.collectTracesStarted = bl;
    }

    private void getFtpData() {
        Trace.observation(this, "Getting destination file name");
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    String string = CollectTraces.this.getDestFileName();
                    Trace.observation(this, "Destination file name is " + string);
                    if (string != null) {
                        CollectTraces.this.setDestinationFile(string);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.destinationTraceFile == null) {
            this.traceCollectionStopped = true;
        }
    }

    public void setDestinationFile(String string) {
        this.destinationTraceFile = string;
    }

    private String getDestFileName() {
        String string = null;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new GzFileFilter());
        try {
            File file = new File(COLLECT_TRACES_FILE);
            jFileChooser.setSelectedFile(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = jFileChooser.showDialog(this.operable.getCvSession().getCvSessionController().getMainWindofFrame(), "Save trace collection");
        if (n == 0) {
            int n2;
            string = jFileChooser.getSelectedFile().getAbsolutePath();
            File file = new File(string);
            if (file.exists() && (n2 = JOptionPane.showConfirmDialog(this.operable.getCvSession().getCvSessionController().getMainWindofFrame(), string + " already exists.\n" + "Do you want to replace it?", "Cabinet viewer", 2)) != 0) {
                string = null;
            }
        } else {
            string = null;
        }
        return string;
    }

    private void startTraceCollection() {
        this.traceCollectionStopped = false;
        NameValue[] nameValueArray = new NameValue[]{};
        Transaction transaction = this.getCmService().createTransaction();
        this.nodeBFunctionMo.action("collectTraces", nameValueArray, transaction);
        if (System.getProperty("AUT_GUI_TESTS_RUNNING", "false").equals("true")) {
            transaction.commit();
        }
    }

    private boolean isMomException(Exception exception, String string) {
        String string2 = exception.getMessage();
        return string2 != null && string2.indexOf(string) != -1;
    }

    private void waitForTraceCollection() {
        NameValue nameValue = null;
        int n = 0;
        int n2 = 10;
        int n3 = 0;
        if (System.getProperty("AUT_GUI_TESTS_RUNNING", "false").equals("true")) {
            WAIT_FOR_COLLECT_TRACES = 1000;
        }
        block8: while (!this.traceCollectionStopped) {
            try {
                Thread.sleep(WAIT_FOR_COLLECT_TRACES);
            }
            catch (Exception exception) {
                // empty catch block
            }
            nameValue = this.nodeBFunctionMo.getAttribute(COLLECT_TRACE_STATUS, null);
            n = nameValue.getIntValue();
            switch (n) {
                case 0: {
                    Trace.observation(this, "Trace collection status is UNDERTERMINED");
                    if (n3 > n2) {
                        Trace.error(this, "Trace collection status is still UNDERTERMINED. Stopping.");
                        this.showErrorFromThread("The RBS failed to collect traces", new Exception("Collection status is UNDERTERMINED"));
                        return;
                    }
                    ++n3;
                    continue block8;
                }
                case 1: {
                    Trace.observation(this, "Trace collection status is COLLECTING");
                    continue block8;
                }
                case 2: {
                    Trace.observation(this, "Trace collection status is READY");
                    return;
                }
                case 3: {
                    Trace.error(this, "Trace collection status is FAILED");
                    this.showErrorFromThread("The RBS failed to collect traces", new Exception("Collection status is FAILED"));
                    return;
                }
            }
            Trace.error(this, "Unknown trace collection status received: " + n);
            this.showErrorFromThread("The RBS failed to collect traces", new Exception("Collection status is " + n));
            return;
        }
    }

    private void closeDialog(JDialog jDialog) {
        try {
            EventQueue.invokeAndWait(new HideDialog(jDialog));
        }
        catch (Exception exception) {
            Trace.error(this, "Closing dialog. Exception=" + exception.toString());
        }
    }

    protected String getLdn() {
        return this.nodeBFunctionLdn;
    }

    protected Mo getMo() {
        return this.nodeBFunctionMo;
    }

    static {
        collectTracesLabels.add("Collecting traces on rbs.");
        collectTracesLabels.add("This will take several minutes.");
    }

    class HideDialog
    implements Runnable {
        JDialog jd;

        public HideDialog(JDialog jDialog) {
            this.jd = jDialog;
        }

        @Override
        public void run() {
            this.jd.setVisible(false);
        }
    }
}

