/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.repairdeliverynote;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class RepairDeliveryView
extends JFrame {
    public static final String REPAIR_DELIVERY_NOTE = "Repair Delivery Note";
    public static final String GENERAL_INFO = "General Information:";
    public static final String PREP_BY = "Prepared by:";
    public static final String PREP_BY_TOOL_TIP = "Name of the operator preparing the log entry.";
    public static final String DATE = "Date:";
    public static final String COUNTRY_CODE = "Country code:      *";
    public static final String COUNTRY_CODE_TOOL_TIP = "Two letter country-code.";
    public static final String FAULT_INFO = "Fault information:";
    public static final String STATE_CODE = "State code:    *";
    public static final String STATE_CODE_TOOL_TIP = "R - Repaired Unit failed during installation\n S - Unit in service when fault occured\n T - New unit failed during isntallation or test\n";
    public static final String DESCR_OF_FAULT = "Description of fault:";
    public static final String DESCR_OF_FAULT_TOOL_TIP = "Specific description of the observed fault.";
    public static final String TR_NO = "Trouble report no:    ";
    public static final String TR_NO_TOOL_TIP = "If the board has a connection with a trouble report number must be supplied.";
    public static final String COMPL_REF = "Complaint reference:  ";
    public static final String COMPL_REF_TOOL_TIP = "Complaint reference.";
    public static final String SAVE = "Save";
    public static final String CANCEL = "Cancel";
    private static final int WINDOW_WIDTH = 620;
    private static final int WINDOW_HEIGTH = 440;
    private static final int MAX_DESCRIPTION = 64;
    private static final int MAX_PREPARED_BY = 15;
    private static final int MAX_TROUBLE_REPORT = 10;
    private static final int MAX_COMPLAINT_REF = 8;
    private JButton saveButton;
    private JButton cancelButton;
    private JLabel prepByLabel = new JLabel("Prepared by:");
    private JTextField prepTextField;
    private JLabel dateLabel = new JLabel("Date:");
    private JLabel date;
    private JLabel date2;
    private JLabel ccLabel = new JLabel("Country code:      *");
    private JComboBox countryCodeCombo;
    private JLabel stateCodeLabel = new JLabel("State code:    *");
    private JComboBox stateCodeCombo = new JComboBox<String>(new String[]{"R", "S", "T"});
    private JLabel faultDesLabel = new JLabel("Description of fault:");
    private JTextArea faultDesTextArea;
    private JLabel trRepNoLabel = new JLabel("Trouble report no:    ");
    private JTextField trRepNoTextField;
    private JLabel compRefLabel = new JLabel("Complaint reference:  ");
    private JTextField compRefTextField;

    public void init() {
        this.setLayout(new BorderLayout());
        this.setTitle(REPAIR_DELIVERY_NOTE);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.getInfoPanel(), "North");
        jPanel.add((Component)this.getFaultInfoPanel(), "South");
        this.add((Component)jPanel, "North");
        this.add((Component)this.createButtonPanel(), "South");
        this.setPreferredSize(new Dimension(620, 440));
        this.packAndCentralize();
    }

    protected void packAndCentralize() {
        this.pack();
        int n = 620;
        int n2 = 440;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = (dimension.width - n) / 2;
        int n4 = (dimension.height - n2) / 2;
        if (n3 < 0) {
            n3 = 0;
            n = dimension.width;
        }
        if (n4 < 0) {
            n4 = 0;
            n2 = (int)((double)dimension.height * 0.95);
        }
        this.setBounds(n3, n4, n, n2);
    }

    public void setButtonListeners(ActionListener actionListener, ActionListener actionListener2) {
        this.saveButton.addActionListener(actionListener);
        this.cancelButton.addActionListener(actionListener2);
    }

    public String getPrepBy() {
        String string = this.prepTextField.getText();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public String getCountryCode() {
        return this.countryCodeCombo.getSelectedItem().toString();
    }

    public String getDesOfFault() {
        String string = this.faultDesTextArea.getText();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public String getTrNo() {
        String string = this.trRepNoTextField.getText();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public String getCompRef() {
        String string = this.compRefTextField.getText();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public String getStateCode() {
        return this.stateCodeCombo.getSelectedItem().toString();
    }

    public void setPrepBy(String string) {
        this.prepTextField.setText(string);
    }

    public void setCountryCode(String string) {
        this.countryCodeCombo.setSelectedItem(string.toUpperCase());
    }

    public void setDesOfFault(String string) {
        this.faultDesTextArea.setText(string);
    }

    public void setTrNo(String string) {
        this.trRepNoTextField.setText(string);
    }

    public void setCompRef(String string) {
        this.compRefTextField.setText(string);
    }

    public void setDateTime(String string) {
        this.date.setVisible(false);
        this.date2.setVisible(true);
        this.date2.setText(string);
    }

    public void setStateCode(String string) {
        this.stateCodeCombo.setSelectedItem(string.toUpperCase());
    }

    public void disableSaveButton() {
        this.saveButton.setEnabled(false);
        this.ccLabel.setEnabled(false);
        this.countryCodeCombo.setEnabled(false);
        this.prepByLabel.setEnabled(false);
        this.prepTextField.setEnabled(false);
        this.stateCodeLabel.setEnabled(false);
        this.stateCodeCombo.setEnabled(false);
        this.faultDesLabel.setEnabled(false);
        this.faultDesTextArea.setEnabled(false);
        this.trRepNoLabel.setEnabled(false);
        this.trRepNoTextField.setEnabled(false);
        this.compRefLabel.setEnabled(false);
        this.compRefTextField.setEnabled(false);
        this.dateLabel.setEnabled(false);
        this.date.setEnabled(false);
        this.date2.setEnabled(false);
    }

    private JPanel getInfoPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(GENERAL_INFO);
        jPanel.setBorder(titledBorder);
        JPanel jPanel2 = new JPanel();
        LimitedDocument limitedDocument = new LimitedDocument(15);
        this.prepTextField = new JTextField(limitedDocument, "", new Integer(16));
        this.prepTextField.setToolTipText(PREP_BY_TOOL_TIP);
        this.prepTextField.setName("operatorName");
        jPanel2.add(this.prepByLabel);
        jPanel2.add(this.prepTextField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)this.dateLabel, gridBagConstraints);
        DateFormat dateFormat = DateFormat.getDateInstance(2, Locale.getDefault());
        DateFormat dateFormat2 = DateFormat.getTimeInstance(2, Locale.getDefault());
        Date date = new Date();
        String string = dateFormat.format(date);
        String string2 = dateFormat2.format(date);
        this.date = new JLabel("" + string + " " + string2);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.date, gridBagConstraints);
        this.date.setVisible(true);
        this.date2 = new JLabel("");
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.date2, gridBagConstraints);
        this.date2.setVisible(false);
        gridBagConstraints.weightx = 99.0;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        this.countryCodeCombo = new JComboBox<String>(Locale.getISOCountries());
        this.countryCodeCombo.setToolTipText(COUNTRY_CODE_TOOL_TIP);
        this.countryCodeCombo.setName("countryCode");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.anchor = 17;
        jPanel3.add((Component)this.ccLabel, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        jPanel3.add((Component)this.countryCodeCombo, gridBagConstraints2);
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 99.0;
        jPanel3.add((Component)new JPanel(), gridBagConstraints2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        return jPanel;
    }

    private JPanel getFaultInfoPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Border border = BorderFactory.createEtchedBorder();
        TitledBorder titledBorder = new TitledBorder(FAULT_INFO);
        jPanel.setBorder(titledBorder);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.stateCodeCombo.setToolTipText(STATE_CODE_TOOL_TIP);
        this.stateCodeCombo.setName("stateCode");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.stateCodeLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)this.stateCodeCombo, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 99.0;
        jPanel2.add((Component)new JPanel(), gridBagConstraints);
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        jPanel.add((Component)this.faultDesLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        LimitedDocument limitedDocument = new LimitedDocument(64);
        this.faultDesTextArea = new JTextArea(limitedDocument, null, 8, 40);
        this.faultDesTextArea.setToolTipText(DESCR_OF_FAULT_TOOL_TIP);
        this.faultDesTextArea.setBorder(border);
        this.faultDesTextArea.setName("faultDescription");
        JScrollPane jScrollPane = new JScrollPane(this.faultDesTextArea);
        jPanel.add((Component)jScrollPane, new GridBagConstraints(1, 1, 5, 1, 1.0, 5.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        LimitedDocument limitedDocument2 = new LimitedDocument(10);
        this.trRepNoTextField = new JTextField(limitedDocument2, "", new Integer(11));
        this.trRepNoTextField.setToolTipText(TR_NO_TOOL_TIP);
        this.trRepNoTextField.setName("troubleReport");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel3.add((Component)this.trRepNoLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        jPanel3.add((Component)this.trRepNoTextField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 99.0;
        jPanel3.add((Component)new JPanel(), gridBagConstraints);
        jPanel.add((Component)jPanel3, new GridBagConstraints(0, 5, 4, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        LimitedDocument limitedDocument3 = new LimitedDocument(8);
        this.compRefTextField = new JTextField(limitedDocument3, "", new Integer(9));
        this.compRefTextField.setToolTipText(COMPL_REF_TOOL_TIP);
        this.compRefTextField.setName("compReference");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)this.compRefLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        jPanel4.add((Component)this.compRefTextField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 99.0;
        jPanel4.add((Component)new JPanel(), gridBagConstraints);
        jPanel.add((Component)jPanel4, new GridBagConstraints(0, 6, 4, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.saveButton = new JButton(SAVE);
        this.saveButton.setToolTipText(SAVE);
        this.cancelButton = new JButton(CANCEL);
        this.cancelButton.setToolTipText(CANCEL);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 99.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        jPanel.add((Component)this.saveButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        jPanel.add((Component)this.cancelButton, gridBagConstraints);
        return jPanel;
    }

    class LimitedDocument
    extends PlainDocument {
        private int maxCharacters;

        public LimitedDocument(int n) {
            this.maxCharacters = n;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (this.getLength() + string.length() <= this.maxCharacters) {
                super.insertString(n, string, attributeSet);
            }
        }
    }
}

