/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.alarmlist;

import java.util.Properties;
import javax.swing.SwingUtilities;
import se.ericsson.cello.em.fm.common.utils.impl.LogPart;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.launcher.emnotification.EmEventInterface;
import se.ericsson.security.launcher.emnotification.EmNotificationListenerInterface;
import se.ericsson.security.launcher.emnotification.EmNotificationServiceInterface;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.mainwindow.MainWindowController;
import se.ericsson.wcdma.rbs.cabinetviewer.launch.LauncherData;
import se.ericsson.wcdma.rbs.cabinetviewer.session.CvSession;

public class AlarmListApplication
implements EmNotificationListenerInterface {
    private CvSession cvSession;
    private MainWindowController mainWindowController = null;
    static final String ALARM_SELECTED = "se.ericsson.cello.em.fm.alarmlist.ALARM_SELECTED";
    private LauncherInterface myLauncher;
    private EmNotificationServiceInterface myEmNotificationService;

    public AlarmListApplication(MainWindowController mainWindowController) {
        this.mainWindowController = mainWindowController;
        this.cvSession = mainWindowController.getCvSession();
    }

    public static void startEmasAlarmListApplication(AlarmListApplication alarmListApplication) {
        LauncherData launcherData = alarmListApplication.cvSession.getLauncherData();
        alarmListApplication.myLauncher = launcherData.launcher;
        if (alarmListApplication.myLauncher instanceof EmNotificationServiceInterface) {
            alarmListApplication.myEmNotificationService = (EmNotificationServiceInterface)alarmListApplication.myLauncher;
            alarmListApplication.myEmNotificationService.addEmNotificationListener((EmNotificationListenerInterface)alarmListApplication);
        }
        String string = launcherData.properties.getProperty("ALARMLIST_CONFIG");
        try {
            launcherData.launcher.runApplication(string, launcherData.ipAddress, launcherData.properties, null);
        }
        catch (LauncherException launcherException) {
            Trace.warning(alarmListApplication, "Failed to start Alarmlist service ", (Exception)((Object)launcherException));
        }
    }

    public void AlarmListApplicationRemoveEmNotificationListener() {
        if (this.myEmNotificationService != null) {
            this.myEmNotificationService.removeEmNotificationListener((EmNotificationListenerInterface)this);
        }
    }

    public void notificationFromEM(EmEventInterface emEventInterface) {
        Properties properties;
        Object object;
        String string = emEventInterface.getType();
        if (string.equals(ALARM_SELECTED) && null != (object = (properties = (Properties)emEventInterface.getUserData()).get(LogPart.MANAGED_OBJECT_INSTANCE))) {
            final String string2 = object.toString();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AlarmListApplication.this.mainWindowController.setSelected(string2);
                }
            });
        }
    }
}

