/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.MouseListener;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VoView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.state.AdminStateJLabel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.state.AvailabilityStateJLabel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.state.OpStateJLabel;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;

public class StatePanel
extends VoView {
    private AdminStateJLabel adminStateJLabel;
    private OpStateJLabel opStateJLabel;
    private AvailabilityStateJLabel availabilityStateJLabel;

    public StatePanel(VoData voData, String string) {
        super(voData);
        this.setToolTipText(string);
        this.initialise();
    }

    @Override
    public void setLabel(String string) {
    }

    @Override
    public void setLedViewActive() {
    }

    @Override
    public void setStateViewActive() {
    }

    @Override
    public void cleanUp() {
        if (this.opStateJLabel != null) {
            this.opStateJLabel = null;
        }
        if (this.adminStateJLabel != null) {
            this.adminStateJLabel = null;
        }
        if (this.availabilityStateJLabel != null) {
            this.availabilityStateJLabel = null;
        }
        this.removeAll();
    }

    public void addVoViewMouseListener(MouseListener mouseListener) {
        if (this.adminStateJLabel != null) {
            this.adminStateJLabel.addMouseListener(mouseListener);
        }
        if (this.opStateJLabel != null) {
            this.opStateJLabel.addMouseListener(mouseListener);
        }
        if (this.availabilityStateJLabel != null) {
            this.availabilityStateJLabel.addMouseListener(mouseListener);
        }
    }

    @Override
    public void initialise() {
        super.initialise();
        this.setBorder(null);
        this.setOpaque(false);
        this.opStateJLabel = new OpStateJLabel(this.getVoData());
        this.adminStateJLabel = new AdminStateJLabel(this.getVoData());
        this.availabilityStateJLabel = new AvailabilityStateJLabel(this.getVoData());
        this.addOpStateIfApplicable();
        this.addAdminStateIfApplicable();
        this.addAvailabilityStateIfApplicable();
        VoView.VoViewMouseListener voViewMouseListener = this.getVoViewMouseListener();
        this.addVoViewMouseListener(voViewMouseListener);
    }

    private void addOpStateIfApplicable() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.opStateJLabel, gridBagConstraints);
    }

    private void addAdminStateIfApplicable() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.adminStateJLabel, gridBagConstraints);
    }

    private void addAvailabilityStateIfApplicable() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.availabilityStateJLabel, gridBagConstraints);
    }

    @Override
    public void setBackground(Color color) {
        if (this.opStateJLabel != null) {
            this.opStateJLabel.setBackground(color);
        }
        if (this.adminStateJLabel != null) {
            this.adminStateJLabel.setBackground(color);
        }
        if (this.availabilityStateJLabel != null) {
            this.availabilityStateJLabel.setBackground(color);
        }
    }
}

