/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.AllAttributesExtractor;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.Attribute;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.AttributeExtractor;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.InfoPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.MoAttributeExtractor;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.MultiAttributeExtractor;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.MultiAttributesExtractor;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.StructMemberExtractor;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.SuperExtractor;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.converters.ToStringConverter;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.converters.ValueConverter;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.restrictions.Restriction;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;

public abstract class AbstractInfoPanel
extends JPanel
implements InfoPanel {
    private Map converters;
    private List attributes;
    private List labels;
    private List requiredMos;
    private List disallowedMos;
    private List optionalLabel;
    private VoData vo;
    private ToStringConverter defaultConverter;
    private boolean isOptional = false;

    public AbstractInfoPanel() {
        this((VoData)null);
    }

    public AbstractInfoPanel(VoData voData) {
        this.vo = voData;
        this.converters = new HashMap();
        this.attributes = new ArrayList();
        this.labels = new ArrayList();
        this.requiredMos = new ArrayList();
        this.disallowedMos = new ArrayList();
        this.optionalLabel = new ArrayList();
        this.defaultConverter = new ToStringConverter();
    }

    public void add(String string, String string2, String string3) {
        this.attributes.add(new MoAttributeExtractor(this.vo, string2, string3));
        this.labels.add(string);
    }

    public void add(String string, String string2, Restriction restriction, String string3) {
        this.attributes.add(new MoAttributeExtractor(this.vo, string2, restriction, string3));
        this.labels.add(string);
    }

    public void add(String string, String string2, String string3, String string4) {
        this.attributes.add(new StructMemberExtractor(this.vo, string2, string3, string4));
        this.labels.add(string);
    }

    public void add(String string, String string2, Restriction restriction, String string3, String string4) {
        this.attributes.add(new StructMemberExtractor(this.vo, string2, restriction, string3, string4));
        this.labels.add(string);
    }

    public void add(String string, String string2, Restriction restriction, String string3, String string4, String string5, String string6) {
        this.attributes.add(new StructMemberExtractor(this.vo, string2, restriction, string3, string4, string5, string6));
        this.labels.add(string);
    }

    public void add(String string, String string2) {
        this.attributes.add(new MultiAttributeExtractor(this.vo, string2));
        this.labels.add(string);
    }

    public void add(String string, String[] stringArray) {
        this.attributes.add(new MultiAttributesExtractor(this.vo, stringArray));
        this.labels.add(string);
    }

    public void addAttributes(String string, Attribute[] attributeArray) {
        AttributeExtractor[] attributeExtractorArray = new AttributeExtractor[attributeArray.length];
        Attribute attribute = null;
        for (int i = 0; i < attributeExtractorArray.length; ++i) {
            attribute = attributeArray[i];
            attributeExtractorArray[i] = attributeArray[i].isStruct() ? new StructMemberExtractor(this.vo, attribute.moTypeName, attribute.moAttributeName, attribute.structMemberName) : new MoAttributeExtractor(this.vo, attribute.moTypeName, attribute.moAttributeName);
        }
        AllAttributesExtractor allAttributesExtractor = new AllAttributesExtractor(attributeExtractorArray);
        this.attributes.add(allAttributesExtractor);
        this.labels.add(string);
    }

    public void addWithBackwardCompatibility(String string, Attribute[] attributeArray) {
        AttributeExtractor[] attributeExtractorArray = new AttributeExtractor[attributeArray.length];
        Attribute attribute = null;
        for (int i = 0; i < attributeExtractorArray.length; ++i) {
            attribute = attributeArray[i];
            attributeExtractorArray[i] = attributeArray[i].isStruct() ? new StructMemberExtractor(this.vo, attribute.moTypeName, attribute.moAttributeName, attribute.structMemberName) : new MoAttributeExtractor(this.vo, attribute.moTypeName, attribute.moAttributeName);
        }
        SuperExtractor superExtractor = new SuperExtractor(attributeExtractorArray);
        this.attributes.add(superExtractor);
        this.labels.add(string);
    }

    public void addConverter(String string, ValueConverter valueConverter) {
        this.converters.put(string, valueConverter);
    }

    public void addRequiredMo(String string) {
        this.requiredMos.add(string);
    }

    public void addDisallowedMo(String string) {
        this.disallowedMos.add(string);
    }

    public void addOptionalLabel(String string) {
        this.optionalLabel.add(string);
    }

    public void setOptional(boolean bl) {
        this.isOptional = bl;
    }

    protected void updateVo(VoData voData) {
        this.vo = voData;
        for (AttributeExtractor attributeExtractor : this.attributes) {
            attributeExtractor.setVo(voData);
        }
    }

    protected VoData getVoData() {
        return this.vo;
    }

    protected boolean isOptional(String string) {
        for (String string2 : this.optionalLabel) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isOptional(int n) {
        String string = (String)this.labels.get(n);
        return this.isOptional(string);
    }

    public String getLabel(int n) {
        return (String)this.labels.get(n);
    }

    public Object getValue(int n) {
        AttributeExtractor attributeExtractor = (AttributeExtractor)this.attributes.get(n);
        Object object = attributeExtractor.get();
        ValueConverter valueConverter = null;
        String[] stringArray = attributeExtractor.getKeys();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.converters.containsKey(stringArray[i])) continue;
            valueConverter = (ValueConverter)this.converters.get(stringArray[i]);
        }
        if (valueConverter == null) {
            valueConverter = this.defaultConverter;
        }
        Object object2 = valueConverter.convert(object);
        return object2;
    }

    protected void setVo(VoData voData) {
        this.vo = voData;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public int getNoOfAttributes() {
        return this.attributes.size();
    }

    @Override
    public boolean isVisible() {
        if (!this.requiredMosExists() || this.disallowedMosExists()) {
            return false;
        }
        boolean bl = false;
        for (AttributeExtractor attributeExtractor : this.attributes) {
            if (!attributeExtractor.isExisting()) continue;
            bl = true;
        }
        return bl;
    }

    private boolean requiredMosExists() {
        for (String string : this.requiredMos) {
            if (this.vo.isExisting(string)) continue;
            return false;
        }
        return true;
    }

    private boolean disallowedMosExists() {
        for (String string : this.disallowedMos) {
            if (!this.vo.isExisting(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isApplicable() {
        int n = this.getNoOfAttributes();
        for (int i = 0; i < n; ++i) {
            Object object = this.getValue(i);
            if (object != null && object.equals("Not applicable") || object == null && this.isOptional) continue;
            return true;
        }
        return false;
    }

    public boolean isApplicable(Object object) {
        return object == null || !object.equals("Not applicable");
    }
}

