/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.converters;

import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Struct;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.converters.ValueConverter;

public class ToStringConverter
implements ValueConverter {
    private Map<String, String> excludes = new HashMap<String, String>();

    public void addExclude(String string, String string2) {
        if (string != null && string2 != null) {
            this.excludes.put(string, string2);
        } else if (string != null) {
            this.excludes.put(string, string);
        } else if (string2 != null) {
            this.excludes.put(string2, string2);
        }
    }

    @Override
    public Object convert(Object object) {
        if (object == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)this.convert(objectArray[i]);
                if (stringBuilder.length() > 0 && !"".equals(string)) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string);
            }
        } else if (object instanceof Struct) {
            stringBuilder.append(this.convert((Struct)object));
        } else if (object instanceof Mo) {
            stringBuilder.append(this.convert((Mo)object));
        } else if (object instanceof NameValue) {
            stringBuilder.append(this.convert((NameValue)object));
        } else {
            stringBuilder.append(object.toString());
        }
        return stringBuilder.toString();
    }

    private Object convert(Struct struct) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = struct.getMemberNames();
        stringBuilder.append("[");
        for (int i = 0; i < stringArray.length; ++i) {
            NameValue nameValue = struct.getMember(stringArray[i]);
            String string = (String)this.convert(nameValue);
            if ("".equals(string)) {
                return "";
            }
            if (stringBuilder.length() > 1 && !"".equals(string)) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
        }
        stringBuilder.append("]");
        return stringBuilder.length() == 2 ? "" : stringBuilder.toString();
    }

    private String convert(Mo mo) {
        String string = "";
        try {
            string = mo.getLdn();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private Object convert(NameValue nameValue) {
        if (this.isExcluded(nameValue)) {
            return "";
        }
        return nameValue.getName() + "=" + nameValue.getValue();
    }

    protected boolean isExcluded(NameValue nameValue) {
        String string;
        if (this.excludes.containsKey(nameValue.getName())) {
            String string2 = this.excludes.get(nameValue.getName());
            if (string2.equals(nameValue.getName())) {
                return true;
            }
            if (string2.equals(nameValue.getValue().toString())) {
                return true;
            }
        } else if (this.excludes.containsKey(nameValue.getValue().toString()) && (string = this.excludes.get(nameValue.getValue().toString())).equals(nameValue.getValue().toString())) {
            return true;
        }
        return false;
    }
}

