/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.security.launcher.download.DownloadListener;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.launch.LauncherData;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.converter.DomContainer;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.loader.VimModelLoader;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.loader.VimModelValidator;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.ModelException;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.equipment.EquipmentXmlSchemaInfo;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.infoview.InfoViewXmlSchemaInfo;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.rbs.RbsTemplateXmlSchemaInfo;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.template.TemplateXmlSchemaInfo;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.valueconverter.ValueConverterXmlSchemaInfo;

public class VimModelLoaderImpl
implements VimModelLoader,
EquipmentXmlSchemaInfo,
TemplateXmlSchemaInfo,
RbsTemplateXmlSchemaInfo,
ValueConverterXmlSchemaInfo,
InfoViewXmlSchemaInfo {
    private String modelPath;
    private JarFile jarFile = null;
    private VimModelValidator vimModelValidator = new VimModelValidator();
    private String rbsProductName;

    @Override
    public void loadJarFile(LauncherData launcherData) throws IOException, LauncherException {
        String string = launcherData.properties.getProperty("CABV_MODEL");
        URL uRL = null;
        uRL = this.isIpAddress(launcherData.ipAddress) ? new URL("http://" + launcherData.ipAddress + "/" + string) : new URL("http:///" + string);
        this.modelPath = launcherData.launcher.getFile(uRL, (DownloadListener)new StubbedDownloadListener());
        this.jarFile = new JarFile(this.modelPath);
    }

    private boolean isIpAddress(String string) {
        String string2 = string;
        if (string2 == null) {
            return false;
        }
        try {
            InetAddress inetAddress;
            int n = -1;
            if (string2.indexOf(":\\") != -1) {
                return false;
            }
            if (string2.indexOf("]") != -1) {
                n = string2.indexOf("]:");
                if (n != -1) {
                    string2 = string2.substring(0, n + 1);
                }
            } else {
                n = string2.indexOf(58);
                if (n != -1) {
                    string2 = string2.substring(0, n);
                }
            }
            return (inetAddress = InetAddress.getByName(string2)) != null;
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    @Override
    public String getModelPath() {
        return this.modelPath;
    }

    @Override
    public void loadAllSchemaFiles() throws IOException {
        if (this.modelPath == null || this.jarFile == null) {
            return;
        }
        Enumeration<JarEntry> enumeration = this.jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string = jarEntry.getName();
            if (!string.endsWith("xsd")) continue;
            try {
                URL uRL = new URL("jar:file:" + this.modelPath + "!/" + string);
                this.vimModelValidator.addSchemaFile(string, uRL);
            }
            catch (SAXException sAXException) {
                Trace.warning(this, "Error reading schema file " + string + " in jar file " + this.jarFile.getName() + ". ", sAXException);
            }
        }
    }

    @Override
    public DomContainer loadAllTemplates() throws IOException {
        DomContainer domContainer = this.loadTemplates("se/ericsson/wcdma/rbs/cabinetviewer/model/templates/");
        return domContainer;
    }

    @Override
    public DomContainer loadSectorViewerTemplates() throws IOException {
        DomContainer domContainer = this.loadTemplates("se/ericsson/wcdma/rbs/cabinetviewer/model/sectorviewer/");
        return domContainer;
    }

    public DomContainer loadTemplates(String string) throws IOException {
        DomContainer domContainer = new DomContainer();
        Enumeration<JarEntry> enumeration = this.jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string2 = jarEntry.getName();
            if (!string2.startsWith(string) || !string2.endsWith("xml")) continue;
            InputStream inputStream = this.jarFile.getInputStream(jarEntry);
            Document document = null;
            try {
                document = this.getDom(inputStream);
                this.loadAndValidateTemplate(domContainer, string2, document);
            }
            catch (ModelException modelException) {
                Trace.warning(this, "Error loading template " + string2, modelException);
            }
            catch (SAXException sAXException) {
                Trace.warning(this, "Error loading template " + string2, sAXException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                Trace.warning(this, "Error loading template " + string2, parserConfigurationException);
            }
            catch (IOException iOException) {
                Trace.warning(this, "Error loading template " + string2, iOException);
            }
        }
        return domContainer;
    }

    protected void loadAndValidateTemplate(DomContainer domContainer, String string, Document document) throws IOException, SAXException {
        Document document2 = document;
        if (document2 == null || !document2.hasChildNodes()) {
            throw new ModelException("Template " + string + " was NOT found.");
        }
        NodeList nodeList = document2.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String string2 = node.getNodeName();
            if (!string2.equals("template") || !node.hasAttributes()) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("name");
            String string3 = node2.getNodeValue();
            String string4 = null;
            Node node3 = namedNodeMap.getNamedItem("revision");
            if (node3 != null) {
                string4 = node3.getNodeValue();
            }
            this.validateDocument(document, node, string);
            domContainer.putDocument(string3, string4, document);
        }
    }

    @Override
    public Node loadEquipment() throws IOException, ParserConfigurationException, SAXException {
        Node node = this.loadAndValidateXmlFile("se/ericsson/wcdma/rbs/cabinetviewer/model/Equipment.xml", "equipment");
        return node;
    }

    @Override
    public void setRbsProductName(String string) {
        this.rbsProductName = string;
    }

    @Override
    public String getRbsProductName() {
        return this.rbsProductName;
    }

    @Override
    public Node loadRbsTemplate(String string) throws Exception {
        Object object;
        Object object2;
        this.rbsProductName = string;
        String string2 = string;
        this.rbsProductName = this.handleSpecialProductNames(this.rbsProductName);
        if (this.rbsProductName.indexOf("RBS") >= 0) {
            string2 = this.rbsProductName.replaceFirst("RBS", "Rbs");
        }
        String string3 = "se/ericsson/wcdma/rbs/cabinetviewer/model/rbs/" + string2 + "Template.xml";
        Trace.observation(this, "Found RBS type: " + this.rbsProductName);
        Document document = null;
        try {
            object2 = this.jarFile.getJarEntry(string3);
            object = this.jarFile.getInputStream((ZipEntry)object2);
            document = this.getDom((InputStream)object);
        }
        catch (Exception exception) {
            if (string3.equals("DefaultRbs")) {
                Trace.error(this, "The RbsTemplate file for " + this.rbsProductName + " could NOT be parsed in jar file " + this.jarFile.getName() + ".", exception);
                throw exception;
            }
            Trace.warning(this, "Error when parsing RbsTemplate file for " + this.rbsProductName + " in jar file " + this.jarFile.getName() + ". " + "Try to use \"DefaultRbsTemplate.xml\" instead", exception);
            return this.loadRbsTemplate("DefaultRbs");
        }
        object2 = document;
        if (object2 != null && object2.hasChildNodes()) {
            object = object2.getChildNodes();
            for (int i = 0; i < object.getLength(); ++i) {
                Node node = object.item(i);
                if (node == null || !node.getNodeName().equals("rbsTemplate")) continue;
                Node node2 = node;
                this.validateDocument(document, node, string3);
                return node2;
            }
        }
        return null;
    }

    @Override
    public Node loadValueConverters() throws IOException, ParserConfigurationException, SAXException {
        Node node = this.loadAndValidateXmlFile("se/ericsson/wcdma/rbs/cabinetviewer/model/ValueConverter.xml", "valueConverter");
        return node;
    }

    @Override
    public Node loadStateView() throws IOException, ParserConfigurationException, SAXException {
        Node node = this.loadAndValidateXmlFile("se/ericsson/wcdma/rbs/cabinetviewer/model/StateView.xml", "stateView");
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node loadAndValidateXmlFile(String string, String string2) throws IOException, ParserConfigurationException, SAXException {
        VimModelLoaderImpl vimModelLoaderImpl = this;
        synchronized (vimModelLoaderImpl) {
            Document document;
            JarEntry jarEntry = this.jarFile.getJarEntry(string);
            InputStream inputStream = this.jarFile.getInputStream(jarEntry);
            Document document2 = document = this.getDom(inputStream);
            if (document2 == null || !document2.hasChildNodes()) {
                throw new ModelException("Xml File " + string + " was NOT found.");
            }
            NodeList nodeList = document2.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node == null || !node.getNodeName().equals(string2)) continue;
                this.validateDocument(document, node, string);
                return node;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document getDom(InputStream inputStream) throws IOException, ParserConfigurationException, SAXException {
        VimModelLoaderImpl vimModelLoaderImpl = this;
        synchronized (vimModelLoaderImpl) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = null;
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            return document;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getDom(String string) throws IOException, ParserConfigurationException, SAXException {
        VimModelLoaderImpl vimModelLoaderImpl = this;
        synchronized (vimModelLoaderImpl) {
            JarEntry jarEntry = this.jarFile.getJarEntry(string);
            InputStream inputStream = this.jarFile.getInputStream(jarEntry);
            Document document = this.getDom(inputStream);
            return document;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateDocument(Document document, Node node, String string) throws IOException, SAXException {
        VimModelLoaderImpl vimModelLoaderImpl = this;
        synchronized (vimModelLoaderImpl) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("xsi:noNamespaceSchemaLocation");
            if (node2 != null) {
                String string2 = string.substring(0, string.lastIndexOf("/") + 1);
                String string3 = string2 + node2.getNodeValue();
                this.vimModelValidator.validateFile(string, string3, document);
            }
        }
    }

    private String handleSpecialProductNames(String string) throws IOException, ParserConfigurationException, SAXException {
        HashMap hashMap = this.loadLookupIfExisting();
        String string2 = string;
        Set set = hashMap.keySet();
        for (String string3 : set) {
            if (!string.endsWith(string3)) continue;
            String string4 = (String)hashMap.get(string3);
            string2 = string2.replace(string3, string4);
            Trace.observation(this, "The \"" + string + "\" was changed to " + string2);
            break;
        }
        return string2;
    }

    private HashMap loadLookupIfExisting() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = "";
        String string2 = "";
        String string3 = "";
        try {
            string3 = "se/ericsson/wcdma/rbs/cabinetviewer/model/rbs/RbsTranslationLookup.xml";
            Document document = this.getDom(string3);
            NodeList nodeList = document.getElementsByTagName("rbsLookup");
            if (nodeList != null) {
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    string = "";
                    string2 = "";
                    Node node = nodeList.item(i);
                    NodeList nodeList2 = node.getChildNodes();
                    for (int j = 0; j < nodeList2.getLength(); ++j) {
                        Node node2 = nodeList2.item(j);
                        String string4 = node2.getNodeName();
                        if ("originName".equals(string4)) {
                            string = this.getElementText(node2);
                            continue;
                        }
                        if (!"duplicateName".equals(string4)) continue;
                        string2 = this.getElementText(node2);
                    }
                    hashMap.put(string2, string);
                }
            }
        }
        catch (IOException iOException) {
            Trace.observation(this, "The lookupFileName file " + string3 + " could NOT be found in jar file " + this.jarFile.getName() + ".", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Trace.observation(this, "Parser Configuration ", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            Trace.observation(this, "The lookupFileName file " + string3 + " could NOT be parsed in jar file " + this.jarFile.getName() + ".", sAXException);
        }
        catch (NullPointerException nullPointerException) {
            Trace.observation(this, "The lookupFileName file " + string3 + " could not be found. in jar file " + this.jarFile.getName());
        }
        catch (Exception exception) {
            Trace.observation(this, "The lookupFileName file " + string3 + " could not be found. in jar file " + this.jarFile.getName() + " (this is probably a P5 node).", exception);
        }
        return hashMap;
    }

    private String getElementText(Node node) {
        String string = "";
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string2 = node2.getNodeName();
            if (!"#text".equals(string2)) continue;
            string = node2.getNodeValue();
            break;
        }
        return string;
    }

    private static class StubbedDownloadListener
    implements DownloadListener {
        private StubbedDownloadListener() {
        }

        public void connecting(String string, String string2) {
        }

        public void downloadFailed(String string) {
        }

        public void downloading(String string, int n, int n2) {
        }

        public void finished(String string) {
        }

        public void finished(String string, String string2) {
        }

        public void updating(String string, int n, int n2) {
        }
    }
}

