/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.property;

import java.util.Hashtable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.dynamicproperty.EqualsCondition;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.property.AbstractCondition;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.property.PropertyXmlSchemaInfo;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.util.Helper;

public class EqualsElement
extends AbstractCondition
implements PropertyXmlSchemaInfo {
    boolean result = false;
    private String var;
    private String booleanElement;
    private String stringElement;

    public EqualsElement(Hashtable hashtable, Node node) {
        super(hashtable);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (!this.isValidNodeName(string)) continue;
            if (string.equals("var")) {
                this.var = Helper.getDataInFirstTextNode(hashtable, node2);
                continue;
            }
            if (string.equals("boolean")) {
                this.booleanElement = Helper.getDataInFirstTextNode(hashtable, node2);
                continue;
            }
            if (!string.equals("string")) continue;
            this.stringElement = Helper.getDataInFirstTextNode(hashtable, node2);
        }
    }

    @Override
    public boolean evaluate() {
        this.result = false;
        if (this.var == null) {
            Trace.warning(this, " Variable \"null\" NOT found among variables/parameters in Hashtable");
            return false;
        }
        Object v = this.getParams().get(this.var);
        if (v == null) {
            Trace.observation(this, " Variable " + this.var + " NOT found among variables/parameters in Hashtable");
            return false;
        }
        if (!(v instanceof String)) {
            Trace.warning(this, " Variable " + this.var + " must be a String");
            return false;
        }
        String string = (String)v;
        if (this.booleanElement != null && string.equals(this.booleanElement)) {
            this.result = true;
        } else if (this.stringElement != null && string.equals(this.stringElement)) {
            this.result = true;
        }
        return this.result;
    }

    @Override
    protected EqualsCondition createCondition() {
        return new EqualsCondition(this.var, this.booleanElement, this.stringElement);
    }
}

