/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.valueconverter;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.converters.BitFieldConverter;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.converters.ValueConverter;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.util.Helper;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.valueconverter.AbstractConverter;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.valueconverter.BitValueElement;

public class BitFieldElement
extends AbstractConverter {
    private List<BitValueElement> bitValueElements = new ArrayList<BitValueElement>();
    private String defaultValue;

    public BitFieldElement(Node node) {
        super(node);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals("bit")) {
                this.bitValueElements.add(new BitValueElement(node2));
                continue;
            }
            if (!string.equals("default")) continue;
            this.defaultValue = Helper.getDataInFirstTextNode(null, node2);
        }
    }

    protected ValueConverter getConverter() {
        BitFieldConverter bitFieldConverter = new BitFieldConverter();
        for (BitValueElement bitValueElement : this.bitValueElements) {
            try {
                int n = bitValueElement.getBitPosition();
                String string = bitValueElement.getText();
                bitFieldConverter.add(n, string);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
        }
        if (this.defaultValue != null) {
            bitFieldConverter.setDefaultValue(this.defaultValue);
        }
        return bitFieldConverter;
    }
}

