/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import ConfigExtended.ConfigurationExtended;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.JApplet;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import se.ericsson.cello.support.gui.EmasStartupService;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.EmasSystemProperties;

public class EmasFramework {
    private static ORB orbRef = null;
    private static NamingContext namingServiceRootRef = null;
    private static POA rootPoa;
    private static JApplet appletRef;
    private static EmasStartupService startupService;
    static ConfigurationExtended celloConfigService;
    protected static Object celloConfigServerObject;
    private static URL namerootUrl;
    private static URL corbaPermissionUrl;
    private static URL emasHtmlUrl;
    private static final String IOR_PATH_NAME = "/cello/ior_files/nameroot.ior";
    private static final String CORBA_SECURITY = "/cello/corbasecurity";
    private static boolean corbaPermissionOnClient;
    private static boolean corbaPermissionOnNode;
    private static final String EMAS_PATH_NAME = "index.html";

    public static void setORB(ORB newRef) {
        Log.trace("setORB( org.omg.CORBA.ORB newRef )");
        orbRef = newRef;
    }

    public static ORB getORB() {
        Log.trace("getORB()");
        return orbRef;
    }

    public static void setNamingServiceRoot(NamingContext aNamingServiceRoot) {
        Log.trace("setNamingServiceRoot(org.omg.CosNaming.NamingContext " + aNamingServiceRoot + ")");
        namingServiceRootRef = aNamingServiceRoot;
    }

    public static NamingContext getNamingServiceRoot() {
        Log.trace("getNamingServiceRoot()");
        return namingServiceRootRef;
    }

    public static final void setStartupService(EmasStartupService aStartupService) {
        startupService = aStartupService;
    }

    public static final EmasStartupService getStartupService() {
        return startupService;
    }

    static final void setCelloConfigService(ConfigurationExtended aCelloConfigService) {
        celloConfigService = aCelloConfigService;
    }

    public static final ConfigurationExtended getCelloConfigService() {
        return celloConfigService;
    }

    public static final URL getNamerootUrl() {
        return namerootUrl;
    }

    public static final URL getEmasHtmlUrl() {
        return emasHtmlUrl;
    }

    public static void boot(JApplet applet, ORB orb) throws IOException {
        appletRef = applet;
        try {
            EmasFramework.boot(orb);
        }
        catch (IOException e) {
            throw new IOException("Error initializing Corba services");
        }
    }

    public static void boot(ORB orb) throws IOException {
        Log.trace("boot(orb)");
        orbRef = orb;
        URL namerootUrl = null;
        try {
            namerootUrl = new URL("http://" + EmasSystemProperties.getProperty("host") + IOR_PATH_NAME);
            emasHtmlUrl = new URL(namerootUrl.getProtocol(), namerootUrl.getHost(), namerootUrl.getPort(), "/cello/emas/index.html");
            rootPoa = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
            rootPoa.the_POAManager().activate();
            BufferedReader nameServiceReader = new BufferedReader(new InputStreamReader(namerootUrl.openStream()));
            String nameServiceRef = nameServiceReader.readLine();
            nameServiceReader.close();
            EmasFramework.getSecurityOnNode();
            EmasFramework.setSecurityOnClient(corbaPermissionOnNode);
            Object nameServiceObject = orb.string_to_object(nameServiceRef);
            NamingContext namingServiceRoot = NamingContextHelper.narrow((Object)nameServiceObject);
            EmasFramework.setNamingServiceRoot(namingServiceRoot);
        }
        catch (InvalidName e) {
            Log.logError("Error initializing Corba services", e);
            throw new IOException("Error initializing Corba services");
        }
        catch (AdapterInactive e) {
            Log.logError("Error initializing Corba services", e);
            throw new IOException("Error initializing Corba services");
        }
        catch (NO_IMPLEMENT e) {
            Log.logError("Error initializing Corba services", e);
            throw new IOException("Error initializing Corba services");
        }
        catch (COMM_FAILURE e) {
            Log.logError("Error initializing Corba services", e);
            throw new IOException("Error initializing Corba services");
        }
        catch (IOException e) {
            Log.logError("Error initializing Corba services", e);
            throw new IOException("Error initializing Corba services");
        }
    }

    public static void boot_without_corba() {
        try {
            namerootUrl = new URL(EmasSystemProperties.getProperty("hostAddress"));
            emasHtmlUrl = new URL(namerootUrl.getProtocol(), namerootUrl.getHost(), namerootUrl.getPort(), "/cello/emas/index.html");
        }
        catch (Exception e) {
            Log.logError("Error trying to create URL", e);
        }
    }

    public static void connect(Servant servant) throws IOException {
        Log.trace("connect(Servant servant )");
        try {
            rootPoa.activate_object(servant);
        }
        catch (WrongPolicy e) {
            Log.logError("error connect", e);
            throw new IOException("Error initializing Corba services");
        }
        catch (ServantAlreadyActive e2) {
            Log.logError("error connect", e2);
        }
    }

    public static void disconnect(Object obj) {
        Log.trace("disconnect(org.omg.CORBA.Object obj)");
        try {
            byte[] objectId = null;
            objectId = rootPoa.reference_to_id(obj);
            rootPoa.deactivate_object(objectId);
        }
        catch (WrongAdapter e) {
            Log.logError("error disconnect", e);
        }
        catch (WrongPolicy e) {
            Log.logError("error disconnect", e);
        }
        catch (ObjectNotActive e) {
            Log.logError("error disconnect", e);
        }
    }

    public static POA getRootPOA() {
        Log.trace("getRootPOA() ");
        return rootPoa;
    }

    public static boolean getSecurityOnNode() {
        try {
            URL server = null;
            BufferedReader serverReader = null;
            server = new URL("http://" + EmasSystemProperties.getProperty("host") + CORBA_SECURITY);
            serverReader = new BufferedReader(new InputStreamReader(server.openStream()));
            String corbaPermission = serverReader.readLine();
            serverReader.close();
            corbaPermissionOnNode = corbaPermission.equalsIgnoreCase("CorbaSecurity=ON");
        }
        catch (Exception ex) {
            Log.trace("Not able to read security from Node ");
        }
        return corbaPermissionOnNode;
    }

    public static boolean getSecurityOnClient() {
        return corbaPermissionOnClient;
    }

    public static void setSecurityOnClient(boolean permission) {
        corbaPermissionOnClient = permission;
    }

    public static Object servant_to_reference(Servant servant) {
        Log.trace("servant_to_reference(Servant servant)");
        Object obj = null;
        try {
            obj = rootPoa.servant_to_reference(servant);
        }
        catch (WrongPolicy e) {
            Log.logError("error servant to refernce", e);
        }
        catch (ServantNotActive e2) {
            Log.logError("error servant to refernce", e2);
        }
        return obj;
    }

    public static Servant reference_to_servant(Object obj) {
        Log.trace("reference_to_servant(org.omg.CORBA.Object obj) ");
        Servant servant = null;
        try {
            servant = rootPoa.reference_to_servant(obj);
        }
        catch (WrongAdapter e) {
            Log.logError("error reference to servant", e);
        }
        catch (ObjectNotActive e) {
            Log.logError("error reference to servant", e);
        }
        catch (WrongPolicy e) {
            Log.logError("error reference to servant", e);
        }
        return servant;
    }

    public static void cleanup() {
        orbRef = null;
        namingServiceRootRef = null;
        rootPoa = null;
        appletRef = null;
        startupService = null;
        celloConfigService = null;
        namerootUrl = null;
        emasHtmlUrl = null;
    }

    public static final URL getEmasBaseUrl() {
        return emasHtmlUrl;
    }

    static {
        corbaPermissionOnClient = false;
        corbaPermissionOnNode = false;
    }
}

