/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class ErrorDialog
extends JDialog
implements ActionListener {
    private JButton detailsButton;
    private JButton closeButton;
    private JScrollPane detailsScrollP;
    private static final int TEXT_WIDTH = 480;
    private static final int TEXT_HEIGHT = 300;
    private String closeStr = "Close";
    private String moreStr = "More >>";
    private String lessStr = "<< Less";

    public void actionPerformed(ActionEvent actionevent) {
        if (actionevent.getSource() == this.closeButton) {
            this.closeButton.removeActionListener(this);
            this.detailsButton.removeActionListener(this);
            this.dispose();
        } else if (actionevent.getSource() == this.detailsButton) {
            if (this.detailsButton.getLabel().equals(this.moreStr)) {
                this.detailsScrollP.setPreferredSize(new Dimension(480, 300));
                this.detailsScrollP.setVisible(true);
                this.pack();
                this.detailsScrollP.getVerticalScrollBar().setValue(0);
                this.detailsScrollP.getHorizontalScrollBar().setValue(0);
                this.detailsButton.setLabel(this.lessStr);
            } else {
                this.detailsScrollP.setPreferredSize(new Dimension(0, 0));
                this.detailsScrollP.setVisible(false);
                this.pack();
                this.detailsButton.setLabel(this.moreStr);
            }
            this.setDetailsBtnMnemonic();
        }
    }

    public static ErrorDialog create(Component parentComponent, String msg, String trace) {
        return ErrorDialog.create(parentComponent, msg, trace, null, null, null, null);
    }

    public static ErrorDialog create(Component parentComponent, String msg, String trace, String close, String more, String less, String title) {
        Frame frame = null;
        if (parentComponent != null) {
            frame = JOptionPane.getFrameForComponent(parentComponent);
        }
        return new ErrorDialog(frame, msg, trace, close, more, less, title);
    }

    private ErrorDialog(Frame frame, String msg, String trace, String close, String more, String less, String title) {
        super(frame, "Error", true);
        this.initStrings(close, more, less, title);
        this.init(frame, msg, trace);
    }

    private void initStrings(String close, String more, String less, String title) {
        if (null != close) {
            this.closeStr = close;
        }
        if (null != more) {
            this.moreStr = more;
        }
        if (null != less) {
            this.lessStr = less;
        }
        if (null != title) {
            this.setTitle(title);
        }
    }

    private void setDetailsBtnMnemonic() {
        if (this.detailsButton.getLabel().indexOf("Less") > -1) {
            this.detailsButton.setMnemonic('L');
        } else if (this.detailsButton.getLabel().indexOf("More") > -1) {
            this.detailsButton.setMnemonic('M');
        }
    }

    private void init(Frame frame, String msg, String additionalInfo) {
        int lines = 1;
        StringTokenizer tok = new StringTokenizer(msg, "\n", true);
        while (tok.hasMoreTokens()) {
            String str = tok.nextToken();
            if (str.equals("\n")) {
                ++lines;
                continue;
            }
            if (str.length() <= 80) continue;
            lines += str.length() / 80;
        }
        JTextArea txt = new JTextArea(msg, lines, 40);
        txt.setBorder(new EmptyBorder(0, 0, 0, 0));
        txt.setEditable(false);
        txt.setOpaque(false);
        txt.setFont(frame.getFont());
        txt.setLineWrap(true);
        txt.setWrapStyleWord(true);
        txt.setCaretPosition(0);
        txt.setRequestFocusEnabled(true);
        JScrollPane txtScrollP = new JScrollPane(txt);
        txtScrollP.setBorder(new EmptyBorder(6, 10, 0, 0));
        JPanel northP = new JPanel(new BorderLayout());
        JPanel buttonP = new JPanel(new FlowLayout(2));
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
        JPanel iconP = new JPanel();
        iconP.add(iconLabel);
        northP.add((Component)txtScrollP, "Center");
        northP.add((Component)iconP, "West");
        this.detailsButton = new JButton(this.moreStr);
        this.closeButton = new JButton(this.closeStr);
        if (this.closeStr.indexOf("Close") > -1) {
            this.closeButton.setMnemonic('C');
        }
        this.closeButton.requestFocus();
        if (null != additionalInfo && !additionalInfo.trim().equals("")) {
            buttonP.add(this.detailsButton);
            this.detailsButton.addActionListener(this);
            this.setDetailsBtnMnemonic();
            JTextArea traceArea = new JTextArea(additionalInfo);
            traceArea.setRequestFocusEnabled(true);
            traceArea.setEditable(false);
            traceArea.setLineWrap(false);
            traceArea.setWrapStyleWord(false);
            traceArea.setOpaque(false);
            traceArea.setBorder(new EmptyBorder(0, 10, 0, 10));
            this.detailsScrollP = new JScrollPane(traceArea);
            this.detailsScrollP.setBorder(BorderFactory.createLoweredBevelBorder());
            this.detailsScrollP.setPreferredSize(new Dimension(0, 0));
            this.getContentPane().add((Component)this.detailsScrollP, "Center");
        }
        buttonP.add(this.closeButton);
        this.closeButton.addActionListener(this);
        northP.add((Component)buttonP, "South");
        this.getContentPane().add((Component)northP, "North");
        this.pack();
        Dimension winSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x_pos = (winSize.width - this.getWidth()) / 2;
        int y_pos = (winSize.height - this.getHeight()) / 2;
        this.setLocation(x_pos, y_pos);
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
    }
}

