/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.util.Locale;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import se.ericsson.cello.support.gui.AbstractViewElement;
import se.ericsson.cello.support.gui.CachingPolicy;
import se.ericsson.cello.support.gui.ViewElementCreator;
import se.ericsson.cello.support.gui.ViewElementEvent;
import se.ericsson.cello.support.gui.ViewElementListener;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public class TopologyModel
implements TreeModel,
ViewElementListener {
    private AbstractViewElement root;
    private CachingPolicy policy = CachingPolicy.ONLY_WHEN_NEEDED;
    private ViewElementCreator rootcreator;
    private Vector listeners = new Vector();
    private Vector standardAttributes = new Vector();
    private static final String typeAttributeName = "VIEWELEMENT_TYPE";
    private String name;
    private Locale locale;
    private String resourceBundleBasename;

    public TopologyModel(String aName, ViewElementCreator aRootCreator) {
        this.name = aName;
        this.rootcreator = aRootCreator;
        this.standardAttributes.add(typeAttributeName);
    }

    public TopologyModel(String aName, ViewElementCreator aRootCreator, CachingPolicy aPolicy) {
        this.name = aName;
        this.rootcreator = aRootCreator;
        this.policy = aPolicy;
        this.standardAttributes.add(typeAttributeName);
    }

    public TopologyModel(String aName, AbstractViewElement aRoot) {
        this.name = aName;
        this.root = aRoot;
        this.root.setModel(this);
        this.listenToSubtree(this.root);
        this.standardAttributes.add(typeAttributeName);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStandardAttribute(String attrName) {
        Vector vector = this.standardAttributes;
        synchronized (vector) {
            this.standardAttributes.add(attrName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStandardAttribute(String attrName) {
        Vector vector = this.standardAttributes;
        synchronized (vector) {
            this.standardAttributes.remove(attrName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceStandardAttributes(String[] newColumns) {
        Vector vector = this.standardAttributes;
        synchronized (vector) {
            this.standardAttributes.removeAllElements();
            for (int i = 0; i < newColumns.length; ++i) {
                this.standardAttributes.addElement(newColumns[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStandardAttributes(String[] newColumns) {
        Vector vector = this.standardAttributes;
        synchronized (vector) {
            for (int i = 0; i < newColumns.length; ++i) {
                this.standardAttributes.addElement(newColumns[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getStandardAttributes() {
        Vector vector = this.standardAttributes;
        synchronized (vector) {
            if (this.standardAttributes.size() == 0) {
                return null;
            }
            return this.standardAttributes.toArray(new String[this.standardAttributes.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTreeModelListener(TreeModelListener l) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
    }

    public Object getChild(Object parent, int index) {
        AbstractViewElement child = null;
        if (parent instanceof AbstractViewElement) {
            child = ((AbstractViewElement)parent).getSubordinateAt(index);
        }
        return child;
    }

    public int getChildCount(Object parent) {
        if (parent instanceof AbstractViewElement) {
            return ((AbstractViewElement)parent).getSubordinateCount();
        }
        return 0;
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof AbstractViewElement && child instanceof AbstractViewElement) {
            AbstractViewElement parentElt = (AbstractViewElement)parent;
            AbstractViewElement childElt = (AbstractViewElement)child;
            return parentElt.getIndexOfSubordinate(childElt);
        }
        return -1;
    }

    public boolean isLeaf(Object viewElement) {
        if (viewElement instanceof AbstractViewElement) {
            AbstractViewElement ave = (AbstractViewElement)viewElement;
            return ave.isLeaf();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTreeModelListener(TreeModelListener l) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.remove(l);
        }
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public Object getRoot() {
        if (this.root == null && this.rootcreator != null) {
            AbstractViewElement[] elts = this.rootcreator.createInstances(null);
            if (elts == null) {
                return null;
            }
            this.root = elts[0];
            this.root.setModel(this);
            this.root.addViewElementListener(this);
            if (this.policy == CachingPolicy.ALL_AT_ONCE) {
                this.expandSubtree(this.root);
            }
        }
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewElementInserted(ViewElementEvent event) {
        Log.trace("viewElementInserted. ViewElementEvent = " + event);
        AbstractViewElement child = (AbstractViewElement)event.getChangedObject();
        if (child != null) {
            int[] indices = new int[]{event.getIndex()};
            Object[] children = new Object[]{child};
            TreeModelEvent evt = new TreeModelEvent((Object)this, event.getPath(), indices, children);
            child.addViewElementListener(this);
            if (!child.childrenAreAllowed()) {
                Vector vector = this.listeners;
                synchronized (vector) {
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        ((TreeModelListener)this.listeners.elementAt(i)).treeStructureChanged(evt);
                    }
                }
            }
            Vector vector = this.listeners;
            synchronized (vector) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ((TreeModelListener)this.listeners.elementAt(i)).treeNodesInserted(evt);
                }
            }
        }
        if (child != null) {
            child.updateLocale(this.locale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewElementDeleted(ViewElementEvent event) {
        AbstractViewElement child = (AbstractViewElement)event.getChangedObject();
        if (child != null) {
            int[] indices = new int[]{event.getIndex()};
            Object[] children = new Object[]{child};
            TreeModelEvent evt = new TreeModelEvent((Object)this, event.getPath(), indices, children);
            child.removeViewElementListener(this);
            if (!child.childrenAreAllowed()) {
                Vector vector = this.listeners;
                synchronized (vector) {
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        ((TreeModelListener)this.listeners.elementAt(i)).treeStructureChanged(evt);
                    }
                }
            }
            Vector vector = this.listeners;
            synchronized (vector) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ((TreeModelListener)this.listeners.elementAt(i)).treeNodesRemoved(evt);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewElementUpdated(ViewElementEvent event) {
        AbstractViewElement child = (AbstractViewElement)event.getChangedObject();
        if (child != null) {
            int[] indices = new int[]{event.getIndex()};
            Object[] children = new Object[]{child};
            TreeModelEvent evt = event.getPath() != null ? new TreeModelEvent((Object)this, event.getPath(), indices, children) : new TreeModelEvent((Object)this, new TreePath(this.getRoot()));
            Vector vector = this.listeners;
            synchronized (vector) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ((TreeModelListener)this.listeners.elementAt(i)).treeNodesChanged(evt);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewElementStructureChanged(ViewElementEvent event) {
        TreeModelEvent evt = new TreeModelEvent((Object)this, event.getPath());
        Vector vector = this.listeners;
        synchronized (vector) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((TreeModelListener)this.listeners.elementAt(i)).treeStructureChanged(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewElementChildrenLoaded(ViewElementEvent event) {
        AbstractViewElement expandedElement = (AbstractViewElement)event.getPath().getLastPathComponent();
        Object[] children = expandedElement.getChildren();
        int[] indices = new int[children.length];
        for (int i = 0; i < children.length; ++i) {
            indices[i] = i;
        }
        TreeModelEvent evt = new TreeModelEvent((Object)this, event.getPath(), indices, children);
        Vector vector = this.listeners;
        synchronized (vector) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((TreeModelListener)this.listeners.elementAt(i)).treeNodesInserted(evt);
            }
        }
        expandedElement.addListenerToSubordinates(this);
    }

    public void setResourceBundleBasename(String aResourceBundleBasename) {
        this.resourceBundleBasename = aResourceBundleBasename;
    }

    public String getResourceBundleBasename() {
        return this.resourceBundleBasename;
    }

    public void updateLocale(Locale aLocale) {
        this.locale = aLocale;
        if (this.root != null) {
            this.root.updateLocale(aLocale);
        } else {
            Log.trace("Root view element is null. Locale cannot be updated yet");
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void expandSubtree(AbstractViewElement elt) {
        AbstractViewElement[] children = elt.getSubordinates();
        for (int i = 0; i < children.length; ++i) {
            this.expandSubtree(children[i]);
        }
    }

    private void listenToSubtree(AbstractViewElement elt) {
        elt.addViewElementListener(this);
        AbstractViewElement[] subordinates = elt.getSubordinates();
        for (int i = 0; i < subordinates.length; ++i) {
            this.listenToSubtree(subordinates[i]);
        }
    }

    public void dispose() {
        Log.logNotify("disposing TopologyModel" + this.getName());
        Log.logNotify("dropping all listeners to this TopologyModel");
        this.listeners.clear();
        Log.logNotify("Stopping to listen to the tree");
        AbstractViewElement root = (AbstractViewElement)this.getRoot();
        this.unlistenToSubtree(root);
        Log.logNotify("deleting children of root");
        AbstractViewElement[] rootChildren = root.getLoadedChildren();
        if (rootChildren != null) {
            for (int i = 0; i < rootChildren.length; ++i) {
                Log.logNotify("Removing child " + i + " " + rootChildren[i]);
                root.removeChild(rootChildren[i]);
            }
        }
        if (this.rootcreator != null) {
            this.rootcreator.dispose();
        }
        if (this.standardAttributes != null) {
            this.standardAttributes.clear();
        }
        this.rootcreator = null;
        root = null;
        this.policy = null;
        this.standardAttributes = null;
        Log.logNotify("TopologyModel dispose() done----------");
    }

    private void unlistenToSubtree(AbstractViewElement elt) {
        elt.removeViewElementListener(this);
        if (elt.childrenAreLoaded()) {
            AbstractViewElement[] subordinates = elt.getSubordinates();
            for (int i = 0; i < subordinates.length; ++i) {
                this.unlistenToSubtree(subordinates[i]);
            }
        }
    }
}

