/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.awt.Dimension;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import se.ericsson.cello.support.gui.gengui.ComponentBoxLayout;
import se.ericsson.cello.support.gui.guilib.infra.GuilibResourceBundle;
import se.ericsson.cello.support.gui.guilib.infra.LocaleChangeListener;

public class GenGroupBox
extends JPanel
implements LocaleChangeListener,
ContainerListener {
    private String myTag = null;
    private String myBundle = null;
    private boolean resizeAble = false;

    public GenGroupBox(String translations, String tag) {
        this(tag);
        this.myTag = tag;
        this.myBundle = translations;
        this.putClientProperty("LANGUAGE_CONTROLLED", "NT");
    }

    public GenGroupBox(String tag) {
        this.setLayout(new ComponentBoxLayout(this));
        this.setAlignmentX(0.0f);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), tag, 1, 2));
        this.addContainerListener(this);
    }

    public Dimension getMaximumSize() {
        if (this.resizeAble) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        return new Dimension(Integer.MAX_VALUE, this.getPreferredSize().height);
    }

    public void componentAdded(ContainerEvent e) {
        if (e.getChild() instanceof ComponentListener) {
            this.resizeAble = true;
        }
    }

    public void componentRemoved(ContainerEvent e) {
    }

    public void updateLocale(Locale locale) {
        String titleBorderText;
        ResourceBundle rb = null;
        try {
            rb = GuilibResourceBundle.getBundle(this.myBundle, locale, this.getClass().getClassLoader());
            titleBorderText = rb.getString(this.myTag);
        }
        catch (MissingResourceException mre) {
            titleBorderText = this.myTag;
        }
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), titleBorderText, 1, 2));
    }
}

