/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Locale;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import se.ericsson.cello.support.gui.gengui.LabelledField;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public class GenPasswordField
extends LabelledField
implements FocusListener,
KeyListener {
    public JPasswordField passwordField = null;
    private ActionListener actionListener = null;
    private String actionCommand = null;
    private String tooltipText = null;
    private String value = null;

    public GenPasswordField(String translations, String labelTag, Integer length) {
        super(translations, labelTag);
        this.passwordField = new JPasswordField(length);
        this.passwordField.setMinimumSize(this.passwordField.getPreferredSize());
        this.passwordField.putClientProperty("LANGUAGE_CONTROLLED", "NT");
        this.add(this.passwordField);
        this.passwordField.addFocusListener(this);
        this.passwordField.addKeyListener(this);
    }

    public GenPasswordField(String labelTag, Integer length) {
        super(labelTag);
        this.passwordField = new JPasswordField(length);
        this.passwordField.setMinimumSize(this.passwordField.getPreferredSize());
        this.add(this.passwordField);
        this.passwordField.addFocusListener(this);
        this.passwordField.addKeyListener(this);
    }

    public void setActionListener(ActionListener aListener, String aCommand) {
        this.actionListener = aListener;
        this.actionCommand = aCommand;
    }

    public Object getFieldComponent() {
        Log.trace("getFieldComponent()");
        return this.passwordField;
    }

    public void focusGained(FocusEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (this.isValidSyntax()) {
            this.passwordField.setForeground(Color.black);
        }
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 0, "ENTRYFIELD_FILLEDIN"));
        }
    }

    public boolean isFilledIn() {
        return !this.passwordField.getPassword().equals("") && this.isValidSyntax();
    }

    public void focusLost(FocusEvent e) {
        Log.trace("focusLost()");
        String password = new String(this.passwordField.getPassword());
        if (!password.equals("")) {
            if (!this.isValidSyntax()) {
                this.passwordField.setForeground(Color.red);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        GenPasswordField.this.passwordField.requestFocus();
                        Toolkit.getDefaultToolkit().beep();
                    }
                });
            } else {
                this.passwordField.setForeground(Color.black);
                if (this.fillInValue(password) && this.actionListener != null) {
                    this.actionListener.actionPerformed(new ActionEvent(this, 0, this.actionCommand));
                }
            }
        } else {
            boolean dummy = this.fillInValue("");
            if (dummy && this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 0, this.actionCommand));
            }
        }
    }

    public void updateLocale(Locale locale) {
        super.updateLocale(locale);
        this.translateTooltip(locale);
    }

    public String getValue() {
        return this.value;
    }

    private boolean fillInValue(String text) {
        Log.trace("FillInValue()");
        if (text.equals("")) {
            if (this.value == null) {
                return false;
            }
            this.value = null;
            return true;
        }
        if (this.value != null && this.value.equals(text)) {
            return false;
        }
        this.value = text;
        return true;
    }

    protected boolean isValidSyntax() {
        Log.trace("isValixSyntax()");
        boolean check = true;
        return check;
    }

    public boolean setValue(String text) {
        this.passwordField.setText(text);
        return this.fillInValue(text);
    }
}

