/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.omg.CORBA.Object;
import se.ericsson.cello.support.gui.guilib.comp.ComponentToolkit;
import se.ericsson.cello.support.gui.guilib.comp.IconHelper;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.cello.support.gui.guilib.infra.AbstractDialogController;
import se.ericsson.cello.support.gui.guilib.infra.AbstractPresenter;
import se.ericsson.cello.support.gui.guilib.infra.AbstractRequest;
import se.ericsson.cello.support.gui.guilib.infra.AbstractView;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationManager;
import se.ericsson.cello.support.gui.guilib.infra.BrowserHelp;
import se.ericsson.cello.support.gui.guilib.infra.ComponentSniffer;
import se.ericsson.cello.support.gui.guilib.infra.DialogModalPresenter;
import se.ericsson.cello.support.gui.guilib.infra.DialogPresenter;
import se.ericsson.cello.support.gui.guilib.infra.ErrorReporter;
import se.ericsson.cello.support.gui.guilib.infra.HelpManager;
import se.ericsson.cello.support.gui.guilib.infra.LanguageManager;
import se.ericsson.cello.support.gui.guilib.infra.LocaleChangeListener;
import se.ericsson.cello.support.gui.guilib.infra.RequestHandler;
import se.ericsson.cello.support.gui.guilib.infra.WizardModalPresenter;
import se.ericsson.cello.support.gui.guilib.infra.WizardPresenter;

public abstract class AbstractController {
    private AbstractPresenter presenter;
    private JDialog dialog;

    void init(AbstractPresenter presenter) {
        this.presenter = presenter;
    }

    AbstractPresenter getPresenter() {
        return this.presenter;
    }

    void dispose() {
        this.presenter = null;
    }

    boolean isDisposed() {
        return this.presenter == null;
    }

    public AbstractApplication getApplication() {
        return this.presenter.getApplication();
    }

    protected Hashtable getExternalApplications() {
        return null;
    }

    public Vector getApplications() {
        Vector v = new Vector();
        Enumeration e = this.getApplication().getApplicationManager().getAllApplications();
        while (e.hasMoreElements()) {
            v.add(e.nextElement());
        }
        return v;
    }

    public JApplet getApplet() {
        return this.getApplication().getApplet();
    }

    public ApplicationManager getApplicationManager() {
        return this.getApplication().getApplicationManager();
    }

    public AbstractController getParentController() {
        AbstractController parentController = null;
        AbstractPresenter parentPresenter = this.presenter.getParentPresenter();
        if (parentPresenter != null) {
            parentController = parentPresenter.getController();
        }
        return parentController;
    }

    public String getProperty(String key) {
        return this.presenter.getApplication().getEnvironment().getProperty(key);
    }

    public AbstractView getView() {
        return this.presenter.getView();
    }

    protected abstract void init();

    protected void beforeVisible() {
    }

    protected void afterVisible() {
    }

    void viewClosing() {
    }

    public boolean verifyUserExiting() {
        java.lang.Object[] app_title = new java.lang.Object[]{this.getApplication().getTitle()};
        String gsl_exit_msg = this.getString("GSL_EXIT_MSG", null);
        String gsl_exit_title = this.getString("GSL_EXIT_TITLE", null);
        String msg = MessageFormat.format(gsl_exit_msg, app_title);
        String title = MessageFormat.format(gsl_exit_title, app_title);
        int result = JOptionPane.showConfirmDialog(this.presenter.getView(), msg, title, 0, 1, null);
        if (result == 0) {
            return true;
        }
        if (result == 1) {
            return false;
        }
        return false;
    }

    protected boolean canStop() {
        return true;
    }

    protected void stop() {
    }

    public void addLocaleChangeListener(LocaleChangeListener listener) {
        this.presenter.addLocaleChangeListener(listener);
    }

    public void removeLocaleChangeListener(LocaleChangeListener listener) {
        this.presenter.removeLocaleChangeListener(listener);
    }

    public AbstractApplication startInitialApplication(boolean visible) {
        return this.getApplicationManager().startInitialApplication(null, visible);
    }

    public AbstractApplication startApplication(String className, java.lang.Object[][] params) {
        return this.startApplication(className, params, true);
    }

    public AbstractApplication startApplication(String className, java.lang.Object[][] params, boolean visible) {
        return this.getApplicationManager().startApplication(className, params, null, false, visible);
    }

    public void stopApplication() {
        this.getApplication().stopApplication();
    }

    public void stopApplication(AbstractApplication application) {
        this.getApplicationManager().stopApplication(application);
    }

    public void stopApplicationNoCheck() {
        this.getApplicationManager().stopApplicationNoCheck(this.getApplication());
    }

    public void reportException(Exception e, String msgKey, java.lang.Object[] msgArgs) {
        ErrorReporter.getReporter().reportException(this, e, msgKey, msgArgs);
    }

    public int showConfirmDialog(String msgKey, java.lang.Object[] msgArgs, String titleKey, java.lang.Object[] titleArgs, int optionType, int msgType, String iconName) {
        Icon icon = IconHelper.createIcon(iconName);
        String msg = this.getString(msgKey, msgArgs);
        String title = this.getString(titleKey, titleArgs);
        if (optionType == 0) {
            java.lang.Object[] buttons = new String[]{this.getString("GSL_YES", msgArgs), this.getString("GSL_NO", msgArgs)};
            int result = JOptionPane.showOptionDialog(this.presenter.getView(), msg, title, 0, msgType, null, buttons, buttons[1]);
            return result;
        }
        return JOptionPane.showConfirmDialog(this.presenter.getView(), msg, title, optionType, msgType, icon);
    }

    public java.lang.Object showInputDialog(String msgKey, java.lang.Object[] msgArgs, String titleKey, java.lang.Object[] titleArgs, int msgType, String iconName, java.lang.Object[] selectionValues, java.lang.Object initialSelectionValue) {
        Icon icon = IconHelper.createIcon(iconName);
        String msg = this.getString(msgKey, msgArgs);
        String title = this.getString(titleKey, titleArgs);
        return JOptionPane.showInputDialog(this.presenter.getView(), msg, title, msgType, icon, selectionValues, initialSelectionValue);
    }

    public void showMessageDialog(String msgKey, java.lang.Object[] msgArgs, String titleKey, java.lang.Object[] titleArgs, int msgType, String iconName) {
        Icon icon = IconHelper.createIcon(iconName);
        String msg = this.getString(msgKey, msgArgs);
        String title = this.getString(titleKey, titleArgs);
        JTextArea txt = new JTextArea(this.getString(msgKey, msgArgs));
        txt.setEditable(false);
        txt.setBackground(this.getView().getBackground());
        txt.setFont(this.getView().getFont());
        txt.setLineWrap(true);
        txt.setWrapStyleWord(true);
        txt.setCaretPosition(0);
        JScrollPane scrollPane = new JScrollPane(txt, 20, 31);
        scrollPane.setPreferredSize(new Dimension(400, 120));
        JOptionPane pane = new JOptionPane(scrollPane, msgType);
        this.dialog = pane.createDialog(this.getView(), this.getString(titleKey, titleArgs));
        this.dialog.setResizable(true);
        this.dialog.show();
    }

    protected JDialog getMessageDialog() {
        return this.dialog;
    }

    public void showOptionDialog(String msgKey, java.lang.Object[] msgArgs, String titleKey, java.lang.Object[] titleArgs, int optionType, int msgType, String iconName, java.lang.Object[] options, java.lang.Object initialValue) {
        Icon icon = IconHelper.createIcon(iconName);
        String msg = this.getString(msgKey, msgArgs);
        String title = this.getString(titleKey, titleArgs);
        JOptionPane.showOptionDialog(this.presenter.getView(), msg, title, optionType, msgType, icon, options, initialValue);
    }

    public synchronized AbstractDialogController startDialog(boolean modal, String titleKey, java.lang.Object[] titleArgs, Class dialogViewClass, Class dialogControllerClass) {
        return this.startDialog(modal, titleKey, titleArgs, dialogViewClass, dialogControllerClass, null);
    }

    public synchronized AbstractDialogController startDialog(boolean modal, String titleKey, java.lang.Object[] titleArgs, Class dialogViewClass, Class dialogControllerClass, java.lang.Object[][] parameters) {
        AbstractPresenter dialogPresenter = modal ? AbstractPresenter.createPresenter(this.presenter, this.getApplication(), DialogModalPresenter.class, dialogViewClass, dialogControllerClass, parameters) : AbstractPresenter.createPresenter(this.presenter, this.getApplication(), DialogPresenter.class, dialogViewClass, dialogControllerClass, parameters);
        dialogPresenter.setTitle(titleKey, titleArgs);
        dialogPresenter.setVisible(true);
        return (AbstractDialogController)dialogPresenter.getController();
    }

    public void setLocation(int x, int y) {
        this.presenter.setLocation(x, y);
    }

    public Point getLocation() {
        return this.presenter.getLocation();
    }

    public java.lang.Object getParameter(String key) {
        return this.presenter.getParameter(key);
    }

    public synchronized void startWizard(boolean modal, String titleKey, java.lang.Object[] titleArgs, Class dialogViewClass, Class dialogControllerClass) {
        this.startWizard(modal, titleKey, titleArgs, dialogViewClass, dialogControllerClass, null);
    }

    public synchronized void startWizard(boolean modal, String titleKey, java.lang.Object[] titleArgs, Class dialogViewClass, Class dialogControllerClass, java.lang.Object[][] parameters) {
        AbstractPresenter wizardPresenter = modal ? AbstractPresenter.createPresenter(this.presenter, this.getApplication(), WizardModalPresenter.class, dialogViewClass, dialogControllerClass, parameters) : AbstractPresenter.createPresenter(this.presenter, this.getApplication(), WizardPresenter.class, dialogViewClass, dialogControllerClass, parameters);
        wizardPresenter.setTitle(titleKey, titleArgs);
        wizardPresenter.setVisible(true);
    }

    public void showWebPage(URL url) {
        JApplet applet = this.getApplication().getApplet();
        if (applet != null) {
            applet.getAppletContext().showDocument(url, "_blank");
        } else {
            BrowserHelp browserHelp = (BrowserHelp)this.presenter.getHelp();
            browserHelp.startBrowser(url);
        }
    }

    public void bindObject(String name, java.lang.Object object) {
        this.getApplicationManager().getObjectNamingService().put(name, object);
    }

    public void unbindObject(String name) {
        this.getApplicationManager().getObjectNamingService().remove(name);
    }

    public java.lang.Object resolveObject(String name) {
        return this.getApplicationManager().getObjectNamingService().get(name);
    }

    public Object resolveService(String name) throws Exception {
        return this.getApplicationManager().getCorbaNameResolver().serviceResolve(name);
    }

    public void invokeRequest(AbstractRequest request) {
        new RequestHandler(this, request).invokeRequest();
    }

    public void showPopupMenu(JPopupMenu menu, Component invoker, int x, int y) {
        LanguageManager languageManager = (LanguageManager)this.presenter.createHandler(LanguageManager.class);
        languageManager.stripShortCut(true);
        ComponentSniffer sniffer = new ComponentSniffer(menu);
        sniffer.addComponentHandler(languageManager);
        HelpManager helpManager = (HelpManager)this.presenter.createHandler(HelpManager.class);
        sniffer.addComponentHandler(helpManager);
        sniffer.sniff();
        sniffer.updateLocale(this.getApplication().getLocale());
        ComponentToolkit.updateLookAndFeel(menu);
        menu.show(invoker, x, y);
    }

    public String getString(String key, java.lang.Object[] args) {
        String str = "";
        if (key != null && !key.equals("")) {
            str = this.getString(key, true);
            if (args != null) {
                str = MessageFormat.format(str, args);
            }
        }
        return str;
    }

    public String getFormattedValueTooltip(java.lang.Object valueRange, java.lang.Object defaultValue) {
        return MessageFormat.format(this.getString("GSL_FORMATTED_VALUE_TOOLTIP", true), valueRange, defaultValue);
    }

    private String getString(String key, boolean strip) {
        return this.presenter.getLanguageManager().getString(key, strip);
    }

    Class getClassForName(String className) {
        Class<?> aClass = null;
        try {
            aClass = Class.forName(className);
        }
        catch (Throwable t) {
            String msg = "Could not create class: " + className;
            Log.logError(msg, t);
            Log.assertion(false, msg);
        }
        return aClass;
    }
}

