/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.omg.CORBA.ORB;
import se.ericsson.cello.emt.utils.guitestsupport.GuiTestEventTypes;
import se.ericsson.cello.support.gui.EmasGuilibMediator;
import se.ericsson.cello.support.gui.EmasLaunchableInterface;
import se.ericsson.cello.support.gui.MainWindowController;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.cello.support.gui.guilib.infra.AbstractPresenter;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationPresenter;
import se.ericsson.cello.support.gui.guilib.infra.CorbaNameResolver;
import se.ericsson.cello.support.gui.guilib.infra.EmasSystemProperties;
import se.ericsson.cello.support.gui.guilib.infra.GuilibConfigParams;
import se.ericsson.cello.support.gui.guilib.infra.GuilibResourceBundle;
import se.ericsson.cello.support.gui.guilib.infra.LanguageManager;
import se.ericsson.cello.support.gui.guilib.infra.SecurityHandler;
import se.ericsson.cello.support.gui.guilib.infra.TraceHelper;
import se.ericsson.cello.support.gui.guilib.infra.ViewContainer;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.launcher.ProgressListenerInterface;
import se.ericsson.security.launcher.emnotification.EmEventInterface;
import se.ericsson.security.launcher.emnotification.EmNotificationServiceInterface;

public class ApplicationManager {
    public static final String SUPERSEDING_PARAMETER_LIST = "SUPERSEDING_PARAMETER_LIST";
    public static boolean IS_APPLETT = true;
    public static final String SYSTEMPROPERTIES_FILE_KEY = "gsl.systemproperties.file";
    public static final String EMT_INIT_CORBA = "EMT_INIT_CORBA";
    static final String SUPPORT_PRESENTATION = "gsl.supportpresentation";
    static final String SUPPORT_LOOK_AND_FEEL = "gsl.supportlookandfeel";
    static final String SYSTEM_LIBRARY = "gsl.systemlibrary";
    static final String LOG_LEVEL = "gsl.loglevel";
    static final String GUILIB_LOG_LEVEL = "gsl.guilib.loglevel";
    static final String MEASUREMENT_INFO_ON = "gsl.measurementinfoon";
    static final String LOG_TO_STD_OUT = "gsl.guilib.logtostdout";
    static final String LOG_TO_FILE = "gsl.guilib.logtofile";
    static final String LOG_FILE_NAME_PREFIX = "gsl.guilib.logfilenameprefix";
    private static final String ENVIRONMENT_BUNDLE = "se.ericsson.cello.support.gui.guilib.infra.resources.Environment";
    public static final String INSTALL_PARAM_FILE_KEY = "gsl.installationparameters.file";
    public static final String INSTALL_PARAM_FILE_DEFAULT = "InstallationParameters";
    private Vector initialApplications = new Vector();
    private String initialClassName;
    private Object[][] initialParams;
    private Vector applications = new Vector();
    private Properties environment = new Properties();
    private SecurityHandler securityHandler;
    private CorbaNameResolver corbaNameResolver;
    private static ClassLoader myClassLoader;
    private Hashtable objectNamingService;
    private int presentation = 0;
    static final int SDI = 0;
    static final int MDI = 1;
    static final int DESKTOP = 2;
    static final int TABBED = 3;
    static final String[] PRESENTATION_TYPE_KEYS;
    static final int[] PRESENTATION_TYPE_VALUES;
    private LauncherInterface launcher;
    private Launchable launchableApplication;
    private ProgressListenerInterface progressListener;
    private static String host;

    public boolean hasNESameVersion() {
        return this.launcher.hasNESameVersion(host, this.launchableApplication);
    }

    public Collection getConfigurationFiles() {
        return this.launcher.getConfigurationFiles(this.launchableApplication);
    }

    public Launchable runApplication(String nameOrPath) {
        Properties props = new Properties(EmasSystemProperties.getProperties());
        props.putAll((Map<?, ?>)ApplicationManager.fetchSupersedingProps());
        try {
            return this.launcher.runApplication(nameOrPath, host, props, this.launchableApplication);
        }
        catch (Exception e) {
            Log.logError("Exception in runApplication", e);
            this.progressListener.close();
            throw new RuntimeException(e);
        }
    }

    private static Properties fetchSupersedingProps() {
        Configer myConfiger = new Configer();
        Properties superSedingProps = myConfiger.getSupersedingProperties();
        return superSedingProps;
    }

    public void launchTool(final String configFile, final Properties props) {
        props.putAll((Map<?, ?>)ApplicationManager.fetchSupersedingProps());
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    ApplicationManager.this.launcher.runApplication(configFile, host, props, ApplicationManager.this.launchableApplication);
                }
                catch (Exception e) {
                    Log.logError("Exception in runApplication", e);
                    throw new RuntimeException(e);
                }
            }
        };
        Thread t = new Thread(runnable);
        t.start();
    }

    public void launchResource(final String configFile, final Properties props) {
        props.putAll((Map<?, ?>)ApplicationManager.fetchSupersedingProps());
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    ApplicationManager.this.launcher.runResource(configFile, host, props, ApplicationManager.this.launchableApplication);
                }
                catch (Exception e) {
                    Log.logError("Exception in runResource", e);
                    throw new RuntimeException(e);
                }
            }
        };
        Thread t = new Thread(runnable);
        t.start();
    }

    public Launchable runResource(String configFile, Properties props) throws LauncherException {
        props.putAll((Map<?, ?>)ApplicationManager.fetchSupersedingProps());
        Log.logNotify("ApplicationManager runResource calling launcher with " + configFile + " with properties: " + props.toString());
        return this.launcher.runResource(configFile, host, props, this.launchableApplication);
    }

    public boolean isApplicationsRunning(Object o) {
        if (o == null) {
            return false;
        }
        Collection collector = this.launcher.getRunningApplications();
        Iterator it = collector.iterator();
        boolean found = false;
        while (!found && it.hasNext()) {
            Launchable launchable = (Launchable)it.next();
            if (!o.equals(launchable)) continue;
            found = true;
        }
        return found;
    }

    public void shoutDownAllExternaApplications() {
        MainWindowController mw = EmasGuilibMediator.getReference().getMainWindowReference();
        EmasLaunchableInterface oeapp = mw.getOeApplication();
        if (oeapp != null) {
            EmasLaunchableInterface launchable = oeapp;
            launchable.exit();
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                ApplicationManager.printUsage();
            } else {
                Class.forName(args[0]);
                Object[][] param = null;
                try {
                    param = ApplicationManager.createParameters(args);
                    new ApplicationManager(args[0], param, null, null).startInitialApplication(null, true);
                }
                catch (ParseException e) {
                    Log.assertion(false, "Illegal argument list " + e);
                }
            }
        }
        catch (ClassNotFoundException t) {
            ApplicationManager.println("");
            ApplicationManager.println("Class not found: " + args[0]);
            ApplicationManager.printUsage();
        }
        catch (Throwable t) {
            ApplicationManager.println("Unknown exception in main: " + t);
            t.printStackTrace();
        }
    }

    public static ApplicationManager Launchermain(String hostname, Properties props, LauncherInterface launcher, Launchable launchableApplication, ProgressListenerInterface progressListener) {
        ApplicationManager app = null;
        String[] args = new String[props.size() * 2 + 3];
        Object[][] param = null;
        String hostflag = "-host";
        String host1 = hostname;
        host = hostname;
        Enumeration<?> enume = props.propertyNames();
        int i = 3;
        while (enume.hasMoreElements()) {
            String key = (String)enume.nextElement();
            if (key != null && !key.equals("")) {
                Log.trace(" key: " + key);
                String val = props.getProperty(key);
                Log.trace(" val: " + val);
                args[i] = key;
                args[++i] = val;
            }
            ++i;
        }
        props.putAll((Map<?, ?>)ApplicationManager.fetchSupersedingProps());
        EmasSystemProperties.setInitialProperties(props);
        Properties p = launcher.getApplVersion(launchableApplication);
        EmasSystemProperties.setProperty("CUSTOM_APPL_PROD_NO", p.getProperty("CUSTOM_APPL_PROD_NO", ""));
        EmasSystemProperties.setProperty("host", hostname);
        String initialClassName = EmasSystemProperties.getProperty("APPL_TO_RUN");
        Log.trace("initialClassName" + initialClassName);
        args[0] = initialClassName;
        args[1] = hostflag;
        args[2] = host1;
        try {
            param = ApplicationManager.createInitialParameters(args);
        }
        catch (ParseException e) {
            Log.assertion(false, "Illegal argument list in Launchermain" + e);
        }
        try {
            Class.forName(initialClassName);
        }
        catch (ClassNotFoundException t) {
            ApplicationManager.println("");
            ApplicationManager.println("Class not found: " + initialClassName);
            ApplicationManager.printUsage();
        }
        try {
            app = new ApplicationManager(initialClassName, param, launcher, launchableApplication, progressListener);
            app.startInitialApplication(null, true);
        }
        catch (Throwable t) {
            ApplicationManager.println("Unknown exception in main: " + t);
            t.printStackTrace();
        }
        return app;
    }

    private static Object[][] createInitialParameters(String[] args) throws ParseException {
        if (args.length == 1) {
            return null;
        }
        if ((args.length - 1) % 2 != 0) {
            throw new ParseException("Odd number of arguments", 0);
        }
        int arrayLength = (args.length - 1) / 2;
        Object[][] arguments = new Object[arrayLength][2];
        for (int i = 0; i < arrayLength; ++i) {
            int position = i * 2 + 1;
            String name = args[position];
            if (name.length() == 1) {
                throw new ParseException("Argument " + name + " too short!", i);
            }
            arguments[i][0] = name.substring(1);
            arguments[i][1] = args[position + 1];
        }
        return arguments;
    }

    private static Object[][] createParameters(String[] args) throws ParseException {
        if (args.length == 1) {
            return null;
        }
        if ((args.length - 1) % 2 != 0) {
            throw new ParseException("Odd number of arguments", 0);
        }
        int arrayLength = (args.length - 1) / 2;
        Object[][] arguments = new Object[arrayLength][2];
        for (int i = 0; i < arrayLength; ++i) {
            int position = i * 2 + 1;
            String name = args[position];
            if (!name.startsWith("-")) {
                throw new ParseException("Argument " + name + " does not begin with '-'", i);
            }
            if (name.length() == 1) {
                throw new ParseException("Argument " + name + " too short!", i);
            }
            arguments[i][0] = name.substring(1);
            arguments[i][1] = args[position + 1];
        }
        return arguments;
    }

    public ApplicationManager(String initialClassName, Object[][] initialParams, LauncherInterface launcher, Launchable launchableApplication) {
        this.launcher = launcher;
        this.launchableApplication = launchableApplication;
        Log.logNotify("ApplicationManager: <constructor>. ClassLoader: " + this.getClass().getClassLoader());
        myClassLoader = this.getClass().getClassLoader();
        this.initialClassName = initialClassName;
        this.initialParams = initialParams;
        GuilibConfigParams.getInstance().init(this.environment, this);
        EmasGuilibMediator.getReference().setLauncher(launcher);
    }

    public ApplicationManager(String initialClassName, Object[][] initialParams, LauncherInterface launcher, Launchable launchableApplication, ProgressListenerInterface progressListener) {
        this(initialClassName, initialParams, launcher, launchableApplication);
        this.progressListener = progressListener;
    }

    SecurityHandler getSecurityHandler() {
        return this.securityHandler;
    }

    boolean isInitialApplication(AbstractApplication application) {
        for (int i = 0; i < this.initialApplications.size(); ++i) {
            if (application != (AbstractApplication)this.initialApplications.elementAt(i)) continue;
            return true;
        }
        return false;
    }

    Properties getEnvironment() {
        return this.environment;
    }

    private static void printUsage() {
        ApplicationManager.println("");
        ApplicationManager.println("usage: java.exe application.ApplicationManager <application class name> [-<arg name> <arg value>]");
    }

    private static void println(String str) {
        System.out.println(str);
    }

    private void setApplicationProperties() {
        Log.logNotify("setApplicationProperties");
        Properties properties = new Properties();
        String systemPropertiesFileName = System.getProperty(SYSTEMPROPERTIES_FILE_KEY);
        Log.logNotify("systemPropertiesFileName(from System):" + systemPropertiesFileName);
        if (systemPropertiesFileName == null || systemPropertiesFileName.equals("")) {
            systemPropertiesFileName = EmasSystemProperties.getProperty(SYSTEMPROPERTIES_FILE_KEY);
            Log.logNotify("systemPropertiesFileName :" + systemPropertiesFileName);
        }
        if (systemPropertiesFileName == null || systemPropertiesFileName.equals("")) {
            Log.logNotify("No setting for a sysprop file, not loading any.");
        } else {
            try {
                ResourceBundle bundle = GuilibResourceBundle.getBundle(systemPropertiesFileName, LanguageManager.EMPTY_LOCALE, this.getClass().getClassLoader());
                Enumeration<String> enume = bundle.getKeys();
                while (enume.hasMoreElements()) {
                    String key = enume.nextElement();
                    properties.put(key, bundle.getObject(key));
                }
            }
            catch (Throwable t) {
                String msg = "Could not create ResourceBundle: " + systemPropertiesFileName;
                Log.logNotify(msg);
                Log.assertion(false, msg);
            }
            Log.logNotify("file with systemproperties loaded : " + systemPropertiesFileName);
        }
        Log.logNotify("All systemdefault systemproperties : " + System.getProperties());
    }

    private void configure(JApplet applet) {
        if (applet == null) {
            this.setApplicationProperties();
        }
        ApplicationManager.loadBundle(ENVIRONMENT_BUNDLE, LanguageManager.EMPTY_LOCALE, this.environment);
        try {
            String installParamFileName = EmasSystemProperties.getProperty(INSTALL_PARAM_FILE_KEY, INSTALL_PARAM_FILE_DEFAULT);
            ApplicationManager.loadBundle(installParamFileName, LanguageManager.EMPTY_LOCALE, this.environment);
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        this.setLogEnvironment(this.environment);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Log.logNotify("System locale: " + Locale.getDefault().getDisplayName());
        Log.logNotify("Environment properties: " + this.environment);
    }

    private void setEmasPropsToSystem() {
        try {
            Properties properties = EmasSystemProperties.getProperties();
            int i = 0;
            Enumeration<?> names = properties.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = EmasSystemProperties.getProperty(name);
                if (value != null) {
                    System.setProperty(name, value);
                }
                ++i;
            }
            Log.logNotify("Emas props copied to system props");
        }
        catch (SecurityException e) {
            Log.logError("Prohibited by SecurityManager to set the properties.", e);
        }
    }

    private void removeEmasPropsFromSystem() {
        try {
            Properties properties = EmasSystemProperties.getProperties();
            int i = 0;
            Enumeration<?> names = properties.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (name != null) {
                    Properties pp = System.getProperties();
                    ((Hashtable)pp).remove(name);
                }
                ++i;
            }
            Log.logNotify("Emas props removed from system props");
        }
        catch (SecurityException e) {
            Log.logError("Prohibited by SecurityManager to remove property from system properties", e);
        }
    }

    private void setLogEnvironment(Properties anEnvironment) {
        String mio = anEnvironment.getProperty(MEASUREMENT_INFO_ON);
        Log.trace("MEASUREMENT_INFO_ON from Environment.properties = " + mio);
        if (mio != null) {
            if ("TRUE".equalsIgnoreCase(mio)) {
                Log.setMeasurementInfoOn(true);
            } else if ("FALSE".equalsIgnoreCase(mio)) {
                Log.setMeasurementInfoOn(false);
            } else {
                Log.logError("Wrong format of measurementinfoon in environment properties");
                Log.setMeasurementInfoOn(false);
            }
        }
        String logLevel = anEnvironment.getProperty(LOG_LEVEL);
        Log.trace("LOG_LEVEL from Environment.properties = " + logLevel);
        if (logLevel != null) {
            try {
                TraceHelper.setTraceType(new Integer(logLevel));
            }
            catch (NumberFormatException nfe) {
                Log.logError("Wrong format of loglevel in environment properties");
            }
        }
        String guilibLogLevel = anEnvironment.getProperty(GUILIB_LOG_LEVEL);
        Log.trace("GUILIB_LOG_LEVEL from Environment.properties = " + guilibLogLevel);
        if (guilibLogLevel != null) {
            try {
                Log.setLogLevel(new Integer(guilibLogLevel));
            }
            catch (NumberFormatException nfe) {
                Log.logError("Wrong format of guilib.loglevel in environment properties");
            }
        }
        String ltso = anEnvironment.getProperty(LOG_TO_STD_OUT);
        Log.trace("LOG_TO_STD_OUT from Environment.properties = " + ltso);
        if (ltso != null) {
            if ("TRUE".equalsIgnoreCase(ltso)) {
                Log.setLogToStdOut(true);
            } else if ("FALSE".equalsIgnoreCase(ltso)) {
                Log.setLogToStdOut(false);
            } else {
                Log.logError("Wrong format of logtostdout in environment properties");
            }
        }
        String ltf = anEnvironment.getProperty(LOG_TO_FILE);
        Log.trace("LOG_TO_FILE from Environment.properties = " + ltf);
        if (ltf != null) {
            if ("TRUE".equalsIgnoreCase(ltf)) {
                Log.setLogToFile(true);
            } else if ("FALSE".equalsIgnoreCase(ltf)) {
                Log.setLogToFile(false);
            } else {
                Log.logError("Wrong format of logtofile in environment properties");
            }
        }
        String lfnp = anEnvironment.getProperty(LOG_FILE_NAME_PREFIX);
        Log.trace("LOG_FILE_NAME_PREFIX from Environment.properties = " + lfnp);
        if (lfnp != null) {
            Log.setLogFileNamePrefix(lfnp);
        }
    }

    AbstractApplication getFirstInitialApplication() {
        return (AbstractApplication)this.initialApplications.firstElement();
    }

    Enumeration getInitialApplications() {
        return this.initialApplications.elements();
    }

    Enumeration getApplications() {
        return this.applications.elements();
    }

    Enumeration getAllApplications() {
        int j;
        Vector<AbstractApplication> allApps = new Vector<AbstractApplication>();
        for (j = 0; j < this.initialApplications.size(); ++j) {
            allApps.add((AbstractApplication)this.initialApplications.elementAt(j));
        }
        for (j = 0; j < this.applications.size(); ++j) {
            allApps.add((AbstractApplication)this.applications.elementAt(j));
        }
        return allApps.elements();
    }

    public void updateAllPrefixes(Object newPrefix) {
        Log.log(4, "Setting all prefixes to : " + newPrefix);
        this.getFirstInitialApplication().getApplicationPresenter().setPrefix(newPrefix);
        this.updateAllTitles();
    }

    private void updateAllTitles() {
        Log.trace("updating titles of all application-windows...");
        Enumeration enume = this.getAllApplications();
        while (enume.hasMoreElements()) {
            AbstractApplication app = (AbstractApplication)enume.nextElement();
            app.getApplicationPresenter().updateTitle();
        }
    }

    public synchronized AbstractApplication startInitialApplication(JApplet applet, boolean visible) {
        Log.traceFlow();
        this.configure(applet);
        return this.startApplication(this.initialClassName, this.initialParams, applet, true, visible);
    }

    synchronized AbstractApplication startApplication(String applicationClassName, Object[][] params, JApplet applet, boolean isInitial, boolean visible) {
        AbstractApplication application = null;
        if (SwingUtilities.isEventDispatchThread()) {
            application = this.startApplicationImpl(applicationClassName, params, applet, isInitial, visible);
        } else if (this.initialApplications.size() > 0) {
            String msg = "Trying to start application \"" + applicationClassName + "\" from other thread than the event dispatch thread";
            Log.logError(msg);
            Log.assertion(false, msg);
        } else {
            final String finalApplicationClassName = applicationClassName;
            final Object[][] finalParams = params;
            final JApplet finalApplet = applet;
            final boolean finalIsInitial = isInitial;
            final boolean finalVisible = visible;
            Runnable applicationStarter = new Runnable(){

                public void run() {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    ApplicationManager.this.startApplicationImpl(finalApplicationClassName, finalParams, finalApplet, finalIsInitial, finalVisible);
                }
            };
            try {
                SwingUtilities.invokeAndWait(applicationStarter);
                if (this.progressListener != null) {
                    this.progressListener.close();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractApplication startApplicationImpl(String applicationClassName, Object[][] params, JApplet applet, boolean isInitial, boolean visible) {
        Log.measure("start", true, "Application start");
        Log.logNotify("ApplicationManager: Starting application... " + applicationClassName);
        AbstractApplication application = null;
        AbstractPresenter presenter = null;
        Locale locale = this.initialApplications.size() <= 0 ? LanguageManager.EMPTY_LOCALE : this.getFirstInitialApplication().getLocale();
        Log.logNotify("ApplicationManager: Setting locale for application " + applicationClassName + " to " + locale.getDisplayLanguage());
        Properties env = isInitial ? this.environment : this.getFirstInitialApplication().getEnvironment();
        for (int i = 0; i < this.applications.size(); ++i) {
            if (!applicationClassName.equals(this.applications.elementAt(i).getClass().getName())) continue;
            application = (AbstractApplication)this.applications.elementAt(i);
            break;
        }
        if (application != null && application.isSingleton()) {
            application.getApplicationPresenter().getViewContainer().bringToFront();
            return application;
        }
        Object element = null;
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (!"VIEWELEMENT".equals((String)params[i][0])) continue;
                element = params[i][1];
            }
        }
        boolean elementCurrentlyActive = false;
        for (int i = 0; i < this.applications.size(); ++i) {
            if (!applicationClassName.equals(this.applications.elementAt(i).getClass().getName())) continue;
            application = (AbstractApplication)this.applications.elementAt(i);
            if (element == null || application.getApplicationPresenter().getParameter("VIEWELEMENT") != element) continue;
            elementCurrentlyActive = true;
            break;
        }
        if (elementCurrentlyActive) {
            application.getApplicationPresenter().getViewContainer().bringToFront();
            return application;
        }
        Log.log(7, "Environment properties: " + env);
        try {
            Class<?> applicationClass = Class.forName(applicationClassName);
            application = (AbstractApplication)applicationClass.newInstance();
            application.init(this, locale, env);
            if (applet != null) {
                application.setApplet(applet);
            } else if (this.initialApplications.size() > 0) {
                application.setApplet(this.getFirstInitialApplication().getApplet());
            }
            Class<?> viewClass = Class.forName(application.getApplicationViewClassName());
            Class<?> controllerClass = Class.forName(application.getApplicationControllerClassName());
            if (isInitial) {
                this.initialApplications.add(application);
            } else {
                this.applications.addElement(application);
            }
            this.setEmasPropsToSystem();
            Log.logNotify("System.properties=" + System.getProperties());
            if (applet != null) {
                presenter = AbstractPresenter.createPresenter(null, application, ApplicationPresenter.class, viewClass, controllerClass, applet);
            } else {
                IS_APPLETT = false;
                presenter = AbstractPresenter.createPresenter(null, application, ApplicationPresenter.class, viewClass, controllerClass, params);
            }
            String isApplication = EmasSystemProperties.getProperty("application launched");
            if (visible && presenter.isVisible() && !presenter.isDisposed()) {
                if (isApplication != null && isApplication.equalsIgnoreCase("true") && presenter.getApplication().getApplicationViewClassName().equalsIgnoreCase("se.ericsson.cello.support.gui.MainWindowView")) {
                    presenter.setVisible(false);
                } else {
                    presenter.setVisible(true);
                }
                if (!presenter.isDisposed()) {
                    if (presenter.getViewContainer() != null) {
                        presenter.getViewContainer().bringToFront();
                        Log.logNotify("ApplicationManager: Application started " + applicationClassName);
                        this.sendEmNotification("Application \"" + applicationClassName + "\" initiated", this, GuiTestEventTypes.EMSERV_APPLICATION_PREFIX + applicationClassName);
                    } else if (this.initialApplications.size() <= 0) {
                        String msg = "ApplicationManager: Can't start application: " + application;
                        Log.logError(msg);
                        if (applet != null) {
                            // empty if block
                        }
                    } else {
                        String msg = "ApplicationManager: Can't start application: " + application;
                        Log.logError(msg);
                    }
                }
            }
        }
        catch (Throwable t) {
            String msg = "ApplicationManager: Can't start application: " + application;
            Log.logError(msg, t);
            if (presenter != null) {
                this.disposeApplication(application, false);
            } else if (isInitial) {
                this.initialApplications.remove(application);
                if (applet == null && this.initialApplications.size() <= 0) {
                    // empty if block
                }
            } else {
                this.applications.remove(application);
            }
            Log.assertion(false, msg);
        }
        finally {
            this.removeEmasPropsFromSystem();
            Log.logNotify("ApplicationManager:Restored System Properties=" + System.getProperties());
        }
        Log.measure("start", false);
        return application;
    }

    synchronized void stopApplication(AbstractApplication application) {
        if (!this.isInitialApplication(application)) {
            this.stopApplicationCheckFirst(application);
        } else if (this.isInitialApplication(application) && this.initialApplications.size() > 1) {
            this.stopApplicationCheckFirst(application);
        } else {
            this.stopApplicationManager();
        }
    }

    private void stopApplicationCheckFirst(AbstractApplication application) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.stopApplicationCheckFirstImpl(application);
        } else {
            final AbstractApplication finalApplication = application;
            Runnable runnable = new Runnable(){

                public void run() {
                    ApplicationManager.this.stopApplicationCheckFirstImpl(finalApplication);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void stopApplicationCheckFirstImpl(AbstractApplication application) {
        if (this.canStop(application)) {
            this.stopApplicationNoCheck(application);
        }
    }

    void stopApplicationNoCheck(AbstractApplication application) {
        Log.logNotify("ApplicationManager.stop (" + this.applications.size() + "): " + application);
        this.disposeApplication(application, true);
    }

    private void disposeApplication(AbstractApplication application, boolean assertRemove) {
        try {
            ApplicationPresenter presenter = application.getApplicationPresenter();
            presenter.setVisible(false);
            presenter.stopNoCheck();
            presenter.dispose();
        }
        catch (Throwable t) {
            Log.logError("Could not stop application: ", t);
        }
        boolean removed = false;
        if (this.isInitialApplication(application)) {
            removed = this.initialApplications.remove(application);
            if (this.initialApplications.size() <= 0) {
                // empty if block
            }
        } else {
            removed = this.applications.removeElement(application);
        }
        if (!removed) {
            String msg = "Application not found: " + application;
            if (assertRemove) {
                Log.assertion(true, msg);
                Log.logWarning(msg);
            }
        }
    }

    synchronized void stopApplicationManager() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.stopApplicationManagerImpl();
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    ApplicationManager.this.stopApplicationManagerImpl();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void stopApplicationManagerImpl() {
        if (this.initialApplications.size() > 0) {
            Log.logNotify("ApplicationManager: Trying to stop ApplicationManager");
            boolean isWizard = EmasSystemProperties.getProperty("wizard launched", "false").equalsIgnoreCase("true");
            boolean isApplication = EmasSystemProperties.getProperty("application launched", "false").equalsIgnoreCase("true");
            if (isWizard || isApplication || this.canStopAllApplications()) {
                Enumeration enume = ((Vector)this.applications.clone()).elements();
                while (enume.hasMoreElements()) {
                    this.stopApplicationNoCheck((AbstractApplication)enume.nextElement());
                }
                Log.assertion(this.applications.size() == 0, "Applications size > 0");
                boolean isApplet = this.getFirstInitialApplication().getApplet() != null;
                enume = ((Vector)this.initialApplications.clone()).elements();
                while (enume.hasMoreElements()) {
                    this.stopApplicationNoCheck((AbstractApplication)enume.nextElement());
                }
                if (this.securityHandler != null) {
                    this.securityHandler.dispose();
                }
                Log.flush();
                Log.logNotify("ApplicationManager stopped");
                if (!isApplet) {
                    this.launcher.onExit(this.launchableApplication);
                }
            }
        } else {
            Log.logWarning("### ApplicationManager already stopped");
        }
    }

    public void exitApplicationEMTApp() {
        if (EmasSystemProperties.getProperty("application launched", "false").equalsIgnoreCase("true")) {
            this.launchableApplication.exit();
        }
    }

    public synchronized void stopApplicationManagerHard() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.stopApplicationManagerHardImpl();
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    ApplicationManager.this.stopApplicationManagerHardImpl();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void stopApplicationManagerHardImpl() {
        Log.logNotify("ApplicationManager: Stopping hard");
        Enumeration enume = ((Vector)this.applications.clone()).elements();
        while (enume.hasMoreElements()) {
            AbstractApplication application = (AbstractApplication)enume.nextElement();
            Log.logWarning("Stopping application hard:" + application);
            this.disposeApplication(application, true);
        }
        if (this.initialApplications.size() > 0) {
            Log.logWarning("Stopping initial applications hard: " + this.initialApplications.firstElement());
            enume = ((Vector)this.initialApplications.clone()).elements();
            while (enume.hasMoreElements()) {
                this.disposeApplication((AbstractApplication)enume.nextElement(), false);
            }
        }
        if (this.securityHandler != null) {
            this.securityHandler.dispose();
        }
        Log.logNotify("ApplicationManager stopped");
    }

    private boolean canStopAllApplications() {
        StringBuffer appNames = new StringBuffer();
        Enumeration enume = this.getAllApplications();
        int count = 0;
        while (enume.hasMoreElements()) {
            appNames.append("  - ");
            appNames.append(((AbstractApplication)enume.nextElement()).getTitle());
            appNames.append("\n");
            ++count;
        }
        Hashtable extApps = this.getFirstInitialApplication().getApplicationPresenter().getController().getExternalApplications();
        if (extApps != null) {
            Enumeration extEnum = extApps.keys();
            while (extEnum.hasMoreElements()) {
                appNames.append("  - ");
                appNames.append((String)extEnum.nextElement());
                appNames.append("\n");
                ++count;
            }
        }
        Object[] appArray = new Object[]{appNames.toString()};
        if (count > 0) {
            int canStop = this.getFirstInitialApplication().getApplicationPresenter().getController().showConfirmDialog("GSL_STOP_ALL_APP_MSG", appArray, "GSL_STOP_ALL_APP_TITLE", null, 0, 2, null);
            return canStop == 0;
        }
        return true;
    }

    private boolean canStop(AbstractApplication application) {
        boolean canStop = true;
        try {
            if (!application.getApplicationPresenter().canStop()) {
                canStop = false;
            }
        }
        catch (Throwable t) {
            Log.logError("Exception in canStop for application: " + application, t);
        }
        return canStop;
    }

    void updateLookAndFeel() {
        Enumeration enume = this.getAllApplications();
        while (enume.hasMoreElements()) {
            ((AbstractApplication)enume.nextElement()).getApplicationPresenter().updateLookAndFeel();
        }
    }

    int getPresentation() {
        return this.presentation;
    }

    void setPresentation(int presentation) {
        Log.logNotify("ApplicationManager: setPresentation: " + presentation);
        Enumeration hideEnum = this.getAllApplications();
        while (hideEnum.hasMoreElements()) {
            this.hideApplication((AbstractApplication)hideEnum.nextElement());
        }
        this.presentation = presentation;
        Enumeration updateEnum = this.getAllApplications();
        while (updateEnum.hasMoreElements()) {
            this.updatePresentation((AbstractApplication)updateEnum.nextElement());
        }
        this.cascadeWindows();
    }

    void hideApplication(AbstractApplication application) {
        application.getApplicationPresenter().setVisible(false);
    }

    void updatePresentation(AbstractApplication application) {
        ApplicationPresenter presenter = application.getApplicationPresenter();
        presenter.replaceViewContainer();
        presenter.setVisible(true);
    }

    void cascadeWindows() {
        ViewContainer viewContainer;
        int x = 0;
        int y = 0;
        Enumeration enume = this.getInitialApplications();
        while (enume.hasMoreElements()) {
            viewContainer = ((AbstractApplication)enume.nextElement()).getApplicationPresenter().getViewContainer();
            viewContainer.setLocation(x += 30, y += 30);
            viewContainer.bringToFront();
        }
        enume = this.getApplications();
        while (enume.hasMoreElements()) {
            viewContainer = ((AbstractApplication)enume.nextElement()).getApplicationPresenter().getViewContainer();
            viewContainer.setLocation(x += 30, y += 30);
            viewContainer.bringToFront();
        }
    }

    CorbaNameResolver getCorbaNameResolver() {
        if (this.corbaNameResolver == null) {
            ORB orb = null;
            System.setProperty("org.omg.CORBA.ORBClass", this.getEnvironment().getProperty("org.omg.CORBA.ORBClass"));
            System.setProperty("org.omg.CORBA.ORBSingletonClass", this.getEnvironment().getProperty("org.omg.CORBA.ORBSingletonClass"));
            if (this.securityHandler != null) {
                orb = this.securityHandler.getOrb();
            }
            this.corbaNameResolver = new CorbaNameResolver(this.getFirstInitialApplication().getApplet(), this.getFirstInitialApplication().getEnvironment(), orb);
        }
        return this.corbaNameResolver;
    }

    Hashtable getObjectNamingService() {
        if (this.objectNamingService == null) {
            this.objectNamingService = new Hashtable();
        }
        return this.objectNamingService;
    }

    static void loadBundle(String bundleName, Locale locale, Properties env) {
        Log.logNotify("loadBundle: " + bundleName + " " + locale);
        Log.assertion(!bundleName.equals(""), "Not allowed to specify empty string as bundle name");
        Log.measure("loadBundle", true, "Loading bundle");
        try {
            ResourceBundle bundle = GuilibResourceBundle.getBundle(bundleName, locale, myClassLoader);
            Enumeration<String> enume = bundle.getKeys();
            while (enume.hasMoreElements()) {
                String key = enume.nextElement();
                env.put(key, bundle.getObject(key));
            }
        }
        catch (Throwable t) {
            String msg = "Could not create ResourceBundle: " + bundleName;
            Log.logNotify(msg);
            Log.assertion(false, msg);
        }
        Log.measure("loadBundle", false);
    }

    public void launchEmtTool(final String configFilePath, Properties props) {
        Log.logNotify("lauchEmtTool, beginning.");
        props.putAll((Map<?, ?>)ApplicationManager.fetchSupersedingProps());
        final Properties properties = props;
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    Log.logNotify("lauchEmtTool, before launcher.runApplication");
                    ApplicationManager.this.launcher.runApplication(configFilePath, host, properties, null);
                    Log.logNotify("lauchEmtTool, after launcher.runApplication");
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "A tool was not possible to start. Error info: " + e.getMessage(), "Launch ERROR", 0);
                }
            }
        };
        Thread t = new Thread(runnable);
        t.start();
    }

    public void sendNotification(String notificationType, Object senderObject, Object userData) {
        Log.logNotify("Send notification " + notificationType + " " + userData);
        long sequenceNumber = System.currentTimeMillis();
        ApplicationManagerEvent appManagerEvent = new ApplicationManagerEvent(notificationType, senderObject, sequenceNumber);
        appManagerEvent.setUserData(userData);
        ApplicationManagerEvent emEvent = appManagerEvent;
        if (this.launcher instanceof EmNotificationServiceInterface) {
            EmNotificationServiceInterface emNotificationServiceInterface = (EmNotificationServiceInterface)this.launcher;
            emNotificationServiceInterface.sendNotification((EmEventInterface)emEvent);
        } else {
            Log.logNotify("Notification service not available.");
        }
    }

    private void sendEmNotification(final String message, final Object source, final String type) {
        LauncherInterface launcher = EmasGuilibMediator.getReference().getLauncher();
        if (launcher != null && launcher instanceof EmNotificationServiceInterface) {
            EmNotificationServiceInterface emNotificationService = (EmNotificationServiceInterface)launcher;
            emNotificationService.sendNotification(new EmEventInterface(){
                private static final long serialVersionUID = 1L;

                public String getMessage() {
                    return message;
                }

                public long getSequenceNumber() {
                    return GuiTestEventTypes.claimSeqNum();
                }

                public Object getSource() {
                    return source;
                }

                public long getTimestamp() {
                    return System.currentTimeMillis();
                }

                public String getType() {
                    return type;
                }

                public Object getUserData() {
                    return null;
                }
            });
        } else {
            Log.trace("Unable to send EM notification");
        }
    }

    static {
        PRESENTATION_TYPE_KEYS = new String[]{"GSL_DESKTOP", "GSL_MDI", "GSL_SDI", "GSL_TABBED"};
        PRESENTATION_TYPE_VALUES = new int[]{2, 1, 0, 3};
    }

    private static class Configer {
        private final String KEY_DELIMITER = ";";

        private Configer() {
        }

        public Properties getSupersedingProperties() {
            Properties tempProp = new Properties();
            Properties prevProps = null;
            if (EmasSystemProperties.isInitialized()) {
                prevProps = EmasSystemProperties.getProperties();
            }
            if (prevProps == null) {
                return tempProp;
            }
            String strSupersedingList = prevProps.getProperty(ApplicationManager.SUPERSEDING_PARAMETER_LIST);
            if (strSupersedingList != null) {
                tempProp.put(ApplicationManager.SUPERSEDING_PARAMETER_LIST, strSupersedingList);
                String[] supersedingListArray = strSupersedingList.split(";");
                for (int i = 0; i < supersedingListArray.length; ++i) {
                    String supersedingName = supersedingListArray[i];
                    String supersedingValue = prevProps.getProperty(supersedingName);
                    if (null == supersedingValue) continue;
                    tempProp.put(supersedingName, supersedingValue);
                }
            }
            return tempProp;
        }
    }

    private class ApplicationManagerEvent
    extends EventObject
    implements EmEventInterface {
        private static final long serialVersionUID = 2953120702774016835L;
        private String myType;
        private long mySequenceNumber;
        private long myTimestamp;
        private String myMessage;
        private Object myUserData;

        public ApplicationManagerEvent(Object source) {
            super(source);
            this.myType = "";
            this.mySequenceNumber = 0L;
            this.myTimestamp = System.currentTimeMillis();
            this.myMessage = "EM Notification";
            this.myUserData = "";
        }

        public ApplicationManagerEvent(String type, Object source, long sequenceNumber) {
            super(source);
            this.myType = "";
            this.mySequenceNumber = 0L;
            this.myTimestamp = System.currentTimeMillis();
            this.myMessage = "EM Notification";
            this.myUserData = "";
            this.myType = type;
            this.mySequenceNumber = sequenceNumber;
        }

        public String getMessage() {
            return this.myMessage;
        }

        public long getSequenceNumber() {
            return this.mySequenceNumber;
        }

        public long getTimestamp() {
            return this.myTimestamp;
        }

        public String getType() {
            return this.myType;
        }

        public Object getUserData() {
            return this.myUserData;
        }

        public void setUserData(Object o) {
            this.myUserData = o;
        }
    }
}

