/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.awt.Component;
import java.awt.Container;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractComponent;
import se.ericsson.cello.support.gui.guilib.infra.AbstractHandler;
import se.ericsson.cello.support.gui.guilib.infra.AbstractPresenter;
import se.ericsson.cello.support.gui.guilib.infra.AbstractView;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationMenuBar;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationPresenter;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationToolBar;
import se.ericsson.cello.support.gui.guilib.infra.WizardSlidePresenter;

class ComponentSniffer {
    private AbstractPresenter presenter;
    private JPopupMenu popupMenu;
    private Vector componentHandlers = new Vector();

    ComponentSniffer(AbstractPresenter presenter) {
        this.presenter = presenter;
    }

    ComponentSniffer(JPopupMenu aPopupMenu) {
        this.popupMenu = aPopupMenu;
    }

    void addComponentHandler(AbstractHandler handler) {
        for (int i = 0; i < this.componentHandlers.size(); ++i) {
            if (handler != this.componentHandlers.elementAt(i)) continue;
            return;
        }
        this.componentHandlers.addElement(handler);
    }

    protected void dispose() {
        for (int i = 0; i < this.componentHandlers.size(); ++i) {
            ((AbstractHandler)this.componentHandlers.elementAt(i)).dispose();
        }
        this.componentHandlers.clear();
    }

    private void iterate(Component component, AbstractHandler[] handlers) {
        AbstractHandler[] newHandlers = new AbstractHandler[handlers.length];
        for (int i = 0; i < handlers.length; ++i) {
            AbstractHandler handler = handlers[i];
            if (handler == null) continue;
            if (component instanceof AbstractComponent) {
                ((AbstractComponent)component).init();
                return;
            }
            if (component instanceof JComponent) {
                if (!handler.handleComponent((JComponent)component)) continue;
                newHandlers[i] = handler;
                continue;
            }
            newHandlers[i] = handler;
        }
        if (component instanceof Container && newHandlers.length > 0) {
            Component[] components = null;
            components = component instanceof JMenu ? ((JMenu)component).getMenuComponents() : ((Container)component).getComponents();
            for (int i = 0; i < components.length; ++i) {
                this.iterate(components[i], newHandlers);
            }
        }
    }

    private void iteratePopup(JPopupMenu popup, AbstractHandler[] handlers) {
        MenuElement[] menuElement = popup.getSubElements();
        for (int j = 0; j < menuElement.length; ++j) {
            if (menuElement[j] instanceof JMenu) {
                this.iterate((JMenu)menuElement[j], handlers);
                continue;
            }
            if (menuElement[j] instanceof JComponent) {
                for (int i = 0; i < handlers.length; ++i) {
                    AbstractHandler handler = handlers[i];
                    if (handler == null) continue;
                    handler.handleComponent((JComponent)((Object)menuElement[j]));
                }
                continue;
            }
            Log.logWarning("Unknown component in iteratePopup");
        }
    }

    void removeComponentHandler(AbstractHandler handler) {
        for (int i = 0; i < this.componentHandlers.size(); ++i) {
            if (handler != this.componentHandlers.elementAt(i)) continue;
            this.componentHandlers.remove(i);
            return;
        }
    }

    void sniff() {
        Log.measure("sniff", true, "ComponentSniffer.sniff");
        Object[] newHandlers = new AbstractHandler[this.componentHandlers.size()];
        this.componentHandlers.copyInto(newHandlers);
        if (this.popupMenu != null) {
            this.iteratePopup(this.popupMenu, (AbstractHandler[])newHandlers);
        } else {
            AbstractView view = this.presenter.getView();
            this.iterate(view, (AbstractHandler[])newHandlers);
            if (this.presenter instanceof ApplicationPresenter) {
                ApplicationToolBar toolbar;
                ApplicationPresenter applicationPresenter = (ApplicationPresenter)this.presenter;
                ApplicationMenuBar menubar = applicationPresenter.getApplicationMenuBar();
                if (menubar != null) {
                    this.iterate(menubar, (AbstractHandler[])newHandlers);
                }
                if ((toolbar = applicationPresenter.getApplicationToolBar()) != null) {
                    this.iterate(toolbar, (AbstractHandler[])newHandlers);
                }
            } else if (this.presenter instanceof WizardSlidePresenter) {
                WizardSlidePresenter wizardSlidePresenter = (WizardSlidePresenter)this.presenter;
                this.iterate(wizardSlidePresenter.getWizardDefaultView(), (AbstractHandler[])newHandlers);
            }
        }
        Log.measure("sniff", false);
    }

    void sniff(Component comp) {
        Object[] newHandlers = new AbstractHandler[this.componentHandlers.size()];
        this.componentHandlers.copyInto(newHandlers);
        this.iterate(comp, (AbstractHandler[])newHandlers);
    }

    void updateLocale(Locale locale) {
        for (int i = 0; i < this.componentHandlers.size(); ++i) {
            ((AbstractHandler)this.componentHandlers.elementAt(i)).updateLocale(locale);
        }
    }
}

