/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.logging;

import java.io.Serializable;
import java.util.ArrayList;

public class Level
implements Serializable {
    private static ArrayList known = new ArrayList();
    private final String name;
    private final int value;
    public static final Level OFF = new Level("OFF", Integer.MAX_VALUE);
    public static final Level SEVERE = new Level("SEVERE", 1000);
    public static final Level WARNING = new Level("WARNING", 900);
    public static final Level INFO = new Level("INFO", 800);
    public static final Level CONFIG = new Level("CONFIG", 700);
    public static final Level FINE = new Level("FINE", 500);
    public static final Level FINER = new Level("FINER", 400);
    public static final Level FINEST = new Level("FINEST", 300);
    public static final Level ALL = new Level("ALL", Integer.MIN_VALUE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Level(String name, int value) {
        this.name = name;
        this.value = value;
        Class<Level> clazz = Level.class;
        synchronized (Level.class) {
            known.add(this);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public final String toString() {
        return this.name;
    }

    public final int intValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readResolve() {
        Class<Level> clazz = Level.class;
        synchronized (Level.class) {
            for (int i = 0; i < known.size(); ++i) {
                Level other = (Level)known.get(i);
                if (!this.name.equals(other.name) || this.value != other.value) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return other;
            }
            known.add(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this;
        }
    }

    public static synchronized Level parse(String name) throws IllegalArgumentException {
        name.length();
        for (int i = 0; i < known.size(); ++i) {
            Level l = (Level)known.get(i);
            if (!name.equals(l.name)) continue;
            return l;
        }
        try {
            int x = Integer.parseInt(name);
            for (int i = 0; i < known.size(); ++i) {
                Level l = (Level)known.get(i);
                if (l.value != x) continue;
                return l;
            }
            return new Level(name, x);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Bad level \"" + name + "\"");
        }
    }

    public boolean equals(Object ox) {
        try {
            Level lx = (Level)ox;
            return lx.value == this.value;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public int hashCode() {
        return this.value;
    }
}

