/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.proxy;

import java.util.ArrayList;
import java.util.List;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyComm.SequencePushConsumer;
import org.omg.CosNotifyComm.SequencePushConsumerHelper;
import org.omg.CosNotifyComm.SequencePushConsumerOperations;
import org.omg.CosNotifyComm.SequencePushConsumerPOATie;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.threegppsa5.AlarmIRPSystem.GetAlarmIRPVersion;
import org.threegppsa5.AlarmIRPSystem._AlarmIRPOperations;
import org.threegppsa5.AlarmIRPSystem._AlarmIRPOperationsHelper;
import org.threegppsa5.NotificationIRPSystem.GetNotificationIRPVersion;
import org.threegppsa5.NotificationIRPSystem._NotificationIRPOperations;
import org.threegppsa5.NotificationIRPSystem._NotificationIRPOperationsHelper;
import se.ericsson.cello.support.gui.EmasFramework;
import se.ericsson.cello.support.gui.EmasGuilibMediator;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractController;
import se.ericsson.cello.support.proxy.AlarmCorbaInterface;
import se.ericsson.cello.support.proxy.AlarmNotificationCorbaInterface;
import se.ericsson.cello.support.proxy.UnsupportedIRPVersionException;
import se.ericsson.cello.support.proxy.action.GetAlarmListCorbaCall;
import se.ericsson.cello.support.proxy.action.GetSubscriptionStatusCorbaCall;
import se.ericsson.cello.support.proxy.action.SetAckStatusCorbaCall;
import se.ericsson.cello.support.proxy.action.SubscribeCorbaCall;
import se.ericsson.cello.support.proxy.action.UnAcknowledgeAlarmsCorbaCall;
import se.ericsson.cello.support.proxy.action.UnsubscribeCorbaCall;

public class AlarmServiceFacade
implements SequencePushConsumerOperations {
    private static AlarmServiceFacade myServer = null;
    private GetAlarmListCorbaCall getalarmlistcall = null;
    private _AlarmIRPOperations irpAlarmRef = null;
    private _NotificationIRPOperations irpNotificationRef = null;
    private POA rootPOA = null;
    private SequencePushConsumer actorReference = null;
    private SequencePushConsumerPOATie pconsumer = null;
    private AbstractController myController = null;
    private List myNotificationReceivers = new ArrayList();

    private AlarmServiceFacade(AbstractController controller) {
        this.myController = controller;
        this.initNotificationServer();
    }

    public static AlarmServiceFacade getAlarmServiceFacadeInstance(AbstractController controller) {
        AbstractController tmpController = controller;
        if (tmpController == null) {
            tmpController = EmasGuilibMediator.getReference().getMainWindowReference();
        }
        if (myServer == null) {
            myServer = new AlarmServiceFacade(controller);
        } else {
            myServer.initNotificationServer();
            myServer.setAbstractController(tmpController);
        }
        return myServer;
    }

    private void setAbstractController(AbstractController controller) {
        this.myController = controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeNotification(AlarmNotificationCorbaInterface notificationReceiver) {
        List list = this.myNotificationReceivers;
        synchronized (list) {
            this.myNotificationReceivers.add(notificationReceiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unSubscribeNotification(AlarmNotificationCorbaInterface notificationReceiver) {
        List list = this.myNotificationReceivers;
        synchronized (list) {
            this.myNotificationReceivers.remove(notificationReceiver);
        }
        this.irpNotificationRef = null;
        this.irpAlarmRef = null;
    }

    public void initNotificationServer() {
        try {
            ORB orb = EmasFramework.getORB();
            this.rootPOA = EmasFramework.getRootPOA();
            this.pconsumer = new SequencePushConsumerPOATie(this);
            this.rootPOA.activate_object((Servant)this.pconsumer);
            this.rootPOA.the_POAManager().activate();
            this.actorReference = SequencePushConsumerHelper.narrow(this.rootPOA.servant_to_reference((Servant)this.pconsumer));
        }
        catch (Exception e1) {
            Log.logError(null, e1);
        }
    }

    private _AlarmIRPOperations getAlarmIRPOperationsRef() throws UnsupportedIRPVersionException {
        if (this.irpAlarmRef != null) {
            return this.irpAlarmRef;
        }
        try {
            Object nsholder = null;
            nsholder = this.myController.resolveService("ALARM_IRP_VERSION_1_1");
            this.irpAlarmRef = _AlarmIRPOperationsHelper.narrow(nsholder);
            try {
                String[] versions = this.irpAlarmRef.get_alarm_IRP_version();
                boolean versionFound = false;
                for (int i = 0; i < versions.length; ++i) {
                    if (!versions[i].equals("1f1")) continue;
                    versionFound = true;
                }
                if (!versionFound) {
                    throw new UnsupportedIRPVersionException("1f1");
                }
            }
            catch (GetAlarmIRPVersion versEx) {
                Log.logError("GetAlarmIRPVersion", (Throwable)((java.lang.Object)versEx));
            }
        }
        catch (UnsupportedIRPVersionException versEx) {
            throw versEx;
        }
        catch (Throwable e) {
            Log.logError("get_alarm_IRP_version", e);
        }
        return this.irpAlarmRef;
    }

    private _NotificationIRPOperations getNotificationIRPRef() throws UnsupportedIRPVersionException {
        if (this.irpNotificationRef != null) {
            return this.irpNotificationRef;
        }
        try {
            Object nsholder = null;
            nsholder = this.myController.resolveService("NOTIFICATION_IRP_VERSION_1_1");
            this.irpNotificationRef = _NotificationIRPOperationsHelper.narrow(nsholder);
            try {
                String[] versions = this.irpNotificationRef.get_notification_IRP_version();
                boolean versionFound = false;
                for (int i = 0; i < versions.length; ++i) {
                    if (!versions[i].equals("1n1")) continue;
                    versionFound = true;
                }
                if (!versionFound) {
                    throw new UnsupportedIRPVersionException("1n1");
                }
            }
            catch (GetNotificationIRPVersion versEx) {
                Log.logError("GetNotificationIRPVersion", (Throwable)((java.lang.Object)versEx));
            }
        }
        catch (UnsupportedIRPVersionException versEx) {
            throw versEx;
        }
        catch (Throwable e) {
            Log.logError("get_alarm_IRP_version", e);
        }
        return this.irpNotificationRef;
    }

    public void subscribeToAlarms(AlarmCorbaInterface corbaInterface) throws UnsupportedIRPVersionException {
        String[] alarmCategories = new String[]{"1f1"};
        corbaInterface.setStatus(1);
        _NotificationIRPOperations notificationRef = this.getNotificationIRPRef();
        StringHolder subscriptionID = new StringHolder("");
        int timeTick = Integer.parseInt(corbaInterface.getProperty("NS_TIME_TICK"));
        SubscribeCorbaCall subscribecall = new SubscribeCorbaCall(notificationRef, this.actorReference, corbaInterface, alarmCategories, timeTick);
        this.myController.invokeRequest(subscribecall);
    }

    public void doUnSubscribe(String subid) {
        try {
            String mysubscriptionid = subid;
            _NotificationIRPOperations irpRef = this.getNotificationIRPRef();
            UnsubscribeCorbaCall unsubscribecall = new UnsubscribeCorbaCall(irpRef, mysubscriptionid, this.actorReference);
            this.myController.invokeRequest(unsubscribecall);
        }
        catch (Throwable e) {
            Log.logError(null, e);
        }
    }

    public void cancelSyncAlarmList() {
        if (this.getalarmlistcall != null) {
            this.getalarmlistcall.cancel();
        }
    }

    public void syncAlarmList(AlarmCorbaInterface corbaInterface) throws UnsupportedIRPVersionException {
        corbaInterface.setStatus(2);
        _AlarmIRPOperations irpRef = this.getAlarmIRPOperationsRef();
        StructuredEvent[] alarmList = null;
        int howMany = Integer.parseInt(corbaInterface.getProperty("HOW_MANY"));
        int maxAlarms = Integer.parseInt(corbaInterface.getProperty("MAX_ALARMS"));
        this.getalarmlistcall = new GetAlarmListCorbaCall(irpRef, corbaInterface, alarmList, maxAlarms, howMany);
        this.myController.invokeRequest(this.getalarmlistcall);
    }

    public void setAckStatus(AlarmCorbaInterface corbaInterface, String[] alarmIdList, String ackStatus, String userId) {
        try {
            corbaInterface.setStatus(3);
            _AlarmIRPOperations irpRef = this.getAlarmIRPOperationsRef();
            SetAckStatusCorbaCall setackstatuscall = new SetAckStatusCorbaCall(corbaInterface, irpRef, alarmIdList, userId);
            this.myController.invokeRequest(setackstatuscall);
        }
        catch (Throwable e) {
            Log.logError(null, e);
        }
    }

    public void unacknowledge(AlarmCorbaInterface corbaInterface, String[] alarmIdList, String ackStatus, String userId) {
        try {
            corbaInterface.setStatus(4);
            _AlarmIRPOperations irpRef = this.getAlarmIRPOperationsRef();
            UnAcknowledgeAlarmsCorbaCall unacknowledgecall = new UnAcknowledgeAlarmsCorbaCall(corbaInterface, irpRef, alarmIdList, userId);
            this.myController.invokeRequest(unacknowledgecall);
        }
        catch (Throwable e) {
            Log.logError(null, e);
        }
    }

    public void getSubscriptionStatus(AlarmCorbaInterface corbaInterface, String subid) {
        String mysubscriptionid = subid;
        try {
            _NotificationIRPOperations irpRefa = this.getNotificationIRPRef();
            GetSubscriptionStatusCorbaCall getSubStatuscall = new GetSubscriptionStatusCorbaCall(corbaInterface, irpRefa, mysubscriptionid);
            this.myController.invokeRequest(getSubStatuscall);
        }
        catch (Exception e) {
            Log.logError(null, e);
        }
    }

    protected void finalize() {
        try {
            byte[] id = this.rootPOA.servant_to_id((Servant)this.pconsumer);
            this.rootPOA.deactivate_object(id);
        }
        catch (Exception e) {
            Log.logError(null, e);
        }
    }

    public void cleanup() {
        try {
            byte[] id = this.rootPOA.servant_to_id((Servant)this.pconsumer);
            this.rootPOA.deactivate_object(id);
        }
        catch (Exception e) {
            Log.logError(null, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push_structured_events(StructuredEvent[] structuredEvents) {
        List list = this.myNotificationReceivers;
        synchronized (list) {
            for (AlarmNotificationCorbaInterface receiver : this.myNotificationReceivers) {
                receiver.pushNotification(structuredEvents);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect_sequence_push_consumer() {
        List list = this.myNotificationReceivers;
        synchronized (list) {
            for (AlarmNotificationCorbaInterface receiver : this.myNotificationReceivers) {
                receiver.disconnectNotification();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offer_change(EventType[] added, EventType[] removed) {
        List list = this.myNotificationReceivers;
        synchronized (list) {
            for (AlarmNotificationCorbaInterface receiver : this.myNotificationReceivers) {
                receiver.offerChangeNotification(added, removed);
            }
        }
    }
}

