/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.proxy.action;

import org.omg.CORBA.UserException;
import org.threegppsa5.AlarmIRPConstDefs.AlarmInformationIdSeqHolder;
import org.threegppsa5.AlarmIRPSystem.AcknowledgeAlarms;
import org.threegppsa5.AlarmIRPSystem.InvalidParameter;
import org.threegppsa5.AlarmIRPSystem.ParameterNotSupported;
import org.threegppsa5.AlarmIRPSystem._AlarmIRPOperations;
import org.threegppsa5.CommonIRPConstDefs.Signal;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractCorbaRequest;
import se.ericsson.cello.support.proxy.AlarmCorbaInterface;

public class SetAckStatusCorbaCall
extends AbstractCorbaRequest {
    private _AlarmIRPOperations irpRef;
    private Signal result = null;
    private String[] setackidlist = null;
    private String setackuserid = null;
    private AlarmCorbaInterface myCorbaInterface = null;

    public SetAckStatusCorbaCall(AlarmCorbaInterface corbaInterface, _AlarmIRPOperations irpRef, String[] idlist, String userId) {
        this.irpRef = irpRef;
        this.setackidlist = idlist;
        this.setackuserid = userId;
        this.myCorbaInterface = corbaInterface;
    }

    protected void invoke() throws UserException {
        String in_ids = "";
        String comma = "";
        for (int i = 0; i < this.setackidlist.length; ++i) {
            in_ids = in_ids + comma + this.setackidlist[i];
            comma = ",";
        }
        Log.log(6, "Acknowledg the follwing alarms:\n" + in_ids);
        AlarmInformationIdSeqHolder unackedAlarms = new AlarmInformationIdSeqHolder();
        unackedAlarms.value = null;
        this.result = this.irpRef.acknowledge_alarms(this.setackidlist, this.setackuserid, "", unackedAlarms);
    }

    protected void handleSuccesful() {
        this.myCorbaInterface.setStatus(0);
        if (this.result.equals(Signal.Failure)) {
            this.myCorbaInterface.showErrorDialog(16);
        }
        if (this.result.equals(Signal.PartialFailure)) {
            this.myCorbaInterface.showErrorDialog(17);
        }
    }

    protected boolean handleUserException(UserException ue) {
        this.myCorbaInterface.setStatus(0);
        if (ue instanceof AcknowledgeAlarms) {
            Log.logError("Acknowledge Alarms by user: " + this.setackuserid, ue);
            this.myCorbaInterface.showErrorDialog(16);
        } else if (ue instanceof ParameterNotSupported) {
            Log.logError("Acknowledge Alarms by user: " + this.setackuserid, ue);
            this.myCorbaInterface.showErrorDialog(18);
        } else if (ue instanceof InvalidParameter) {
            Log.logError("Acknowledge Alarms by user: " + this.setackuserid, ue);
            this.myCorbaInterface.showErrorDialog(19);
        } else {
            Log.logError("Acknowledge Alarms by user: " + this.setackuserid, ue);
            this.myCorbaInterface.showErrorDialog(14);
        }
        return false;
    }
}

