/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.proxy.action;

import org.omg.CORBA.UserException;
import org.omg.CosNotifyComm.SequencePushConsumer;
import org.threegppsa5.AlarmIRPSystem.InvalidParameter;
import org.threegppsa5.AlarmIRPSystem.ParameterNotSupported;
import org.threegppsa5.NotificationIRPSystem.AlreadySubscribed;
import org.threegppsa5.NotificationIRPSystem.AtLeastOneNotificationCategoryNotSupported;
import org.threegppsa5.NotificationIRPSystem.Attach;
import org.threegppsa5.NotificationIRPSystem._NotificationIRPOperations;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractCorbaRequest;
import se.ericsson.cello.support.proxy.AlarmCorbaInterface;

public class SubscribeCorbaCall
extends AbstractCorbaRequest {
    private _NotificationIRPOperations irpRef = null;
    private SequencePushConsumer actorreference;
    private String[] alarmcategories;
    private AlarmCorbaInterface myCorbaInterface = null;
    private String subscriptionid;
    private int timeTick;

    public SubscribeCorbaCall(_NotificationIRPOperations irpNotificationRef, SequencePushConsumer actorReference, AlarmCorbaInterface corbaInterface, String[] alarmCategories, int timeTick) {
        this.irpRef = irpNotificationRef;
        this.actorreference = actorReference;
        this.alarmcategories = alarmCategories;
        this.timeTick = timeTick;
        this.myCorbaInterface = corbaInterface;
    }

    protected void invoke() throws UserException {
        String cats = "";
        if (this.alarmcategories.length == 0) {
            cats = "<none>";
        } else {
            cats = this.alarmcategories[0];
            for (int i = 1; i < this.alarmcategories.length; ++i) {
                cats = cats + ", " + this.alarmcategories[i];
            }
        }
        Log.log(6, "SubscribeCorbaCall::attach_push\nalarm categories = " + cats);
        this.subscriptionid = this.irpRef.attach_push(this.actorreference, this.timeTick, this.alarmcategories, "");
    }

    protected void handleSuccesful() {
        this.myCorbaInterface.setSubscriptionID(this.subscriptionid);
        this.myCorbaInterface.setSubscriptionOK(true);
        this.myCorbaInterface.setStatus(2);
        this.myCorbaInterface.syncAlarmList();
    }

    protected boolean handleUserException(UserException ue) {
        this.myCorbaInterface.setStatus(0);
        this.myCorbaInterface.setRetrievingFinished(true);
        if (ue instanceof Attach) {
            this.myCorbaInterface.showErrorDialog(20);
            Log.logError("SubscribeCorbaCall failed", ue);
        } else if (ue instanceof ParameterNotSupported) {
            this.myCorbaInterface.showErrorDialog(21);
            Log.logError("SubscribeCorbaCall failed", ue);
        } else if (ue instanceof InvalidParameter) {
            this.myCorbaInterface.showErrorDialog(22);
            Log.logError("SubscribeCorbaCall failed", ue);
        } else if (ue instanceof AlreadySubscribed) {
            this.myCorbaInterface.setSubscriptionOK(true);
            this.myCorbaInterface.setStatus(2);
            this.myCorbaInterface.syncAlarmList();
            Log.logError("SubscribeCorbaCall failed", ue);
        } else if (ue instanceof AtLeastOneNotificationCategoryNotSupported) {
            this.myCorbaInterface.showErrorDialog(23);
            Log.logError("SubscribeCorbaCall failed", ue);
        } else {
            Log.logError("SubscribeCorbaCall failed", ue);
            this.myCorbaInterface.showErrorDialog(14);
        }
        return false;
    }
}

