/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.script;

import BasicConfig.MORef;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import org.omg.CORBA.UserException;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.CSFacade;
import se.ericsson.cello.support.proxy.MOName;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;
import se.ericsson.cello.support.proxy.Struct;
import se.ericsson.cello.support.proxy.Transaction;
import se.ericsson.cello.support.script.Configurator;
import se.ericsson.cello.support.script.ConfiguratorInterface;
import se.ericsson.cello.support.script.FileParser;
import se.ericsson.cello.support.script.NonExistingLdnException;
import se.ericsson.cello.support.script.ParseException;
import se.ericsson.cello.support.script.SubConfigurationFailedException;
import se.ericsson.cello.support.script.URLNotFoundException;

class ConfigEngine {
    private Transaction session = null;
    private Integer transactionTimeoutValue = null;
    private Configurator configurator;
    private ConfiguratorInterface user;
    private String configFile;
    private Vector configFileLifo = new Vector();
    private boolean isLocal;
    private NameValue[] configParameters;
    private String currentFile;
    private String currentCommand;
    private boolean verboseDeveloperProgress = false;
    private static final boolean TRANSACTION_COMMIT = true;
    private static final boolean TRANSACTION_ROLLBACK = false;
    private static final int TRANSACTION_ENABLE = 0;
    private static final int TRANSACTION_DISABLE = 1;
    private static final int TRANSACTION_BEGIN = 2;
    private static final int TRANSACTION_END = 3;
    private int transactionCounter = 0;
    private int lastTransactionState = 0;
    private boolean eachCommandATransaction = true;
    private boolean transactionActive = false;
    private boolean rollbackTransaction = false;
    private boolean haltMode;
    private boolean somethingWentWrong = false;
    private int numberOfCSExceptions = 0;

    protected ConfigEngine(ConfiguratorInterface _user, String _configFile, NameValue[] _configParameters, boolean _verboseDeveloperProgress, int _progressInterval, boolean _testMode, Configurator _configurator) {
        this.user = _user;
        this.configFile = _configFile != null ? _configFile : "?";
        this.configFileLifo.add(this.configFile);
        this.configParameters = _configParameters;
        this.verboseDeveloperProgress = _verboseDeveloperProgress;
        this.haltMode = _testMode;
        this.configurator = _configurator;
        this.isLocal = true;
    }

    protected ConfigEngine(ConfiguratorInterface _user, URL _configFile, NameValue[] _configParameters, boolean _verboseDeveloperProgress, int _progressInterval, boolean _testMode, Configurator _configurator) {
        this.user = _user;
        this.configFile = _configFile != null ? _configFile.toString() : "?";
        this.configFileLifo.add(this.configFile);
        this.configParameters = _configParameters;
        this.verboseDeveloperProgress = _verboseDeveloperProgress;
        this.haltMode = _testMode;
        this.configurator = _configurator;
        this.isLocal = false;
    }

    private void performCommand(FileParser in) throws CSException, IOException, ParseException, NonExistingLdnException {
        if (in.sval.equals("CREATE")) {
            this.executeCreate(in);
        } else if (in.sval.equals("ACTION")) {
            this.executeAction(in);
        } else if (in.sval.equals("DELETE")) {
            this.executeDelete(in);
        } else if (in.sval.equals("CHECK")) {
            this.executeCheck(in);
        } else if (in.sval.equals("SET")) {
            this.executeSet(in);
        } else if (in.sval.equals("ECHO")) {
            this.executeEcho(in);
        } else if (in.sval.equals("TRANSACTION")) {
            this.executeTransaction(in);
        } else if (in.sval.equals("CALL")) {
            this.executeCall(in);
        } else if (in.sval.equals("REFRESH")) {
            this.executeRefresh(in);
        } else if (in.sval.equals("TRACE")) {
            this.executeTrace(in);
        } else {
            this.currentCommand = in.sval;
            throw new ParseException("<A valid command>", in.sval);
        }
    }

    protected void execute() {
        this.execute(this.configFile, true);
    }

    private void execute(String _currentFile, boolean isMainConfigFile) {
        FileParser in = null;
        this.currentFile = _currentFile;
        String currFile = _currentFile;
        this.currentCommand = "";
        try {
            Reader myConfigFile = this.isLocal ? this.getConfigFileFromLocalMachine(currFile) : this.getConfigFileFromNode(currFile);
            this.startSession();
            in = new FileParser(myConfigFile);
            in.slashSlashComments(true);
            in.slashStarComments(true);
            in.quoteChar(34);
            in.ordinaryChar(36);
            in.nextToken();
            while (in.ttype != -1 && this.configurator.getProceedConfigFile() && !this.rollbackTransaction) {
                this.somethingWentWrong = false;
                if (this.haltMode) {
                    try {
                        this.performCommand(in);
                    }
                    catch (Exception cse) {
                        this.user.logDeveloperProgress("Exception execute:" + cse);
                        this.somethingWentWrong = true;
                        ++this.numberOfCSExceptions;
                    }
                } else {
                    this.performCommand(in);
                }
                in.nextToken();
            }
            if (isMainConfigFile && !this.rollbackTransaction) {
                if (!this.eachCommandATransaction) {
                    this.endTransaction(true);
                }
                if (this.configurator.getProceedConfigFile()) {
                    if (this.haltMode && this.numberOfCSExceptions > 0) {
                        this.user.configurationFailed("Configuration failed: " + this.configFile);
                        this.user.configurationFailed("Number of CSExceptions = " + this.numberOfCSExceptions);
                    } else {
                        this.user.logDeveloperProgress("Configuration succeeded: " + this.configFile);
                        this.user.configurationSucceeded(this.configFile);
                    }
                }
            } else if (this.rollbackTransaction) {
                throw new SubConfigurationFailedException();
            }
            this.configFileLifo.remove(this.configFileLifo.lastElement());
        }
        catch (FileNotFoundException e) {
            this.user.logDeveloperProgress("Configuration not found: " + currFile + "; FileNotFoundException");
            if (isMainConfigFile) {
                this.user.configurationNotFound(currFile);
            }
            this.rollbackTransaction = true;
        }
        catch (URLNotFoundException e) {
            this.user.logDeveloperProgress("Configuration not found: " + currFile + "; URLNotFoundException" + e);
            if (isMainConfigFile) {
                this.user.configurationNotFound(currFile);
            }
            this.rollbackTransaction = true;
        }
        catch (IOException e) {
            this.user.logDeveloperProgress("Configuration failed: " + currFile + ", line " + in.lineno() + "; IOException" + "; Exception occurred in " + this.currentCommand + " command");
            if (isMainConfigFile) {
                this.user.configurationFailed(currFile, in.lineno(), "IOException; Exception occurred in " + this.currentCommand + " command");
            }
            this.rollbackTransaction = true;
        }
        catch (ParseException e) {
            this.user.logDeveloperProgress("Configuration failed: " + currFile + ", line " + in.lineno() + "; " + e.toString() + "; Exception occurred in " + this.currentCommand + " command");
            if (isMainConfigFile) {
                this.user.configurationFailed(currFile, in.lineno(), e.toString() + "; Exception occurred in " + this.currentCommand + " command");
            }
            this.rollbackTransaction = true;
        }
        catch (CSException e) {
            this.user.logDeveloperProgress("Configuration failed: " + currFile + ", line " + in.lineno() + "; CSException" + "; Exception occurred in " + this.currentCommand + " command" + e.toString());
            if (isMainConfigFile) {
                this.user.configurationFailed(currFile, in.lineno(), "CSException; Exception occurred in " + this.currentCommand + " command");
            }
            this.rollbackTransaction = true;
        }
        catch (SubConfigurationFailedException e) {
            this.user.logDeveloperProgress("  at: " + currFile + ", line " + in.lineno());
            if (isMainConfigFile) {
                this.user.configurationFailed(currFile, in.lineno(), e.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.user.logDeveloperProgress("Configuration failed: " + currFile + ", line " + in.lineno() + "; " + e.toString() + "; Exception occurred in " + this.currentCommand + " command");
            if (isMainConfigFile) {
                this.user.configurationFailed(currFile, in.lineno(), e.toString() + "; Exception occurred in " + this.currentCommand + " command");
            }
            this.rollbackTransaction = true;
        }
        if (this.rollbackTransaction || !this.configurator.getProceedConfigFile()) {
            try {
                this.endTransaction(false);
            }
            catch (CSException e) {
                this.user.logDeveloperProgress("Transaction rollback failed.");
            }
            this.lastTransactionState = 0;
        }
        if (isMainConfigFile) {
            this.endSession();
        }
    }

    private MOProxy findMo(String ldn) throws CSException {
        if (ldn.equals("null")) {
            return null;
        }
        MOProxy mOProxy = new MOProxy(ldn);
        return mOProxy;
    }

    private void executeCheck(FileParser in) throws IOException, ParseException, NonExistingLdnException, CSException {
        String exception;
        String recException;
        block26: {
            this.currentCommand = "CHECK";
            recException = "none";
            in.checkBegin();
            String ldn = this.checkLdn(in.getTokenValue("mo"));
            MOProxy mo = this.findMo(ldn);
            exception = in.getTokenValue("exception");
            String objName = in.getNextString();
            Comparable<Boolean>[] objValue = null;
            if (this.eachCommandATransaction) {
                this.beginTransaction();
            }
            try {
                if (this.haltMode) {
                    try {
                        objValue = mo.getAttribute(objName, this.session.session);
                    }
                    catch (Exception cse) {
                        this.user.logDeveloperProgress("CSException getAttribute:" + cse);
                        this.somethingWentWrong = true;
                        ++this.numberOfCSExceptions;
                    }
                } else {
                    objValue = mo.getAttribute(objName, this.session.session);
                }
                if (objValue instanceof boolean[]) {
                    boolean[] boolArray = (boolean[])objValue;
                    Boolean[] booleanArray = new Boolean[boolArray.length];
                    for (int i = 0; i < boolArray.length; ++i) {
                        booleanArray[i] = Boolean.valueOf(String.valueOf(boolArray[i]));
                    }
                    objValue = booleanArray;
                    break block26;
                }
                if (objValue instanceof int[]) {
                    int[] intArray = (int[])objValue;
                    Integer[] integerArray = new Integer[intArray.length];
                    for (int i = 0; i < intArray.length; ++i) {
                        integerArray[i] = new Integer(intArray[i]);
                    }
                    objValue = integerArray;
                    break block26;
                }
                if (objValue instanceof Object[]) {
                    Object[] obj = objValue;
                    String[] expectedValue = new String[obj.length];
                    String[] retrievedValue = new String[obj.length];
                    retrievedValue = this.getSequenceObjectValue(obj);
                    if (this.verboseDeveloperProgress) {
                        this.user.logDeveloperProgress("CHECK");
                        this.user.logDeveloperProgress("  mo = " + ldn);
                        this.user.logDeveloperProgress("  " + objName + " = " + mo.getDN());
                    }
                    for (int i = 0; i < obj.length; ++i) {
                        expectedValue[i] = this.checkKeyword(in.getNextString());
                        if (expectedValue[i].equals(retrievedValue[i])) continue;
                        this.user.logDeveloperProgress("Warning: " + this.currentFile + ", line " + in.lineno() + ", CHECK " + objName + " failed at element [" + i + "], " + "expected='" + expectedValue[i] + "', " + "retrieved='" + retrievedValue[i] + "'");
                    }
                    break block26;
                }
                if (objValue instanceof Struct) {
                    Struct struct = (Struct)objValue;
                    String[] expectedValue = new String[struct.size()];
                    NameValue[] values = struct.getNameValues();
                    if (this.verboseDeveloperProgress) {
                        this.user.logDeveloperProgress("CHECK");
                        this.user.logDeveloperProgress("  mo = " + ldn);
                        this.user.logDeveloperProgress("  " + objName + " = " + mo.getDN());
                    }
                    for (int i = 0; i < struct.size(); ++i) {
                        String retrievedValue = this.getObjectValue(values[i].value);
                        expectedValue[i] = this.checkKeyword(in.getNextString());
                        if (expectedValue[i].equals(retrievedValue)) continue;
                        this.user.logDeveloperProgress("Warning: " + this.currentFile + ", line " + in.lineno() + ", CHECK " + objName + " failed at element [" + i + "], " + "expected='" + expectedValue[i] + "', " + "retrieved='" + retrievedValue + "'");
                    }
                    break block26;
                }
                if (objValue instanceof Object) {
                    String expectedVal = this.checkKeyword(in.getNextString());
                    String retrievedVal = this.getObjectValue(objValue);
                    if (this.verboseDeveloperProgress) {
                        this.user.logDeveloperProgress("CHECK");
                        this.user.logDeveloperProgress("  mo = " + ldn);
                        this.user.logDeveloperProgress("  " + objName + " = " + retrievedVal);
                    }
                    if (!expectedVal.equals(retrievedVal)) {
                        this.user.logDeveloperProgress("Warning: " + this.currentFile + ", line " + in.lineno() + ", CHECK " + objName + " failed, " + "expected='" + expectedVal + "', " + "retrieved='" + retrievedVal + "'");
                    }
                    break block26;
                }
                throw new CSException("Unknown or unsupported attribute type encountered ");
            }
            catch (Exception e) {
                this.user.logDeveloperProgress("ACTION: Exception getting values from struct.");
            }
        }
        in.checkEnd();
        if (this.eachCommandATransaction) {
            if (!this.somethingWentWrong) {
                this.endTransaction(true);
            } else {
                try {
                    this.endTransaction(false);
                }
                catch (CSException e) {
                    this.user.logDeveloperProgress("Transaction rollback failed.");
                }
            }
        }
        if (this.verboseDeveloperProgress) {
            this.user.logDeveloperProgress("");
        }
        this.printException(this.currentFile, in.lineno(), exception, recException);
    }

    private void executeSet(FileParser in) throws IOException, ParseException, NonExistingLdnException, CSException {
        this.currentCommand = "SET";
        in.checkBegin();
        String ldn = this.checkLdn(in.getTokenValue("mo"));
        MOProxy mo = this.findMo(ldn);
        String exception = in.getTokenValue("exception");
        String name = in.getNextString();
        NameValue[] nameValue = new NameValue[]{new NameValue(name, this.getAttributeValue(in))};
        String recException = "none";
        in.checkEnd();
        if (this.eachCommandATransaction) {
            this.beginTransaction();
        }
        if (this.haltMode) {
            try {
                mo.setAttributes(nameValue, this.session.session);
            }
            catch (Exception cse) {
                this.user.logDeveloperProgress("CSException setAttribute:" + cse);
                this.somethingWentWrong = true;
                ++this.numberOfCSExceptions;
            }
        } else {
            mo.setAttributes(nameValue, this.session.session);
        }
        if (this.verboseDeveloperProgress) {
            this.user.logDeveloperProgress("SET");
            this.user.logDeveloperProgress("  mo = " + ldn);
            this.user.logDeveloperProgress("  " + this.getObjectType(nameValue[0].value) + " " + name + " = " + this.printObjectValue(nameValue[0].value));
        }
        if (this.eachCommandATransaction) {
            if (!this.somethingWentWrong) {
                this.endTransaction(true);
            } else {
                try {
                    this.endTransaction(false);
                }
                catch (CSException e) {
                    this.user.logDeveloperProgress("Transaction rollback failed.");
                }
            }
        }
        if (this.verboseDeveloperProgress) {
            this.user.logDeveloperProgress("");
        }
        this.printException(this.currentFile, in.lineno(), exception, recException);
    }

    private void executeAction(FileParser in) throws IOException, ParseException, NonExistingLdnException, CSException {
        this.currentCommand = "ACTION";
        String recException = "none";
        in.checkBegin();
        String actionName = in.getTokenValue("actionName");
        String ldn = this.checkLdn(in.getTokenValue("mo"));
        MOProxy mo = this.findMo(ldn);
        String exception = in.getTokenValue("exception");
        String nrOfParams = in.getNextString();
        if (nrOfParams.equals("nrOfParameters")) {
            int nrOfParameters = in.getNextInteger();
            NameValue[] attributes = new NameValue[nrOfParameters];
            for (int i = 0; i < nrOfParameters; ++i) {
                attributes[i] = new NameValue("DUMMY", this.getAttributeValue(in));
            }
            Object[] returnObject = null;
            if (this.eachCommandATransaction) {
                this.beginTransaction();
            }
            if (this.haltMode) {
                try {
                    returnObject = mo.action(actionName, attributes, this.session.session);
                }
                catch (Exception cse) {
                    this.user.logDeveloperProgress("ACTION failed");
                    this.somethingWentWrong = true;
                    ++this.numberOfCSExceptions;
                }
            } else {
                returnObject = mo.action(actionName, attributes, this.session.session);
            }
            if (returnObject instanceof int[]) {
                int[] intArray = (int[])returnObject;
                Integer[] integerArray = new Integer[intArray.length];
                for (int i = 0; i < intArray.length; ++i) {
                    integerArray[i] = new Integer(intArray[i]);
                }
                returnObject = integerArray;
            } else if (returnObject instanceof boolean[]) {
                boolean[] boolArray = (boolean[])returnObject;
                Boolean[] booleanArray = new Boolean[boolArray.length];
                for (int i = 0; i < boolArray.length; ++i) {
                    booleanArray[i] = Boolean.valueOf(String.valueOf(boolArray[i]));
                }
                returnObject = booleanArray;
            } else if (returnObject instanceof float[]) {
                float[] floatArray = (float[])returnObject;
                Float[] floatFArray = new Float[floatArray.length];
                for (int i = 0; i < floatArray.length; ++i) {
                    floatFArray[i] = new Float(floatArray[i]);
                }
                returnObject = floatFArray;
            } else if (returnObject instanceof long[]) {
                long[] longArray = (long[])returnObject;
                Long[] longObjArray = new Long[longArray.length];
                for (int i = 0; i < longArray.length; ++i) {
                    longObjArray[i] = new Long(longArray[i]);
                }
                returnObject = longObjArray;
            } else if (returnObject instanceof Struct) {
                try {
                    Struct struct = (Struct)returnObject;
                    NameValue[] values = struct.getNameValues();
                    Object[] allValues = new Object[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        allValues[i] = values[i].getValue();
                    }
                    returnObject = allValues;
                }
                catch (Exception e) {
                    System.err.println(" !!! Exception whilst getting values from struct: " + e);
                }
            } else if (this.verboseDeveloperProgress) {
                this.user.logDeveloperProgress("ACTION");
                this.user.logDeveloperProgress("  actionname = " + actionName);
                this.user.logDeveloperProgress("  mo = " + ldn);
                if (nrOfParameters > 0) {
                    this.user.logDeveloperProgress("nrOfParameters = " + nrOfParameters);
                }
                for (int i = 0; i < nrOfParameters; ++i) {
                    this.user.logDeveloperProgress("  " + this.getObjectType(attributes[i].value) + " " + this.printObjectValue(attributes[i].value));
                }
            }
            String returnValue = this.checkKeyword(in.getTokenValue("returnValue"));
            if (returnValue.equals("ignore")) {
                this.user.logDeveloperProgress("Inside the ignore loop");
            } else if (returnValue.equals("none")) {
                if (returnObject != null) {
                    this.user.logDeveloperProgress("ACTION failed: unexpected return value received");
                }
            } else {
                in.pushBack();
                if (returnObject == null) {
                    this.user.logDeveloperProgress("ACTION failed: expected return value not received");
                } else if (returnObject instanceof Object[]) {
                    try {
                        Object[] obj = returnObject;
                        String[] retrievedValue = null;
                        String[] expectedValue = null;
                        retrievedValue = this.getSequenceObjectValue(obj);
                        expectedValue = new String[retrievedValue.length];
                        if (this.verboseDeveloperProgress) {
                            this.user.logDeveloperProgress("  returned: " + this.getObjectType(obj) + " " + this.printObjectValue(obj));
                        }
                        for (int i = 0; i < retrievedValue.length; ++i) {
                            expectedValue[i] = this.checkKeyword(in.getNextString());
                            if (expectedValue[i].equals(retrievedValue[i])) continue;
                            this.user.logDeveloperProgress("  Mismatch in return in file " + this.currentFile + ", line " + in.lineno() + "  at element [" + i + "]:");
                            this.user.logDeveloperProgress("  expected: " + expectedValue[i]);
                            this.user.logDeveloperProgress("  retrieved: " + retrievedValue[i]);
                        }
                    }
                    catch (Exception e) {
                        this.user.logDeveloperProgress("ACTION: Exception getting values from struct.");
                    }
                } else if (returnObject instanceof Object) {
                    String expectedVal = this.checkKeyword(in.getNextString());
                    String retrievedVal = null;
                    try {
                        retrievedVal = this.getObjectValue(returnObject);
                    }
                    catch (Exception e) {
                        this.user.logDeveloperProgress("ACTION: Exception getting values from struct.");
                    }
                    if (!expectedVal.equals(retrievedVal)) {
                        this.user.logDeveloperProgress("  Mismatch in return in file " + this.currentFile + ", line " + in.lineno() + ": " + this.getObjectType(returnObject) + ": ");
                        this.user.logDeveloperProgress("  expected: " + expectedVal);
                        this.user.logDeveloperProgress("  retrieved: " + retrievedVal);
                        this.user.logDeveloperProgress("");
                    } else if (this.verboseDeveloperProgress) {
                        this.user.logDeveloperProgress("   returned: " + this.getObjectType(returnObject) + " " + this.printObjectValue(returnObject));
                    }
                } else if (this.verboseDeveloperProgress) {
                    this.user.logDeveloperProgress("ACTION return  ?????type  failed");
                }
            }
            if (this.eachCommandATransaction) {
                if (!this.somethingWentWrong) {
                    this.endTransaction(true);
                } else {
                    try {
                        this.endTransaction(false);
                    }
                    catch (CSException e) {
                        this.user.logDeveloperProgress("Transaction rollback failed.");
                    }
                }
            }
            if (this.verboseDeveloperProgress) {
                this.user.logDeveloperProgress("");
            }
        } else {
            throw new ParseException("nrOfParameters", nrOfParams);
        }
        in.checkEnd();
        this.printException(this.currentFile, in.lineno(), exception, recException);
    }

    private void executeDelete(FileParser in) throws IOException, ParseException, NonExistingLdnException, CSException {
        this.currentCommand = "DELETE";
        in.checkBegin();
        String ldn = this.checkLdn(in.getTokenValue("mo"));
        MOProxy mo = this.findMo(ldn);
        String exception = in.getTokenValue("exception");
        in.checkEnd();
        String recException = "none";
        if (this.eachCommandATransaction) {
            this.beginTransaction();
        }
        if (this.verboseDeveloperProgress) {
            this.user.logDeveloperProgress("DELETE");
            this.user.logDeveloperProgress("  mo = " + ldn);
        }
        if (this.haltMode) {
            try {
                mo.delete(this.session.session);
            }
            catch (Exception cse) {
                this.user.logDeveloperProgress("CSException deleteMO:" + cse);
                this.somethingWentWrong = true;
                ++this.numberOfCSExceptions;
            }
        } else {
            mo.delete(this.session.session);
        }
        if (this.eachCommandATransaction) {
            if (!this.somethingWentWrong) {
                this.endTransaction(true);
            } else {
                try {
                    this.endTransaction(false);
                }
                catch (CSException e) {
                    this.user.logDeveloperProgress("Transaction rollback failed.");
                }
            }
        }
        if (this.verboseDeveloperProgress) {
            this.user.logDeveloperProgress("");
        }
        this.printException(this.currentFile, in.lineno(), exception, recException);
    }

    private void executeCreate(FileParser in) throws IOException, ParseException, NonExistingLdnException, CSException {
        String recException;
        this.currentCommand = "CREATE";
        in.checkBegin();
        String ldn = in.getTokenValue("parent");
        MOProxy parent = this.findMo(this.checkLdn(ldn));
        String id = this.checkKeyword(in.getTokenValue("identity"));
        String moType = in.getTokenValue("moType");
        String exception = in.getTokenValue("exception");
        String nextToken = in.getNextString();
        MOProxy sourceMo = null;
        if (nextToken.equals("sourceMo")) {
            sourceMo = this.findMo(in.getNextString());
            nextToken = in.getNextString();
        }
        if (nextToken.equals("nrOfAttributes")) {
            int nrOfAttributes = in.getNextInteger();
            String[] attributeNames = new String[nrOfAttributes];
            NameValue[] nameValues = new NameValue[nrOfAttributes];
            for (int i = 0; i < nrOfAttributes; ++i) {
                attributeNames[i] = in.getNextString();
                nameValues[i] = new NameValue(attributeNames[i], this.getAttributeValue(in));
            }
            in.checkEnd();
            recException = "none";
            String newLDN = parent.toString() + "," + moType + "=" + id;
            MOProxy mo = new MOProxy(newLDN);
            if (this.eachCommandATransaction) {
                this.beginTransaction();
            }
            if (sourceMo != null) {
                this.user.logDeveloperProgress("Source MO not yet implemented");
            }
            if (this.haltMode) {
                try {
                    mo.create(nameValues, this.session.session);
                }
                catch (Exception cse) {
                    this.user.logDeveloperProgress("CSException createMO:" + cse);
                    this.somethingWentWrong = true;
                    ++this.numberOfCSExceptions;
                }
            } else {
                mo.create(nameValues, this.session.session);
            }
            if (this.verboseDeveloperProgress) {
                this.user.logDeveloperProgress("CREATE");
                this.user.logDeveloperProgress("  parent = " + parent.getDN());
                this.user.logDeveloperProgress("  identity = " + id);
                this.user.logDeveloperProgress("  moType = " + moType);
                if (sourceMo != null) {
                    this.user.logDeveloperProgress("  sourceMo = " + sourceMo.getDN());
                }
            }
            if (this.eachCommandATransaction) {
                if (!this.somethingWentWrong) {
                    this.endTransaction(true);
                } else {
                    try {
                        this.endTransaction(false);
                    }
                    catch (CSException e) {
                        this.user.logDeveloperProgress("Transaction rollback failed.");
                    }
                }
            }
            if (this.verboseDeveloperProgress) {
                this.user.logDeveloperProgress("");
            }
        } else {
            throw new ParseException("sourceMo or nrOfAttributes", nextToken);
        }
        this.printException(this.currentFile, in.lineno(), exception, recException);
    }

    private void executeCall(FileParser in) throws IOException, ParseException {
        try {
            in.checkBegin();
        }
        catch (ParseException e) {
            in.pushBack();
        }
        String scriptName = this.checkKeyword(in.getNextString());
        String lastScriptName = (String)this.configFileLifo.lastElement();
        int chopOff1 = lastScriptName.lastIndexOf(47) + 1;
        int chopOff2 = lastScriptName.lastIndexOf(92) + 1;
        if (chopOff2 > chopOff1) {
            chopOff1 = chopOff2;
        }
        String baseName = lastScriptName.substring(0, chopOff1);
        String currentName = baseName + scriptName;
        this.configFileLifo.add(currentName);
        try {
            in.checkEnd();
        }
        catch (ParseException e) {
            in.pushBack();
        }
        if (this.verboseDeveloperProgress) {
            this.user.logDeveloperProgress("CALL " + currentName);
            this.user.logDeveloperProgress("");
        }
        this.execute(currentName, false);
    }

    private void executeEcho(FileParser in) throws IOException, ParseException {
        this.currentCommand = "ECHO";
        this.user.logOperatorProgress(this.checkLdn(in.getNextString()));
    }

    private void executeTrace(FileParser in) throws IOException, ParseException {
        this.currentCommand = "TRACE";
        String operation = in.getNextString();
        if (operation.equals("OFF")) {
            this.verboseDeveloperProgress = false;
            this.user.logDeveloperProgress("Verbose developer progress logging OFF");
        } else if (operation.equals("ON")) {
            this.verboseDeveloperProgress = true;
            this.user.logDeveloperProgress("Verbose developer progress logging ON");
        } else {
            this.user.logDeveloperProgress("Verbose developer progress logging " + operation);
            this.user.logDeveloperProgress("  Incorrect operation");
            this.user.logDeveloperProgress("");
            throw new ParseException("ON or OFF", operation);
        }
        this.user.logDeveloperProgress("");
    }

    private void executeRefresh(FileParser in) throws IOException, ParseException {
        this.currentCommand = "REFRESH";
        in.checkBegin();
        in.checkEnd();
        if (this.verboseDeveloperProgress) {
            this.user.logDeveloperProgress("REFRESH");
            this.user.logDeveloperProgress("  Command is deprecated; please remove it.");
            this.user.logDeveloperProgress("");
        }
    }

    private void executeTransaction(FileParser in) throws IOException, ParseException, NonExistingLdnException, CSException {
        this.currentCommand = "TRANSACTION";
        String state = null;
        String readTimeout = null;
        try {
            in.checkBegin();
            state = in.getTokenValue("mode");
            try {
                in.checkEnd();
            }
            catch (ParseException pe) {
                in.pushBack();
                readTimeout = in.getTokenValue("timeout");
                in.checkEnd();
            }
        }
        catch (ParseException e) {
            in.pushBack();
            state = in.getNextString();
        }
        if (state.equals("ENABLE")) {
            if (this.lastTransactionState == 2) {
                this.user.logDeveloperProgress("TRANSACTION ENABLE");
                this.user.logDeveloperProgress("  Error: Can not enable transactions inside an active transaction.");
                this.user.logDeveloperProgress("");
                throw new ParseException("END", state);
            }
            if (this.lastTransactionState == 3) {
                this.user.logDeveloperProgress("TRANSACTION ENABLE");
                this.user.logDeveloperProgress("  Warning: Transactions are already enabled. Command ignored.");
                this.user.logDeveloperProgress("");
            } else {
                if (readTimeout != null) {
                    this.transactionTimeoutValue = new Integer(readTimeout);
                }
                this.eachCommandATransaction = true;
                this.lastTransactionState = 0;
                if (this.verboseDeveloperProgress) {
                    this.user.logDeveloperProgress("TRANSACTION ENABLE");
                    this.user.logDeveloperProgress("");
                }
            }
        } else if (state.equals("DISABLE")) {
            if (this.lastTransactionState == 1) {
                this.user.logDeveloperProgress("TRANSACTION DISABLE");
                this.user.logDeveloperProgress("  Warning: Transactions are already disabled. Command ignored.");
                this.user.logDeveloperProgress("");
            } else {
                if (this.lastTransactionState == 2) {
                    this.user.logDeveloperProgress("TRANSACTION DISABLE");
                    this.user.logDeveloperProgress("  Error: Can not disable transactions inside an active transaction.");
                    this.user.logDeveloperProgress("");
                    throw new ParseException("END", state);
                }
                this.eachCommandATransaction = false;
                this.transactionTimeoutValue = null;
                this.lastTransactionState = 1;
                if (this.verboseDeveloperProgress) {
                    this.user.logDeveloperProgress("TRANSACTION DISABLE");
                    this.user.logDeveloperProgress("");
                }
            }
        } else if (state.equals("BEGIN")) {
            if (this.lastTransactionState == 1) {
                this.user.logDeveloperProgress("TRANSACTION BEGIN");
                this.user.logDeveloperProgress("  Error: Can not begin transaction. Transactions are disabled.");
                this.user.logDeveloperProgress("");
                throw new ParseException("ENABLE", state);
            }
            if (this.lastTransactionState == 2) {
                this.user.logDeveloperProgress("TRANSACTION BEGIN");
                this.user.logDeveloperProgress("  Error: Can not begin a transaction inside an active transaction.");
                this.user.logDeveloperProgress("");
                throw new ParseException("END", state);
            }
            if (readTimeout != null) {
                this.transactionTimeoutValue = new Integer(readTimeout);
            }
            this.beginTransaction();
            this.eachCommandATransaction = false;
            this.lastTransactionState = 2;
            if (this.verboseDeveloperProgress) {
                this.user.logDeveloperProgress("TRANSACTION BEGIN");
                this.user.logDeveloperProgress("");
            }
        } else if (state.equals("END")) {
            if (this.lastTransactionState == 0) {
                this.user.logDeveloperProgress("TRANSACTION END");
                this.user.logDeveloperProgress("  Error: Can not end transaction. No transaction active.");
                this.user.logDeveloperProgress("");
                throw new ParseException("BEGIN or DISABLE", state);
            }
            if (this.lastTransactionState == 1) {
                this.user.logDeveloperProgress("TRANSACTION END");
                this.user.logDeveloperProgress("  Error: Can not end transaction. No transaction active.");
                this.user.logDeveloperProgress("");
                throw new ParseException("ENABLE", state);
            }
            if (this.lastTransactionState == 3) {
                this.user.logDeveloperProgress("TRANSACTION END");
                this.user.logDeveloperProgress("  Error: Can not end transaction. No transaction active.");
                this.user.logDeveloperProgress("");
                throw new ParseException("BEGIN or DISABLE", state);
            }
            if (this.verboseDeveloperProgress) {
                this.user.logDeveloperProgress("TRANSACTION END");
                this.user.logDeveloperProgress("");
            }
            this.transactionTimeoutValue = null;
            this.endTransaction(true);
            this.eachCommandATransaction = true;
            this.lastTransactionState = 3;
        } else {
            this.user.logDeveloperProgress("TRANSACTION " + state);
            this.user.logDeveloperProgress("  Incorrect transaction operation");
            this.user.logDeveloperProgress("");
            throw new ParseException("BEGIN, END, ENABLE or DISABLE", state);
        }
    }

    private void printException(String configFile, int lineNo, String expException, String recException) {
        int index = recException.indexOf("TAG");
        if (index > 0) {
            String tmpString = recException.substring(index + 6);
            index = tmpString.indexOf(34);
            recException = tmpString.substring(0, index);
        }
        if (recException.indexOf(expException) == -1) {
            this.user.logDeveloperProgress("  Failed in file " + configFile + " at line (" + lineNo + ")! Exception mismatch");
            this.user.logDeveloperProgress("    Expected: " + expException);
            this.user.logDeveloperProgress("    Received: " + recException);
            this.user.logDeveloperProgress("");
        }
    }

    private String getObjectValue(Object obj) throws UserException {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof String[]) {
            String[] arr = (String[])obj;
            String value = "String[]: ";
            for (int i = 0; i < arr.length; ++i) {
                value = value + arr[i] + " ";
            }
            return value;
        }
        if (obj instanceof Integer) {
            return obj.toString();
        }
        if (obj instanceof Integer[]) {
            Integer[] arr = (Integer[])obj;
            String value = "Integer[]: ";
            for (int i = 0; i < arr.length; ++i) {
                value = value + arr[i] + " ";
            }
            return value;
        }
        if (obj instanceof Boolean) {
            return obj.toString();
        }
        if (obj instanceof Boolean[]) {
            Boolean[] arr = (Boolean[])obj;
            String value = "Boolean[]: ";
            for (int i = 0; i < arr.length; ++i) {
                value = value + arr[i] + " ";
            }
            return value;
        }
        if (obj instanceof Float) {
            return obj.toString();
        }
        if (obj instanceof Float[]) {
            Float[] arr = (Float[])obj;
            String value = "Float[]: ";
            for (int i = 0; i < arr.length; ++i) {
                value = value + arr[i] + " ";
            }
            return value;
        }
        if (obj instanceof Long) {
            return obj.toString();
        }
        if (obj instanceof Long[]) {
            Long[] arr = (Long[])obj;
            String value = "Long[]: ";
            for (int i = 0; i < arr.length; ++i) {
                value = value + arr[i] + " ";
            }
            return value;
        }
        if (obj instanceof MOProxy) {
            MOProxy mOProxy = (MOProxy)obj;
            return mOProxy.getDN();
        }
        if (obj instanceof MORef) {
            MORef myMORef = (MORef)obj;
            CSFacade cs = null;
            cs = CSFacade.getInstance();
            MOName dn = null;
            try {
                dn = cs.getDN(myMORef);
            }
            catch (CSException cse) {
                return "null";
            }
            if (dn == null) {
                return "null";
            }
            return dn.getRDNSeq();
        }
        this.user.logDeveloperProgress("ERROR: Unsupported type detected in getObjectValue: " + obj.getClass().getName());
        return "null";
    }

    private String[] getSequenceObjectValue(Object[] obj) throws UserException {
        Vector<String> returnValue = new Vector<String>();
        for (int i = 0; i < obj.length; ++i) {
            try {
                if (obj[i] instanceof Struct) {
                    NameValue[] tmpNameValues = ((Struct)obj[i]).getNameValues();
                    Object[] allValues = new Object[tmpNameValues.length];
                    for (int k = 0; k < tmpNameValues.length; ++k) {
                        allValues[k] = tmpNameValues[k].getValue();
                    }
                    Object[] objArr = allValues;
                    String[] strArr = this.getSequenceObjectValue(objArr);
                    for (int j = 0; j < strArr.length; ++j) {
                        returnValue.addElement(this.getObjectValue(strArr[j]));
                    }
                    continue;
                }
                if (obj[i] instanceof int[]) {
                    int[] intArr = (int[])obj[i];
                    for (int j = 0; j < intArr.length; ++j) {
                        returnValue.addElement(this.getObjectValue(new Integer(intArr[j])));
                    }
                    continue;
                }
                if (obj[i] instanceof long[]) {
                    long[] longArr = (long[])obj[i];
                    for (int j = 0; j < longArr.length; ++j) {
                        returnValue.addElement(this.getObjectValue(new Long(longArr[j])));
                    }
                    continue;
                }
                if (obj[i] instanceof float[]) {
                    float[] floatArr = (float[])obj[i];
                    for (int j = 0; j < floatArr.length; ++j) {
                        returnValue.addElement(this.getObjectValue(new Float(floatArr[j])));
                    }
                    continue;
                }
                if (obj[i] instanceof boolean[]) {
                    boolean[] boolArr = (boolean[])obj[i];
                    for (int j = 0; j < boolArr.length; ++j) {
                        returnValue.addElement(this.getObjectValue(Boolean.valueOf(String.valueOf(boolArr[j]))));
                    }
                    continue;
                }
                returnValue.addElement(this.getObjectValue(obj[i]));
                continue;
            }
            catch (Exception e) {
                this.user.logDeveloperProgress("ACTION: Exception getting values from struct.");
            }
        }
        Object[] tmpArr = new String[returnValue.size()];
        returnValue.copyInto(tmpArr);
        return tmpArr;
    }

    private String getObjectType(Object obj) {
        if (obj == null) {
            return "null (probably MoRef)";
        }
        if (obj instanceof Struct) {
            return "Struct";
        }
        if (obj instanceof String) {
            return "String";
        }
        if (obj instanceof Integer) {
            return "Integer";
        }
        if (obj instanceof Boolean) {
            return "Boolean";
        }
        if (obj instanceof Float) {
            return "Float";
        }
        if (obj instanceof Long) {
            return "Long";
        }
        if (obj instanceof MOProxy) {
            return "MOProxy";
        }
        if (obj instanceof String[]) {
            return "String[]";
        }
        if (obj instanceof Integer[]) {
            return "Integer[]";
        }
        if (obj instanceof Boolean[]) {
            return "Boolean[]";
        }
        if (obj instanceof int[]) {
            return "int[]";
        }
        if (obj instanceof Float[]) {
            return "Float[]";
        }
        if (obj instanceof Long[]) {
            return "Long[]";
        }
        if (obj instanceof MOProxy[]) {
            return "MOProxy[]";
        }
        if (obj instanceof MORef) {
            return "MORef";
        }
        if (obj instanceof MORef[]) {
            return "MORef[]";
        }
        if (obj instanceof Struct[]) {
            return "Struct[]";
        }
        this.user.logDeveloperProgress("ERROR: Unsupported type detected " + obj.getClass());
        return "null";
    }

    private String printObjectValue(Object argObj) {
        String returnString = "<Unknown>";
        if (argObj == null) {
            returnString = "null";
        } else if (argObj instanceof Struct) {
            returnString = this.formatStructPrintout(argObj);
        } else if (argObj instanceof Struct[]) {
            StringBuffer strBuff = new StringBuffer();
            Struct[] structArr = (Struct[])argObj;
            for (int i = 0; i < structArr.length; ++i) {
                strBuff.append(this.formatStructPrintout(structArr[i]));
            }
            returnString = strBuff.toString();
        } else if (argObj instanceof Object[]) {
            Object[] obj = (Object[])argObj;
            String[] stringValue = null;
            try {
                stringValue = this.getSequenceObjectValue(obj);
            }
            catch (Exception e) {
                this.user.logDeveloperProgress("Exception getting values from sequence.");
            }
            returnString = "length:" + obj.length;
            for (int i = 0; i < obj.length; ++i) {
                returnString = returnString + "\n       " + stringValue[i];
            }
        } else if (argObj instanceof Object) {
            try {
                returnString = this.getObjectValue(argObj);
            }
            catch (Exception e) {
                this.user.logDeveloperProgress("Exception getting values from object.");
            }
        } else {
            returnString = "Unknown type";
        }
        return returnString;
    }

    private String formatStructPrintout(Object argObj) {
        String returnString = "";
        try {
            Struct struct = (Struct)argObj;
            NameValue[] nameValue = struct.getNameValues();
            returnString = "\n           numberOfElements: " + struct.size();
            for (int i = 0; i < nameValue.length; ++i) {
                returnString = returnString + "\n              " + this.getObjectType(nameValue[i].value) + " " + nameValue[i].name + " = " + nameValue[i].value;
            }
        }
        catch (Exception e) {
            this.user.logDeveloperProgress("Exception whilst getting values from struct: " + e);
        }
        return returnString;
    }

    private Object getAttributeValue(FileParser in) throws IOException, NonExistingLdnException, ParseException, CSException {
        String type = in.getNextString();
        if (type.startsWith("Struct")) {
            String nrOfElements = in.getNextString();
            if (nrOfElements.equals("nrOfElements")) {
                int structSize = in.getNextInteger();
                String[] names = new String[structSize];
                Object[] values = new Object[structSize];
                NameValue[] nameValue = new NameValue[structSize];
                for (int i = 0; i < structSize; ++i) {
                    names[i] = in.getNextString();
                    values[i] = this.getAttributeValue(in);
                    nameValue[i] = new NameValue(names[i], values[i]);
                }
                return new Struct(nameValue);
            }
            this.user.logDeveloperProgress("Parse error in file " + this.currentFile + " at line:" + in.lineno() + " nrOfElements expected ");
            throw new ParseException("nrOfElements", nrOfElements);
        }
        if (type.startsWith("Array")) {
            String arrayType = in.getNextString();
            int arraySize = in.getNextInteger();
            if (arrayType.startsWith("String")) {
                String[] stringArray = new String[arraySize];
                for (int i = 0; i < arraySize; ++i) {
                    String readValue;
                    String value = readValue = in.getNextString();
                    stringArray[i] = value = this.checkKeyword(readValue);
                }
                return stringArray;
            }
            if (arrayType.startsWith("Integer")) {
                Integer[] intArray = new Integer[arraySize];
                for (int i = 0; i < arraySize; ++i) {
                    String readValue;
                    String value = readValue = in.getNextString();
                    value = this.checkKeyword(readValue);
                    intArray[i] = new Integer(value);
                }
                return intArray;
            }
            if (arrayType.startsWith("Bool")) {
                Boolean[] booleanArray = new Boolean[arraySize];
                for (int i = 0; i < arraySize; ++i) {
                    String readValue;
                    String value = readValue = in.getNextString();
                    value = this.checkKeyword(value);
                    value = this.checkSyntaxOfBoolean(value);
                    booleanArray[i] = Boolean.valueOf(value);
                }
                return booleanArray;
            }
            if (arrayType.startsWith("Float")) {
                Float[] floatArray = new Float[arraySize];
                for (int i = 0; i < arraySize; ++i) {
                    String readValue = in.getNextString();
                    String value = this.checkKeyword(readValue);
                    floatArray[i] = new Float(value);
                }
                return floatArray;
            }
            if (arrayType.startsWith("Long")) {
                Long[] longArray = new Long[arraySize];
                for (int i = 0; i < arraySize; ++i) {
                    String readValue = in.getNextString();
                    String value = this.checkKeyword(readValue);
                    longArray[i] = new Long(value);
                }
                return longArray;
            }
            if (arrayType.startsWith("Ref")) {
                MOProxy[] mOProxyArray = new MOProxy[arraySize];
                for (int i = 0; i < arraySize; ++i) {
                    String ldn = this.checkKeyword(in.getNextString());
                    mOProxyArray[i] = this.findMo(this.checkLdn(ldn));
                    if (mOProxyArray[i] == null || mOProxyArray[i].isExisting()) continue;
                    throw new NonExistingLdnException(ldn);
                }
                return mOProxyArray;
            }
            if (arrayType.startsWith("Struct")) {
                Struct[] structArray = new Struct[arraySize];
                for (int i = 0; i < arraySize; ++i) {
                    NameValue[] nameValue;
                    String nrOfElements = in.getNextString();
                    if (nrOfElements.equals("nrOfElements")) {
                        int structSize = in.getNextInteger();
                        String[] names = new String[structSize];
                        Object[] values = new Object[structSize];
                        nameValue = new NameValue[structSize];
                        for (int j = 0; j < structSize; ++j) {
                            names[j] = in.getNextString();
                            values[j] = this.getAttributeValue(in);
                            nameValue[j] = new NameValue(names[j], values[j]);
                        }
                    } else {
                        this.user.logDeveloperProgress("Parse error in file " + this.currentFile + " at line:" + in.lineno() + " nrOfElements expected ");
                        throw new ParseException("nrOfElements", nrOfElements);
                    }
                    structArray[i] = new Struct(nameValue);
                }
                return structArray;
            }
        } else {
            String value = this.checkKeyword(in.getNextString());
            if (type.startsWith("String")) {
                return value;
            }
            if (type.startsWith("Integer")) {
                return new Integer(value);
            }
            if (type.startsWith("Bool")) {
                value = this.checkSyntaxOfBoolean(value);
                return Boolean.valueOf(String.valueOf(value));
            }
            if (type.startsWith("Float")) {
                return new Float(value);
            }
            if (type.startsWith("Long")) {
                return new Long(value);
            }
            if (type.startsWith("Ref")) {
                if ("".equals(value)) {
                    return null;
                }
                return this.findMo(this.checkLdn(value));
            }
            this.user.logDeveloperProgress("Unknown type of attribute encountered: " + type);
            throw new ParseException("<A valid attribute type>", type);
        }
        return null;
    }

    private Reader getConfigFileFromLocalMachine(String _configFile) throws FileNotFoundException {
        File file = new File(_configFile);
        FileInputStream fis = new FileInputStream(file);
        InputStreamReader isr = new InputStreamReader(fis);
        return isr;
    }

    private Reader getConfigFileFromNode(String _configFile) throws URLNotFoundException {
        InputStreamReader isr = null;
        try {
            URL nodeLoc = new URL(_configFile);
            URLConnection urlConnection = nodeLoc.openConnection();
            InputStream is = urlConnection.getInputStream();
            isr = new InputStreamReader(is);
        }
        catch (MalformedURLException e) {
            throw new URLNotFoundException(_configFile);
        }
        catch (IOException e) {
            throw new URLNotFoundException(_configFile);
        }
        catch (NullPointerException e) {
            throw new URLNotFoundException(_configFile);
        }
        return isr;
    }

    private String getUserValue(String configParam) throws ParseException {
        if (this.configParameters == null) {
            throw new ParseException("<A valid configuration parameter>", configParam);
        }
        for (int i = 0; i < this.configParameters.length; ++i) {
            if (!configParam.equals(this.configParameters[i].name)) continue;
            return (String)this.configParameters[i].value;
        }
        throw new ParseException("<A valid configuration parameter>", configParam);
    }

    private String checkLdn(String LDN) throws ParseException {
        String newLDN = "";
        int offSet = LDN.indexOf("$");
        while (offSet != -1) {
            String lastPart;
            String firstPart;
            int offSet2 = LDN.indexOf(",", offSet);
            if (offSet2 != -1) {
                firstPart = LDN.substring(0, offSet);
                lastPart = LDN.substring(offSet2, LDN.length());
                String middlePart = this.getUserValue(LDN.substring(offSet, offSet2));
                newLDN = firstPart.concat(middlePart).concat(lastPart);
            } else if (offSet2 == -1) {
                firstPart = LDN.substring(0, offSet);
                lastPart = this.getUserValue(LDN.substring(offSet, LDN.length()));
                newLDN = firstPart.concat(lastPart);
            }
            LDN = newLDN;
            offSet = LDN.indexOf("$");
        }
        return LDN;
    }

    private String checkKeyword(String val) throws ParseException {
        if (val.startsWith("$")) {
            return this.getUserValue(val);
        }
        return val;
    }

    private String checkSyntaxOfBoolean(String value) throws ParseException {
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            return value;
        }
        if (value.equals("1")) {
            return "true";
        }
        if (value.equals("0")) {
            return "false";
        }
        throw new ParseException("'true' (not case sensitive) or 'false' (not case sensitive) or '1' or '0'", value);
    }

    private void beginTransaction() throws CSException {
        if (!this.transactionActive) {
            if (this.transactionTimeoutValue != null) {
                this.session.begin(this.transactionTimeoutValue);
            } else {
                this.session.begin();
            }
            this.transactionActive = true;
            if (this.verboseDeveloperProgress) {
                if (this.transactionTimeoutValue != null) {
                    this.user.logDeveloperProgress("Begin transaction #" + ++this.transactionCounter + " with timeout of " + this.transactionTimeoutValue.toString() + " seconds");
                } else {
                    this.user.logDeveloperProgress("Begin transaction #" + ++this.transactionCounter + " with default timeout value");
                }
            }
        }
    }

    private void endTransaction(boolean status) throws CSException {
        if (this.transactionActive) {
            if (status) {
                this.session.commit();
            } else {
                this.session.rollback();
            }
            this.transactionActive = false;
            if (this.verboseDeveloperProgress) {
                this.user.logDeveloperProgress("End transaction #" + this.transactionCounter);
            }
        }
    }

    private void startSession() throws CSException {
        Log.trace("startSession()");
        if (this.session == null) {
            this.session = new Transaction();
            this.session.commit();
        }
    }

    private void endSession() {
        Log.trace("endSession()");
        if (this.session != null) {
            try {
                this.session.end();
            }
            catch (CSException e) {
                Log.logError("Error occured with ending session", e);
            }
        }
        this.session = null;
    }
}

