/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.common;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipFileHelper
extends se.ericsson.crbs.common.ZipFileHelper {
    private ZipFileHelper() {
    }

    public static void addToZipFile(String zipFilePath, String directoryOrFileToBeAdded) throws IOException {
        List fileList = ZipFileHelper.getSubFiles(new File(directoryOrFileToBeAdded));
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFilePath));
        byte[] buf = new byte[1024];
        int readLen = 0;
        for (int i = 0; i < fileList.size(); ++i) {
            File currentFile = (File)fileList.get(i);
            ZipEntry ze = new ZipEntry(ZipFileHelper.getAbsFileName(directoryOrFileToBeAdded, currentFile));
            ze.setSize(currentFile.length());
            ze.setTime(currentFile.lastModified());
            zos.putNextEntry(ze);
            BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(currentFile));
            while ((readLen = ((InputStream)inStream).read(buf, 0, 1024)) != -1) {
                zos.write(buf, 0, readLen);
            }
            ((InputStream)inStream).close();
        }
        zos.close();
    }

    private static List getSubFiles(File inBaseDir) {
        ArrayList<File> fileList = new ArrayList<File>();
        File[] currentList = inBaseDir.listFiles();
        for (int i = 0; i < currentList.length; ++i) {
            if (currentList[i].isFile()) {
                fileList.add(currentList[i]);
            }
            if (!currentList[i].isDirectory()) continue;
            fileList.addAll(ZipFileHelper.getSubFiles(currentList[i]));
        }
        return fileList;
    }

    private static String getAbsFileName(String inBaseDir, File inFileName) {
        File real = inFileName;
        String absName = real.getName();
        while ((real = real.getParentFile()) != null && !real.equals(new File(inBaseDir))) {
            absName = real.getName() + File.separator + absName;
        }
        return absName;
    }

    public static boolean isZipEntryExist(File inFile, String inEntryName) {
        boolean result2 = false;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(inFile);
        }
        catch (Exception e) {
            logger.traceError(THIS_CLASS, e.getMessage());
            return result2;
        }
        if (zipFile != null) {
            Enumeration<? extends ZipEntry> zipEnum = zipFile.entries();
            while (zipEnum.hasMoreElements()) {
                ZipEntry item = zipEnum.nextElement();
                if (item.getName().indexOf(inEntryName) == -1) continue;
                result2 = true;
                break;
            }
            try {
                zipFile.close();
            }
            catch (IOException e) {
                logger.traceError(THIS_CLASS, e.getMessage());
            }
            zipFile = null;
        }
        return result2;
    }
}

