/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.antennasystemconfiguration;

import java.io.IOException;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.AntennaSystemConfigurationFailedException;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.AntennaSystemConfigurationMao;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.AntennaNearUnitData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.AntennaSubUnitData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.AntennaSystemData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.AntennaSystemDataFinder;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.AntennaUnitData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.AntennaUnitGroupData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.AuPortData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.ExtTmaConnectorData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.ExternalTmaData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.MulticastAntennaBranchData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.RetSubUnitData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.RfBranchData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.TmaSubUnitData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.TmfConfigurationData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.reportlogger.AntennaSystemConfigurationReportLogger;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.reportlogger.ReportLoggerHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.common.LdnHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.common.logger.ConfigurationReportLoggerService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class AntennaSystemConfigurationMaoImpl
implements AntennaSystemConfigurationMao {
    private static final Class THIS_CLASS = AntennaSystemConfigurationMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final GenericMaoContext aGenericMaoContext;
    private final MoRepositoryWrapper aMoRepository;

    public AntennaSystemConfigurationMaoImpl(GenericMaoContext inputAGenericMaoContext) {
        this.aGenericMaoContext = inputAGenericMaoContext;
        this.aMoRepository = inputAGenericMaoContext.getMoRepositoryWrapper();
    }

    public void actionConfigureAntennaSystem(String antennaSystemXmlFile, Coordinator coordinator) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "actionConfigureAntennaSystem() path: " + antennaSystemXmlFile);
        AntennaSystemData antennaSystemData = this.parseAntennaSystemXmlFile(antennaSystemXmlFile);
        if (antennaSystemData != null) {
            this.configureAntennaSystem(antennaSystemData, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "actionConfigureAntennaSystem()");
    }

    protected AntennaSystemData parseAntennaSystemXmlFile(String antennaSystemXmlFile) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "parseAntennaSystemXmlFile()");
        AntennaSystemDataFinder finder = new AntennaSystemDataFinder();
        AntennaSystemData antennaSystemData = null;
        try {
            antennaSystemData = finder.parseAntennaSystemXmlFile(antennaSystemXmlFile, this.aMoRepository);
        }
        catch (IOException ioe) {
            String slogan = "Error parsing file";
            String faultMsg = "Could not parse Antenna System XML file.";
            throw new AntennaSystemConfigurationFailedException("Error parsing file", "Could not parse Antenna System XML file.", ioe);
        }
        logger.traceReturn(THIS_CLASS, "parseAntennaSystemXmlFile()");
        return antennaSystemData;
    }

    public void configureAntennaSystem(AntennaSystemData antennaSystemData, Coordinator coordinator) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "configureAntennaSystem()");
        ManagedObject equipmentMo = this.findAndCheckMo("ManagedElement=1,Equipment=1");
        this.createAntennaUnitGroupAndChildren(equipmentMo, antennaSystemData.antennaUnitGroupData, coordinator);
        this.createAntennaUnitGroupAndChildrenRefs(equipmentMo, antennaSystemData.antennaUnitGroupData, coordinator);
        logger.traceReturn(THIS_CLASS, "configureAntennaSystem()");
    }

    protected void createAntennaUnitGroupAndChildren(ManagedObject equipmentMo, AntennaUnitGroupData[] antennaUnitGroupData, Coordinator coordinator) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createAntennaUnitGroupAndChildren()");
        if (antennaUnitGroupData != null) {
            for (int i = 0; i < antennaUnitGroupData.length; ++i) {
                try {
                    ManagedObject antennaUnitGroupMo = this.findOrCreateMo("AntennaUnitGroup", equipmentMo, antennaUnitGroupData[i].antennaUnitGroupId, null, coordinator);
                    this.createAntennaUnitAndChildren(antennaUnitGroupMo, antennaUnitGroupData[i].antennaUnitData, coordinator);
                    this.createRfBranch(antennaUnitGroupMo, antennaUnitGroupData[i].rfBranchData, coordinator);
                    this.createAntennaNearUnitAndChildren(antennaUnitGroupMo, antennaUnitGroupData[i].antennaNearUnitData, coordinator);
                    this.createExternalTmaAndChildren(antennaUnitGroupMo, antennaUnitGroupData[i].externalTmaData, coordinator);
                    this.createMulticastAntennaBranch(antennaUnitGroupMo, antennaUnitGroupData[i].multicastAntennaBranchData, coordinator);
                    this.createTmfConfiguration(antennaUnitGroupMo, antennaUnitGroupData[i].tmfConfigurationData, coordinator);
                    continue;
                }
                catch (AntennaSystemConfigurationFailedException ascfe) {
                    throw new AntennaSystemConfigurationFailedException("AntennaUnitGroup configuration failed", "Could not configure AntennaUnitGroup with id: " + antennaUnitGroupData[i].antennaUnitGroupId, (Exception)((Object)ascfe));
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "createAntennaUnitGroupAndChildren()");
    }

    protected void createExternalTmaAndChildren(ManagedObject antennaUnitGroupMo, ExternalTmaData[] externalTmaData, Coordinator coordinator) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createExternalTmaAndChildren()");
        if (externalTmaData != null) {
            for (int i = 0; i < externalTmaData.length; ++i) {
                try {
                    AttrListImpl attrList = new AttrListImpl();
                    if (externalTmaData[i].powerSupervisionSupported != null) {
                        attrList.addElement("powerSupervisionSupported", (Object)externalTmaData[i].powerSupervisionSupported);
                    }
                    ManagedObject externalTmaMo = this.findOrCreateMo("ExternalTMA", antennaUnitGroupMo, externalTmaData[i].externalTmaId, attrList, coordinator);
                    this.createExtTmaConnector(externalTmaMo, externalTmaData[i].extTmaConnectorData, coordinator);
                    continue;
                }
                catch (AntennaSystemConfigurationFailedException ascfe) {
                    throw new AntennaSystemConfigurationFailedException("ExternalTma configuration failed", "Could not configure ExternalTma with id: " + externalTmaData[i].externalTmaId, (Exception)((Object)ascfe));
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "createExternalTmaAndChildren()");
    }

    protected void createExtTmaConnector(ManagedObject externalTmaMo, ExtTmaConnectorData[] extTmaConnectorData, Coordinator coordinator) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createExtTmaConnector()");
        if (extTmaConnectorData != null) {
            for (int i = 0; i < extTmaConnectorData.length; ++i) {
                try {
                    AttrListImpl attrList = new AttrListImpl();
                    attrList.addElement("dlAttenuation", (Object)extTmaConnectorData[i].dlAttenuation);
                    attrList.addElement("ulGain", (Object)extTmaConnectorData[i].ulGain);
                    attrList.addElement("dlTrafficDelay", (Object)extTmaConnectorData[i].dlTrafficDelay);
                    attrList.addElement("ulTrafficDelay", (Object)extTmaConnectorData[i].ulTrafficDelay);
                    this.findOrCreateMo("ExtTmaConnector", externalTmaMo, extTmaConnectorData[i].extTmaConnectorId, attrList, coordinator);
                    continue;
                }
                catch (AntennaSystemConfigurationFailedException ascfe) {
                    throw new AntennaSystemConfigurationFailedException("ExtTmaConnector configuration failed", "Could not configure ExtTmaConnector with id: " + extTmaConnectorData[i].extTmaConnectorId, (Exception)((Object)ascfe));
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "createExtTmaConnector()");
    }

    protected void createAntennaNearUnitAndChildren(ManagedObject antennaUnitGroupMo, AntennaNearUnitData[] antennaNearUnitData, Coordinator coordinator) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createAntennaNearUnitAndChildren()");
        if (antennaNearUnitData != null) {
            for (int i = 0; i < antennaNearUnitData.length; ++i) {
                try {
                    AttrListImpl attrList = new AttrListImpl();
                    attrList.addElement("anuType", (Object)antennaNearUnitData[i].anuType);
                    attrList.addElement("iuantDeviceType", (Object)antennaNearUnitData[i].iuantDeviceType);
                    attrList.addElement("uniqueId", (Object)(antennaNearUnitData[i].uniqueId == null ? "" : antennaNearUnitData[i].uniqueId));
                    ManagedObject antennaNearUnit = this.findOrCreateMo("AntennaNearUnit", antennaUnitGroupMo, antennaNearUnitData[i].antennaNearUnitId, attrList, coordinator);
                    this.createRetSubUnit(antennaNearUnit, antennaNearUnitData[i].retSubUnitData, coordinator);
                    this.createTmaSubUnit(antennaNearUnit, antennaNearUnitData[i].tmaSubUnitData, coordinator);
                    continue;
                }
                catch (AntennaSystemConfigurationFailedException ascfe) {
                    throw new AntennaSystemConfigurationFailedException("AntennaNearUnit configuration failed", "Could not configure AntennaNearUnit with id: " + antennaNearUnitData[i].antennaNearUnitId, (Exception)((Object)ascfe));
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "createAntennaNearUnitAndChildren()");
    }

    protected void createRetSubUnit(ManagedObject antennaNearUnit, RetSubUnitData[] retSubUnitData, Coordinator coordinator) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createRetSubUnit()");
        if (retSubUnitData != null) {
            for (int i = 0; i < retSubUnitData.length; ++i) {
                try {
                    AttrListImpl attrList = new AttrListImpl();
                    attrList.addElement("electricalAntennaTilt", (Object)retSubUnitData[i].electricalAntennaTilt);
                    this.findOrCreateMo("RetSubUnit", antennaNearUnit, retSubUnitData[i].retSubUnitId, attrList, coordinator);
                    continue;
                }
                catch (AntennaSystemConfigurationFailedException ascfe) {
                    throw new AntennaSystemConfigurationFailedException("RetSubUnit configuration failed", "Could not configure RetSubUnit with id: " + retSubUnitData[i].retSubUnitId, (Exception)((Object)ascfe));
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "createRetSubUnit()");
    }

    protected void createTmaSubUnit(ManagedObject antennaNearUnit, TmaSubUnitData[] tmaSubUnitData, Coordinator coordinator) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createTmaSubUnit()");
        if (tmaSubUnitData != null) {
            for (int i = 0; i < tmaSubUnitData.length; ++i) {
                try {
                    AttrListImpl attrList = new AttrListImpl();
                    if (tmaSubUnitData[i].dlAttenuation != null) {
                        attrList.addElement("dlAttenuation", (Object)tmaSubUnitData[i].dlAttenuation);
                    }
                    if (tmaSubUnitData[i].dlTrafficDelay != null) {
                        attrList.addElement("dlTrafficDelay", (Object)tmaSubUnitData[i].dlTrafficDelay);
                    }
                    if (tmaSubUnitData[i].ulTrafficDelay != null) {
                        attrList.addElement("ulTrafficDelay", (Object)tmaSubUnitData[i].ulTrafficDelay);
                    }
                    if (tmaSubUnitData[i].tmaType != null) {
                        attrList.addElement("tmaType", (Object)tmaSubUnitData[i].tmaType);
                    }
                    this.findOrCreateMo("TmaSubUnit", antennaNearUnit, tmaSubUnitData[i].tmaSubUnitId, attrList, coordinator);
                    continue;
                }
                catch (AntennaSystemConfigurationFailedException ascfe) {
                    throw new AntennaSystemConfigurationFailedException("TmaSubUnit configuration failed", "Could not configure TmaSubUnit with id: " + tmaSubUnitData[i].tmaSubUnitId, (Exception)((Object)ascfe));
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "createTmaSubUnit()");
    }

    protected void createRfBranch(ManagedObject antennaUnitGroupMo, RfBranchData[] rfBranchData, Coordinator coordinator) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createRfBranch()");
        if (rfBranchData != null) {
            for (int i = 0; i < rfBranchData.length; ++i) {
                try {
                    AttrListImpl attrList = new AttrListImpl();
                    attrList.addElement("dlAttenuation", (Object)rfBranchData[i].dlAttenuation);
                    attrList.addElement("ulAttenuation", (Object)rfBranchData[i].ulAttenuation);
                    attrList.addElement("dlTrafficDelay", (Object)rfBranchData[i].dlTrafficDelay);
                    attrList.addElement("ulTrafficDelay", (Object)rfBranchData[i].ulTrafficDelay);
                    this.findOrCreateMo("RfBranch", antennaUnitGroupMo, rfBranchData[i].rfBranchId, attrList, coordinator);
                    continue;
                }
                catch (AntennaSystemConfigurationFailedException ascfe) {
                    throw new AntennaSystemConfigurationFailedException("RfBranch configuration failed", "Could not configure RfBranch with id: " + rfBranchData[i].rfBranchId, (Exception)((Object)ascfe));
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "createRfBranch()");
    }

    protected void createAntennaUnitAndChildren(ManagedObject antennaUnitGroupMo, AntennaUnitData[] antennaUnitData, Coordinator coordinator) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createAntennaUnitAndChildren()");
        if (antennaUnitData != null) {
            for (int i = 0; i < antennaUnitData.length; ++i) {
                try {
                    AttrListImpl attrList = new AttrListImpl();
                    if (antennaUnitData[i].mechanicalAntennaTilt != null) {
                        attrList.addElement("mechanicalAntennaTilt", (Object)antennaUnitData[i].mechanicalAntennaTilt);
                    }
                    ManagedObject antennaUnitMo = this.findOrCreateMo("AntennaUnit", antennaUnitGroupMo, antennaUnitData[i].antennaUnitId, attrList, coordinator);
                    this.createAntennaSubUnitAndChildren(antennaUnitMo, antennaUnitData[i].antennaSubUnitData, coordinator);
                    continue;
                }
                catch (AntennaSystemConfigurationFailedException ascfe) {
                    throw new AntennaSystemConfigurationFailedException("AntennaUnit configuration failed", "Could not configure AntennaUnit with id: " + antennaUnitData[i].antennaSubUnitData, (Exception)((Object)ascfe));
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "createAntennaUnitAndChildren()");
    }

    protected void createAntennaSubUnitAndChildren(ManagedObject antennaUnitMo, AntennaSubUnitData[] antennaSubUnitData, Coordinator coordinator) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createAntennaSubUnitAndChildren()");
        if (antennaSubUnitData != null) {
            for (int i = 0; i < antennaSubUnitData.length; ++i) {
                try {
                    AttrListImpl attrList = new AttrListImpl();
                    attrList.addElement("minTotalTilt", (Object)antennaSubUnitData[i].minTotalTilt);
                    if (antennaSubUnitData[i].maxTotalTilt != null) {
                        attrList.addElement("maxTotalTilt", (Object)antennaSubUnitData[i].maxTotalTilt);
                    }
                    ManagedObject antennaSubUnitMo = this.findOrCreateMo("AntennaSubunit", antennaUnitMo, antennaSubUnitData[i].antennaSubUnitId, attrList, coordinator);
                    this.createAuPort(antennaSubUnitMo, antennaSubUnitData[i].auPortData, coordinator);
                    continue;
                }
                catch (AntennaSystemConfigurationFailedException ascfe) {
                    throw new AntennaSystemConfigurationFailedException("AntennaSubUnit configuration failed", "Could not configure AntennaSubUnit with id: " + antennaSubUnitData[i].antennaSubUnitId, (Exception)((Object)ascfe));
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "createAntennaSubUnitAndChildren()");
    }

    protected void createAuPort(ManagedObject antennaSubUnitMo, AuPortData[] auPortData, Coordinator coordinator) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createAuPort()");
        if (auPortData != null) {
            for (int i = 0; i < auPortData.length; ++i) {
                try {
                    this.findOrCreateMo("AuPort", antennaSubUnitMo, auPortData[i].auPortId, new AttrListImpl(), coordinator);
                    continue;
                }
                catch (AntennaSystemConfigurationFailedException ascfe) {
                    throw new AntennaSystemConfigurationFailedException("AuPort configuration failed", "Could not configure AuPort with id: " + auPortData[i].auPortId, (Exception)((Object)ascfe));
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "createAuPort()");
    }

    protected void createMulticastAntennaBranch(ManagedObject antennaUnitGroupMo, MulticastAntennaBranchData[] multicastAntennaBranchData, Coordinator coordinator) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createMulticastAntennaBranch()");
        if (multicastAntennaBranchData != null) {
            for (int i = 0; i < multicastAntennaBranchData.length; ++i) {
                try {
                    this.findOrCreateMo("MulticastAntennaBranch", antennaUnitGroupMo, multicastAntennaBranchData[i].multicastAntennaBranchId, new AttrListImpl(), coordinator);
                    continue;
                }
                catch (AntennaSystemConfigurationFailedException ascfe) {
                    throw new AntennaSystemConfigurationFailedException("MulticastAntennaBranch configuration failed", "Could not configure MulticastAntennaBranch with id: " + multicastAntennaBranchData[i].multicastAntennaBranchId, (Exception)((Object)ascfe));
                }
            }
        }
    }

    private void createAntennaUnitGroupAndChildrenRefs(ManagedObject equipmentMo, AntennaUnitGroupData[] antennaUnitGroupData, Coordinator coordinator) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createAntennaUnitGroupAndChildrenRefs()");
        if (antennaUnitGroupData != null) {
            for (int i = 0; i < antennaUnitGroupData.length; ++i) {
                try {
                    String antennaUnitGroupLdn = equipmentMo.getLocalDistinguishedName() + "," + "AntennaUnitGroup" + "=" + antennaUnitGroupData[i].antennaUnitGroupId;
                    this.createRfBranchRefs(antennaUnitGroupData[i].rfBranchData, antennaUnitGroupLdn, coordinator);
                    this.createExternalTmaRefs(antennaUnitGroupData[i].externalTmaData, antennaUnitGroupLdn, coordinator);
                    this.createAntennaNearUnitAndChildrenRefs(antennaUnitGroupData[i].antennaNearUnitData, antennaUnitGroupLdn, coordinator);
                    this.createMulticastAntennaBranchRefs(antennaUnitGroupData[i].multicastAntennaBranchData, antennaUnitGroupLdn, coordinator);
                    continue;
                }
                catch (AntennaSystemConfigurationFailedException ascfe) {
                    throw new AntennaSystemConfigurationFailedException("Creation of AntennaUnitGroup references failed", "Could not create references for AntennaUnitGroup with id: " + antennaUnitGroupData[i].antennaUnitGroupId, (Exception)((Object)ascfe));
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "createAntennaUnitGroupAndChildrenRefs()");
    }

    private void createRfBranchRefs(RfBranchData[] rfBranchData, String antennaUnitGroupLdn, Coordinator coordinator) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createRfBranchRefs()");
        if (rfBranchData != null) {
            for (int i = 0; i < rfBranchData.length; ++i) {
                String currentRfBranchLdn = antennaUnitGroupLdn + "," + "RfBranch" + "=" + rfBranchData[i].rfBranchId;
                if (rfBranchData[i].auPortRef != null) {
                    ManagedObject[] auPortRef = new ManagedObject[rfBranchData[i].auPortRef.length];
                    for (int j = 0; j < rfBranchData[i].auPortRef.length; ++j) {
                        String toRefLdn = antennaUnitGroupLdn + rfBranchData[i].auPortRef[j];
                        auPortRef[j] = this.findAndCheckMo(toRefLdn);
                    }
                    this.setAuPortRefOnRfBranchMo(coordinator, currentRfBranchLdn, auPortRef);
                }
                if (rfBranchData[i].rfPortRef == null) continue;
                String toRfPortRefLdn = rfBranchData[i].rfPortRef;
                ManagedObject referencedRfPortMo = null;
                try {
                    referencedRfPortMo = this.findAndCheckMo(toRfPortRefLdn);
                }
                catch (AntennaSystemConfigurationFailedException e) {
                    logger.info(THIS_CLASS, "createRfBranchRefs() rfPort with ldn=" + toRfPortRefLdn + " not found, attempt to create");
                }
                if (referencedRfPortMo == null) {
                    int lastIndex = toRfPortRefLdn.lastIndexOf(",");
                    String parentLdnId = null;
                    if (lastIndex >= 0) {
                        parentLdnId = toRfPortRefLdn.substring(0, lastIndex);
                    }
                    ManagedObject parentMo = this.aMoRepository.lookup(parentLdnId);
                    String identity = LdnHelper.getRdnAttributeValue((String)toRfPortRefLdn);
                    MoFactoryMgrWrapper aFactoryMgr = this.aGenericMaoContext.getMoFactoryMgrWrapper();
                    MoFactory rfPortFactory = aFactoryMgr.lookup("RfPort");
                    AttrListImpl attrList = new AttrListImpl();
                    try {
                        referencedRfPortMo = rfPortFactory.createMo(parentMo, (AttrList)attrList, identity, null, coordinator);
                    }
                    catch (MoAccessException mae) {
                        throw new AntennaSystemConfigurationFailedException("Incorrect reference", "Unable to create missing RfPort MO, RfPort reference possibly wrong Check SiteEquipment input fileRfBranch and RfPort", (Exception)((Object)mae));
                    }
                }
                try {
                    referencedRfPortMo.setAttribute("vswrSupervisionActive", (Object)rfBranchData[i].vswrSupervisionActive, coordinator);
                    referencedRfPortMo.setAttribute("vswrSupervisionSensitivity", (Object)rfBranchData[i].vswrSupervisionSensitivity, coordinator);
                }
                catch (MoAccessException e) {
                    throw new AntennaSystemConfigurationFailedException("MO setAttribute problem", "Cant set RfPort attributes", (Exception)((Object)e));
                }
                try {
                    ManagedObject rfBranchMo = this.findAndCheckMo(currentRfBranchLdn);
                    rfBranchMo.setAttribute("rfPortRef", (Object)referencedRfPortMo, coordinator);
                    continue;
                }
                catch (MoAccessException mae) {
                    throw new AntennaSystemConfigurationFailedException("Incorrect reference", "Unable to create reference between RfBranch and RfPort", (Exception)((Object)mae));
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "createRfBranchRefs()");
    }

    private void setAuPortRefOnRfBranchMo(Coordinator coordinator, String currentRfBranchLdn, ManagedObject[] auPortRef) throws AntennaSystemConfigurationFailedException {
        try {
            ManagedObject rfBranchMo = this.findAndCheckMo(currentRfBranchLdn);
            rfBranchMo.setAttribute("auPortRef", (Object)auPortRef, coordinator);
        }
        catch (MoAccessException mae) {
            throw new AntennaSystemConfigurationFailedException("Incorrect reference", "Unable to create reference between RfBranch and AuPort", (Exception)((Object)mae));
        }
    }

    private void createExternalTmaRefs(ExternalTmaData[] externalTmaData, String antennaUnitGroupLdn, Coordinator coordinator) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createExternalTmaRefs()");
        if (externalTmaData != null) {
            for (int i = 0; i < externalTmaData.length; ++i) {
                if (externalTmaData[i].rfPortRef == null) continue;
                String currentExternalTmaLdn = antennaUnitGroupLdn + "," + "ExternalTMA" + "=" + externalTmaData[i].externalTmaId;
                try {
                    ManagedObject currentExternalTma = this.findAndCheckMo(currentExternalTmaLdn);
                    ManagedObject referencedRfPortMo = this.findAndCheckMo(externalTmaData[i].rfPortRef);
                    currentExternalTma.setAttribute("rfPortRef", (Object)referencedRfPortMo, coordinator);
                    continue;
                }
                catch (MoAccessException mae) {
                    throw new AntennaSystemConfigurationFailedException("Incorrect reference", "Unable to create reference between ExternalTMA and RfPort", (Exception)((Object)mae));
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "createExternalTmaRefs()");
    }

    private void setTransceiverRefOnMulticastAntennaBranchMo(Coordinator coordinator, String currentMulticastAntennaBranchLdn, ManagedObject[] transceiverRef) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "setTransceiverRefOnMulticastAntennaBranchMo()");
        try {
            ManagedObject multicastAntennaBranchMo = this.findAndCheckMo(currentMulticastAntennaBranchLdn);
            multicastAntennaBranchMo.setAttribute("transceiverRef", (Object)transceiverRef, coordinator);
        }
        catch (NoSuchAttributeException nsae) {
            throw new AntennaSystemConfigurationFailedException("No such attribute: transceiverRef", "No such attribute for MulticastAntennaBranch: transceiverRef", (Exception)((Object)nsae));
        }
        catch (MoAccessException mae) {
            throw new AntennaSystemConfigurationFailedException("Incorrect reference", "Unable to create reference between MulticastAntennaBranch and Transceiver", (Exception)((Object)mae));
        }
        logger.traceReturn(THIS_CLASS, "setTransceiverRefOnMulticastAntennaBranchMo()");
    }

    private void createMulticastAntennaBranchRefs(MulticastAntennaBranchData[] multicastAntennaBranchData, String antennaUnitGroupLdn, Coordinator coordinator) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createMulticastAntennaBranchRefs()");
        if (multicastAntennaBranchData == null) {
            logger.traceReturn(THIS_CLASS, "createMulticastAntennaBranchRefs(): no input for: " + antennaUnitGroupLdn);
            return;
        }
        for (int i = 0; i < multicastAntennaBranchData.length; ++i) {
            if (multicastAntennaBranchData[i].transceiverRef == null) {
                logger.traceDebug(THIS_CLASS, "no TransceiverRef for MulticastAntennaBranch=" + multicastAntennaBranchData[i].multicastAntennaBranchId);
                continue;
            }
            String currentMulticastAntennaBranchLdn = antennaUnitGroupLdn + "," + "MulticastAntennaBranch" + "=" + multicastAntennaBranchData[i].multicastAntennaBranchId;
            ManagedObject[] transceiverRef = new ManagedObject[multicastAntennaBranchData[i].transceiverRef.length];
            for (int j = 0; j < multicastAntennaBranchData[i].transceiverRef.length; ++j) {
                String toRefLdn = multicastAntennaBranchData[i].transceiverRef[j];
                ManagedObject referencedTransceiverMo = null;
                try {
                    referencedTransceiverMo = this.findAndCheckMo(toRefLdn);
                }
                catch (AntennaSystemConfigurationFailedException e) {
                    ManagedObject parentMo;
                    logger.traceDebug(THIS_CLASS, "createMulticastAntennaBranchRefs() transceiver with ldn=" + toRefLdn + " not found, attempt to create");
                    int lastIndex = toRefLdn.lastIndexOf(",");
                    String parentLdnId = null;
                    if (lastIndex >= 0) {
                        parentLdnId = toRefLdn.substring(0, lastIndex);
                    }
                    if ((parentMo = this.aMoRepository.lookup(parentLdnId)) == null) {
                        throw new AntennaSystemConfigurationFailedException("missing MO: " + parentLdnId, "unable to create Transceiver MO: " + toRefLdn);
                    }
                    String identity = LdnHelper.getRdnAttributeValue((String)toRefLdn);
                    MoFactoryMgrWrapper aFactoryMgr = this.aGenericMaoContext.getMoFactoryMgrWrapper();
                    MoFactory transceiverFactory = aFactoryMgr.lookup("Transceiver");
                    AttrListImpl attrList = new AttrListImpl();
                    try {
                        referencedTransceiverMo = transceiverFactory.createMo(parentMo, (AttrList)attrList, identity, null, coordinator);
                    }
                    catch (MoAccessException mae) {
                        throw new AntennaSystemConfigurationFailedException("Incorrect reference", "Unable to create missing Transceiver MO, Transceiver reference possibly wrong Check SiteEquipment input fileMulticastAntennaBranch and Transceiver", (Exception)((Object)mae));
                    }
                }
                transceiverRef[j] = referencedTransceiverMo;
            }
            this.setTransceiverRefOnMulticastAntennaBranchMo(coordinator, currentMulticastAntennaBranchLdn, transceiverRef);
        }
        logger.traceReturn(THIS_CLASS, "createMulticastAntennaBranchRefs()");
    }

    private void createAntennaNearUnitAndChildrenRefs(AntennaNearUnitData[] antennaNearUnitData, String antennaUnitGroupLdn, Coordinator coordinator) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createAntennaNearUnitAndChildrenRefs()");
        if (antennaNearUnitData != null) {
            for (int i = 0; i < antennaNearUnitData.length; ++i) {
                String referencedRfPortLdn = antennaNearUnitData[i].rfPortRef;
                String antennaNearUnitLdn = antennaUnitGroupLdn + "," + "AntennaNearUnit" + "=" + antennaNearUnitData[i].antennaNearUnitId;
                if (antennaNearUnitData[i].rfPortRef != null) {
                    try {
                        ManagedObject referencedRfPortMo = this.findAndCheckMo(referencedRfPortLdn);
                        ManagedObject currentAntennaNearUnit = this.findAndCheckMo(antennaNearUnitLdn);
                        currentAntennaNearUnit.setAttribute("rfPortRef", (Object)referencedRfPortMo, coordinator);
                    }
                    catch (MoAccessException mae) {
                        throw new AntennaSystemConfigurationFailedException("Incorrect reference", "Unable to create reference between AntennaNearUnit and RfPort", (Exception)((Object)mae));
                    }
                }
                this.createRetSubUnitRefs(antennaNearUnitData[i].retSubUnitData, antennaNearUnitLdn, antennaUnitGroupLdn, coordinator);
                this.createTmaSubUnitRefs(antennaNearUnitData[i].tmaSubUnitData, antennaNearUnitLdn, antennaUnitGroupLdn, coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "createAntennaNearUnitAndChildrenRefs()");
    }

    private void createRetSubUnitRefs(RetSubUnitData[] retSubUnitData, String antennaNearUnitLdn, String antennaUnitGroupLdn, Coordinator coordinator) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createRetSubUnitRefs()");
        if (retSubUnitData != null) {
            for (int i = 0; i < retSubUnitData.length; ++i) {
                if (retSubUnitData[i].antennaSubUnitRef == null) continue;
                String currentRetSubUnitLdn = antennaNearUnitLdn + "," + "RetSubUnit" + "=" + retSubUnitData[i].retSubUnitId;
                String referencedAntennaSubUnitLdn = antennaUnitGroupLdn + retSubUnitData[i].antennaSubUnitRef;
                try {
                    ManagedObject currentRetSubUnitMo = this.findAndCheckMo(currentRetSubUnitLdn);
                    ManagedObject referencedAntennaSubUnitMo = this.findAndCheckMo(referencedAntennaSubUnitLdn);
                    referencedAntennaSubUnitMo.setAttribute("retSubunitRef", (Object)currentRetSubUnitMo, coordinator);
                    continue;
                }
                catch (MoAccessException mae) {
                    throw new AntennaSystemConfigurationFailedException("Incorrect reference", "Unable to create reference between AntennaSubunit and RetSubUnit", (Exception)((Object)mae));
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "createRetSubUnitRefs()");
    }

    private void createTmaSubUnitRefs(TmaSubUnitData[] tmaSubUnitData, String antennaNearUnitLdn, String antennaUnitGroupLdn, Coordinator coordinator) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createTmaSubUnitRefs()");
        if (tmaSubUnitData != null) {
            for (int i = 0; i < tmaSubUnitData.length; ++i) {
                if (tmaSubUnitData[i].rfBranchRef == null) continue;
                String currentTmaSubUnitLdn = antennaNearUnitLdn + "," + "TmaSubUnit" + "=" + tmaSubUnitData[i].tmaSubUnitId;
                String referencedAntennaSubUnitLdn = antennaUnitGroupLdn + tmaSubUnitData[i].rfBranchRef;
                try {
                    ManagedObject referencedRfBranchMo = this.findAndCheckMo(referencedAntennaSubUnitLdn);
                    ManagedObject currentTmaSubUnitMo = this.findAndCheckMo(currentTmaSubUnitLdn);
                    referencedRfBranchMo.setAttribute("tmaRef", (Object)currentTmaSubUnitMo, coordinator);
                    continue;
                }
                catch (MoAccessException mae) {
                    throw new AntennaSystemConfigurationFailedException("Incorrect reference", "Unable to create reference between RfBranch and TmaSubUnit", (Exception)((Object)mae));
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "createTmaSubUnitRefs()");
    }

    protected void createTmfConfiguration(ManagedObject antennaUnitGroupMo, TmfConfigurationData[] tmfConfigurationData, Coordinator coordinator) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createTmfConfiguration()");
        if (tmfConfigurationData != null) {
            for (int i = 0; i < tmfConfigurationData.length; ++i) {
                try {
                    AttrListImpl attrList = new AttrListImpl();
                    attrList.addElement("operatingBand", (Object)tmfConfigurationData[i].operatingBand);
                    attrList.addElement("operatingMode", (Object)tmfConfigurationData[i].operatingMode);
                    attrList.addElement("channelNumber1", (Object)tmfConfigurationData[i].channelNumber1);
                    if (tmfConfigurationData[i].channelNumber2 != null) {
                        attrList.addElement("channelNumber2", (Object)tmfConfigurationData[i].channelNumber2);
                    }
                    if (tmfConfigurationData[i].frequencyDistance != null) {
                        attrList.addElement("frequencyDistance", (Object)tmfConfigurationData[i].frequencyDistance);
                    }
                    if (tmfConfigurationData[i].antBtoRbsB != null) {
                        attrList.addElement("antBtoRbsB", (Object)tmfConfigurationData[i].antBtoRbsB);
                    }
                    if (tmfConfigurationData[i].dcMonitoringRbsA != null) {
                        attrList.addElement("dcMonitoringRbsA", (Object)tmfConfigurationData[i].dcMonitoringRbsA);
                    }
                    if (tmfConfigurationData[i].dcToRetBlocked != null) {
                        attrList.addElement("dcToRetBlocked", (Object)tmfConfigurationData[i].dcToRetBlocked);
                    }
                    if (tmfConfigurationData[i].dcMonitoringAntA != null) {
                        attrList.addElement("dcMonitoringAntA", (Object)tmfConfigurationData[i].dcMonitoringAntA);
                    }
                    if (tmfConfigurationData[i].dcMonitoringAntB != null) {
                        attrList.addElement("dcMonitoringAntB", (Object)tmfConfigurationData[i].dcMonitoringAntB);
                    }
                    this.findOrCreateMo("TmfConfiguration", antennaUnitGroupMo, tmfConfigurationData[i].tmfConfigurationId, attrList, coordinator);
                    continue;
                }
                catch (AntennaSystemConfigurationFailedException ascfe) {
                    throw new AntennaSystemConfigurationFailedException("TmfConfiguration configuration failed", "Could not configure TmfConfiguration with id: " + tmfConfigurationData[i].tmfConfigurationId, (Exception)((Object)ascfe));
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "createTmfConfiguration()");
    }

    public void registerReportLogger(AntennaSystemConfigurationReportLogger reportLogger) {
        logger.traceEnter(THIS_CLASS, "registerReportLogger()");
        if (ConfigurationReportLoggerFactory.getReportFile() != null && ConfigurationReportLoggerFactory.getTheCallbackObject() != null) {
            ReportLoggerHelper.getInstance().registerReportLogger(reportLogger);
        } else {
            String errorMsg = "Programming fault, register of AntennaSystemConfigurationReportLogger has failed. The init method  of class ConfigurationReportLoggerFactory has not beeen called before registerReportLogger, or the file and callbackobject was null. Trying to recover from fault by assuming ConfigurationReportLoggerService has been used for init";
            logger.traceError(THIS_CLASS, errorMsg);
            String filename = ConfigurationReportLoggerService.getConfigurationReportLogger().getDefaultConfigurationReportPath();
            if (filename != null) {
                ReportLoggerHelper.getInstance().registerReportLogger(reportLogger);
                logger.traceGeneral(THIS_CLASS, "Recover was successfull, register of AntennaSystemConfigurationReportLogger is complete");
            }
        }
        logger.traceReturn(THIS_CLASS, "registerReportLogger()");
    }

    private ManagedObject findAndCheckMo(String ldn) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "findAndCheckMo() ldn: " + ldn);
        ManagedObject mo = this.aMoRepository.lookup(ldn);
        if (mo == null) {
            throw new AntennaSystemConfigurationFailedException("MO not found", "Could not find MO with ldn " + ldn + ".");
        }
        logger.traceReturn(THIS_CLASS, "findAndCheckMo()");
        return mo;
    }

    private ManagedObject findOrCreateMo(String moType, ManagedObject parent, String identity, AttrListImpl attrList, Coordinator coordinator) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "findOrCreateMo() " + moType);
        ManagedObject result2 = null;
        String moToFind = parent.getLocalDistinguishedName() + "," + moType + "=" + identity;
        try {
            result2 = this.findAndCheckMo(moToFind);
        }
        catch (AntennaSystemConfigurationFailedException ascfe) {
            result2 = this.createMo(moType, parent, identity, attrList, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "findOrCreateMo() " + moType);
        return result2;
    }

    private ManagedObject createMo(String moType, ManagedObject parent, String identity, AttrListImpl attrList, Coordinator coordinator) throws AntennaSystemConfigurationFailedException {
        ManagedObject createdMo = null;
        MoFactory moFactory = this.findAndCheckFactory(moType);
        AttrListImpl attributeList = new AttrListImpl();
        if (attrList != null) {
            attributeList = attrList;
        }
        try {
            createdMo = moFactory.createMo(parent, (AttrList)attributeList, identity, null, coordinator);
        }
        catch (MoAccessException mae) {
            throw new AntennaSystemConfigurationFailedException("Create failed", "Could not create MO of type " + moType + " with id: " + identity, (Exception)((Object)mae));
        }
        this.logCreate(moType, attrList);
        return createdMo;
    }

    private void logCreate(String moType, AttrListImpl attrList) {
        logger.traceEnter(THIS_CLASS, "logCreate() " + moType);
        if (attrList != null && attrList.size() > 0) {
            String[] names = new String[attrList.size()];
            Object[] values = new Object[attrList.size()];
            for (int index = 0; index < attrList.size(); ++index) {
                names[index] = attrList.getName(index);
                values[index] = attrList.getValue(index);
            }
            ReportLoggerHelper.getInstance().logAction(moType, "create", names, values);
        } else {
            ReportLoggerHelper.getInstance().logAction(moType, "create", "", "");
        }
        logger.traceReturn(THIS_CLASS, "logCreate() " + moType);
    }

    private MoFactory findAndCheckFactory(String moType) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "findAndCheckFactory() " + moType);
        MoFactory moFactory = this.aGenericMaoContext.getMoFactoryMgrWrapper().lookup(moType);
        if (moFactory == null) {
            throw new AntennaSystemConfigurationFailedException("MO factory not found", "Could not find MO factory for type " + moType + ".");
        }
        logger.traceReturn(THIS_CLASS, "findAndCheckFactory() " + moType);
        return moFactory;
    }
}

