/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.antennasystemconfiguration.helper;

import java.util.ArrayList;
import java.util.StringTokenizer;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.AntennaSystemConfigurationFailedException;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.AuPortRefData;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class AntennaSystemConfigurationHelper {
    private static final Class THIS_CLASS = AntennaSystemConfigurationHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    private AntennaSystemConfigurationHelper() {
    }

    public static String convertAntennaSubUnitRef(String unseparatedAntennaSubUnitRef) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "convertAntennaSubUnitRef(), antennaSubUnitRef=" + unseparatedAntennaSubUnitRef);
        String antennaSubUnitRefLdn = null;
        if (unseparatedAntennaSubUnitRef != null) {
            int delimiterPosition = unseparatedAntennaSubUnitRef.indexOf(45);
            if (unseparatedAntennaSubUnitRef.lastIndexOf(45) > delimiterPosition) {
                throw new AntennaSystemConfigurationFailedException("Reference failure", "Unable to convert antennaSubUnitRef: " + unseparatedAntennaSubUnitRef + ". Too many delimiters.");
            }
            String antennaUnitId = null;
            String antennaSubunitId = null;
            try {
                antennaUnitId = unseparatedAntennaSubUnitRef.substring(0, delimiterPosition);
                antennaSubunitId = unseparatedAntennaSubUnitRef.substring(delimiterPosition + 1, unseparatedAntennaSubUnitRef.length());
            }
            catch (IndexOutOfBoundsException iobe) {
                throw new AntennaSystemConfigurationFailedException("Reference failure", "Unable to convert antennaSubUnitRef: " + unseparatedAntennaSubUnitRef);
            }
            antennaSubUnitRefLdn = ",AntennaUnit=" + antennaUnitId + "," + "AntennaSubunit" + "=" + antennaSubunitId;
        }
        logger.traceReturn(THIS_CLASS, "convertAntennaSubUnitRef(), ldn=" + antennaSubUnitRefLdn);
        return antennaSubUnitRefLdn;
    }

    public static String[] convertAuPortRefData(AuPortRefData[] auPortRefData) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "convertAuPortRefData()");
        String[] auPortRefLdnStringArray = null;
        if (auPortRefData != null) {
            auPortRefLdnStringArray = new String[auPortRefData.length];
            for (int i = 0; i < auPortRefData.length; ++i) {
                String unseparatedAuPortId = auPortRefData[i].auPortId;
                int[] delimiterPositions = new int[]{unseparatedAuPortId.indexOf(45), unseparatedAuPortId.indexOf(45, unseparatedAuPortId.indexOf(45) + 1)};
                if (unseparatedAuPortId.lastIndexOf(45) > delimiterPositions[1]) {
                    throw new AntennaSystemConfigurationFailedException("Reference failure", "Unable to convert AuPortRef: " + unseparatedAuPortId + ". Too many delimiters.");
                }
                String antennaUnitId = null;
                String antennaSubunitId = null;
                String auPortId = null;
                try {
                    antennaUnitId = unseparatedAuPortId.substring(0, delimiterPositions[0]);
                    antennaSubunitId = unseparatedAuPortId.substring(delimiterPositions[0] + 1, delimiterPositions[1]);
                    auPortId = unseparatedAuPortId.substring(delimiterPositions[1] + 1, unseparatedAuPortId.length());
                }
                catch (IndexOutOfBoundsException iobe) {
                    throw new AntennaSystemConfigurationFailedException("Reference failure", "Unable to convert AuPortRef: " + unseparatedAuPortId);
                }
                auPortRefLdnStringArray[i] = ",AntennaUnit=" + antennaUnitId + "," + "AntennaSubunit" + "=" + antennaSubunitId + "," + "AuPort" + "=" + auPortId;
            }
        }
        logger.traceReturn(THIS_CLASS, "convertAuPortRefData()");
        return auPortRefLdnStringArray;
    }

    public static String convertRfPortRefToLdn(String ref, MoRepositoryWrapper aMoRepository) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "convertRfPortRefToLdn(), ref=" + ref);
        String convertedRfPortLdn = null;
        if (ref != null) {
            int delimiter = 45;
            int lastIndexOfDelimiter = ref.lastIndexOf(45);
            String parent = null;
            String rfport = null;
            try {
                parent = ref.substring(0, lastIndexOfDelimiter);
                rfport = ref.substring(lastIndexOfDelimiter + 1, ref.length());
            }
            catch (IndexOutOfBoundsException iobe) {
                throw new AntennaSystemConfigurationFailedException("Reference failure", "Unable to convert rfPortRef: " + ref);
            }
            String decodedRuLdn = AntennaSystemConfigurationHelper.decodeRuToLdn(parent);
            ManagedObject decodedRuParentMo = aMoRepository.lookup(decodedRuLdn);
            AntennaSystemConfigurationHelper.checkRuParent(ref, decodedRuParentMo);
            MoIterator decodedRuParentIterator = decodedRuParentMo.getChildren();
            ManagedObject deviceGroup = null;
            ManagedObject auxPlugInUnitChild = null;
            while (decodedRuParentIterator.hasMoreElements()) {
                auxPlugInUnitChild = decodedRuParentIterator.nextMo();
                if (!auxPlugInUnitChild.getType().equalsIgnoreCase("DeviceGroup")) continue;
                deviceGroup = auxPlugInUnitChild;
                break;
            }
            AntennaSystemConfigurationHelper.checkDeviceGroup(decodedRuParentMo, deviceGroup);
            String deviceGroupLdn = deviceGroup.getLocalDistinguishedName();
            convertedRfPortLdn = deviceGroupLdn + "," + "RfPort" + "=" + rfport;
        }
        logger.traceReturn(THIS_CLASS, "convertRfPortRefToLdn(), ldn = " + convertedRfPortLdn);
        return convertedRfPortLdn;
    }

    public static String[] convertTransceiverRefToLdn(String[] transceiverRefs) {
        if (transceiverRefs == null) {
            logger.traceReturn(THIS_CLASS, "no input transceiver references");
            return null;
        }
        String[] transceiverLdn = new String[transceiverRefs.length];
        for (int i = 0; i < transceiverRefs.length; ++i) {
            transceiverLdn[i] = "ManagedElement=1,Equipment=1,AuxPlugInUnit=" + transceiverRefs[i] + "," + "DeviceGroup=rd,Transceiver=1";
        }
        return transceiverLdn;
    }

    private static void checkRuParent(String ref, ManagedObject decodedRuParentMo) throws AntennaSystemConfigurationFailedException {
        if (decodedRuParentMo == null) {
            throw new AntennaSystemConfigurationFailedException("Reference failure", "Unable to decode reference to rfPortRef: " + ref);
        }
    }

    private static void checkDeviceGroup(ManagedObject decodedRuParentMo, ManagedObject deviceGroup) throws AntennaSystemConfigurationFailedException {
        if (deviceGroup == null) {
            throw new AntennaSystemConfigurationFailedException("MO not found", "Could not find DeviceGroup MO under: " + decodedRuParentMo.getLocalDistinguishedName() + ".");
        }
    }

    private static String decodeRuToLdn(String unitRdn) throws AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "decodeRuToLdn(), unitRDN=" + unitRdn);
        String unitLDN = "";
        if (unitRdn.startsWith("RRU")) {
            unitLDN = "ManagedElement=1,Equipment=1,AuxPlugInUnit=" + unitRdn;
        } else if (unitRdn.startsWith("RU") || unitRdn.startsWith("IRU")) {
            int firstSeparator = unitRdn.indexOf(45);
            int secondSeparator = unitRdn.indexOf(45, firstSeparator + 1);
            int thirdSeparator = unitRdn.indexOf(45, secondSeparator + 1);
            try {
                String rbsSubrackId = unitRdn.substring(firstSeparator + 1, secondSeparator);
                String rbsSlotId = thirdSeparator == -1 ? unitRdn.substring(secondSeparator + 1) : unitRdn.substring(secondSeparator + 1, thirdSeparator);
                unitLDN = "ManagedElement=1,Equipment=1,RbsSubrack=" + rbsSubrackId + "," + "RbsSlot" + "=" + rbsSlotId + "," + "AuxPlugInUnit" + "=" + unitRdn;
            }
            catch (IndexOutOfBoundsException iobe) {
                throw new AntennaSystemConfigurationFailedException("Reference failure", "Unable to decode RU: " + unitRdn);
            }
        }
        logger.traceReturn(THIS_CLASS, "decodeRuToLdn(), unitLDN=" + unitLDN);
        return unitLDN;
    }

    public static Integer[] stringToIntArray(String attributeName, String stringValue) {
        logger.traceEnter(THIS_CLASS, "stringToIntArray(" + attributeName + ")");
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(stringValue, ",");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken().trim());
        }
        Integer[] intarr = new Integer[list.size()];
        for (int i = 0; i < intarr.length; ++i) {
            intarr[i] = new Integer((String)list.get(i));
        }
        logger.traceReturn(THIS_CLASS, "stringToIntArray(" + attributeName + ")");
        return intarr;
    }
}

