/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import se.ericsson.cello.commandlog.logcontentcontrol.InspectorRepository;
import se.ericsson.cello.commandlog.logcontentcontrol.LogContentInspector;
import se.ericsson.cello.ipsec.IpSecMaoi;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrNotReadableException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.cat.common.ArrayHelper;
import se.ericsson.crbs.cat.mao.interfaces.AutoIntegrationStartStateMachine;
import se.ericsson.crbs.cat.mao.interfaces.NodeAddressChange;
import se.ericsson.crbs.cat.mao.interfaces.NodeAddressChangeInformer;
import se.ericsson.crbs.cat.mao.nodeaddresschange.NodeAddressChangeParams;
import se.ericsson.crbs.cat.mao.rbsconfiguration.PersistentDataCleaner;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.actions.RbsConfigurationAction;
import se.ericsson.crbs.cat.mao.rbsconfiguration.actions.RbsConfigurationActionFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.geolocationcheck.GeoLocationCheckHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.geolocationcheck.GeoLocationCheckHandlerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.geolocationcheck.GeoLocationCheckHandlerImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.JarFileHelperFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.SensitiveDataHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.OssInformer;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.OssInformerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.AutoIntParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.StateMachineParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.postset.ConfigFaultReasonPostSetExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.postset.PostSetHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.postset.PostSetHandlerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.led.LEDProxyFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.NodeAddressChangeParamsHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.FetchFilesStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.FetchSiteInstallationFileStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.IntegrationNotStartedStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.IpConfigurationStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHandlerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.VlanScanStateExecutor;
import se.ericsson.crbs.common.FileHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.FileLogger;
import se.ericsson.crbs.logging.LogFileWriter;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.common.logger.ConfigurationReportLoggerObserver;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionServicesFactoryImpl;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class RbsConfigurationMaoImpl
extends GenericMao
implements RbsConfigurationMao,
AutoIntegrationStartStateMachine,
NodeAddressChangeInformer,
ConfigurationReportLoggerObserver {
    private static final String NPC_STRING = "npc";
    private static final String SITEEQUIPMENT_STRING = "siteequipment";
    private static final String SITEINSTALLATION_STRING = "siteinstallation";
    private static final String SITEBASIC_STRING = "sitebasic";
    private static final String SUMMARYFILE_STRING = "summaryfile";
    private static final String FILE_NAME_STRING = "File name";
    private static final String PRODUCT_NUMBER_STRING = "Product number";
    private static final String REVISIONS_STRING = "Revisions";
    private static final String SENSITIVE_DATA_FILE_PATH_SYSTEM_PROP_NAME = "sensitivedata_filepath";
    private static final String SENSITIVE_DATA_FILE_PATH;
    private static final String AUTO_INTEGRATION_LOG_FILE_PATH;
    private static final Struct RBS_MODIFIC_STAT_INFO;
    protected String schemaPath = "rbsManagerMetaData/rbsConfiguration/";
    private static final String REV_STRING = "rev";
    private static final String MO_TYPE = "RbsConfiguration";
    public final Integer currentVersion = new Integer(1);
    private static final Class THIS_CLASS;
    private static final AbstractLogger logger;
    private static TransactionFactory transFact;
    private static final int TX_TIMEOUT = 0;
    private final MoRepositoryWrapper aMoRepository;
    private static String supportedConfigVersions;
    protected boolean validateXml = true;
    protected final RbsConfigurationContext rbsConfigurationContext;
    private static final int columnWidth = 25;
    private static final Map cxcVersions;
    private final FileLogger fileLogger;
    private final ProgressReportHandler progressReportHandler;
    private LogFileWriter theWriter;
    private boolean moRestored = false;
    private boolean integrationStarted = false;
    private RbsConfigurationHelper helper = null;
    private final StateHandler stateHandler;
    private final PostSetHandler postSetHandler;
    protected GeoLocationCheckHandler geoLocationCheckHandler = null;
    private String storedFaultSlogan = null;
    private String storedFaultInformation = null;
    private NodeAddressChange nodeAddressChange = null;
    private volatile boolean moppletFinished = false;
    protected static final String PARAM = "param";
    protected static final String NOTSTARTED = "notstarted";
    protected static final String VLANSCAN = "vlanscan";
    protected static final String IPCONFIG = "ipconfig";
    protected static final String FETCHSI = "fetchsi";
    protected static final String FETCHFILES = "fetchfiles";
    protected static final String LED = "led";
    protected static final String LED_15MIN = "led_15min";
    protected static final String VENDORCREDENTIALS = "vendorCredentials";
    private static final String ACTION_TEST_CAPABILITY_HELP = "\nparam [xml]        Set AutoIntParameters\nnotstarted         Run integration not started\nvlanscan           Run vlan scan\nipconfig [xml]     Initial IP configuration\nfetchsi [xml]      Fetch SiteInstallation\nfetchfiles [xml]   Fetch Summery, SiteBaseic and SiteEquipment\nled <visaulState>  Set LED, 1=green fast blink, 3=steedy green, 7=steedy blue, 9=blue off\nled_15min          Change LED visualState every 5s for 15 minutes";
    private static final String[] ACTION_TEST_CAPABILITY_HELP_STRINGS;

    public RbsConfigurationMaoImpl(ManagedObject parent, AttrList attributes, String identity, GenericMaoContext aGenericMaoContext, Integer softwareRevision, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(parent, attributes, identity, MO_TYPE, aGenericMaoContext, softwareRevision, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "RbsConfigurationMaoImpl() - constructor");
        ((InspectorRepository)this.getMaoContext().getServiceRepository().getService(InspectorRepository.class)).register((LogContentInspector)this, MO_TYPE);
        this.rbsConfigurationContext = new RbsConfigurationContext(this.genericMaoContext, this);
        this.progressReportHandler = ProgressReportHandler.getInstance();
        this.fileLogger = LoggingService.getFileLogger();
        this.aMoRepository = aGenericMaoContext.getMoRepositoryWrapper();
        this.helper = (RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class);
        this.helper.createLocalPaths();
        File configReport = new File("/c/logfiles/autointegration" + File.separator + "configurationReport.log");
        ConfigurationReportLoggerFactory.init(this, configReport);
        logger.traceDebug(THIS_CLASS, "ConfigurationReportLogger init(ConfigurationReportLoggerObserver, File)");
        SensitiveDataHelper sensitiveDataHelper = (SensitiveDataHelper)this.rbsConfigurationContext.getHelper(SensitiveDataHelper.class);
        sensitiveDataHelper.setFilePath(SENSITIVE_DATA_FILE_PATH);
        this.stateHandler = StateHandlerFactory.getInstance().getStateHandler(this);
        this.storePersistently("featureActivationTriggered", Boolean.FALSE.toString(), coordinator);
        this.storePersistently("unlockingOfCellsTriggered", Boolean.FALSE.toString(), coordinator);
        this.setCounterAttributesToZero(coordinator);
        this.checkSizeOfConfigurationReportAttribute(coordinator);
        this.postSetHandler = PostSetHandlerFactory.getInstance().getPostSetHandler(this);
        logger.traceReturn(THIS_CLASS, "RbsConfigurationMaoImpl() - constructor");
    }

    private void setCounterAttributesToZero(Coordinator coordinator) throws MoAccessException {
        this.setReadOnlyAttribute("progressReportUpdateCounter", new Integer(0), coordinator);
        this.setReadOnlyAttribute("configurationReportUpdateCounter", new Integer(0), coordinator);
    }

    private void checkSizeOfConfigurationReportAttribute(Coordinator coordinator) {
        try {
            Object reportContent = this.getAttribute("configurationReport", coordinator);
            if (reportContent != null && reportContent instanceof String) {
                String content = (String)reportContent;
                ConfigurationReportLoggerFactory.getLogger().checkSizeOfConfigurationReportAttribute(new StringBuffer(content));
                logger.info(THIS_CLASS, "Successfully check ConfigurationReportAttribute ");
            }
        }
        catch (MoAccessException e) {
            String msg = e.toString() + " :checkSizeOfConfigurationReportAttribute failed: " + e.getMessage();
            if (e.getCause() != null) {
                msg = msg + " Cause: " + e.getCause().getMessage() + e.getVariablesAsString();
            }
            logger.traceError(THIS_CLASS, msg);
        }
    }

    public RbsConfigurationMaoImpl(MoDataWrapper recoveredData, String moType, GenericMaoContext aGenericMaoContext, InitialMaoContext initialmaocontext) throws MoNameAlreadyTakenException, MoAccessException {
        super(recoveredData, moType, aGenericMaoContext, initialmaocontext);
        logger.traceEnter(THIS_CLASS, "RbsConfigurationMaoImpl() - Recover constructor");
        this.moRestored = true;
        ((InspectorRepository)this.getMaoContext().getServiceRepository().getService(InspectorRepository.class)).register((LogContentInspector)this, MO_TYPE);
        this.rbsConfigurationContext = new RbsConfigurationContext(this.genericMaoContext, this);
        this.progressReportHandler = ProgressReportHandler.getInstance();
        this.fileLogger = LoggingService.getFileLogger();
        this.helper = (RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class);
        this.aMoRepository = aGenericMaoContext.getMoRepositoryWrapper();
        this.helper.createLocalPaths();
        File configReport = new File("/c/logfiles/autointegration" + File.separator + "configurationReport.log");
        ConfigurationReportLoggerFactory.init(this, configReport);
        logger.traceDebug(THIS_CLASS, "ConfigurationReportLogger init(ConfigurationReportLoggerObserver, File)");
        Integer configLevel = (Integer)this.getAttribute("rbsConfigLevel", null);
        if (RbsConfigurationDefinitions.RBS_CL_INTEGRATION_COMPLETE.equals(configLevel)) {
            this.helper.setConfigurationStateAndProgressLevel(110);
        }
        SensitiveDataHelper sensitiveDataHelper = (SensitiveDataHelper)this.rbsConfigurationContext.getHelper(SensitiveDataHelper.class);
        sensitiveDataHelper.setFilePath(SENSITIVE_DATA_FILE_PATH);
        this.stateHandler = StateHandlerFactory.getInstance().getStateHandler(this);
        this.postSetHandler = PostSetHandlerFactory.getInstance().getPostSetHandler(this);
        this.geoLocationCheckHandler = GeoLocationCheckHandlerFactory.getInstance().getGeoLocationCheckHandler(1, this);
        if (this.geoLocationCheckHandler != null) {
            this.geoLocationCheckHandler.start();
        }
        logger.traceReturn(THIS_CLASS, "RbsConfigurationMaoImpl() - Recover constructor");
    }

    public ProgressReportHandler getProgressReportHandler() {
        return this.progressReportHandler;
    }

    public void setIntegrationStarted(boolean inIntegrationStarted) {
        this.integrationStarted = inIntegrationStarted;
    }

    public StateHandler getStateHandler() {
        return this.stateHandler;
    }

    public void removeAdditionalAttribute(String attributeName, Coordinator coordinator) {
        super.deleteAdditionalAttribute(attributeName, coordinator);
    }

    public boolean isIntegrationStarted() {
        return this.integrationStarted;
    }

    public void actionCancelRbsIntegration(Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "actionCancelRbsIntegration()");
        if (this.getProgressReportHandler().getIntegrationCanBeCancelled() == Boolean.FALSE) {
            throw new RbsConfigurationFailedException("Cannot cancel Autointegration, RbsIntegrationCanBeCancelled is false");
        }
        RbsConfigurationAction rbsConfigurationAction = RbsConfigurationActionFactory.getInstance().getCancelRbsIntegrationAction(this, coordinator);
        rbsConfigurationAction.execute();
        logger.traceReturn(THIS_CLASS, "actionCancelRbsIntegration()");
    }

    public void actionEnableaiwol(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "actionEnableaiwol()");
        StateMachineParameters.instance(this).setWoLaptopCancelledByUser(Boolean.FALSE.toString(), coordinator);
        this.getProgressReportHandler().setForEnableAiWoLaptop();
        logger.traceReturn(THIS_CLASS, "actionEnableaiwol()");
    }

    public void actionChangeIpForOamSetting(String smrsUserId, String smrsPassword, String summaryFileUrl, String summaryFileHash, String rbsIntegrationCode, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "actionChangeIpForOamSetting()");
        RbsConfigurationAction rbsConfigurationAction = RbsConfigurationActionFactory.getInstance().getChangeIpForOamSettingAction(this, smrsUserId, smrsPassword, summaryFileUrl, summaryFileHash, rbsIntegrationCode, coordinator);
        rbsConfigurationAction.execute();
        logger.traceReturn(THIS_CLASS, "actionChangeIpForOamSetting()");
    }

    public String actionTestCapability(String testCapabilityCommand, Coordinator coordinator) {
        for (int h = 0; h < ACTION_TEST_CAPABILITY_HELP_STRINGS.length; ++h) {
            if (!ACTION_TEST_CAPABILITY_HELP_STRINGS[h].equalsIgnoreCase(testCapabilityCommand)) continue;
            logger.info(THIS_CLASS, ACTION_TEST_CAPABILITY_HELP);
            return ACTION_TEST_CAPABILITY_HELP;
        }
        int spacePos = testCapabilityCommand.indexOf(" ");
        String capability = "";
        String params = "";
        if (spacePos != -1) {
            capability = testCapabilityCommand.substring(0, spacePos).trim();
            params = testCapabilityCommand.substring(spacePos).trim();
        } else {
            capability = testCapabilityCommand.trim();
        }
        if (!(params.length() <= 0 || LED.equalsIgnoreCase(capability) && LED_15MIN.equalsIgnoreCase(capability))) {
            try {
                AutoIntParameters.instance(this).parse(params);
            }
            catch (IOException e) {
                logger.traceError(THIS_CLASS, "Failed to parse parameters", (Throwable)e);
            }
        }
        if (NOTSTARTED.equalsIgnoreCase(capability)) {
            new IntegrationNotStartedStateExecutor(this).execute();
        } else if (VLANSCAN.equalsIgnoreCase(capability)) {
            new VlanScanStateExecutor(this).execute();
        } else if (IPCONFIG.equalsIgnoreCase(capability)) {
            new IpConfigurationStateExecutor(this).execute();
        } else if (FETCHSI.equalsIgnoreCase(capability)) {
            new FetchSiteInstallationFileStateExecutor(this).execute();
        } else if (FETCHFILES.equalsIgnoreCase(capability)) {
            new FetchFilesStateExecutor(this).execute();
        } else if (LED.equalsIgnoreCase(capability)) {
            LEDProxyFactory.getLEDProxy().setLEDVisualState(Integer.parseInt(params));
        } else if (LED_15MIN.equalsIgnoreCase(capability)) {
            this.fifteenMinuteLedToggling();
        } else if (VENDORCREDENTIALS.equalsIgnoreCase(capability)) {
            logger.info(THIS_CLASS, "Start action VendorCrdentials.Please wait...");
            this.vendorCredentials(coordinator);
        } else {
            return "Unknown command:" + testCapabilityCommand;
        }
        return "OK";
    }

    private void vendorCredentials(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, VENDORCREDENTIALS);
        ManagedObject IpSecMo = null;
        IpSecMaoi myOwnIpSecMo = null;
        MoIterator myIterator = this.aMoRepository.lookupType("IpSec");
        if (myIterator != null) {
            while (myIterator.hasMoreElements()) {
                IpSecMo = (ManagedObject)myIterator.nextElement();
                myOwnIpSecMo = (IpSecMaoi)IpSecMo;
                try {
                    if (myOwnIpSecMo == null) continue;
                    logger.info(THIS_CLASS, "Action to set VendorCredentials " + IpSecMo.getLocalDistinguishedName());
                    long currentVC = myOwnIpSecMo.getVendorCredentials(coordinator);
                    if (currentVC == 0L) {
                        myOwnIpSecMo.setVendorCredentials(1L, coordinator);
                    } else {
                        myOwnIpSecMo.setVendorCredentials(0L, coordinator);
                    }
                    logger.info(THIS_CLASS, "Get VendorCredentials");
                    long status = myOwnIpSecMo.getVendorCredentials(coordinator);
                    logger.info(THIS_CLASS, "and the result is " + status);
                }
                catch (MoAccessException e) {
                    logger.traceError(THIS_CLASS, "Failed to set/get VendorCredentials ");
                }
            }
        } else {
            logger.info(THIS_CLASS, "MO IpSec not found");
        }
        logger.traceReturn(THIS_CLASS, VENDORCREDENTIALS);
    }

    private void fifteenMinuteLedToggling() {
        new Thread(){

            public void run() {
                logger.info(THIS_CLASS, "LED toggling started");
                int totalNbrTogglingLoops = 45;
                for (int i = 0; i < 45; ++i) {
                    logger.traceDebug(THIS_CLASS, (45 - i) * 20 + " seconds of LED toggling remaining");
                    logger.traceDebug(THIS_CLASS, "GREEN_LED_FAST_BLINK");
                    LEDProxyFactory.getLEDProxy().setLEDVisualState(1);
                    RbsConfigurationMaoImpl.this.fiveSec();
                    logger.traceDebug(THIS_CLASS, "BLUE_LED_STEADY_ON");
                    LEDProxyFactory.getLEDProxy().setLEDVisualState(7);
                    RbsConfigurationMaoImpl.this.fiveSec();
                    logger.traceDebug(THIS_CLASS, "GREEN_LED_STEADY_ON");
                    LEDProxyFactory.getLEDProxy().setLEDVisualState(3);
                    RbsConfigurationMaoImpl.this.fiveSec();
                    logger.traceDebug(THIS_CLASS, "BLUE_LED_OFF");
                    LEDProxyFactory.getLEDProxy().setLEDVisualState(9);
                    RbsConfigurationMaoImpl.this.fiveSec();
                }
                logger.info(THIS_CLASS, "LED toggling stopped");
            }
        }.start();
    }

    private void fiveSec() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ie) {
            logger.traceDebug(THIS_CLASS, "Thread interrupted while sleeping. " + ie);
        }
    }

    public void actionModifyConfiguration(String parametersXml, Coordinator coordinator) {
        this.actionTestCapability(parametersXml, coordinator);
    }

    public void actionSetUniqueLogicalName(String inputUniqueLogicalName, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionSetUniqueLogicalName()");
        RbsConfigurationAction rbsConfigurationAction = RbsConfigurationActionFactory.getInstance().getSetUniqueLogicalNameAction(this, inputUniqueLogicalName, coordinator);
        rbsConfigurationAction.execute();
        logger.traceReturn(THIS_CLASS, "actionSetUniqueLogicalName()");
    }

    public void actionStartProductionTestConfiguration(String inputSiteBasicFilePath, String inputRbsEquipmentFilePath, String inputProductionTestConfFilePath, String inputLogicalName, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "actionStartProductionTestConfiguration()");
        RbsConfigurationAction rbsConfigurationAction = RbsConfigurationActionFactory.getInstance().getStartProductionTestConfigurationAction(this, inputSiteBasicFilePath, inputRbsEquipmentFilePath, inputProductionTestConfFilePath, inputLogicalName, this.validateXml);
        rbsConfigurationAction.execute();
        logger.traceReturn(THIS_CLASS, "actionStartProductionTestConfiguration()");
    }

    public void actionStartRbsIntegration(String parametersXml, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "actionStartRbsIntegration()");
        RbsConfigurationAction rbsConfigurationAction = RbsConfigurationActionFactory.getInstance().getStartRbsIntegrationAction(this, parametersXml, coordinator);
        rbsConfigurationAction.execute();
        logger.traceReturn(THIS_CLASS, "actionStartRbsIntegration()");
    }

    public void actionStartNetworkLoader(String guiParameters, String sif, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "actionStartNetworkLoader()");
        RbsConfigurationAction rbsConfigurationAction = RbsConfigurationActionFactory.getInstance().getStartNetworkLoaderAction(this, guiParameters, sif);
        rbsConfigurationAction.execute();
        logger.traceReturn(THIS_CLASS, "actionStartNetworkLoader()");
    }

    public void actionStartAutoIntegration(Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "actionStartAutoIntegration()");
        RbsConfigurationAction rbsConfigurationAction = RbsConfigurationActionFactory.getInstance().getStartAutoIntegrationAction(this);
        rbsConfigurationAction.execute();
        logger.traceReturn(THIS_CLASS, "actionStartAutoIntegration()");
    }

    public void actionStoreConfigurationReport(String inputSmrsUserId, String inputSmrsPassword, String inputSmrsAddress, String inputConfigReportFilePath, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "actionStoreConfigurationReport()");
        RbsConfigurationAction rbsConfigurationAction = RbsConfigurationActionFactory.getInstance().getStoreConfigurationReportAction(this, inputSmrsUserId, inputSmrsPassword, inputSmrsAddress, inputConfigReportFilePath);
        rbsConfigurationAction.execute();
        logger.traceReturn(THIS_CLASS, "actionStoreConfigurationReport()");
    }

    public void actionUpdateRbsIntegrationParameters(String updatedParametersXml, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "actionUpdateRbsIntegrationParameters()");
        RbsConfigurationAction rbsConfigurationAction = RbsConfigurationActionFactory.getInstance().getUpdateRbsIntegrationParametersAction(this, updatedParametersXml);
        rbsConfigurationAction.execute();
        logger.traceReturn(THIS_CLASS, "actionUpdateRbsIntegrationParameters()");
    }

    public void cleanPersistentAttributesAndRemoveFiles(String cleanupReason) {
        PersistentDataCleaner persistentAttributesCleaner = new PersistentDataCleaner(this);
        persistentAttributesCleaner.cleanPersistentAttributesAndRemoveFiles(cleanupReason);
    }

    public final Object getAttribute(String attributeName) throws MoAccessException {
        Object result2 = null;
        while (true) {
            try {
                Control control = transFact.create(0);
                Coordinator coordinator = control.getCoordinator();
                try {
                    result2 = this.getAttribute(attributeName, coordinator);
                }
                catch (MoAccessException mae) {
                    control.getTerminator().rollback();
                    throw mae;
                }
                control.getTerminator().commit();
                break;
            }
            catch (TransactionRolledBackException e) {
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, "Rollback failed!", "Transaction failure. Retrying.");
            }
            catch (InactiveTransactionException e) {
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, "Rollback failed!", "Transaction failure. Retrying.");
            }
            this.helper.waitForRetry("getAttribute(" + attributeName + ")");
        }
        return result2;
    }

    public final Object getAttribute(String attributeName, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        Object result2 = null;
        if ("supportedConfigFileRevisions".equalsIgnoreCase(attributeName)) {
            result2 = supportedConfigVersions;
            if (result2 == null) {
                result2 = this.handleSupportedVersions();
            }
        } else {
            result2 = "rbsModificationStateInfo".equalsIgnoreCase(attributeName) ? RBS_MODIFIC_STAT_INFO : super.getAttribute(attributeName, coordinator);
        }
        return result2;
    }

    public Object[] getAttributes(String[] attrNames, Coordinator context) throws MoAccessException, NoSuchAttributeException {
        Object[] result2 = new Object[attrNames.length];
        for (int i = 0; i < attrNames.length; ++i) {
            result2[i] = this.getAttribute(attrNames[i], context);
        }
        return result2;
    }

    private String handleSupportedVersions() throws AttrNotReadableException {
        logger.traceEnter(THIS_CLASS, "handleSupportedVersions()");
        StringBuffer resultingString = this.createOutputHeadings();
        try {
            List sortedOriginalFileNames;
            String jarFilePath = JarFileHelperFactory.getInstance().getJarFileHelper().getJarFilePathFromResource(this.schemaPath);
            if (jarFilePath != null && !(sortedOriginalFileNames = this.getConfigFileNames(jarFilePath)).isEmpty()) {
                resultingString.append(this.createFileTableOutput(sortedOriginalFileNames));
            }
        }
        catch (IOException e) {
            throw new AttrNotReadableException((ManagedObject)this, "supportedConfigFileRevisions");
        }
        supportedConfigVersions = resultingString.toString();
        logger.traceReturn(THIS_CLASS, "handleSupportedVersions()");
        return supportedConfigVersions;
    }

    private List getConfigFileNames(String jarFileName) throws IOException {
        ArrayList<String> dtdFileNames = new ArrayList<String>();
        ArrayList<String> xsdFileNames = new ArrayList<String>();
        JarFile jarFile = new JarFile(jarFileName);
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            String fileName;
            JarEntry entry = jarEntries.nextElement();
            if (entry.getName().startsWith(this.schemaPath) && entry.getName().endsWith(".dtd")) {
                fileName = entry.getName().substring(entry.getName().lastIndexOf("/") + 1);
                dtdFileNames.add(fileName);
                continue;
            }
            if (!entry.getName().startsWith(this.schemaPath) || !entry.getName().endsWith(".xsd")) continue;
            fileName = entry.getName().substring(entry.getName().lastIndexOf("/") + 1);
            xsdFileNames.add(fileName);
        }
        Collections.sort(dtdFileNames);
        Collections.sort(xsdFileNames);
        ArrayList<String> sortedOriginalFileNames = new ArrayList<String>();
        sortedOriginalFileNames.addAll(dtdFileNames);
        sortedOriginalFileNames.addAll(xsdFileNames);
        return sortedOriginalFileNames;
    }

    private StringBuffer createFileTableOutput(List sortedOriginalFileNames) {
        logger.traceEnter(THIS_CLASS, "createFileTableOutput()");
        StringBuffer fileTableOutput = new StringBuffer("");
        Iterator fileNameIterator = sortedOriginalFileNames.iterator();
        String currentFileName = "";
        String oldFileName = "";
        while (fileNameIterator.hasNext()) {
            String originalFileName = (String)fileNameIterator.next();
            if (!originalFileName.endsWith(".dtd") && !originalFileName.endsWith(".xsd")) continue;
            int revIndex = originalFileName.toLowerCase(Locale.getDefault()).indexOf(REV_STRING);
            currentFileName = this.getFileName(originalFileName, revIndex);
            String productNumber = this.getProductNumber(currentFileName);
            if (productNumber != null) {
                if (oldFileName.equalsIgnoreCase(currentFileName)) {
                    fileTableOutput.append(",");
                    fileTableOutput.append(this.getRevision(originalFileName, revIndex));
                } else {
                    fileTableOutput.append("\n");
                    fileTableOutput.append(currentFileName);
                    fileTableOutput.append(this.createWhiteSpaceString(25 - currentFileName.length()));
                    fileTableOutput.append(productNumber);
                    fileTableOutput.append(this.createWhiteSpaceString(25 - productNumber.length()));
                    fileTableOutput.append(this.getRevision(originalFileName, revIndex));
                }
            }
            oldFileName = currentFileName;
        }
        logger.traceReturn(THIS_CLASS, "createFileTableOutput()");
        return fileTableOutput;
    }

    private StringBuffer createOutputHeadings() {
        StringBuffer resultingString = new StringBuffer("\nFile name");
        resultingString.append(this.createWhiteSpaceString(25 - FILE_NAME_STRING.length()));
        resultingString.append(PRODUCT_NUMBER_STRING);
        this.createWhiteSpaceString(25 - PRODUCT_NUMBER_STRING.length());
        resultingString.append(this.createWhiteSpaceString(25 - PRODUCT_NUMBER_STRING.length()));
        resultingString.append(REVISIONS_STRING);
        return resultingString;
    }

    private StringBuffer createWhiteSpaceString(int whiteSpacesToAdd) {
        StringBuffer whiteSpaces = new StringBuffer("");
        for (int addedWhiteSpaces = 0; addedWhiteSpaces < whiteSpacesToAdd; ++addedWhiteSpaces) {
            whiteSpaces.append(" ");
        }
        return whiteSpaces;
    }

    private String getFileName(String originalFileName, int revIndex) {
        String modifiedFileName = null;
        if (originalFileName != null && originalFileName.length() > 4) {
            String firstPartOfFileName = originalFileName.substring(0, revIndex);
            String fileExtension = originalFileName.substring(originalFileName.length() - 4, originalFileName.length());
            modifiedFileName = firstPartOfFileName + fileExtension;
        }
        return modifiedFileName;
    }

    private String getProductNumber(String fileName) {
        String result2 = null;
        if (fileName != null) {
            if (fileName.toLowerCase(Locale.getDefault()).startsWith(SUMMARYFILE_STRING)) {
                result2 = (String)cxcVersions.get("AutoIntegrationRbsSummaryFile");
            } else if (fileName.toLowerCase(Locale.getDefault()).startsWith(SITEBASIC_STRING)) {
                result2 = (String)cxcVersions.get("SiteBasic");
            } else if (fileName.toLowerCase(Locale.getDefault()).startsWith(SITEINSTALLATION_STRING)) {
                result2 = (String)cxcVersions.get("RbsSiteInstallationFile");
            } else if (fileName.toLowerCase(Locale.getDefault()).startsWith(SITEEQUIPMENT_STRING)) {
                result2 = (String)cxcVersions.get("SiteEquipment");
            } else if (fileName.toLowerCase(Locale.getDefault()).startsWith(NPC_STRING)) {
                result2 = (String)cxcVersions.get("NpcConfig");
            }
        }
        return result2;
    }

    private Object getRevision(String originalFileName, int revIndex) {
        String revision = null;
        if (originalFileName != null && originalFileName.length() > 4) {
            revision = originalFileName.substring(revIndex + 3, originalFileName.length() - 4);
        }
        return revision;
    }

    public void postSet(String attributeName, Object attributeValue, Coordinator coordinator) {
        if ("rbsConfigLevel".equalsIgnoreCase(attributeName)) {
            this.stateHandler.checkAndSetIntegrationCanBeStarted(coordinator);
            Integer rbsConfigurationLevel = (Integer)attributeValue;
            this.postSetHandler.registerExecutorBasedOnConfigLevel(rbsConfigurationLevel);
        } else if ("configFaultReason".equalsIgnoreCase(attributeName)) {
            ConfigFaultReasonPostSetExecutor configFaultReasonPostSetExecutor = new ConfigFaultReasonPostSetExecutor(this.getStoredFaultSlogan(), this.getStoredFaultInformation(), attributeValue, this);
            this.postSetHandler.registerExecutor(configFaultReasonPostSetExecutor);
        }
    }

    public void resetProgressInformation() {
        logger.traceEnter(THIS_CLASS, "resetProgressInformation()");
        try {
            ConfigurationReportLoggerFactory.getLogger().logFailure("Configuration failed", "The configuration has failed, no configuration performed." + System.getProperty("line.separator") + System.getProperty("line.separator"));
            this.progressReportHandler.init("", "", this);
            this.progressReportHandler.setProgressReport(this.progressReportHandler.getProgressReport(), false, null);
            this.setReadOnlyAttribute("progressLevel", new Integer(0));
        }
        catch (MoAccessException e) {
            logger.traceGeneral(THIS_CLASS, "Exception caught and ignored!");
        }
        logger.traceReturn(THIS_CLASS, "resetProgressInformation()");
    }

    public final Object retrievePersistently(String attributeName) {
        logger.traceEnter(THIS_CLASS, "retrievePersistently(" + attributeName + ")");
        Object result2 = null;
        while (true) {
            try {
                Control control = transFact.create(0);
                Coordinator coordinator = control.getCoordinator();
                try {
                    result2 = this.getAdditionalAttribute(attributeName, coordinator);
                }
                catch (MoAccessException mae) {
                    logger.traceError(THIS_CLASS, "The persistently stored attribute " + attributeName + " could not be retrieved.", (Throwable)mae);
                }
                if (result2 == null) {
                    logger.traceDebug(THIS_CLASS, "The retrieved additional attribute: " + attributeName + " was null. It might have been deleted or never initialized!.");
                }
                control.getTerminator().commit();
                break;
            }
            catch (TransactionRolledBackException e) {
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, "Framwork failed!", "Transaction failure. Retrying.");
            }
            catch (InactiveTransactionException e) {
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, "Framwork failed!", "Transaction failure. Retrying.");
            }
            this.helper.waitForRetry("retrievePersistently()");
        }
        logger.traceReturn(THIS_CLASS, "retrievePersistently(" + attributeName + ")");
        return result2;
    }

    public void setFaultReason(Integer faultReason, String faultSlogan, String faultInformation, Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "setFaultReason() - reason = " + faultReason + ", slogan = " + faultSlogan);
        this.storeFaultDataForPostSet(faultSlogan, faultInformation);
        String faultInfo = faultInformation == null ? " " : faultInformation;
        String faultInformationTrunked = faultInfo.length() < 128 ? faultInfo : faultInfo.substring(0, 125) + "..";
        logger.traceGeneral(THIS_CLASS, "Fault in auto integration: " + faultSlogan + " - " + faultInfo);
        try {
            StructImpl configFaultReason = new StructImpl(new String[]{"faultReason", "faultInformation"}, new Object[]{faultReason, faultInformationTrunked});
            if (coordinator == null) {
                this.setAttribute("configFaultReason", configFaultReason);
            } else {
                this.setAttribute("configFaultReason", configFaultReason, coordinator);
            }
        }
        catch (MoAccessException mae) {
            logger.traceError(THIS_CLASS, "setFaultReason(faultReason - " + faultReason + ",faultSlogan - " + faultSlogan + ",faultInformation,coordinator)" + "Could not set configFaultReason attribute in the RbsConfiguration MO" + mae.getVariablesAsString());
        }
        logger.traceReturn(THIS_CLASS, "setFaultReason()");
    }

    public void setAttribute(String attributeName, Object attributeValue) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAttribute(name, value) - " + attributeName);
        while (true) {
            try {
                Control control = transFact.create(0);
                Coordinator coordinator = control.getCoordinator();
                try {
                    this.setAttribute(attributeName, attributeValue, coordinator);
                }
                catch (MoAccessException mae) {
                    control.getTerminator().rollback();
                    throw mae;
                }
                control.getTerminator().commit();
                break;
            }
            catch (TransactionRolledBackException e) {
                logger.traceError(THIS_CLASS, "Received TransactionRolledBackException exception when setting attribute: " + attributeName, (Throwable)e);
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, "Framwork failed!", "Transaction failure. Retrying.");
            }
            catch (InactiveTransactionException e) {
                logger.traceError(THIS_CLASS, "Received InactiveTransactionException exception when setting attribute: " + attributeName, (Throwable)e);
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, "Framwork failed!", "Transaction failure. Retrying.");
            }
            this.helper.waitForRetry("setAttribute(name, value)");
        }
        logger.traceReturn(THIS_CLASS, "setAttribute()");
    }

    private void throwIfInvalidWantedPosition(Object attributeValue) throws MoAccessException {
        Struct wantedPosition = (Struct)attributeValue;
        String latitude = (String)wantedPosition.getValue("latitude");
        String longitude = (String)wantedPosition.getValue("longitude");
        String altitude = (String)wantedPosition.getValue("altitude");
        Object tolerance = wantedPosition.getValue("tolerance");
        if (!GeoLocationCheckHandlerImpl.verifyWantedPositionFormatting(latitude, longitude, altitude) || !(tolerance instanceof Integer)) {
            String msg = "rbsConfiguration.wantedPosition is not correctly formatted: (latitude=\"" + latitude + "\", longitude=\"" + longitude + "\", altitude=\"" + altitude + "\", tolerance=\"" + tolerance + "\")";
            logger.traceParam(THIS_CLASS, msg);
            throw new IllegalAttributeValueException(msg, MO_TYPE);
        }
    }

    public void setAttribute(String attributeName, Object attributeValue, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAttribute(name, value, coordinator) - " + attributeName);
        if ("wantedPosition".equalsIgnoreCase(attributeName)) {
            this.throwIfInvalidWantedPosition(attributeValue);
            this.geoLocationCheckHandler = GeoLocationCheckHandlerFactory.getInstance().getGeoLocationCheckHandler(2, this);
            if (this.geoLocationCheckHandler != null) {
                this.geoLocationCheckHandler.start();
            }
        }
        super.setAttribute(attributeName, attributeValue, coordinator);
        logger.traceReturn(THIS_CLASS, "setAttribute(name, value, coordinator) - " + attributeName);
    }

    public void setWantedPosition(String longitude, String latitude, String altitude, Integer tolerance) throws MoAccessException, InactiveTransactionException, TransactionRolledBackException {
        logger.traceEnter(THIS_CLASS, "setWantedPosition()");
        StructImpl wantedPositionStruct = new StructImpl(new String[]{"longitude", "latitude", "altitude", "tolerance"}, new Object[]{longitude, latitude, altitude, tolerance});
        Control control = transFact.create(0);
        Coordinator coordinator = control.getCoordinator();
        try {
            this.throwIfInvalidWantedPosition(wantedPositionStruct);
            super.setAttribute("wantedPosition", (Object)wantedPositionStruct, coordinator);
        }
        catch (MoAccessException moe) {
            logger.traceError(THIS_CLASS, "Unable to set wanted position:\n" + moe.getMessage() + "\n" + moe.getStackTrace());
            control.getTerminator().rollback();
            throw moe;
        }
        control.getTerminator().commit();
        logger.traceReturn(THIS_CLASS, "setWantedPosition()");
    }

    public void setAttributes(String[] attributeNames, Object[] attributeValues, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAttributes(name, value, coordinator)");
        for (int i = 0; i < attributeNames.length; ++i) {
            if (!"wantedPosition".equalsIgnoreCase(attributeNames[i])) continue;
            this.throwIfInvalidWantedPosition(attributeValues[i]);
            this.geoLocationCheckHandler = GeoLocationCheckHandlerFactory.getInstance().getGeoLocationCheckHandler(2, this);
            if (this.geoLocationCheckHandler == null) continue;
            this.geoLocationCheckHandler.start();
        }
        super.setAttributes(attributeNames, attributeValues, coordinator);
        logger.traceReturn(THIS_CLASS, "setAttributes(name, value, coordinator)");
    }

    public void setReadOnlyAttribute(String attributeName, Object attributeValue) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setReadOnlyAttribute(name, value) - " + attributeName);
        while (true) {
            try {
                Control control = transFact.create(0);
                Coordinator coordinator = control.getCoordinator();
                try {
                    this.setReadOnlyAttribute(attributeName, attributeValue, coordinator);
                }
                catch (MoAccessException mae) {
                    control.getTerminator().rollback();
                    throw mae;
                }
                control.getTerminator().commit();
                break;
            }
            catch (TransactionRolledBackException e) {
                logger.traceError(THIS_CLASS, "Unexpected exception: " + e.getLocalizedMessage());
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, "Rollback failed!", "Transaction failure. Retrying.");
            }
            catch (InactiveTransactionException e) {
                logger.traceError(THIS_CLASS, "Unexpected exception: " + e.getLocalizedMessage());
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, "Rollback failed!", "Transaction failure. Retrying.");
            }
            this.helper.waitForRetry("setReadOnlyAttribute(name, value)");
            logger.traceDebug(THIS_CLASS, "Waiting for " + attributeName + " to be set.");
        }
        logger.traceReturn(THIS_CLASS, "setReadOnlyAttribute()");
    }

    public LogFileWriter getProgressReportFileHandler() {
        return this.theWriter;
    }

    public boolean isMoRestored() {
        return this.moRestored;
    }

    public final void storePersistently(String attributeName, Object attributeValue) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "storePersistently()");
        while (true) {
            try {
                Control control = transFact.create(0);
                Coordinator coordinator = control.getCoordinator();
                int id = coordinator.getTransactionID();
                try {
                    this.setAdditionalAttribute(attributeName, attributeValue, coordinator);
                    control.getTerminator().commit();
                }
                catch (MoAccessException mae) {
                    control.getTerminator().rollback();
                    String msg = "Failed to persistently store attributes. (" + attributeName + "," + attributeValue.toString() + ") Transaction (ID:" + id + ")";
                    this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "Internal failure", msg);
                    logger.traceError(THIS_CLASS, msg, (Throwable)mae);
                    throw mae;
                }
                logger.traceReturn(THIS_CLASS, "storePersistently()");
                break;
            }
            catch (TransactionRolledBackException e) {
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, "Rollback failure", "Transaction failure. Retrying");
            }
            catch (InactiveTransactionException e) {
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, "Rollback failure", "Transaction failure. Retrying");
            }
            this.helper.waitForRetry("storePersistently" + attributeName);
        }
    }

    public final void storePersistently(String attributeName, Object attributeValue, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "storePersistently(coordinator)");
        try {
            this.setAdditionalAttribute(attributeName, attributeValue, coordinator);
            logger.traceReturn(THIS_CLASS, "storePersistently(coordinator)");
        }
        catch (MoAccessException mae) {
            String msg = "Failed to persistently store attributes.";
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "Internal failure", "Failed to persistently store attributes.", coordinator);
            logger.traceError(THIS_CLASS, "Failed to persistently store attributes.", (Throwable)mae);
            throw mae;
        }
    }

    public Object[] hideHazardousActionParameters(String actionName, Object[] parameters) {
        logger.traceEnter(THIS_CLASS, "hideHazardousActionParameters() action: " + actionName);
        Object[] result2 = null;
        if ("startRbsAutoIntegration".equalsIgnoreCase(actionName)) {
            result2 = ArrayHelper.replaceObject(parameters, 3, "[HIDDEN]");
            result2 = ArrayHelper.replaceObject(result2, 15, "[HIDDEN]");
        } else if ("storeConfigurationReport".equalsIgnoreCase(actionName)) {
            result2 = ArrayHelper.replaceObject(parameters, 1, "[HIDDEN]");
        } else if ("startRbsIntegration".equalsIgnoreCase(actionName)) {
            try {
                AutoIntParameters autoIntParameters = AutoIntParameters.instance(this);
                autoIntParameters.parse(parameters[0].toString());
                autoIntParameters.getFileParameters().setSmrsPassword("[HIDDEN]");
                autoIntParameters.getSecurityParameters().setIntegrationCode("[HIDDEN]");
                result2 = new String[]{autoIntParameters.getAsXml()};
            }
            catch (IOException e) {
                result2 = new String[]{"Could not hide hazardous parameters in XML string due to: " + e.getMessage()};
            }
        }
        logger.traceReturn(THIS_CLASS, "hideHazardousActionParameters()");
        return result2;
    }

    public Object[] hideHazardousAttributeValues(AttrList arg0) {
        return null;
    }

    public RbsConfigurationContext getRbsConfigurationContext() {
        return this.rbsConfigurationContext;
    }

    private void storeFaultDataForPostSet(String faultSlogan, String faultInformation) {
        this.storedFaultSlogan = faultSlogan;
        this.storedFaultInformation = faultInformation;
    }

    private String getStoredFaultSlogan() {
        String result2 = this.storedFaultSlogan;
        this.storedFaultSlogan = null;
        return result2;
    }

    private String getStoredFaultInformation() {
        String result2 = this.storedFaultInformation;
        this.storedFaultInformation = null;
        return result2;
    }

    public void startStateMachine() {
        this.getStateHandler().start();
    }

    public void notifyMoppletFinished() {
        this.moppletFinished = true;
    }

    public void init(NodeAddressChange nodeAddressChangeIn) {
        this.nodeAddressChange = nodeAddressChangeIn;
    }

    public void informOss(NodeAddressChangeParams params) {
        logger.traceEnter(THIS_CLASS, "informOss()");
        OssInformer ossInformer = OssInformerFactory.createOssInformer(this.rbsConfigurationContext);
        NodeAddressChangeParams nodeAddressChangeParams = NodeAddressChangeParamsHandler.getNodeAddressChangeParams(this.rbsConfigurationContext.getRbsConfigurationMao());
        if (params.getWantedIpSecLevel() == 0) {
            ossInformer.informOss(params.getDn(), params.getIpAddress());
        } else {
            ossInformer.nodeSecurityAddressChanged(params.getDn(), params.getIpAddress(), params.getSshKey(), params.getInstallerName(), params.getWantedSecLevel(), params.getMinimumSecLevel(), params.getReachedSecLevel(), params.getSecurityChecksums(), params.getSecurityChecksumVersion(), params.getOamCertSerNo(), params.getOamCertFingerPrint(), params.getWantedIpSecLevel(), params.getReachedIpSecLevel(), nodeAddressChangeParams.getiPSecCUSCertSerNo(), nodeAddressChangeParams.getiPSecCUSCertFingerPrint());
        }
        logger.traceReturn(THIS_CLASS, "informOss()");
    }

    public NodeAddressChange getNodeAddressChange() {
        return this.nodeAddressChange;
    }

    public FileLogger getFileLogger() {
        return this.fileLogger;
    }

    public void integrationStarted() {
        logger.traceEnter(THIS_CLASS, "integrationStarted()");
        try {
            this.theWriter = new LogFileWriter(new LogFileWriter.LogFile(AUTO_INTEGRATION_LOG_FILE_PATH, false));
            this.fileLogger.connectLogFileWriter(this.theWriter);
        }
        catch (IOException e) {
            String msg = e.toString() + " :Writing file:" + AUTO_INTEGRATION_LOG_FILE_PATH + " has failed, see: " + e.getMessage();
            if (e.getCause() != null) {
                msg = msg + " Cause info: " + e.getCause().getMessage();
            }
            logger.traceError(THIS_CLASS, msg);
            this.theWriter = null;
        }
        List mylist = new ArrayList();
        mylist = this.fileLogger.getDefaultNameOfPackages();
        this.fileLogger.startLogListner(mylist, logger);
        logger.info(THIS_CLASS, "Logging to file is enabled");
        logger.traceReturn(THIS_CLASS, "integrationStarted()");
    }

    public void integrationContinued() {
        logger.traceEnter(THIS_CLASS, "integrationContinued()");
        try {
            this.theWriter = new LogFileWriter(new LogFileWriter.LogFile(AUTO_INTEGRATION_LOG_FILE_PATH, true));
            this.fileLogger.connectLogFileWriter(this.theWriter);
        }
        catch (IOException e) {
            String msg = e.toString() + " :Writing file:" + AUTO_INTEGRATION_LOG_FILE_PATH + " has failed, see: " + e.getMessage();
            if (e.getCause() != null) {
                msg = msg + " Cause info: " + e.getCause().getMessage();
            }
            logger.traceError(THIS_CLASS, msg);
            this.theWriter = null;
        }
        List mylist = new ArrayList();
        mylist = this.fileLogger.getDefaultNameOfPackages();
        this.fileLogger.stopLogListner();
        this.fileLogger.startLogListner(mylist, logger);
        logger.info(THIS_CLASS, "Logging to file will continue");
        logger.traceReturn(THIS_CLASS, "integrationContinued()");
    }

    public void updateAttribute(StringBuffer copiedReportBuffer) {
        logger.traceEnter(THIS_CLASS, "updateAttribute(StringBuffer)");
        String value = new String("");
        try {
            Object reportContent = this.getAttribute("configurationReport");
            StringBuffer reportContentBuffer = reportContent == null ? new StringBuffer() : new StringBuffer((String)reportContent);
            value = reportContentBuffer.append(copiedReportBuffer).toString();
            this.setReadOnlyAttribute("configurationReport", value);
        }
        catch (MoAccessException mae) {
            logger.traceError(THIS_CLASS, "updateAttribute(StringBuffer), Could not update attribute : configurationReport, message:" + mae.getMessage());
        }
        try {
            Object configReportUpdateCounter = this.getAttribute("configurationReportUpdateCounter");
            Integer configReportUpdateCounterNew = configReportUpdateCounter == null ? new Integer(1) : new Integer((Integer)configReportUpdateCounter + 1);
            this.setReadOnlyAttribute("configurationReportUpdateCounter", configReportUpdateCounterNew);
        }
        catch (MoAccessException mae) {
            logger.traceError(THIS_CLASS, "updateAttribute(StringBuffer), Could not update attribute : configurationReportUpdateCounter, message:" + mae.getMessage());
        }
        logger.traceReturn(THIS_CLASS, "updateAttribute(StringBuffer)");
    }

    public void integrationFinishedOrFailed() {
        logger.traceEnter(THIS_CLASS, "integrationFinishedOrFailed()");
        logger.info(THIS_CLASS, "Logging to file will be removed");
        this.fileLogger.integrationFinishedOrFailed();
        logger.traceReturn(THIS_CLASS, "integrationFinishedOrFailed()");
    }

    public boolean isMoppletFinished() {
        return this.moppletFinished;
    }

    static {
        String sensitiveDataFilePath;
        String[] structNames = new String[]{"modificationInformation", "modificationState"};
        Object[] structValues = new Object[]{"Not implemented", new Integer(0)};
        RBS_MODIFIC_STAT_INFO = new StructImpl(structNames, structValues);
        AUTO_INTEGRATION_LOG_FILE_PATH = LoggingService.getFileLogger().getDefaultFileLogPath();
        String unitTestString = System.getProperty("UNIT_TEST", "false");
        String propertySensitiveDataFilePath = System.getProperty(SENSITIVE_DATA_FILE_PATH_SYSTEM_PROP_NAME);
        if ("true".equalsIgnoreCase(unitTestString)) {
            String userHomeDir = System.getProperty("user.home");
            sensitiveDataFilePath = userHomeDir + File.separator + "rbs_sensitive_data" + System.currentTimeMillis() + File.separator + "rbs_auto_integration_data.dat";
        } else {
            sensitiveDataFilePath = propertySensitiveDataFilePath == null ? "/c/configuration/rbs_auto_integration_data.dat" : propertySensitiveDataFilePath;
        }
        SENSITIVE_DATA_FILE_PATH = sensitiveDataFilePath;
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                try {
                    FileHelper.deleteDirectoryTree((File)new File(sensitiveDataFilePath).getParentFile());
                }
                catch (FileHelper.FileException fileException) {
                    // empty catch block
                }
            }
        }));
        THIS_CLASS = RbsConfigurationMaoImpl.class;
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
        transFact = TransactionServicesFactoryImpl.getInstance().getCppTransactionFactory();
        supportedConfigVersions = null;
        cxcVersions = new HashMap();
        cxcVersions.put("SiteBasic", "CXC 172 9121/1");
        cxcVersions.put("SiteEquipment", "CXC 172 9123/1");
        cxcVersions.put("RbsSiteInstallationFile", "CXC 172 9122/1");
        cxcVersions.put("AutoIntegrationRbsSummaryFile", "CXC 172 9120/1");
        cxcVersions.put("NpcConfig", "CXC 172 9124/1");
        ACTION_TEST_CAPABILITY_HELP_STRINGS = new String[]{"help", "-help", "--help", "?"};
    }
}

