/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.actions;

import java.io.IOException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.su.mom.ConfigurationVersion;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.actions.AbstractRbsConfigurationAction;
import se.ericsson.crbs.cat.mao.rbsconfiguration.log.LogHandler;
import se.ericsson.crbs.common.ExceptionHelper;

public class CancelRbsIntegrationAction
extends AbstractRbsConfigurationAction {
    protected static final String DEFAULT_ROLLBACK_THREAD_NAME = "Rollback Thread - Will be replaced";
    protected static final String EXCEPTION_MSG_FOR_UNDEFINED_CONFIG_LEVEL = "Integration can not be cancelled. No integration in progress.";
    protected static final String EXCEPTION_MSG_FOR_READY_ROR_SERVICE_CONFIG_LEVEL = "Integration can not be cancelled in ready for service. Already completed.";
    protected static final String EXCEPTION_MSG_FOR_INTEGRATION_COMPLETE_CONFIG_LEVEL = "Integration can not be cancelled. Already completed.";
    protected static final String EXCEPTION_MSG_FOR_OSS_CONTACT = "Integration can not be cancelled. Node already in contact with OSS.";
    protected Thread rollbackThread = new Thread("Rollback Thread - Will be replaced");
    private final Coordinator coordinator;
    private static final Class THIS_CLASS = CancelRbsIntegrationAction.class;

    public CancelRbsIntegrationAction(RbsConfigurationMao inputRbsConfigurationMao, Coordinator inCoordinator) {
        super(THIS_CLASS, inputRbsConfigurationMao);
        this.coordinator = inCoordinator;
    }

    public void execute() throws RbsConfigurationFailedException {
        this.logger.traceEnter(THIS_CLASS, "execute()");
        try {
            ManagedObject managedElement = this.moRepositoryWrapper.lookup("ManagedElement=1");
            String logicalName = managedElement.getAttribute("logicalName", this.coordinator).toString();
            ConfigurationVersion configurationVersion = (ConfigurationVersion)this.moRepositoryWrapper.lookup("ManagedElement=1,SwManagement=1,ConfigurationVersion=1");
            LogHandler.makeZipFileOfLogFiles(logicalName, configurationVersion, this.rbsConfigurationMao, this.coordinator);
        }
        catch (NoSuchAttributeException nsae) {
            this.logger.traceAbnormal(THIS_CLASS, ExceptionHelper.appendReason((String)"Failed to get ManagedElement logicalName", (Throwable)nsae));
        }
        catch (MoAccessException mae) {
            this.logger.traceAbnormal(THIS_CLASS, ExceptionHelper.appendReason((String)"Failure during collecting log files and adding them to ZIP", (Throwable)mae));
        }
        catch (IOException ioe) {
            this.logger.traceAbnormal(THIS_CLASS, ExceptionHelper.appendReason((String)"Failed to create ZIP file containing log files", (Throwable)ioe));
        }
        catch (NullPointerException npe) {
            this.logger.traceAbnormal(THIS_CLASS, ExceptionHelper.appendReason((String)"Null pointer found during collecting of log files ", (Throwable)npe));
        }
        Integer currentConfigLevel = this.helper.getRbsConfigLevel();
        if (RbsConfigurationDefinitions.RBS_CL_UNDEFINED.equals(currentConfigLevel)) {
            throw new RbsConfigurationFailedException(EXCEPTION_MSG_FOR_UNDEFINED_CONFIG_LEVEL);
        }
        if (RbsConfigurationDefinitions.RBS_CL_READY_FOR_SERVICE.equals(currentConfigLevel)) {
            throw new RbsConfigurationFailedException(EXCEPTION_MSG_FOR_READY_ROR_SERVICE_CONFIG_LEVEL);
        }
        if (RbsConfigurationDefinitions.RBS_CL_INTEGRATION_COMPLETE.equals(currentConfigLevel)) {
            throw new RbsConfigurationFailedException(EXCEPTION_MSG_FOR_INTEGRATION_COMPLETE_CONFIG_LEVEL);
        }
        if (RbsConfigurationDefinitions.RBS_CL_OSS_ACTIVATING_CONFIGURATION.equals(currentConfigLevel) || RbsConfigurationDefinitions.RBS_CL_OSS_CONFIGURATION_SUCCESSFUL.equals(currentConfigLevel)) {
            throw new RbsConfigurationFailedException(EXCEPTION_MSG_FOR_OSS_CONTACT);
        }
        this.doRollBack();
        this.logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void doRollBack() {
        Runnable handler = new Runnable(){

            public void run() {
                boolean rollBackIsOk = false;
                while (!rollBackIsOk) {
                    try {
                        CancelRbsIntegrationAction.this.stateHandler.rollbackIntegration();
                        rollBackIsOk = true;
                    }
                    catch (Throwable e) {
                        CancelRbsIntegrationAction.this.logger.traceAbnormal(THIS_CLASS, ExceptionHelper.convertToString((Throwable)e));
                        CancelRbsIntegrationAction.this.helper.waitForRetry("CancelRbsIntegration action");
                    }
                }
            }
        };
        this.rollbackThread = new Thread(handler, "RbsConfiguration_CatOam_rollback");
        this.rollbackThread.start();
    }
}

