/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.actions;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.actions.AbstractRbsConfigurationAction;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpForOamSettingHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpForOamSettingHelperImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationService;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationServiceImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpSecConfigurationData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.SmrsFilesHolder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.IpRollbackStack;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.IpRollbackStackImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.ipaddresschange.NodeIpAddressChangePackage.NotAcceptedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.ipaddresschange.Reason;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.RbsConfigurationSiteBasicParser;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.SiteBasicData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.smrs.HashHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.smrs.SmrsException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;

public class ChangeIpForOamSettingAction
extends AbstractRbsConfigurationAction {
    protected static final int MAX_ULN_LENGTH = 255;
    private static final Class THIS_CLASS = ChangeIpForOamSettingAction.class;
    private RbsConfigurationFailedException currentException = null;
    private final String smrsUserId;
    private final String smrsPassword;
    private String summaryFileUrl;
    private final String summaryFileHash;
    private final String rbsIntegrationCode;
    private String smrsServer = "";
    private SiteBasicData siteBasicData;
    private final GenericMaoContext genericMaoContext;
    private final RbsConfigurationSiteBasicParser parser;
    private SmrsFilesHolder smrsFilesHolder;
    protected String oldIpAddress = "";
    private String remoteIscfFile;
    private final IpOamConfigurationService ipOamConfigurationService;
    private final IpForOamSettingHelper ipForOamSettingHelper;
    private final IpRollbackStack rollbackStack;
    private boolean ossNotified = false;
    private final String ipSecLdn = "ManagedElement=1,IpSystem=1,IpSec=1";
    private boolean ipSecMoInXml = false;
    protected Integer wantedIpSecFeatureState = null;

    public ChangeIpForOamSettingAction(RbsConfigurationMao theRbsConfigurationMao, String theSmrsUserId, String theSmrsPassword, String theSummaryFileUrl, String theSummaryFileHash, String theRbsIntegrationCode, Coordinator inputCoordinator) throws RbsConfigurationFailedException {
        super(THIS_CLASS, theRbsConfigurationMao);
        this.logger.traceEnter(THIS_CLASS, "ChangeIpForOamSettingAction()");
        if (theSmrsUserId == null || theSmrsPassword == null || theSummaryFileUrl == null || theSummaryFileHash == null || theRbsIntegrationCode == null) {
            throw new RbsConfigurationFailedException("Error when calling changeIpForOamSetting action.", "At least one of the action parameters is null.");
        }
        this.smrsUserId = theSmrsUserId.trim();
        this.smrsPassword = theSmrsPassword.trim();
        this.summaryFileUrl = theSummaryFileUrl.trim();
        if (this.summaryFileUrl.startsWith("sftp")) {
            this.summaryFileUrl = this.summaryFileUrl.substring(1, this.summaryFileUrl.length());
        }
        this.summaryFileHash = theSummaryFileHash.trim();
        this.rbsIntegrationCode = theRbsIntegrationCode.trim();
        this.genericMaoContext = theRbsConfigurationMao.getRbsConfigurationContext().getGenericMaoContext();
        this.parser = new RbsConfigurationSiteBasicParser(this.genericMaoContext);
        this.ipOamConfigurationService = IpOamConfigurationServiceImpl.getInstance(this.genericMaoContext);
        this.ipForOamSettingHelper = IpForOamSettingHelperImpl.getInstance();
        this.rollbackStack = IpRollbackStackImpl.getInstance();
        this.rollbackStack.clearStack();
        this.logger.traceReturn(THIS_CLASS, "ChangeIpForOamSettingAction()");
    }

    public void execute() throws RbsConfigurationFailedException {
        this.logger.traceEnter(THIS_CLASS, "execute()");
        try {
            this.doPreConfiguration();
        }
        catch (RbsConfigurationFailedException e) {
            this.logger.traceError(THIS_CLASS, e.getMessage());
            this.cleanUpAfterExecution();
            throw e;
        }
        Configurator theConfigurator = new Configurator();
        theConfigurator.startConfigure();
        Thread.yield();
        if (this.currentException != null) {
            throw this.currentException;
        }
        this.logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void cleanUpAfterExecution() {
        this.logger.traceEnter(THIS_CLASS, "cleanUpAfterExecution()");
        IpRollbackStackImpl.getInstance().clearStack();
        this.ipForOamSettingHelper.clearData();
        this.ipOamConfigurationService.resetMomParser();
        this.logger.traceReturn(THIS_CLASS, "cleanUpAfterExecution()");
    }

    protected void doPreConfiguration() throws RbsConfigurationFailedException {
        this.logger.traceEnter(THIS_CLASS, "doPreConfiguration()");
        try {
            this.getAndStoreOldIpAddress();
            this.downloadAndHashCheckFiles();
            try {
                this.siteBasicData = this.parser.parseSiteBasicFile(this.smrsFilesHolder.localIpForOamFilePath, false);
            }
            catch (IOException e) {
                String ioErrorMsg = "ChangeIpForOamSettingAction failed when parsing Site Basic file.";
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_SMRS_CONNECTION_FAULT, "IO-error", ioErrorMsg);
                throw new RbsConfigurationFailedException("SiteBasicParser failed", "IOException when parsing XML file", e);
            }
            catch (MoAccessException e) {
                String accessErrorMsg = "ChangeIpForOamSettingAction failed when parsing Site Basic file.";
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_SMRS_CONNECTION_FAULT, "MoAccess-error", accessErrorMsg);
                throw new RbsConfigurationFailedException("SiteBasicParser failed", "MoAccessException when parsing XML file", (Exception)((Object)e));
            }
            IpSecConfigurationData ipSecConfigurationData = new IpSecConfigurationData();
            ipSecConfigurationData.putConfigurationData(this.siteBasicData);
            this.ipOamConfigurationService.performConsistencyCheck();
        }
        catch (Exception e) {
            this.configurationRollback(e);
        }
        this.logger.traceReturn(THIS_CLASS, "doPreConfiguration()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyConfiguration() throws RbsConfigurationFailedException {
        this.logger.traceEnter(THIS_CLASS, "applyConfiguration()");
        try {
            try {
                this.ipSecMoInXml = this.ipForOamSettingHelper.getIpForOamSettingData().containsKey("ManagedElement=1,IpSystem=1,IpSec=1");
                if (this.ipSecMoInXml) {
                    String featureStateAttributeName = "featureState";
                    try {
                        this.wantedIpSecFeatureState = (Integer)this.ipOamConfigurationService.getAttributeFromConfigurationData("ManagedElement=1,IpSystem=1,IpSec=1", featureStateAttributeName);
                    }
                    catch (RbsConfigurationFailedException e) {
                        String errorSlogan = "Getting feature state failed.";
                        String errorMsg = "Could not get attribute " + featureStateAttributeName + " from configuration data for the " + "ManagedElement=1,IpSystem=1,IpSec=1" + " MO.";
                        this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_IP_FOR_OAM_CONFIGURATION_CHANGE_FAULT, errorSlogan, errorMsg);
                        throw new RbsConfigurationFailedException(errorSlogan, errorMsg, (Exception)((Object)e));
                    }
                    if (this.wantedIpSecFeatureState != null && this.wantedIpSecFeatureState == 1) {
                        this.ipOamConfigurationService.checkIpSecLicense();
                        if (this.remoteIscfFile != null) {
                            this.ipOamConfigurationService.installIpSecCertificate(this.smrsFilesHolder.localIscfFilePath, this.rbsIntegrationCode, this.smrsUserId);
                        }
                        this.setIpSecFeatureStateAndAddToRollbackStack();
                    }
                }
                this.ipOamConfigurationService.deleteCurrentConfiguration();
                this.ipOamConfigurationService.createConfiguration();
                if (this.wantedIpSecFeatureState != null && this.wantedIpSecFeatureState == 0) {
                    this.setIpSecFeatureStateAndAddToRollbackStack();
                }
                this.ipOamConfigurationService.verifyOamConnectivity();
                this.ipOamConfigurationService.notifyOssOfChangedIpAddress(this.oldIpAddress, this.extractRawHash(this.summaryFileHash), Reason.complete);
                this.ossNotified = true;
            }
            catch (Exception e) {
                this.configurationRollback(e);
            }
            this.ipOamConfigurationService.createCv();
        }
        finally {
            this.cleanUpAfterExecution();
        }
        this.logger.traceReturn(THIS_CLASS, "applyConfiguration()");
    }

    protected void setIpSecFeatureStateAndAddToRollbackStack() throws RbsConfigurationFailedException {
        try {
            String attributeName = "featureState";
            Integer oldFeatureState = (Integer)this.ipOamConfigurationService.getAttribute("ManagedElement=1,IpSystem=1,IpSec=1", attributeName);
            this.ipOamConfigurationService.setAttribute("ManagedElement=1,IpSystem=1,IpSec=1", attributeName, this.wantedIpSecFeatureState);
            this.rollbackStack.pushSet("ManagedElement=1,IpSystem=1,IpSec=1", new String[]{attributeName}, new Object[]{oldFeatureState});
        }
        catch (MoAccessException mae) {
            throw new RbsConfigurationFailedException("Changing IPsec feature state failed.", "Could not set featureState to " + this.wantedIpSecFeatureState, (Exception)((Object)mae));
        }
    }

    private void configurationRollback(Exception e) throws RbsConfigurationFailedException {
        this.logger.traceAbnormal(THIS_CLASS, "Caught an Exception.\n" + e.getMessage() + "\nStarting rollback.");
        if (e.getCause() != null && e.getCause() instanceof NotAcceptedException) {
            try {
                this.getAndStoreOldIpAddress();
            }
            catch (RbsConfigurationFailedException rcfe) {
                this.logger.traceAbnormal(THIS_CLASS, "Could not get the currently used IP address for rollback notification to OSS. Trying to notify OSS anyway.\nError message: " + rcfe.getMessage());
            }
        }
        this.rollbackStack.doRollback();
        String errorSlogan = "Action changeIpForOamSetting() failed.";
        String rollbackErrorMessage = "Rollback has been performed. The node is back on the initial configuration.";
        try {
            this.ipOamConfigurationService.notifyOssOfChangedIpAddress(this.oldIpAddress, this.extractRawHash(this.summaryFileHash), Reason.rollback);
            this.ossNotified = true;
        }
        catch (RbsConfigurationFailedException rcfe) {
            throw new RbsConfigurationFailedException("Action changeIpForOamSetting() failed.", "Rollback has been performed. The node is back on the initial configuration. Failed to notify the OSS of rollback.", (Exception)((Object)rcfe));
        }
        catch (HashHelper.HashException he) {
            throw new RbsConfigurationFailedException("Action changeIpForOamSetting() failed.", "Rollback has been performed. The node is back on the initial configuration. Failed to format the hash value before notifying the OSS of rollback.", he);
        }
        throw new RbsConfigurationFailedException("Action changeIpForOamSetting() failed.", "Rollback has been performed. The node is back on the initial configuration.", e);
    }

    protected void downloadAndHashCheckFiles() throws RbsConfigurationFailedException {
        block4: {
            this.logger.traceEnter(THIS_CLASS, "downloadAndHashCheckFiles()");
            try {
                String localSummaryFilePath = this.retrieveSummaryFile();
                this.checkHash(this.summaryFileHash, localSummaryFilePath);
                this.smrsFilesHolder = this.retrieveFilesFromSmrs(localSummaryFilePath);
                this.logger.traceDebug(THIS_CLASS, "Retrieved " + this.smrsFilesHolder.toString());
                this.checkHash(this.smrsFilesHolder.ipForOamHash, this.smrsFilesHolder.localIpForOamFilePath);
                if (this.remoteIscfFile == null) break block4;
                if (this.smrsFilesHolder.iscfFileHash != null && this.smrsFilesHolder.iscfFileHash != "") {
                    this.checkHash(this.smrsFilesHolder.iscfFileHash, this.smrsFilesHolder.localIscfFilePath);
                    break block4;
                }
                throw new RbsConfigurationFailedException("Hash check failed.", "Missing hash value for the ISCF!");
            }
            catch (SmrsException smrsExcep) {
                String smrsErrorMsg = "Action Failed when downloading the configuration files from SMRS";
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_SMRS_CONNECTION_FAULT, "FTP-error", smrsErrorMsg);
                throw new RbsConfigurationFailedException("Retrieving files from SMRS failed.", "Could not retrieve files from SMRS.", smrsExcep);
            }
            catch (HashHelper.HashException hashExcep) {
                String hashErrorMsg = "Action Failed when executing hashCheck of the configuration files retreived from SMR";
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_SMRS_CONNECTION_FAULT, "HashCheck-error", hashErrorMsg);
                throw new RbsConfigurationFailedException("Hash check failed.", "An unexpected hash exception was thrown", hashExcep);
            }
        }
        this.logger.traceReturn(THIS_CLASS, "downloadAndHashCheckFiles()");
    }

    protected void getAndStoreOldIpAddress() throws RbsConfigurationFailedException {
        String ipHostLinkLdn = ((ManagedObject)this.ipOamConfigurationService.getAllMosOfType("IpHostLink").get(0)).getLocalDistinguishedName();
        try {
            this.oldIpAddress = ((String[])this.ipOamConfigurationService.getAttribute(ipHostLinkLdn, "ipv4Addresses"))[0];
        }
        catch (MoAccessException e) {
            String errorMsg = "Action Failed when fetching the current OAM IP address";
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, "MoAccess-error", errorMsg);
            throw new RbsConfigurationFailedException("Fetching current OAM IP address failed!", "Could not fetch current OAM IP address from IpHostLink MO.", (Exception)((Object)e));
        }
        if (this.oldIpAddress.equals("")) {
            String errorMsg = "Action Failed: An empty string is returned as current OAM IP address";
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, "MoAccess-error", errorMsg);
            throw new RbsConfigurationFailedException("Fetching old OAM IP address failed!", "An empty string is returned as current OAM IP address.");
        }
    }

    protected void checkHash(String expectedHash, String filePath) throws HashHelper.HashException {
        this.logger.traceEnter(THIS_CLASS, "checkHash(" + expectedHash + ", " + filePath + ")");
        String sha1 = "SHA1=";
        if (!expectedHash.startsWith("SHA1=")) {
            if (expectedHash.indexOf("=") > -1) {
                throw new HashHelper.HashException("Unsupported hash format: " + expectedHash.substring(0, expectedHash.indexOf("=")));
            }
            throw new HashHelper.HashException("Incorrect format of the given hash: " + expectedHash);
        }
        this.logger.traceDebug(THIS_CLASS, "The format of the hash is SHA1.");
        String expectedHashRaw = this.extractRawHash(expectedHash);
        HashHelper.checkSha1HashAgainstFile(expectedHashRaw, filePath);
        this.logger.traceReturn(THIS_CLASS, "checkHash(" + expectedHash + ", " + filePath + ")");
    }

    private String extractRawHash(String inputHash) throws HashHelper.HashException {
        this.logger.traceEnter(THIS_CLASS, "extractRawHash(" + inputHash + ")");
        int expectedLengthOfHash = 40;
        int index = inputHash.indexOf("=");
        String hashAfterEqualSign = inputHash.substring(index + 1);
        char[] hashAsCharArray = hashAfterEqualSign.toCharArray();
        StringBuffer finalHash = new StringBuffer();
        int charsSinceLastColon = 0;
        for (int i = 0; i < hashAsCharArray.length; ++i) {
            if (hashAsCharArray[i] == ':' && charsSinceLastColon == 2) {
                charsSinceLastColon = 0;
                continue;
            }
            if (Character.digit(hashAsCharArray[i], 16) > -1 && charsSinceLastColon < 2) {
                finalHash.append(hashAsCharArray[i]);
                ++charsSinceLastColon;
                continue;
            }
            throw new HashHelper.HashException("Unexpected character " + hashAsCharArray[i] + " in String " + hashAfterEqualSign);
        }
        if (finalHash.length() != 40) {
            throw new HashHelper.HashException("Unexpected length (" + finalHash.length() + ") of the hash. Should be " + 40 + ".");
        }
        String outputHash = finalHash.toString();
        this.logger.traceReturn(THIS_CLASS, "extractRawHash(" + inputHash + ") = " + outputHash);
        return outputHash;
    }

    protected String retrieveSummaryFile() throws SmrsException {
        this.logger.traceEnter(THIS_CLASS, "retrieveSummaryFile()");
        String localSummaryFilePath = "";
        try {
            URL summaryUrl = new URL(this.summaryFileUrl);
            this.smrsServer = summaryUrl.getHost();
            String summaryFilePath = summaryUrl.getPath();
            this.smrsHelper.storeSmrsDataPersistently(this.smrsUserId, this.smrsPassword, this.smrsServer, summaryFilePath);
            String remoteSummaryFilePath = summaryFilePath;
            localSummaryFilePath = this.helper.getLocalPath() + "IpForOamSettingSummaryFile.xml";
            this.getFileFromFtp("Summary", remoteSummaryFilePath, localSummaryFilePath, this.smrsServer);
            this.logger.traceGeneral(THIS_CLASS, "Retrieved Summary file, \"" + remoteSummaryFilePath + "\",  from SMRS: " + this.smrsServer);
            this.logger.traceReturn(THIS_CLASS, "retrieveSummaryFile() = " + localSummaryFilePath);
            return localSummaryFilePath;
        }
        catch (MalformedURLException mue) {
            throw new SmrsException("The provided URL is malformed: " + StringHelper.doubleQuote((String)this.summaryFileUrl), mue);
        }
        catch (MoAccessException mae) {
            throw new SmrsException("The SMRS data could not be stored persistently", mae);
        }
    }

    protected SmrsFilesHolder retrieveFilesFromSmrs(String localSummaryFilePath) throws SmrsException {
        this.logger.traceEnter(THIS_CLASS, "retrieveFilesFromSmrs()");
        try {
            Map configurationFiles = this.smrsHelper.parseSummaryFile(localSummaryFilePath);
            String remoteIpForOamSettingFile = (String)configurationFiles.get("ipForOamSettingFilePath");
            String ipForOamSettingFileHash = (String)configurationFiles.get("ipForOamSettingFileHash");
            this.remoteIscfFile = (String)configurationFiles.get("initialSecurityConfigurationFilePath");
            String localIpForOamSettingFile = this.helper.getLocalPath() + "IpForOamSetting.xml";
            String localIscfFile = this.helper.getLocalPath() + "ISCF.xml";
            String iscfHash = (String)configurationFiles.get("initialSecurityConfigurationFileHash");
            this.getFileFromFtp("IpForOamSetting.xml", remoteIpForOamSettingFile, localIpForOamSettingFile, this.smrsServer);
            if (this.remoteIscfFile != null) {
                this.getFileFromFtp("ISCF", this.remoteIscfFile, localIscfFile, this.smrsServer);
            }
            this.logger.traceReturn(THIS_CLASS, "retrieveFilesFromSmrs()");
            return new SmrsFilesHolder(localSummaryFilePath, localIpForOamSettingFile, ipForOamSettingFileHash, localIscfFile, iscfHash);
        }
        catch (MalformedURLException mue) {
            throw new SmrsException("The provided URL is malformed: " + StringHelper.doubleQuote((String)this.summaryFileUrl), mue);
        }
        catch (IOException ioe) {
            throw new SmrsException("The local summary file, \"" + localSummaryFilePath + "\", could not be parsed", ioe);
        }
    }

    protected void getFileFromFtp(String fileName, String remoteFile, String localFile, String inSmrsServer) throws SmrsException {
        this.logger.traceEnter(THIS_CLASS, "getFileFromFtp()");
        boolean result2 = true;
        try {
            result2 = this.smrsHelper.getFileFromFtp(true, -1, remoteFile, localFile);
            if (!result2) {
                throw new SmrsException("FTP returned failed result for download of " + fileName + ", file, \"" + remoteFile + "\", from SMRS: " + StringHelper.doubleQuote((String)inSmrsServer));
            }
        }
        catch (RbsConfigurationFailedException rcfe) {
            throw new SmrsException("Failed to download " + fileName + " from SMRS, " + inSmrsServer, (Throwable)((Object)rcfe));
        }
        this.logger.traceGeneral(THIS_CLASS, "Retrieved " + fileName + " file, \"" + remoteFile + "\",  from SMRS: " + inSmrsServer);
        this.logger.traceReturn(THIS_CLASS, "getFileFromFtp()");
    }

    public boolean isOssNotified() {
        return this.ossNotified;
    }

    public RbsConfigurationFailedException getCurrentException() {
        return this.currentException;
    }

    private class Configurator {
        private Runnable theRunnable = null;
        private Thread theRunner = null;
        private final long MAX_WAIT_FOR_CONFIGURATION = 5000L;

        public Configurator() {
            ChangeIpForOamSettingAction.this.logger.traceEnter(THIS_CLASS, "Configurator()");
            this.theRunnable = new Runnable(){

                public void run() {
                    ((Configurator)Configurator.this).ChangeIpForOamSettingAction.this.logger.traceEnter(THIS_CLASS, "Configurator.theRunnable.run()");
                    ChangeIpForOamSettingAction.this.currentException = null;
                    try {
                        ChangeIpForOamSettingAction.this.applyConfiguration();
                        Thread.yield();
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            ((Configurator)Configurator.this).ChangeIpForOamSettingAction.this.logger.traceDebug(THIS_CLASS, "Thread was interrupted while sleeping. " + e);
                        }
                    }
                    catch (RbsConfigurationFailedException e) {
                        ((Configurator)Configurator.this).ChangeIpForOamSettingAction.this.logger.traceError(THIS_CLASS, e.getMessage());
                        ChangeIpForOamSettingAction.this.currentException = e;
                    }
                    ((Configurator)Configurator.this).ChangeIpForOamSettingAction.this.logger.traceReturn(THIS_CLASS, "Configurator.theRunnable.run()");
                }
            };
            this.theRunner = new Thread(this.theRunnable, "ConfiguratorThreadIpForOamSetting");
            ChangeIpForOamSettingAction.this.logger.traceReturn(THIS_CLASS, "Configurator()");
        }

        public void startConfigure() {
            this.theRunner.start();
        }
    }
}

