/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.actions;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.managedelement.NtpServerMo;
import se.ericsson.cello.managedelement.TimeSettingMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class ClientTimeSetter {
    protected static final String NODE_UTC_TIME = "nodeUTCTime";
    private static final Class THIS_CLASS = ClientTimeSetter.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final RbsConfigurationHelper helper;
    private final List ntpInitialStatus;
    private final TimeSettingMo timeSettingMo;
    private final List ntpServers;

    public ClientTimeSetter(MoRepositoryWrapper anMoRepositoryWrapper, RbsConfigurationHelper anHelper) {
        this.timeSettingMo = (TimeSettingMo)anMoRepositoryWrapper.lookup("ManagedElement=1,SystemFunctions=1,TimeSetting=1");
        MoIterator moIterator = anMoRepositoryWrapper.lookupType("NtpServer");
        this.ntpServers = new ArrayList();
        this.ntpInitialStatus = new ArrayList();
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                this.ntpServers.add(moIterator.nextMo());
                this.ntpInitialStatus.add(Boolean.FALSE);
            }
        }
        this.helper = anHelper;
    }

    public void setTime(long currentClientTime) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setTime(" + currentClientTime + ")");
        if (this.timeSettingMo == null) {
            logger.traceAbnormal(THIS_CLASS, "Unable to find TimeSetting MO - will not set node time.");
        } else {
            TransactionHandler.run(new InactivateNtpTp());
            TransactionHandler.run(new SetTimeTp(currentClientTime));
            TransactionHandler.run(new ReActivateNtpTp());
        }
        logger.traceReturn(THIS_CLASS, "setTime(" + currentClientTime + ")");
    }

    private void inactivateNtpAttribute(NtpServerMo ntpServerMo, Boolean active, String ntpAddress, Coordinator coordinator) throws MoAccessException {
        logger.traceDebug(THIS_CLASS, "ntpServer: " + ntpServerMo.getLocalDistinguishedName() + " ntpAddress: " + ntpAddress + "activ" + active);
        if (active != null && ntpAddress != null) {
            if (active.booleanValue() && ntpAddress.equalsIgnoreCase("0.0.0.0")) {
                logger.traceDebug(THIS_CLASS, "temporary setting the ntp adress from 0.0.0.0 to 169.254.0.10 to avoid error message from cpp");
                ntpServerMo.setServerAddress("169.254.0.10", coordinator);
            } else if (active.booleanValue() && !ntpAddress.equalsIgnoreCase("0.0.0.0")) {
                logger.traceDebug(THIS_CLASS, "setting attribute to false");
                ntpServerMo.setServiceActive(false, coordinator);
            } else if (!active.booleanValue() && ntpAddress.equalsIgnoreCase("0.0.0.0")) {
                try {
                    logger.traceDebug(THIS_CLASS, "temporary setting the ntp address from 0.0.0.0 to 169.254.0.20 to avoid error message from cpp");
                    ntpServerMo.setServerAddress("169.254.0.20", coordinator);
                }
                catch (MoAccessException e) {
                    logger.traceDebug(THIS_CLASS, "Ignore this fault, action to create ntp has not been executed " + ntpServerMo.getLocalDistinguishedName() + e.getMessage());
                }
            }
        }
    }

    private void restoreNtpAttribute(NtpServerMo ntpServerMo, Boolean saved, Boolean current, Coordinator coordinator) throws MoAccessException {
        logger.traceDebug(THIS_CLASS, "Check if stored ntpServerMo: " + ntpServerMo.getLocalDistinguishedName() + "diffent from current: " + current);
        if (saved != null && saved.booleanValue() != current.booleanValue()) {
            logger.traceDebug(THIS_CLASS, "setting ntpServerMo:" + ntpServerMo.getLocalDistinguishedName() + "to saved: " + saved);
            ntpServerMo.setServiceActive(saved.booleanValue(), coordinator);
        }
    }

    private class ReActivateNtpTp
    extends AbstractClientTimeSetterTp {
        protected ReActivateNtpTp() {
            super("Unable to re-activate NTP for correction of node time. ");
        }

        public void execute(Coordinator coordinator) throws MoAccessException {
            for (int i = 0; i < ClientTimeSetter.this.ntpServers.size(); ++i) {
                NtpServerMo ntpServer = (NtpServerMo)ClientTimeSetter.this.ntpServers.get(i);
                boolean ntpCurrentStatus = ntpServer.getServiceActive(coordinator);
                String ntpAddress = ntpServer.getServerAddress(coordinator);
                if (ntpAddress == null || ntpAddress.equalsIgnoreCase("0.0.0.0")) continue;
                logger.traceDebug(THIS_CLASS, "start to re-activate NtpAddress: " + ntpAddress);
                ClientTimeSetter.this.restoreNtpAttribute(ntpServer, (Boolean)ClientTimeSetter.this.ntpInitialStatus.get(i), ntpCurrentStatus, coordinator);
            }
        }
    }

    private class InactivateNtpTp
    extends AbstractClientTimeSetterTp {
        protected InactivateNtpTp() {
            super("Unable to inactivate NTP for correction of node time. ");
        }

        public void execute(Coordinator coordinator) throws MoAccessException {
            for (int i = 0; i < ClientTimeSetter.this.ntpServers.size(); ++i) {
                NtpServerMo ntpServer = (NtpServerMo)ClientTimeSetter.this.ntpServers.get(i);
                ClientTimeSetter.this.ntpInitialStatus.set(i, ntpServer.getServiceActive(coordinator));
                String ntpAddress = ntpServer.getServerAddress(coordinator);
                if (ntpAddress == null) continue;
                logger.traceDebug(THIS_CLASS, "start to inactivate NtpServer: " + ntpServer.getLocalDistinguishedName());
                ClientTimeSetter.this.inactivateNtpAttribute(ntpServer, (Boolean)ClientTimeSetter.this.ntpInitialStatus.get(i), ntpAddress, coordinator);
            }
        }
    }

    private class SetTimeTp
    extends AbstractClientTimeSetterTp {
        private final long timeToSet;

        protected SetTimeTp(long currentClientTime) {
            super("Unable to set NodeTime. ");
            this.timeToSet = currentClientTime;
        }

        public void execute(Coordinator coordinator) throws MoAccessException {
            ClientTimeSetter.this.timeSettingMo.actionSetNodeUTCTime(this.timeToSet, coordinator);
        }
    }

    private abstract class AbstractClientTimeSetterTp
    implements TransactionPackage {
        protected final String executionFaultMessage;

        public AbstractClientTimeSetterTp(String faultMessage) {
            this.executionFaultMessage = faultMessage;
        }

        public void handleExecutionException(Exception exception) {
            String msg = ExceptionHelper.appendReason((String)this.executionFaultMessage, (Throwable)exception);
            ClientTimeSetter.this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "Internal failure", msg);
            logger.traceAbnormal(THIS_CLASS, msg);
        }

        public void handleTransactionException(Exception exception) {
            ClientTimeSetter.this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "Time setter fault.", "Transaction failure.");
        }
    }
}

